/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import merlin.Intl;
import merlin.data.egress.agents.IOccArea;
import thunderheadeng.units.UnitDouble;

public class OccArea
implements IOccArea {
    public static final long serialVersionUID = 1L;
    private final String d_name;
    private final UnitDouble d_area;

    public OccArea(UnitDouble areaPerPerson) {
        this(Intl.intl("Custom"), areaPerPerson);
    }

    public OccArea(String name, UnitDouble areaPerPerson) {
        this.d_name = name;
        this.d_area = areaPerPerson;
    }

    @Override
    public String getName() {
        return this.d_name;
    }

    @Override
    public UnitDouble getArea() {
        return this.d_area;
    }

    public String toString() {
        if (Double.isInfinite(this.d_area.getValueNoUnit())) {
            return this.d_name;
        }
        return this.d_name + " -- " + String.valueOf(this.d_area) + "/occupant";
    }

    public boolean equals(Object o) {
        if (!(o instanceof OccArea)) {
            return false;
        }
        OccArea ot = (OccArea)o;
        return ot == this || ot.d_name.equals(this.d_name) && ot.d_area.equals(this.d_area);
    }
}

