/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import inferno.geom.Inter;
import java.awt.Window;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.OccGenerator;
import merlin.data.AMerlinObj;
import merlin.data.IMerlinObj;
import merlin.data.IOrientable;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.ObjsFilter;
import merlin.data.OccGroupObj;
import merlin.data.Proxy;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.agents.IAvatar;
import merlin.data.egress.agents.IProfileObj;
import merlin.data.egress.agents.IProfileProp;
import merlin.data.egress.agents.IProfilePropDist;
import merlin.data.egress.agents.IProfilePropUnary;
import merlin.data.egress.agents.OccLocation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.ProfileProps;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.AssistOccupants;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.WaitForAssistance;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.data.stat.DisabledCurve;
import merlin.data.tag.Tag;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.geom.Inter2D;
import merlin.gui.ObjSources;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.IDisplayProp;
import thunderheadeng.gui.framework.property.IPropComparisonEditorSupplier;
import thunderheadeng.gui.framework.property.ISimplePropComparisonEd;
import thunderheadeng.gui.framework.property.PropertyDefsFramework;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.CancelObjectPicking;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.Sets;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.theUtil;

public class EgressAgent
extends AMerlinObj
implements Serializable,
IEgressObj,
IDirectDependent<MerlinData>,
ICyclicSurrogate,
IOrientable,
IEventObserver {
    static final long serialVersionUID = 1L;
    public static final UnitDouble AVG_SHOULDER_WIDTH = new UnitDouble(0.4558, SI.METER);
    public static final PropertyDefs<EgressAgent> PROP_TYPES = PropertyDefs.defsRoot(EgressAgent.class, PropertyDefs.none());
    public static final DisplayProp<String> NAME = PROP_TYPES.storeAsPlainOldData(NamedMerlinObj.NAME).attrGetter(EgressAgent::getName, Stream.empty()).attrSetter(EgressAgent::setName, null).attrFinish();
    public static final DisplayProp<OccLocation> LOC = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"Agent.LOC", OccLocation.class, new OccLocation(new Point3d()), Intl.intl("Location"), "").attrFormatValue(OccLocation::toString)).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsMutable(PROP_TYPES).attrCloneAndRestoreValue((obj, prevVal) -> new OccLocation(null, Collections.emptySet(), prevVal.overlapsWalls, prevVal.failsFilter, prevVal.point)).attrGetter(EgressAgent::getLocation, Stream.empty()).attrSetter(EgressAgent::setLocation, (obj, val) -> {
        obj.d_location = val;
    }).attrUndoPropRestoreAll().attrDependency(prop -> new DepCallback<MerlinData, EgressAgent, OccLocation, IEgressOccupiable>(DLink.CONTAINED_BY, IEgressOccupiable.class, (md, src, val) -> Stream.of(val.room), (Predicate)null, null)).attrComparisonEditor(PropComparisons.factory().convert(loc -> new UnitPoint3D(loc.point, Geometry.LENGTH_UNIT), PropComparisons.factory().unitPoint3D(0))).attrFinish();
    static final DisplayProp<OccProfile> PROFILE = (DisplayProp)DisplayProps.build((Object)"Agent.Profile", OccProfile.class, null, Intl.intl("Profile"), "").attrStoreAsMutable(PROP_TYPES).attrGetter(EgressAgent::getProfile, Stream.empty()).attrSetter(EgressAgent::setProfile, (agent, prof) -> {
        agent.d_profile = prof;
    }).attrCloneAndRestoreValue((obj, prof) -> new OccProfile(prof.getProfParent())).attrSurrogateEquals(null).attrComparisonEditor(PropComparisons.factory().convert(prof -> prof.getProfParent(), PropComparisons.factory().singleObj(md -> ObjSources.getProfiles(md, null, false)))).attrFinish();
    public static final Object PROFILE_PROP_CHANGED = new Object();
    public static final DisplayProp<OccProfile> PARENT_PROFILE = PROP_TYPES.storeAsPlainOldData(OccProfile.PROP_PROF_PARENT).attrGetter(a -> a.getProfile().getProfParent(), Stream.empty()).attrSetter(EgressAgent::setProfileParent, null).attrDependency(prop -> Dependencies.newDependencyAsValue(prop, DLink.STRONG, OccProfile.class, Predicates.alwaysTrue())).attrFinish();
    public static final DisplayProp<Behavior> BEHAVIOR = ((TeciDisplayProps.Builder)DisplayProps.build((Object)"Agent.Behavior", Behavior.class, null, Intl.intl("Behavior"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(EgressAgent::getBehavior, Stream.empty()).attrSetter(EgressAgent::setBehavior, null).attrDependency(prop -> Dependencies.newDependencyAsValue(prop, DLink.STRONG, Behavior.class, Predicates.alwaysTrue())).attrComparisonEditor(PropComparisons.factory().singleObj(md -> ObjSources.getBehaviors(md, null, false))).attrFinish();
    public static final TypedProp<OccGroupObj> MOVEMENT_GROUP = ((TeciDisplayProps.Builder)DisplayProps.build((Object)"Agent.MovementGroup", OccGroupObj.class, null, Intl.intl("Movement Group"), "").attrFormatValue(group -> group == null ? Intl.intl("[none]") : group.getName())).attrStoreAsReadOnly(PROP_TYPES).attrGetter(EgressAgent::getMovementGroup, Stream.empty()).attrFinish();
    public static final TypedProp<Long> PROFILE_SEED = PROP_TYPES.storeAsPlainOldData(MerlinData.SEED).attrGetter(EgressAgent::getProfileSeed, Stream.empty()).attrSetter(EgressAgent::setProfileSeed, null).attrFinish();
    static final TypedProp<Long> ORIENT_SEED = TypedProps.build((Object)"Agent.ORIENT_SEED", 0L).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(EgressAgent::getOrientSeed, Stream.empty()).attrSetter(EgressAgent::setOrientSeed, (obj, val) -> {
        obj.d_orientSeed = val;
    }).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Boolean> ENABLED = PROP_TYPES.storeAsPlainOldData(MerlinData.ENABLED).attrGetter(EgressAgent::isEnabled, Stream.empty()).attrSetter(EgressAgent::setEnabled, null).attrFinish();
    static final TypedProp<Boolean> STORED_VISIBILITY = ((TypedProps.Builder)TypedProps.build((Object)"EgressAgent.STORED_VISIBILITY", true).attrAddMarkers(MerlinData.VISIBILITY_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(a -> a.d_visible, Stream.empty()).attrSetter(EgressAgent::setVisible, null).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Boolean> VISIBILITY = PROP_TYPES.storeAsWrapper(MerlinData.VISIBILITY).attrGetter(EgressAgent::isVisible, Stream.of(STORED_VISIBILITY, ENABLED)).attrSetter(EgressAgent::setVisible, null).attrUndoPropRestore(false, STORED_VISIBILITY).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS;
    private static final Map<IProfileProp, AgentProfProp> s_propProfPropMap;
    private static final Map<IProfileProp, AgentOccProp> s_propOccPropMap;
    private String d_name;
    @SkipDep
    private OccProfile d_profile;
    private long d_profileSeed;
    private long d_orientSeed;
    private OccLocation d_location = new OccLocation(new Point3d());
    private Behavior d_behavior;
    private boolean d_visible = true;
    private boolean d_enabled = true;
    @Deprecated
    private Object d_exit = null;
    private static final double PI2 = Math.PI * 2;

    public EgressAgent(OccProfile prof, Behavior behavior) {
        this(prof, behavior, MerlinUtil.newSeed());
    }

    public EgressAgent(OccProfile prof, Behavior behavior, long profileSeed) {
        assert (prof.getProfParent() != null);
        this.d_profile = prof;
        this.d_behavior = behavior;
        this.d_profileSeed = profileSeed;
        this.d_orientSeed = profileSeed;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_enabled = true;
        in.defaultReadObject();
        if (this.d_profile == null) {
            this.d_profile = new OccProfile();
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0004)) {
            this.d_profileSeed = MerlinUtil.newSeed();
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0123)) {
            this.d_orientSeed = this.d_profileSeed;
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0165)) {
            AgentValue socialDistVal = this.getStoredProfileVal(EgressAgent.asAgentProfProp(OccProfile.PROP_SOCIAL_DIST));
            if (socialDistVal.isLocal) {
                ICurve socialDist = (ICurve)socialDistVal.value;
                if (socialDist instanceof DisabledCurve || socialDist == OccProfile.PROP_SOCIAL_DIST.defVal) {
                    this.setLocalProfileVal(OccProfile.PROP_SOCIAL_DIST_FILTER, new ObjsFilter(ObjsFilter.Mode.NONE, false, Collections.emptySet()));
                    this.removeProfileValue(OccProfile.PROP_SOCIAL_DIST);
                } else {
                    this.setLocalProfileVal(OccProfile.PROP_SOCIAL_DIST_FILTER, new ObjsFilter(ObjsFilter.Mode.ALL, false, Collections.emptySet()));
                }
            }
        }
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        this.d_location.writeTopology(oos);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_location.readTopology(ois);
    }

    public Predicate<IEgressOccupiable> getRoomFilter() {
        return EgressAgent.getRoomFilter(this.d_profile);
    }

    public static Predicate<IEgressOccupiable> getRoomFilter(OccProfile profile) {
        Predicate<IEgressOccupiable> filter = Filters.acceptAll(IEgressOccupiable.class);
        MerlinData md = (MerlinData)profile.getDomain();
        if (md == null) {
            return filter;
        }
        OccProfile.CompRestrictions compRestrictions = profile.get(OccProfile.PROP_RESTRICTED_COMPONENTS);
        return Predicates.and(filter, o -> compRestrictions.isAccepted((IMerlinObj)o));
    }

    public boolean getAssistanceOffered() {
        return !this.getBehavior().flatten(AssistOccupants.class).isEmpty();
    }

    public boolean getAssistanceDesired() {
        VehicleShape shape = this.getProfile().get(OccProfile.PROP_VEHICLE_SHAPE);
        if (shape == VehicleShape.NONE) {
            return false;
        }
        if (this.toOccValue(OccProfile.PROP_REQUIRES_ASSISTANCE).booleanValue()) {
            return true;
        }
        return !this.getBehavior().flatten(WaitForAssistance.class).isEmpty();
    }

    @Override
    public boolean updateTopo() {
        OccLocation loc;
        this.d_location = loc = ((MerlinData)this.getDomain()).findValidOccLocation(this.getProfile(), this.getProfileSeed(), this.d_location.point, this.getAngle().getValue(Geometry.ANGLE_UNIT), 0, Filters.accept(this));
        this.changedEvt(new Object[0]);
        return true;
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return this.getRoom() == null;
    }

    private void markTopoDirty() {
        this.changedEvt(MerlinData.TOPOLOGY);
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class, EgressAgent.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        ArrayList<IEgressObj> conns = new ArrayList<IEgressObj>(this.d_location.getOverlappingAgents().size() + 1);
        if (this.d_location.room != null) {
            conns.add(this.d_location.room);
        }
        conns.addAll(this.d_location.getOverlappingAgents());
        return conns;
    }

    @Override
    public void connectTo(IEgressObj obj) {
        if (obj instanceof EgressAgent && this.d_location.add((EgressAgent)obj)) {
            this.changedEvt(LOC, MerlinData.CONNECTION);
        }
    }

    @Override
    public void disconnectFrom(IEgressObj obj) {
        if (obj instanceof IEgressOccupiable) {
            if (this.d_location.room == obj) {
                this.d_location = new OccLocation(null, this.d_location.getOverlappingAgents(), this.d_location.overlapsWalls, this.d_location.failsFilter, this.d_location.point);
                this.changedEvt(LOC, MerlinData.CONNECTION);
            }
        } else if (obj instanceof EgressAgent && this.d_location.remove((EgressAgent)obj)) {
            this.changedEvt(LOC, MerlinData.CONNECTION);
        }
    }

    @Override
    protected void addToDomain(MerlinData domain, IMerlinObj parent) {
        super.addToDomain(domain, parent);
        domain.agentOverlapDetector.add(this);
        this.d_profile.setDomain(domain);
        domain.getEvents().addObserverInDomain((IEventObserver)this, OccProfile.class, false, false, OccProfile.PROP_SHAPE, OccProfile.PROP_VEHICLE_SHAPE, OccProfile.PROP_COLOR, OccProfile.PROP_OCCMODEL, OccProfile.PROP_ANIMS_IDLE, OccProfile.PROP_ANIMS_MOVING);
        domain.getEvents().addObserverInDomain((IEventObserver)this, VehicleShape.class, false, false, VehicleShape.PROP_HEIGHT, VehicleShape.PROP_MODEL, VehicleShape.PROP_POINTS, VehicleShape.PROP_OCCAVATAR_OFFSET, VehicleShape.PROP_PIVOT, VehicleShape.PROP_ANIM_TAGS);
        domain.getEvents().addObserverInDomain((IEventObserver)this, OccGroupObj.class, true, true, OccGroupObj.PROP_COLOR, OccGroupObj.PROP_TEMPLATE_COLOR);
        domain.getEvents().addObserverInDomain((IEventObserver)this, Proxy.class, false, false, Proxy.ENABLED);
    }

    @Override
    protected void removeFromDomain(MerlinData domain, IMerlinObj parent) {
        domain.getEvents().removeObserverInDomain(this);
        this.d_profile.setDomain((MerlinData)null);
        domain.agentOverlapDetector.remove(this);
        super.removeFromDomain(domain, parent);
    }

    @Override
    public void update(Events events) {
        BooleanSupplier test = () -> {
            if (events.isChanged(this.getProfile().getProfParent())) {
                return true;
            }
            PropValue optVehicle = this.getWithDetails(EgressAgent.asAgentOccProp(OccProfile.PROP_VEHICLE_SHAPE));
            if (optVehicle.isPresent() && optVehicle.get() != null && events.isChanged((VehicleShape)((AgentValue)optVehicle.get()).value)) {
                return true;
            }
            Collection<? extends Proxy<? extends IMerlinObj>> proxies = this.getProxies();
            if (proxies.stream().anyMatch(proxy -> events.isChanged(proxy, Proxy.ENABLED))) {
                return true;
            }
            OccGroupObj group = this.getMovementGroup();
            return group != null && (events.isChanged(group, OccGroupObj.PROP_COLOR) || events.isChanged(group, OccGroupObj.PROP_TEMPLATE_COLOR));
        };
        if (test.getAsBoolean()) {
            this.updateProps(null);
        }
    }

    @Override
    public void notifyProxyAdded(Proxy<? extends IMerlinObj> proxy) {
        IEgressObj.super.notifyProxyAdded(proxy);
        this.updateProps(null);
    }

    @Override
    public void notifyProxyRemoved(Proxy<? extends IMerlinObj> proxy) {
        IEgressObj.super.notifyProxyRemoved(proxy);
        this.updateProps(null);
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return this.d_location.point;
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return this.d_location.point;
    }

    private void markOverlapDirty() {
        if (this.getDomain() != null) {
            ((MerlinData)this.getDomain()).agentOverlapDetector.update(this);
        }
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(MerlinData.ENABLED, EventChannel.EVT_GENERAL);
        }
    }

    @Override
    public boolean isVisible() {
        return this.d_visible && this.d_enabled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible != this.d_visible) {
            this.d_visible = visible;
            this.changedEvt(STORED_VISIBILITY);
        }
    }

    @Override
    public void setName(String name) {
        if (Objects.equals(name, this.d_name)) {
            return;
        }
        this.d_name = name;
        this.changedEvt(NAME);
    }

    @Override
    public String getName() {
        return this.d_name;
    }

    public static UnitDouble getShoulderWidth(OccProfile profile, long profileSeed) {
        return profile.toOccValue(OccProfile.PROP_DIAMETER, profileSeed, 0L);
    }

    public UnitDouble getShoulderWidth() {
        return this.toOccValue(OccProfile.PROP_DIAMETER);
    }

    public UnitDouble getMaxShoulderWidth() {
        ICurve diam = (ICurve)this.d_profile.get(OccProfile.PROP_DIAMETER);
        return diam.getMax();
    }

    public UnitDouble getGeomShoulderWidth(boolean nullAllowed) {
        UnitDouble geomDiameter = this.getProfile().get(OccProfile.PROP_GEOM_DIAMETER);
        if (geomDiameter == null) {
            return nullAllowed ? null : this.getShoulderWidth();
        }
        return geomDiameter;
    }

    public OccGroupObj getMovementGroup() {
        return this.getProxies().stream().map(proxy -> ((MerlinData)this.getDomain()).hierarchy.getParent(proxy)).filter(proxyParent -> proxyParent instanceof OccGroupObj).map(proxyParent -> (OccGroupObj)proxyParent).findFirst().orElse(null);
    }

    public UnitDouble getAngle() {
        return this.toOccValue(OccProfile.PROP_INIT_ORIENT);
    }

    public UnitDouble getMaxSpeed() {
        ICurve vel = (ICurve)this.d_profile.get(OccProfile.PROP_MAXVEL);
        return vel.getMax();
    }

    public IAvatar getAvatar() {
        return this.d_profile.toOccValue(OccProfile.PROP_OCCMODEL, this.d_profileSeed, this.d_orientSeed);
    }

    public long getProfileSeed() {
        return this.d_profileSeed;
    }

    public void setProfileSeed(long seed) {
        if (this.d_profileSeed == seed) {
            return;
        }
        this.d_profileSeed = seed;
        this.updateProps(PROFILE_SEED);
    }

    public long getOrientSeed() {
        return this.d_orientSeed;
    }

    public void setOrientSeed(long seed) {
        if (this.d_orientSeed == seed) {
            return;
        }
        this.d_orientSeed = seed;
        try (IDomainObject.EventPause paused = this.openPause();){
            this.changedEvt(ORIENT_SEED);
            this.updateProps(OccProfile.PROP_INIT_ORIENT);
        }
    }

    public void setLocation(OccLocation loc) {
        if (this.d_location.equals(loc)) {
            return;
        }
        this.pauseUpdates();
        this.d_location = new OccLocation(this.d_location.room, this.d_location.getOverlappingAgents(), this.d_location.overlapsWalls, this.d_location.failsFilter, loc.point);
        this.markTopoDirty();
        this.markOverlapDirty();
        this.changedEvt(LOC);
        this.resumeUpdates();
    }

    public void setOrient(double angle) {
        UnitDouble newAngle;
        UnitDouble oldAngle = this.toOccValue(OccProfile.PROP_INIT_ORIENT);
        if (!EgressAgent.equalAngles(oldAngle, newAngle = new UnitDouble(angle, Geometry.ANGLE_UNIT), 1.0E-9)) {
            this.setLocalProfileVal(OccProfile.PROP_INIT_ORIENT, new ConstantCurve(newAngle));
        }
    }

    @Override
    public void setOrientTarget(Point3d target) {
        UnitDouble angle = GeomUtil.getOccOrient(this.getLocPoint(), target);
        this.setOrient(angle);
    }

    @Override
    public void setOrient(UnitDouble angle) {
        this.setOrient(angle.get(Geometry.ANGLE_UNIT));
    }

    @Override
    public boolean isValidOrient(UnitDouble angle) {
        MerlinData md = (MerlinData)this.getDomain();
        OccProfile.OccShape occShape = (OccProfile.OccShape)this.getProfile().get(OccProfile.PROP_SHAPE);
        if (md == null || occShape.type.equals(VehicleShape.ShapeType.CYLINDER)) {
            return true;
        }
        UnitDouble maxDiam = OccGenerator.getMaxDiam(Arrays.asList(this.getProfile()));
        OccLocation oloc = md.findValidOccLocation(occShape, this.getLocPoint(), maxDiam, maxDiam.getValue(Geometry.LENGTH_UNIT), angle.getValue(Geometry.ANGLE_UNIT), 0, Predicates.alwaysTrue(), Filters.accept(this));
        return oloc.room != null && !oloc.overlapsWalls && !oloc.failsFilter && !oloc.isOverlappingAgents();
    }

    private static double toCompareAngle(UnitDouble angle) {
        double arad = angle.get(SI.RADIAN);
        double div = arad / (Math.PI * 2);
        double frac = (div - Math.floor(div)) * (Math.PI * 2);
        return frac;
    }

    private static boolean equalAngles(UnitDouble a1, UnitDouble a2, double tol) {
        double a1r = EgressAgent.toCompareAngle(a1);
        double a2r = EgressAgent.toCompareAngle(a2);
        return theUtil.eq(a1r, a2r, tol);
    }

    public IEgressOccupiable getRoom() {
        return this.d_location.room;
    }

    public OccLocation getLocation() {
        return this.d_location;
    }

    public Point3d getLocPoint() {
        return this.d_location.point;
    }

    @Override
    public IGeomNode getGeom() {
        boolean checkAttachedPositions = true;
        AgentGeom geom = new AgentGeom((OccProfile.OccShape)this.getProfile().get(OccProfile.PROP_SHAPE), this.d_location, this.getShoulderWidth().getValue(Geometry.LENGTH_UNIT) * 0.5, this.getAngle().getValue(Geometry.ANGLE_UNIT), this.getRoomFilter(), checkAttachedPositions);
        return GeomNodeUtil.newNode(geom);
    }

    @Override
    public void setGeom(IGeomNode node) {
        IGeom geom = node.flatten().getLocalGeom();
        if (geom instanceof AgentGeom) {
            AgentGeom ag = (AgentGeom)geom;
            this.setLocation(ag.location);
            this.setOrient(ag.angle);
        } else if (geom instanceof Point) {
            this.setLocation(new OccLocation(((Point)geom).loc));
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return DisplayGeom.EMPTY;
    }

    @Override
    public void getAll(Consumer<Object> result, IIsectFilter filter) {
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull box, IDisplayProps dprops) {
    }

    @Override
    public void pickPoints(thunderheadeng.scene3d.picking.IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester, IDisplayProps dprops) {
    }

    public String toString() {
        return "name=" + this.d_name + " loc=" + String.valueOf(this.getLocPoint());
    }

    public OccProfile getProfile() {
        return this.d_profile;
    }

    public void setProfile(OccProfile profile) {
        this.d_profile = profile;
        this.d_profile.setDomain((MerlinData)this.getDomain());
        this.updateProps(PROFILE);
    }

    public void setProfileParent(OccProfile parent) {
        if (this.d_profile.getProfParent() == parent) {
            return;
        }
        this.pauseUpdates();
        this.d_profile.setProfParent(parent);
        this.updateProps(PARENT_PROFILE);
        this.resumeUpdates();
    }

    @Deprecated
    public Object getAndClearPre9ExitObj() {
        Object exit = this.d_exit;
        this.d_exit = null;
        return exit;
    }

    @Deprecated
    public Set<EgressDoor> getAndClearPre17Exits() {
        try {
            if (this.d_exit == null) {
                Set set = Collections.EMPTY_SET;
                return set;
            }
            if (this.d_exit instanceof EgressDoor) {
                IdentityHashSet<EgressDoor> identityHashSet = Sets.fromArrayIHS((EgressDoor)this.d_exit);
                return identityHashSet;
            }
            Set set = (Set)this.d_exit;
            return set;
        }
        finally {
            this.d_exit = null;
        }
    }

    public Behavior getBehavior() {
        return this.d_behavior;
    }

    public void setBehavior(Behavior behavior) {
        if (behavior == this.d_behavior) {
            return;
        }
        this.d_behavior = behavior;
        this.pauseUpdates();
        this.markOverlapDirty();
        this.markTopoDirty();
        this.changedEvt(BEHAVIOR);
        this.resumeUpdates();
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    public <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>> AgentValue<ProfT> getStoredProfileVal(PropT prop) {
        return this.getStoredProfileVal(EgressAgent.asAgentProfProp(prop));
    }

    public <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>> AgentValue<ProfT> getStoredProfileVal(AgentProfProp<OccT, ProfT, PropT> oprop) {
        boolean local = this.isDefinedLocally((IProfileProp<?, ?>)oprop.baseProp);
        Object baseVal = this.getProfile().get(oprop.baseProp.asProp());
        return new AgentValue(local, baseVal);
    }

    public <OccT, ProfT> void setLocalProfileVal(IProfileProp<OccT, ProfT> oprop, ProfT value) {
        this.setProfileVal(EgressAgent.asAgentProfProp(oprop), new AgentValue<ProfT>(true, value));
    }

    public <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>> void setProfileVal(AgentProfProp<OccT, ProfT, PropT> oprop, AgentValue<ProfT> value) {
        if (!value.isLocal) {
            this.removeProfileValue((IProfileProp<?, ?>)oprop.baseProp);
            return;
        }
        try (IDomainObject.EventPause pause = this.openPause();){
            AgentValue prev = (AgentValue)this.get(oprop);
            this.getProfile().set(oprop.baseProp.asProp(), value.value);
            if (!Objects.equals(prev, value)) {
                this.propChanged((IProfileProp<?, ?>)oprop.baseProp);
            }
        }
    }

    public <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>> AgentValue<OccT> getOccProfileVal(AgentOccProp<OccT, ProfT, PropT> rprop) {
        boolean local = this.isDefinedLocally((IProfileProp<?, ?>)rprop.baseProp);
        OccT resolvedVal = this.toOccValue((IProfileProp<OccT, ProfT>)rprop.baseProp);
        return new AgentValue<OccT>(local, resolvedVal);
    }

    public <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>> void setOccupantVal(AgentOccProp<OccT, ProfT, PropT> rprop, AgentValue<OccT> occVal) {
        AgentProfProp profProp = EgressAgent.asAgentProfProp(rprop.baseProp);
        AgentValue<Object> newVal = !occVal.isLocal ? new AgentValue<Object>(false, null) : new AgentValue(true, rprop.toProf.apply(this, occVal.value));
        this.setProfileVal(profProp, newVal);
    }

    public boolean isDefinedLocally(IProfileProp<?, ?> prop) {
        return this.getProfile().isDefinedLocally(prop.asProp());
    }

    public <OccT, ProfT> OccT toOccValue(IProfileProp<OccT, ProfT> oprop) {
        return this.getProfile().toOccValue(oprop, this.getProfileSeed(), this.getOrientSeed());
    }

    public void removeProfileValue(IProfileProp<?, ?> prop) {
        if (!this.isDefinedLocally(prop)) {
            return;
        }
        try (IDomainObject.EventPause paused = this.openPause();){
            this.getProfile().remove(prop.asProp());
            this.propChanged(prop);
        }
    }

    protected void propChanged(IProfileProp<?, ?> prop) {
        try (IDomainObject.EventPause paused = this.openPause();){
            if (prop instanceof ProfileProps.Prop) {
                ProfileProps.Prop pprop = (ProfileProps.Prop)prop;
                if (pprop.geometric) {
                    this.markTopoDirty();
                }
            }
            if (prop == OccProfile.PROP_DIAMETER || prop == OccProfile.PROP_SHAPE || prop == OccProfile.PROP_INIT_ORIENT) {
                this.markOverlapDirty();
            }
            this.fireProfilePropChanged(prop);
        }
    }

    protected void fireProfilePropChanged(IProfileProp<?, ?> prop) {
        this.changedEvt(prop, EgressAgent.asAgentOccProp(prop), EgressAgent.asAgentProfProp(prop), PROFILE_PROP_CHANGED);
    }

    public void updateProps(TypedProp<?> propChanged) {
        this.pauseUpdates();
        this.markTopoDirty();
        this.markOverlapDirty();
        if (propChanged instanceof IProfileProp) {
            IProfileProp pprop = (IProfileProp)((Object)propChanged);
            this.fireProfilePropChanged(pprop);
        } else if (propChanged != null) {
            this.changedEvt(Events.EVT_GENERAL, propChanged);
        } else {
            this.changedEvt(new Object[0]);
        }
        this.resumeUpdates();
    }

    public static <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>> AgentProfProp<OccT, ProfT, PropT> asAgentProfProp(PropT prop) {
        AgentProfProp aprop = s_propProfPropMap.get(prop);
        assert (aprop != null);
        return aprop;
    }

    public static <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>> AgentOccProp<OccT, ProfT, PropT> asAgentOccProp(PropT prop) {
        AgentOccProp result = s_propOccPropMap.get(prop);
        assert (result != null);
        return result;
    }

    static {
        OccProfile.streamProfileProps().map(prop -> new AgentProfProp((IProfileProp)prop)).forEach(prop -> prop.registerProp(PROP_TYPES));
        s_propProfPropMap = PROP_TYPES.props().stream().filter(p -> p instanceof AgentProfProp).map(p -> (AgentProfProp)p).collect(Collectors.toMap(p -> p.baseProp, p -> p));
        OccProfile.streamProfileProps().map(prop -> {
            AgentOccProp<Object, Object, IProfileProp> agentOccProp;
            if (prop instanceof IProfilePropDist) {
                IProfilePropDist dprop = (IProfilePropDist)prop;
                agentOccProp = new AgentOccProp<Object, Object, IProfilePropDist>(dprop, (a, dval) -> dprop.toOccValue(a.getProfile(), dval, a.getProfileSeed(), a.getOrientSeed()), (a, sval) -> dprop.toProfileValue(sval));
            } else {
                agentOccProp = new AgentOccProp<Object, Object, IProfileProp>((IProfileProp)prop, (a, val) -> val, (a, val) -> val);
            }
            return agentOccProp;
        }).forEach(prop -> prop.registerProp(PROP_TYPES));
        s_propOccPropMap = PROP_TYPES.props().stream().filter(p -> p instanceof AgentOccProp).map(p -> (AgentOccProp)p).collect(Collectors.toMap(p -> p.baseProp, p -> p));
        TAGS = PROP_TYPES.storeAsWrapper(MerlinData.TAGS).attrGetter((prop, obj) -> (Set)obj.getStoredProfileVal(OccProfile.PROP_TAGS).value(), EgressAgent.asAgentProfProp(OccProfile.PROP_TAGS)).attrSetter((prop, obj, val) -> obj.setProfileVal(EgressAgent.asAgentProfProp(OccProfile.PROP_TAGS), new AgentValue<Set>(true, (Set)val)), null).attrUndoPropRestore(false, EgressAgent.asAgentProfProp(OccProfile.PROP_TAGS)).attrMarkersOverride(Filters.reject(MerlinData.SCENARIO_MARKER)).attrFinish();
    }

    public static class AgentProfProp<OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>>
    extends TypedProp<AgentValue<ProfT>>
    implements IDisplayProp<AgentValue<ProfT>> {
        public final PropT baseProp;

        private AgentProfProp(PropT baseProp) {
            this(baseProp, baseProp.streamMarkers().collect(Collectors.toSet()));
        }

        private AgentProfProp(PropT baseProp, Set<Object> markers) {
            super(new AgentProfPropKey(baseProp.getKey()), AgentValue.class, markers);
            this.baseProp = baseProp;
        }

        @Override
        public String getGroupDisplayName() {
            return this.baseProp.getGroupDisplayName();
        }

        @Override
        public String getDisplayName() {
            return this.baseProp.getDisplayName();
        }

        @Override
        public String getDisplayDesc() {
            return this.baseProp.getDisplayDesc();
        }

        @Override
        public String formatValue(Object src, AgentValue<ProfT> value) {
            return String.format(value.isLocal ? Intl.intl("[Customized] %s") : Intl.intl("[Inherited] %s"), this.baseProp.formatValue(src, value.value));
        }

        @Override
        public IDisplayProp.ValEditorSupplier<AgentValue<ProfT>> getValEditorSupplier() {
            return null;
        }

        @Override
        public TypedProp<AgentValue<ProfT>> asProp() {
            return this;
        }

        @Override
        public <MedT extends Mediator, ObjT extends IDomainObject<MedT>> IPropComparisonEditorSupplier<MedT, ObjT, AgentValue<ProfT>> getComparisonEditorSupplier() {
            return null;
        }

        public AgentProfProp<OccT, ProfT, PropT> registerProp(PropertyDefs<EgressAgent> props) {
            EnumSet<PropertyDefsFramework.Options> baseOptions = OccProfile.SHARED_PROFILE_PROPS.getAttrOptions(this.baseProp.asProp());
            PropertyDefsFramework.ICloneValue baseClone = OccProfile.SHARED_PROFILE_PROPS.getAttrCloneValue(this.baseProp.asProp());
            PropertyDefsFramework.ICloneValue baseGetRestore = OccProfile.SHARED_PROFILE_PROPS.getAttrRestoreValue(this.baseProp.asProp());
            PropertyDefsFramework.ISurrogateEquals baseSurrEquals = OccProfile.SHARED_PROFILE_PROPS.getAttrSurrogateEquals(this.baseProp.asProp());
            boolean baseHasDeps = OccProfile.SHARED_PROFILE_PROPS.hasDependencyCallback(this.baseProp.asProp());
            props.storeAsPlainOldData(this).attrGetter(agent -> agent.getStoredProfileVal(this), Stream.empty()).attrSetter((agent, val) -> agent.setProfileVal(this, val), (agent, val) -> agent.setProfileVal(this, val)).attrCloneValue(baseClone == null ? null : (agent, val) -> val.isLocal ? new AgentValue(true, baseClone.clone(agent.getProfile(), val.value)) : new AgentValue<Object>(false, null)).attrRestoreValue(baseGetRestore == null ? null : (agent, val) -> val.isLocal ? new AgentValue(true, baseGetRestore.clone(agent.getProfile(), val.value)) : new AgentValue<Object>(false, null)).attrSurrogateEquals(baseSurrEquals == null ? null : (obj1, v1, obj2, v2, comparedList) -> {
                if (v1.isLocal && v2.isLocal) {
                    return baseSurrEquals.test(obj1.getProfile(), v1.value, obj2.getProfile(), v2.value, comparedList);
                }
                return v1.isLocal == v2.isLocal;
            }).attrOptions(baseOptions == null ? EnumSet.noneOf(PropertyDefsFramework.Options.class) : baseOptions).attrDependencyStream(!baseHasDeps ? null : prop -> agent -> OccProfile.SHARED_PROFILE_PROPS.streamDependencies(agent.getProfile(), this.baseProp.asProp()).map(dep -> AgentProfProp.toAgentPropDep(this, dep))).attrFinish();
            return this;
        }

        private static <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>, RefT> DepCallback<MerlinData, EgressAgent, AgentValue<ProfT>, RefT> toAgentPropDep(AgentProfProp<OccT, ProfT, PropT> aprop, DepCallback<MerlinData, ? super IProfileObj, ProfT, RefT> dep) {
            return Dependencies.newDependency(aprop, dep.link(), dep.refType(), (md, src, aval) -> aval.isLocal ? dep.streamRefs().stream((MerlinData)md, src.getProfile(), aval.value()) : Stream.empty(), dep.getReplFilter() != null ? (md, src) -> dep.getReplFilter().getReplacementFilter((MerlinData)md, src.getProfile()) : null, dep.replDep() != null ? (md, src, val, old, repl) -> {
                if (val.value() == null) {
                    return val;
                }
                Object baseRepl = dep.replDep().replace((MerlinData)md, src.getProfile(), val.value(), old, repl);
                if (baseRepl == val.value()) {
                    return val;
                }
                return new AgentValue(val.isLocal, baseRepl);
            } : null);
        }
    }

    public record AgentValue<T>(boolean isLocal, T value) implements Serializable
    {
    }

    protected static class AgentGeom
    implements IGeom,
    IManipulatable {
        private static final long serialVersionUID = -5824877637848085033L;
        private final OccLocation location;
        private final double radius;
        private final Predicate<IEgressOccupiable> roomFilter;
        private final OccProfile.OccShape shape;
        private final double angle;
        private final boolean includeAttachedPositions;

        public AgentGeom(OccProfile.OccShape shape, OccLocation loc, double radius, double angle, Predicate<IEgressOccupiable> roomFilter, boolean includesAttachedPositions) {
            this.shape = shape;
            this.location = loc;
            this.radius = radius;
            this.angle = angle;
            this.roomFilter = roomFilter;
            this.includeAttachedPositions = includesAttachedPositions;
        }

        @Override
        public IGeom optimize(IPointOptimizer pointOptimizer) {
            return this;
        }

        @Override
        public AABox getBoundingBox(AABox aabb) {
            Point3d loc = this.location.point;
            aabb.add(switch (this.shape.type) {
                case VehicleShape.ShapeType.POLYGON -> {
                    Point3d[] points = this.includeAttachedPositions ? this.shape.vehicleShape.getOuterPoints(loc, this.angle) : this.shape.vehicleShape.getBodyPoints(loc, this.angle);
                    yield new AABox(points);
                }
                default -> {
                    Point3d min = new Point3d(loc.x - this.radius, loc.y - this.radius, loc.z - this.radius);
                    Point3d max = new Point3d(loc.x + this.radius, loc.y + this.radius, loc.z + this.radius);
                    yield new AABox(min, max);
                }
            });
            return aabb;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.INVERTIBLE;
        }

        @Override
        public IDOF getRetainingDOF() {
            return IDOF.INVERTIBLE;
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d xform = ti.getMatrix();
            Point3d newLoc = Util3D.xform(xform, this.location.point);
            Vector3d ref = new Vector3d(1.0, 0.0, 0.0);
            Inter.rotateTuple2D(ref, this.angle, GeomConstants.VEC3D_ZPOS);
            xform.transform(ref);
            double newAngle = Util3D.angle0To2PI(GeomConstants.VEC3D_XPOS, new Vector3d(ref.x, ref.y, 0.0), GeomConstants.VEC3D_ZPOS);
            OccLocation loc = MerlinApp.getApp().getData().findValidOccLocation(this.shape, newLoc, new UnitDouble(this.radius * 2.0, Geometry.LENGTH_UNIT), newAngle, 0, this.roomFilter);
            return new AgentGeom(this.shape, loc, this.radius, newAngle, this.roomFilter, this.includeAttachedPositions);
        }

        @Override
        public boolean isAxisAlignedBlock(TransformInfo parentXform) {
            return false;
        }

        @Override
        public boolean isShell() {
            return false;
        }

        @Override
        public int getNumPrims(int types) {
            return 0;
        }

        @Override
        public Iterator<Byte> iteratePrimTypes(int offset) {
            return Collections.emptyIterator();
        }

        @Override
        public boolean canExplode() {
            return false;
        }

        @Override
        public Collection<IGeom> explode(Collection<IGeom> prims) {
            return prims;
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, IElemSource<Boolean> creases, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
        }

        @Override
        public void pickBox(Object source, IElemSource<Boolean> visFaceEdges, IIsectFilter filter, ConvexHull region, thunderheadeng.geometry.objs.IBoxCollector isects) throws CancelObjectPicking {
        }

        @Override
        public void find(ITest<AABox> test, IResult<? super IGeom.FoundPrimitive> result) {
        }

        @Override
        public void getAll(IResult<? super IPrimitive> result) {
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new LocHandle(this));
            handles.accept(new OrientHandle(this));
        }

        protected static class LocHandle
        implements IHandle {
            protected AgentGeom d_geom;

            public LocHandle(AgentGeom geom) {
                this.d_geom = geom;
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof LocHandle;
            }

            @Override
            public IGeomNode getGeom() {
                return GeomNodeUtil.newNode(new Point(this.d_geom.location.point));
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                DefaultFilter filter = new DefaultFilter(this, IEgressOccupiable.class, GeomType.FACE){

                    @Override
                    public boolean acceptPickObject(Object obj) {
                        return super.acceptPickObject(obj) && ((IEgressOccupiable)obj).getOccupantsAllowed();
                    }
                };
                return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, filter);
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return null;
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            }

            @Override
            public AgentGeom modify(IsectInfo constraintInfo, Point3d newLoc) throws ManipException {
                MerlinData md = MerlinApp.getApp().getData();
                OccLocation loc = md.findValidOccLocation(this.d_geom.shape, newLoc, new UnitDouble(this.d_geom.radius * 2.0, Geometry.LENGTH_UNIT), this.d_geom.angle, 0, this.d_geom.roomFilter);
                boolean blocked = GeomUtil.isPoint3dInPreventingBlockage(md, loc.point, 0);
                if (loc.room == null || loc.overlapsWalls || loc.failsFilter || blocked) {
                    throw new ManipException();
                }
                this.d_geom = new AgentGeom(this.d_geom.shape, loc, this.d_geom.radius, this.d_geom.angle, this.d_geom.roomFilter, this.d_geom.includeAttachedPositions);
                return this.d_geom;
            }

            @Override
            public AgentGeom end() {
                return this.d_geom;
            }
        }

        protected static class OrientHandle
        implements IHandle {
            private final double handleLength;
            private AgentGeom d_geom;

            public OrientHandle(AgentGeom geom) {
                double handleLength;
                this.d_geom = geom;
                if (geom.shape.type == VehicleShape.ShapeType.POLYGON && geom.shape.vehicleShape != null) {
                    Point3d[] shape = geom.shape.vehicleShape.getBodyPoints();
                    Point3d centroid = Util3D.simplePolygonCentroid(shape);
                    double minDistSq = Double.MAX_VALUE;
                    for (int m = 0; m < shape.length; ++m) {
                        Point3d p1 = shape[m];
                        Point3d p2 = shape[(m + 1) % shape.length];
                        double distsq = Inter3D.distSqToNearestPtOnLineSeg(p1, p2, centroid);
                        if (!(distsq < minDistSq)) continue;
                        minDistSq = distsq;
                    }
                    handleLength = minDistSq == Double.MAX_VALUE ? 1.0 : Math.sqrt(minDistSq);
                } else {
                    handleLength = geom.radius;
                }
                this.handleLength = Math.max(handleLength, 0.5);
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof OrientHandle;
            }

            @Override
            public IGeomNode getGeom() {
                Vector3d orient = new Vector3d(1.0, 0.0, 0.0);
                Inter.rotateTuple2D(orient, this.d_geom.angle, new Point3d(0.0, 0.0, 0.0));
                orient.scale(this.handleLength);
                orient.add(this.d_geom.location.point);
                Point3d orientPoint = new Point3d(orient);
                return GeomNodeUtil.newNode(new LineSeg(this.d_geom.location.point, orientPoint));
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            }

            @Override
            public AgentGeom modify(IsectInfo constraintInfo, Point3d newLoc) throws ManipException {
                Point3d agentLoc = this.d_geom.location.point;
                Point3d agentOrient = new Point3d(agentLoc);
                agentOrient.add(new Point3d(1.0, 0.0, 0.0));
                double newAngle = Inter2D.getAngle(agentLoc, agentOrient, newLoc);
                OccLocation loc = MerlinApp.getApp().getData().findValidOccLocation(this.d_geom.shape, this.d_geom.location.point, new UnitDouble(this.d_geom.radius * 2.0, Geometry.LENGTH_UNIT), newAngle, 0, this.d_geom.roomFilter);
                if (loc.room == null || loc.overlapsWalls || loc.failsFilter) {
                    throw new ManipException();
                }
                this.d_geom = new AgentGeom(this.d_geom.shape, loc, this.d_geom.radius, newAngle, this.d_geom.roomFilter, this.d_geom.includeAttachedPositions);
                return this.d_geom;
            }

            @Override
            public Object end() {
                return this.d_geom;
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return new Pair<SnapMode, Object>(SnapMode.ANY, null);
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return new PlanarConstraint(new Plane3d(GeomConstants.VEC3D_ZPOS, this.d_geom.location.point));
            }
        }
    }

    public static class AgentOccProp<OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>>
    extends TypedProp<AgentValue<OccT>>
    implements IDisplayProp<AgentValue<OccT>> {
        public final PropT baseProp;
        public final BiFunction<? super EgressAgent, ProfT, OccT> fromProf;
        public final BiFunction<? super EgressAgent, OccT, ProfT> toProf;

        private AgentOccProp(PropT baseProp, BiFunction<? super EgressAgent, ProfT, OccT> fromProf, BiFunction<? super EgressAgent, OccT, ProfT> toProf) {
            super(new AgentOccPropKey(baseProp), AgentValue.class, Set.of());
            this.baseProp = baseProp;
            this.fromProf = fromProf;
            this.toProf = toProf;
        }

        protected void registerProp(PropertyDefs<EgressAgent> props) {
            Supplier<IPropComparisonEditorSupplier> getComparisonSupplier = () -> {
                if (this.baseProp instanceof IProfilePropUnary) {
                    IPropComparisonEditorSupplier baseEdSuppl = OccProfile.ALL_PROPS.getAttrComparisonEditor(this.baseProp.asProp());
                    if (baseEdSuppl == null) {
                        return null;
                    }
                    return (parent, md) -> {
                        ISimplePropComparisonEd baseEd = baseEdSuppl.get(parent, md);
                        return new AgentComparisonEd(baseEd);
                    };
                }
                if (this.baseProp instanceof IProfilePropDist) {
                    IPropComparisonEditorSupplier baseEdSuppl = OccProfile.ALL_PROPS.getAttrCustom(this.baseProp.asProp(), OccProfile.occCompEdAttr()).orElse(null);
                    if (baseEdSuppl == null) {
                        return null;
                    }
                    return (parent, md) -> {
                        ISimplePropComparisonEd baseEd = baseEdSuppl.get(parent, md);
                        return new AgentComparisonEd(baseEd);
                    };
                }
                assert (false);
                return null;
            };
            props.storeAsWrapper(this).attrGetter(agent -> agent.getOccProfileVal(this), Stream.empty()).attrSetter((agent, val) -> agent.setOccupantVal(this, val), null).attrUndoPropRestore(true, new TypedProp[0]).attrComparisonEditor(getComparisonSupplier.get()).attrFinish();
        }

        @Override
        public String getGroupDisplayName() {
            return this.baseProp.getGroupDisplayName();
        }

        @Override
        public String getDisplayName() {
            return String.format(Intl.intl("Occ. %s"), this.baseProp.getDisplayName());
        }

        @Override
        public String getDisplayDesc() {
            return this.baseProp.getDisplayDesc();
        }

        @Override
        public IDisplayProp.ValEditorSupplier<AgentValue<OccT>> getValEditorSupplier() {
            return null;
        }

        @Override
        public <MedT extends Mediator, ObjT extends IDomainObject<MedT>> IPropComparisonEditorSupplier<MedT, ObjT, ? super AgentValue<OccT>> getComparisonEditorSupplier() {
            return null;
        }

        @Override
        public String formatValue(Object src, AgentValue<OccT> value) {
            return String.format(value.isLocal ? Intl.intl("[Customized] %s") : Intl.intl("[Inherited] %s"), this.baseProp.formatValue(src, this.baseProp.toProfileValue(value.value)));
        }

        @Override
        public TypedProp<AgentValue<OccT>> asProp() {
            return this;
        }
    }

    private static class AgentComparisonEd<ValT>
    extends guiPanel
    implements ISimplePropComparisonEd<EgressAgent, AgentValue<ValT>> {
        private static final long serialVersionUID = 1L;
        private final guiComboBox<Type> d_typeCb = guiUtil.newLabeledCombo((ILabeled[])Type.values());
        private final ISimplePropComparisonEd<? super OccProfile, ? super ValT> d_baseEd;

        public AgentComparisonEd(ISimplePropComparisonEd<? super OccProfile, ? super ValT> baseEd) {
            this.d_baseEd = baseEd;
            guiPanel baseUi = this.d_baseEd.getUi();
            Runnable updateBaseEd = () -> {
                boolean newVisible;
                boolean visible = baseUi.isVisible();
                if (visible != (newVisible = this.d_typeCb.getSelectedItem().matchSpec)) {
                    baseUi.setVisible(newVisible);
                    SwingUtilities.invokeLater(() -> {
                        Window parentWindow = SwingUtilities.getWindowAncestor(this);
                        if (parentWindow != null) {
                            parentWindow.pack();
                        }
                    });
                }
            };
            this.d_typeCb.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    updateBaseEd.run();
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.d_typeCb, 0);
            gb.addFilledRow(baseUi);
            gb.finalizeRows();
            updateBaseEd.run();
        }

        @Override
        public guiPanel getUi() {
            return this;
        }

        @Override
        public void update(Events events) {
            this.d_baseEd.update(events);
        }

        @Override
        public Predicate<? super AgentValue<ValT>> getSimplePredicate() {
            switch (this.d_typeCb.getSelectedItem().ordinal()) {
                case 1: {
                    return v -> !v.isLocal;
                }
                case 3: {
                    return v -> v.isLocal;
                }
                case 2: {
                    Predicate basePred = this.d_baseEd.getSimplePredicate();
                    return v -> !v.isLocal && basePred.test((Object)v.value);
                }
                case 4: {
                    Predicate basePred = this.d_baseEd.getSimplePredicate();
                    return v -> v.isLocal && basePred.test((Object)v.value);
                }
                case 0: {
                    Predicate basePred = this.d_baseEd.getSimplePredicate();
                    return v -> basePred.test((Object)v.value);
                }
            }
            assert (false);
            return Predicates.alwaysTrue();
        }

        private static enum Type implements ILabeled
        {
            EITHER_AS(Intl.intl("Matches following criteria"), Intl.intl("The occupant's value matches the specified criteria (ignores whether the property is inherited from the profile or customized)."), true),
            INHERITED(Intl.intl("Is inherited"), Intl.intl("The occupant's value is derived from the profile."), false),
            INHERITED_AS(Intl.intl("Is inherited and matches critiera"), Intl.intl("The occupant's value is derived from the profile and matches the specified criteria."), true),
            CUSTOMIZED(Intl.intl("Is customized"), Intl.intl("The occupant's value is customized for the occupant."), false),
            CUSTOMIZED_AS(Intl.intl("Is customized and matches criteria"), Intl.intl("The occupant's value is customized for the occupant and matches the specified criteria."), true);

            public final String name;
            public final String desc;
            public final boolean matchSpec;

            private Type(String name, String desc, boolean matchSpec) {
                this.name = name;
                this.desc = desc;
                this.matchSpec = matchSpec;
            }

            @Override
            public String getDescription() {
                return this.desc;
            }

            @Override
            public String getName() {
                return this.name;
            }
        }
    }

    public record AgentOccPropKey<OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>>(PropT prop) {
    }

    public record AgentProfPropKey<OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>>(Object propKey) implements Serializable
    {
    }
}

