/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.gui.guiUtil;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Warning;

public class SimError
extends Warning {
    public static final int WARNINGINFO_OBJS = 2;
    public final Level level;
    public final String cause;
    public final String fix;
    public final Set<? extends IMerlinObj> causeObjs;

    public SimError(Level level, String cause, String fix, IMerlinObj ... causeObjs) {
        this(level, cause, fix, Set.of(causeObjs));
    }

    public SimError(Level level, String cause, String fix, Collection<? extends IMerlinObj> causeObjs) {
        super(cause, fix);
        Set<IMerlinObj> set;
        this.level = level;
        this.cause = cause;
        this.fix = fix;
        if (causeObjs instanceof Set) {
            Set set2 = (Set)causeObjs;
            set = set2;
        } else {
            set = new LinkedIdentityHashSet<IMerlinObj>(causeObjs);
        }
        this.causeObjs = set;
    }

    public String format() {
        return String.format(Intl.intl("%1$s: %2$s"), this.level.label, this.cause);
    }

    @Override
    public Comparable<?> getWarningInfo(int type) {
        if (type == 2) {
            List names = this.causeObjs.stream().map(o -> o != null ? o.getName() : "").collect(Collectors.toList());
            return guiUtil.escapeHTML(String.join((CharSequence)"; ", names));
        }
        return super.getWarningInfo(type);
    }

    public static enum Level implements Comparable<Level>
    {
        MODERATE(Intl.intl("Warning"), 5),
        CRITICAL(Intl.intl("Error"), 10);

        public final String label;
        public final int severity;

        private Level(String label, int severity) {
            this.label = label;
            this.severity = severity;
        }
    }
}

