/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.camera;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.camera.ICameraObj;
import merlin.data.camera.IViewObj;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.geom.Geometry;
import merlin.geom.IMerlinGeomSrc;
import org.jscience.physics.units.NonSI;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;

public class Camera
extends NamedMerlinObj
implements ICameraObj,
IMerlinGeomSrc,
IViewObj,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<Camera> ALL_PROPS = PropertyDefs.defsInheritPropsOnly(Camera.class, PropertyDefs.serializedOnly(cam -> cam.d_props, cam -> {
        cam.d_props = new PropertySet();
    }), NamedMerlinObj.PROPS);
    @Deprecated
    public static final IPropertySet.Prop<Type> PROP_TYPE = new IPropertySet.Prop<Type>(1, Type.PERSPECTIVE);
    @Deprecated
    public static final IPropertySet.Prop<Point3d> PROP_LOC = new IPropertySet.Prop<Point3d>(2, new Point3d(0.0, 0.0, 1.0));
    @Deprecated
    public static final IPropertySet.Prop<Point3d> PROP_REF = new IPropertySet.Prop<Point3d>(3, new Point3d(0.0, 0.0, 0.0));
    @Deprecated
    public static final IPropertySet.Prop<Vector3d> PROP_UP = new IPropertySet.Prop<Vector3d>(4, new Vector3d(0.0, 1.0, 0.0));
    @Deprecated
    public static final IPropertySet.Prop<double[]> PROP_CLIP = new IPropertySet.Prop<double[]>(5, new double[]{0.1, Double.POSITIVE_INFINITY});
    @Deprecated
    public static final IPropertySet.Prop<Double> PROP_ZOOM = new IPropertySet.Prop<Double>(6, 1.0);
    @Deprecated
    public static final IPropertySet.Prop<Point2d> PROP_ZOOM_LOC = new IPropertySet.Prop<Point2d>(7, new Point2d(0.0, 0.0));
    @Deprecated
    public static final IPropertySet.Prop<Double> PROP_FOV = new IPropertySet.Prop<Double>(8, UnitDouble.convert(65.0, NonSI.DEGREE_ANGLE, Geometry.ANGLE_UNIT));
    public static final DisplayProp<Boolean> PROP_SECURITY = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)9, Boolean.FALSE, Intl.intl("Security Camera"), Intl.intl("Treats the camera as a security camera that can be controlled during the simulation.")).attrAddMarkersIf(MerlinApp.isFP(), MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(ALL_PROPS).attrFinish();
    public static final TypedProp<PTZSpec> PROP_PAN_INFO = TypedProps.build(10, PTZSpec.class, new PTZSpec(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.7853981633974483)).attrStoreAsPlainOldData(ALL_PROPS).attrFinish();
    public static final TypedProp<PTZSpec> PROP_TILT_INFO = TypedProps.build(11, PTZSpec.class, new PTZSpec(-1.5707963267948966, 0.0, 0.7853981633974483)).attrStoreAsPlainOldData(ALL_PROPS).attrFinish();
    public static final TypedProp<PTZSpec> PROP_ZOOM_INFO = TypedProps.build(12, PTZSpec.class, new PTZSpec(1.0, Double.POSITIVE_INFINITY, 2.0)).attrStoreAsPlainOldData(ALL_PROPS).attrFinish();
    public static final DisplayProp<Vector3d> PROP_PTZ_ORIENT = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)13, Vector3d.class, GeomConstants.VEC3D_ZPOS, Intl.intl("Orientation"), "").attrAddMarkersIf(MerlinApp.isFP(), MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(ALL_PROPS).attrFinish();
    public static final TypedProp<CameraRecord> PROP_CAMDATA = TypedProps.build(14, CameraRecord.class, new CameraRecord(new Point3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), 1.0, new Point2d(0.0, 0.0), 0.1, Double.POSITIVE_INFINITY, new PerspectiveCamera.FrustumRecord(Math.toRadians(65.0)))).attrStoreAsPlainOldData(ALL_PROPS).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = TagsUtil.newTagsProp(ALL_PROPS);
    public static DisplayProp<Boolean> VISIBILITY = ALL_PROPS.storeAsPlainOldData(MerlinData.VISIBILITY).attrGetter(Camera::isVisible, Stream.empty()).attrSetter(Camera::setVisible, null).attrFinish();
    private PropertySet d_props = new PropertySet();
    private boolean d_visible = true;

    public Camera(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        IPropertySet.Prop[] legProps;
        in.defaultReadObject();
        Map<Object, Object> map = this.d_props.getMap();
        for (IPropertySet.Prop prop : legProps = new IPropertySet.Prop[]{PROP_PAN_INFO, PROP_TILT_INFO, PROP_ZOOM_INFO}) {
            Object val = map.get(prop.key);
            if (!(val instanceof double[])) continue;
            double[] dval = (double[])val;
            PTZSpec spec = new PTZSpec(dval[0], dval[1], ((PTZSpec)prop.defVal).maxSpeed);
            map.put(prop.key, spec);
        }
        if (this.d_props.isDefined(PROP_LOC)) {
            IPropertySet.Prop[] legCamdataProps;
            CameraRecord.IFrustumRecord frustum = this.d_props.get(PROP_TYPE) == Type.PERSPECTIVE ? new PerspectiveCamera.FrustumRecord(this.d_props.get(PROP_FOV)) : new OrthoCamera.FrustumRecord(this.d_props.get(PROP_FOV));
            CameraRecord cr = new CameraRecord(this.d_props.get(PROP_LOC), this.d_props.get(PROP_REF), this.d_props.get(PROP_UP), this.d_props.get(PROP_ZOOM), this.d_props.get(PROP_ZOOM_LOC), this.d_props.get(PROP_CLIP)[0], this.d_props.get(PROP_CLIP)[1], frustum);
            this.set(PROP_CAMDATA, cr);
            for (IPropertySet.Prop legProp : legCamdataProps = new IPropertySet.Prop[]{PROP_LOC, PROP_REF, PROP_UP, PROP_CLIP, PROP_ZOOM, PROP_ZOOM_LOC, PROP_TYPE, PROP_FOV}) {
                this.d_props.remove(legProp);
            }
        }
    }

    @Override
    public void setCameraState(CameraRecord cs) {
        this.set(PROP_CAMDATA, cs);
    }

    @Override
    public CameraRecord getCameraState() {
        return this.get(PROP_CAMDATA);
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return ALL_PROPS;
    }

    public Set<Tag> getTags() {
        return this.get(MerlinData.TAGS);
    }

    public void setTags(Set<Tag> newTags) {
        this.set(MerlinData.TAGS, newTags);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode p = this.getGeom();
        IPrimProps.Vertex pprops = new IPrimProps.Vertex(Color.PINK, 10.0);
        return new DisplayGeom(p, (IPrimProps)pprops);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible == visible) {
            return;
        }
        this.d_visible = visible;
        this.changedEvt(MerlinData.VISIBILITY);
    }

    public static class PTZSpec
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final double rangeMin;
        public final double rangeMax;
        public final double maxSpeed;

        public PTZSpec(double rangeMin, double rangeMax, double maxSpeed) {
            this.rangeMin = rangeMin;
            this.rangeMax = rangeMax;
            this.maxSpeed = maxSpeed;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof PTZSpec && ((PTZSpec)obj).rangeMin == this.rangeMin && ((PTZSpec)obj).rangeMax == this.rangeMax && ((PTZSpec)obj).maxSpeed == this.maxSpeed;
        }

        public int hashCode() {
            return 0xFE2323A9 ^ theUtil.hashCode(this.rangeMin) + theUtil.hashCode(this.rangeMax) + theUtil.hashCode(this.maxSpeed);
        }
    }

    public static enum Type {
        ORTHO,
        PERSPECTIVE;

    }
}

