/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.animation;

import java.util.Objects;
import merlin.Intl;
import merlin.data.animation.AAnimationClip;
import merlin.data.property.DisplayProps;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;

public class PivotAnimationClip
extends AAnimationClip {
    private static final long serialVersionUID = 1L;
    public static final DisplayProp<UnitDouble> NATURAL_SPEED = DisplayProps.build((Object)-1262855578, UnitDouble.class, new UnitDouble(0.0, SI.RADIAN.divide(SI.SECOND)), Intl.intl("Natural Speed"), Intl.intl("The natural turning speed of this animation.\nWhen the occupant is turning at this speed, the animation will be played back at 1x speed.\nIf the occupant is turning at twice this speed, the animation will be played back at 2x speed, etc.")).attrToProp();
    public static final DisplayProp<UnitDouble> TOP_SPEED = DisplayProps.build((Object)-325372069, UnitDouble.class, new UnitDouble(Double.POSITIVE_INFINITY, SI.RADIAN.divide(SI.SECOND)), Intl.intl("Top Speed"), Intl.intl("The maximum movement speed at which this clip will be used.")).attrToProp();
    private final UnitDouble d_naturalSpeed;
    private final UnitDouble d_topSpeed;

    public PivotAnimationClip(IPropertySet values) {
        super(values);
        this.d_naturalSpeed = values.get(NATURAL_SPEED);
        this.d_topSpeed = values.get(TOP_SPEED);
    }

    public static PropertySet getDefaults() {
        PropertySet defaults = AAnimationClip.getDefaults();
        defaults.setIfNotDefault(TOP_SPEED, new UnitDouble(0.0, SI.METER.divide(SI.SECOND)));
        return defaults;
    }

    @Override
    protected void getValues(PropertySet props) {
        props.setIfNotDefault(NATURAL_SPEED, this.d_naturalSpeed);
        props.setIfNotDefault(TOP_SPEED, this.d_topSpeed);
    }

    @Override
    public boolean surrogateEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        PivotAnimationClip clip = (PivotAnimationClip)obj;
        return super.surrogateEquals(clip) && Objects.equals(this.d_naturalSpeed, clip.d_naturalSpeed) && Objects.equals(this.d_topSpeed, clip.d_topSpeed);
    }

    public UnitDouble getNaturalSpeed() {
        return this.d_naturalSpeed;
    }

    public UnitDouble getTopSpeed() {
        return this.d_topSpeed;
    }
}

