/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.animation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import merlin.data.animation.AAnimationClip;
import merlin.data.animation.AnimDirection;
import merlin.data.animation.Animation;
import merlin.data.animation.AnimationTransform;
import merlin.data.animation.IdleAnimationClip;
import merlin.data.animation.MoveAnimationClip;
import merlin.data.animation.PivotAnimationClip;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import thunderheadeng.io.JsonUtil;

public class JsonAnimationWriter {
    public static void writeAnimationFile(Animation anim, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            writer.write(JsonAnimationWriter.writeAnimationFile(anim).toJSONString());
        }
    }

    public static JSONObject writeAnimationFile(Animation anim) {
        JSONObject jobj = new JSONObject();
        jobj.put("anims", JsonUtil.toJson(JsonAnimationWriter.writeAnimation(anim)));
        JsonAnimationWriter.addExtras(jobj, anim.getExtraFileProps());
        return jobj;
    }

    private static JSONObject writeAnimation(Animation anim) {
        JSONObject jobj = new JSONObject();
        jobj.put("uuid", anim.getUuid().toString());
        jobj.put("type", anim.getType().jsonName);
        jobj.put("tags", JsonUtil.toJson(anim.getTags()));
        switch (anim.getType()) {
            case IDLE: {
                JsonAnimationWriter.writeIdleClip(jobj, anim.getIdleClip());
                break;
            }
            case MOVE: {
                jobj.put("clips", JsonUtil.toJson(anim.getMoveClips(), JsonAnimationWriter::writeMoveClip));
                jobj.put("dir", JsonAnimationWriter.writeDirections(anim.getDirections()));
                break;
            }
            case PIVOT: {
                jobj.put("clips", JsonUtil.toJson(anim.getPivotClips(), JsonAnimationWriter::writePivotClip));
                jobj.put("dir", JsonAnimationWriter.writeDirections(anim.getDirections()));
            }
        }
        JsonAnimationWriter.addExtras(jobj, anim.getExtraAnimProps());
        return jobj;
    }

    private static JSONArray writeDirections(Set<AnimDirection> directions) {
        JSONArray array = new JSONArray();
        for (AnimDirection dir : directions) {
            array.add(dir.jsonName);
        }
        return array;
    }

    private static void writeIdleClip(JSONObject target, IdleAnimationClip clip) {
        JsonAnimationWriter.writeBaseClip(target, clip);
        target.put("idlePlayback", clip.getIdlePlayback().jsonName);
    }

    private static JSONObject writeMoveClip(MoveAnimationClip clip) {
        JSONObject jobj = new JSONObject();
        JsonAnimationWriter.writeBaseClip(jobj, clip);
        jobj.put("naturalSpeed", clip.getNaturalSpeed().getValue(SI.METER.divide(SI.SECOND)));
        jobj.put("maxSpeed", clip.getTopSpeed().getValue(SI.METER.divide(SI.SECOND)));
        return jobj;
    }

    private static JSONObject writePivotClip(PivotAnimationClip clip) {
        JSONObject jobj = new JSONObject();
        JsonAnimationWriter.writeBaseClip(jobj, clip);
        jobj.put("naturalSpeed", clip.getNaturalSpeed().getValue(SI.RADIAN.divide(SI.SECOND)));
        jobj.put("maxSpeed", clip.getTopSpeed().getValue(SI.RADIAN.divide(SI.SECOND)));
        return jobj;
    }

    private static void writeBaseClip(JSONObject target, AAnimationClip clip) {
        target.put("uuid", clip.getUuid().toString());
        target.put("path", clip.getPath());
        target.put("frameOffset", clip.getFrameOffset().get(Unit.ONE));
        target.put("transform", JsonUtil.toJson(JsonAnimationWriter.writeTransform(clip.getTransform())));
        target.put("retargetTo", clip.getRetargetMode().jsonName);
        target.put("retargetSource", clip.getRetargetSource());
        JsonAnimationWriter.addExtras(target, clip.getExtraProps());
    }

    private static JSONObject writeTransform(AnimationTransform xform) {
        JSONObject jobj = new JSONObject();
        jobj.put("scale", xform.getScale().get(Unit.ONE));
        jobj.put("rotate", JsonUtil.toJson(xform.getRotationAxis().x, xform.getRotationAxis().y, xform.getRotationAxis().z, xform.getRotation().get(NonSI.DEGREE_ANGLE)));
        jobj.put("translate", JsonUtil.toJson(xform.getTranslation().getVector3dValue(SI.METER)));
        return jobj;
    }

    private static void addExtras(JSONObject base, JSONObject extras) {
        for (Map.Entry obj : extras.entrySet()) {
            Map.Entry entry;
            if (!(obj instanceof Map.Entry) || !((entry = obj).getKey() instanceof String) || base.containsKey(entry.getKey())) continue;
            base.put(entry.getKey(), entry.getValue());
        }
    }
}

