/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.animation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.NamedMerlinObj;
import merlin.data.animation.AAnimationClip;
import merlin.data.animation.AnimDirection;
import merlin.data.animation.AnimType;
import merlin.data.animation.IdleAnimationClip;
import merlin.data.animation.MoveAnimationClip;
import merlin.data.animation.PivotAnimationClip;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.util.StringTagsUtil;
import org.json.simple.JSONObject;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;

public class Animation
extends NamedMerlinObj
implements ISurrogate {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<Animation> PROP_TYPES = PropertyDefs.defsInheritStorageAndProps(Animation.class, null, NamedMerlinObj.PROPS);
    public static final DisplayProp<Set<String>> TAGS = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.buildGeneric(634846507, Set.class, theUtil.emptySet(String.class), Intl.intl("Tags"), Intl.intl("Identifies the animation. These tags are matched against those in an occupant's profile\nto determine which animation to play.")).attrFormatValue(v -> StringTagsUtil.format(v))).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(Animation::getTags, Stream.empty()).attrSetter(Animation::setTags, null).attrFinish();
    public static final DisplayProp<IdleAnimationClip> IDLE_CLIP = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)136676565, IdleAnimationClip.class, new IdleAnimationClip(IdleAnimationClip.getDefaults()), Intl.intl("Clip"), "").attrFormatValue((obj, v) -> AAnimationClip.FILE.formatValue(obj, v.getPath()))).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(Animation::getIdleClip, Stream.empty()).attrSetter(Animation::setIdleClip, null).attrFinish();
    public static final DisplayProp<List<MoveAnimationClip>> MOVE_CLIPS = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.buildGeneric(-601540412, List.class, theUtil.emptyList(MoveAnimationClip.class), Intl.intl("Clips"), Intl.intl("Animation clips to pick between depending on the occupant's movement speed.")).attrFormatValue((obj, v) -> v.stream().map(c -> AAnimationClip.FILE.formatValue(obj, c.getPath())).collect(Collectors.joining(",")))).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(Animation::getMoveClips, Stream.empty()).attrSetter(Animation::setMoveClips, null).attrFinish();
    public static final DisplayProp<List<PivotAnimationClip>> PIVOT_CLIPS = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.buildGeneric(1021934925, List.class, theUtil.emptyList(PivotAnimationClip.class), Intl.intl("Clips"), Intl.intl("Animation clips to pick between depending on the occupant's turning speed.")).attrFormatValue((obj, v) -> v.stream().map(c -> AAnimationClip.FILE.formatValue(obj, c.getPath())).collect(Collectors.joining(",")))).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(Animation::getPivotClips, Stream.empty()).attrSetter(Animation::setPivotClips, null).attrFinish();
    public static final DisplayProp<Set<AnimDirection>> DIRECTION = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.buildGeneric(1913319301, Set.class, theUtil.emptySet(AnimDirection.class), Intl.intl("Direction"), Intl.intl("The direction an occupant must be moving to use this animation.")).attrFormatValue(v -> v.stream().map(d -> d.displayName).collect(Collectors.joining(",")))).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(Animation::getDirections, Stream.empty()).attrSetter(Animation::setDirections, null).attrFinish();
    public static final DisplayProp<AnimType> TYPE = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)-1969745471, AnimType.class, AnimType.IDLE, Intl.intl("Type"), Intl.intl("Defines whether this animation will play while idling or moving.")).attrFormatValue(v -> v.displayName)).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(Animation::getType, Stream.empty()).attrSetter((prop, type) -> prop.setType((AnimType)((Object)type)), (prop, type) -> prop.setType((AnimType)((Object)type), false)).attrUndoPropRestore(true, DIRECTION, MOVE_CLIPS, PIVOT_CLIPS).attrFinish();
    public static final UUID UUID_ZERO = new UUID(0L, 0L);
    public static final TypedProp<UUID> PROP_UUID = TypedProps.build("Animation.PROP_UUID", UUID.class, UUID_ZERO).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(Animation::getUuid, Stream.empty()).attrSetter(Animation::setUuid, null).attrSurrogateEquals(null).attrFinish();
    public static final TypedProp<JSONObject> EXTRA_FILE_PROPS = TypedProps.build("Animation.EXTRA_FILE_PROPS", JSONObject.class, new JSONObject()).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(Animation::getExtraFileProps, Stream.empty()).attrSetter(Animation::setExtraFileProps, null).attrFinish();
    public static final TypedProp<JSONObject> EXTRA_ANIM_PROPS = TypedProps.build("Animation.EXTRA_ANIM_PROPS", JSONObject.class, new JSONObject()).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(Animation::getExtraAnimProps, Stream.empty()).attrSetter(Animation::setExtraAnimProps, null).attrFinish();
    private UUID d_uuid = UUID.randomUUID();
    private AnimType d_animType = AnimType.IDLE;
    private Set<String> d_tags = Collections.emptySet();
    private IdleAnimationClip d_idleClip;
    private List<MoveAnimationClip> d_moveClips;
    private List<PivotAnimationClip> d_pivotClips;
    private Set<AnimDirection> d_directions;
    private JSONObject d_extraFileProps;
    private JSONObject d_extraAnimProps;

    public Animation() {
        this.d_idleClip = (IdleAnimationClip)Animation.IDLE_CLIP.defVal;
        this.d_moveClips = List.of();
        this.d_pivotClips = List.of();
        this.d_directions = Collections.emptySet();
        this.d_extraFileProps = new JSONObject();
        this.d_extraAnimProps = new JSONObject();
    }

    public UUID getUuid() {
        return this.d_uuid;
    }

    public void setUuid(UUID uuid) {
        if (!this.d_uuid.equals(uuid)) {
            this.d_uuid = uuid;
            this.changedEvt(PROP_UUID);
        }
    }

    public AnimType getType() {
        return this.d_animType;
    }

    public void setType(AnimType type) {
        this.setType(type, true);
    }

    public void setType(AnimType type, boolean updateEffects) {
        if (this.d_animType != type) {
            this.pauseUpdates();
            this.d_animType = type;
            if (updateEffects) {
                switch (type) {
                    case IDLE: {
                        this.setDirections(Collections.emptySet());
                        this.setMoveClips(Collections.emptyList());
                        this.setPivotClips(Collections.emptyList());
                        break;
                    }
                    case MOVE: {
                        this.setPivotClips(Collections.emptyList());
                        break;
                    }
                    case PIVOT: {
                        this.setMoveClips(Collections.emptyList());
                    }
                }
            }
            this.changedEvt(TYPE);
            this.resumeUpdates();
        }
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.d_tags);
    }

    public void setTags(Set<String> tags) {
        if (!this.d_tags.equals(tags)) {
            this.pauseUpdates();
            this.d_tags = tags;
            this.changedEvt(TAGS);
            this.resumeUpdates();
        }
    }

    public IdleAnimationClip getIdleClip() {
        return this.d_idleClip;
    }

    public void setIdleClip(IdleAnimationClip clip) {
        if (!Objects.equals(this.d_idleClip, clip)) {
            this.d_idleClip = clip;
            this.changedEvt(IDLE_CLIP);
        }
    }

    public List<MoveAnimationClip> getMoveClips() {
        return Collections.unmodifiableList(this.d_moveClips);
    }

    public void setMoveClips(List<MoveAnimationClip> clips) {
        if (!this.d_moveClips.equals(clips)) {
            this.d_moveClips = clips;
            this.changedEvt(MOVE_CLIPS);
        }
    }

    public List<PivotAnimationClip> getPivotClips() {
        return Collections.unmodifiableList(this.d_pivotClips);
    }

    public void setPivotClips(List<PivotAnimationClip> clips) {
        if (!this.d_pivotClips.equals(clips)) {
            this.d_pivotClips = clips;
            this.changedEvt(PIVOT_CLIPS);
        }
    }

    public JSONObject getExtraAnimProps() {
        return this.d_extraAnimProps;
    }

    public void setExtraAnimProps(JSONObject props) {
        if (!this.d_extraAnimProps.equals(props)) {
            this.d_extraAnimProps = props;
            this.changedEvt(EXTRA_ANIM_PROPS);
        }
    }

    public JSONObject getExtraFileProps() {
        return this.d_extraFileProps;
    }

    public void setExtraFileProps(JSONObject props) {
        if (!this.d_extraFileProps.equals(props)) {
            this.d_extraFileProps = props;
            this.changedEvt(EXTRA_FILE_PROPS);
        }
    }

    public Set<AnimDirection> getDirections() {
        return Collections.unmodifiableSet(this.d_directions);
    }

    public void setDirections(Set<AnimDirection> directions) {
        if (!this.d_directions.equals(directions)) {
            this.pauseUpdates();
            this.d_directions = directions;
            this.changedEvt(DIRECTION);
            this.resumeUpdates();
        }
    }

    public List<AAnimationClip> getClips() {
        switch (this.getType()) {
            case IDLE: {
                return Collections.singletonList(this.getIdleClip());
            }
            case MOVE: {
                return Collections.unmodifiableList(this.getMoveClips());
            }
            case PIVOT: {
                return Collections.unmodifiableList(this.getPivotClips());
            }
        }
        return Collections.emptyList();
    }

    public void generateUuids() {
        this.pauseUpdates();
        this.setUuid(UUID.randomUUID());
        UnaryOperator newUuid = vals -> {
            vals.setIfNotDefault(AAnimationClip.ID, UUID.randomUUID());
            return vals;
        };
        this.setIdleClip(new IdleAnimationClip((IPropertySet)newUuid.apply(this.d_idleClip.getValues())));
        this.setMoveClips(Animation.modifyProp(this.d_moveClips, p -> newUuid.apply(p), MoveAnimationClip::new));
        this.setPivotClips(Animation.modifyProp(this.d_pivotClips, p -> newUuid.apply(p), PivotAnimationClip::new));
        this.resumeUpdates();
    }

    public void modifyClipVals(Consumer<? super PropertySet> modifyVals) {
        switch (this.getType()) {
            case IDLE: {
                this.setIdleClip(Animation.modifyProp(List.of(this.getIdleClip()), modifyVals, IdleAnimationClip::new).get(0));
                break;
            }
            case MOVE: {
                this.setMoveClips(Animation.modifyProp(this.getMoveClips(), modifyVals, MoveAnimationClip::new));
                break;
            }
            case PIVOT: {
                this.setPivotClips(Animation.modifyProp(this.getPivotClips(), modifyVals, PivotAnimationClip::new));
            }
        }
    }

    private static <ClipT extends AAnimationClip, ValT> List<ClipT> modifyProp(List<ClipT> clips, Consumer<? super PropertySet> modifyVals, Function<IPropertySet, ClipT> newClip) {
        ArrayList<AAnimationClip> result = new ArrayList<AAnimationClip>(clips.size());
        for (AAnimationClip oldClip : clips) {
            PropertySet newVals = oldClip.getValues();
            modifyVals.accept(newVals);
            result.add((AAnimationClip)newClip.apply(newVals));
        }
        return result;
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }
}

