/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.animation;

import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.UUID;
import merlin.Intl;
import merlin.data.animation.AnimRetargetMode;
import merlin.data.animation.AnimationTransform;
import merlin.data.property.DisplayProps;
import merlin.gui.guiUtil;
import org.jscience.physics.units.Unit;
import org.json.simple.JSONObject;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;

public abstract class AAnimationClip
implements Serializable,
ISurrogate {
    private static final long serialVersionUID = 1L;
    public static final TypedProp<UUID> ID = TypedProps.build("AAnimationClip.UUID", UUID.class, new UUID(0L, 0L)).attrToProp();
    public static final DisplayProp<String> FILE = ((TeciDisplayProps.Builder)DisplayProps.build((Object)1987994580, "", Intl.intl("Clip"), Intl.intl("The animation file that will be played.")).attrFormatValue(v -> Paths.get(v, new String[0]).getFileName().toString())).attrToProp();
    public static final DisplayProp<UnitDouble> FRAME_OFFSET = DisplayProps.build((Object)355421375, UnitDouble.class, new UnitDouble(0.0, Unit.ONE), Intl.intl("Start Frame"), Intl.intl("Remaps the specified frame as the first frame of the animation.\nFor walking animations, this should be the frame at which the\navatar's legs are together and the left leg is about to step forward.")).attrToProp();
    public static final DisplayProp<AnimationTransform> TRANSFORM = ((TeciDisplayProps.Builder)DisplayProps.build((Object)75572467, AnimationTransform.class, new AnimationTransform(), Intl.intl("Transform"), Intl.intl("Transformation applied to this animation during playback.")).attrFormatValueWithToString()).attrToProp();
    public static final DisplayProp<AnimRetargetMode> RETARGET_MODE = ((TeciDisplayProps.Builder)DisplayProps.build((Object)1097401916, AnimRetargetMode.class, AnimRetargetMode.SELF, Intl.intl("Retarget Mode"), Intl.intl("Defines how this animation will be retargeted to avatars.")).attrFormatValue(v -> v.displayName)).attrToProp();
    public static final DisplayProp<String> RETARGET_SOURCE = ((TeciDisplayProps.Builder)DisplayProps.build((Object)-1377799430, "", Intl.intl("Base Pose"), guiUtil.encodeToHtmlLabel(Intl.intl("Defines the file containing either a T-pose or A-pose for the animation's avatar.\nUsually, this is a file containing the avatar itself. Some animation files may contain\nboth the animation and the base pose."))).attrFormatValue(v -> Paths.get(v, new String[0]).getFileName().toString())).attrToProp();
    public static final TypedProp<JSONObject> EXTRA_PROPS = TypedProps.build(125794963, JSONObject.class, new JSONObject()).attrToProp();
    private final UUID d_uuid;
    private final String d_path;
    private final UnitDouble d_frameOffset;
    private final AnimationTransform d_transform;
    private final AnimRetargetMode d_retargetMode;
    private final String d_retargetSource;
    private final JSONObject d_extraProps;

    protected AAnimationClip(IPropertySet props) {
        this.d_uuid = props.get(ID);
        this.d_path = props.get(FILE);
        this.d_frameOffset = props.get(FRAME_OFFSET);
        this.d_transform = props.get(TRANSFORM);
        this.d_retargetMode = props.get(RETARGET_MODE);
        this.d_retargetSource = props.get(RETARGET_SOURCE);
        this.d_extraProps = props.get(EXTRA_PROPS);
    }

    public static PropertySet getDefaults() {
        PropertySet result = new PropertySet();
        result.setIfNotDefault(ID, UUID.randomUUID());
        return result;
    }

    public PropertySet getValues() {
        PropertySet props = new PropertySet();
        props.setIfNotDefault(ID, this.d_uuid);
        props.setIfNotDefault(FILE, this.d_path);
        props.setIfNotDefault(FRAME_OFFSET, this.d_frameOffset);
        props.setIfNotDefault(TRANSFORM, this.d_transform);
        props.setIfNotDefault(RETARGET_MODE, this.d_retargetMode);
        props.setIfNotDefault(RETARGET_SOURCE, this.d_retargetSource);
        props.setIfNotDefault(EXTRA_PROPS, this.d_extraProps);
        this.getValues(props);
        return props;
    }

    protected abstract void getValues(PropertySet var1);

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        AAnimationClip clip = (AAnimationClip)obj;
        return this.d_uuid.equals(clip.d_uuid) && this.surrogateEquals(obj);
    }

    @Override
    public boolean surrogateEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        AAnimationClip clip = (AAnimationClip)obj;
        return Objects.equals(this.d_path, clip.d_path) && Objects.equals(this.d_frameOffset, clip.d_frameOffset) && Objects.equals(this.d_transform, clip.d_transform) && Objects.equals((Object)this.d_retargetMode, (Object)clip.d_retargetMode) && Objects.equals(this.d_retargetSource, clip.d_retargetSource);
    }

    public UUID getUuid() {
        return this.d_uuid;
    }

    public String getPath() {
        return this.d_path;
    }

    public UnitDouble getFrameOffset() {
        return this.d_frameOffset;
    }

    public AnimationTransform getTransform() {
        return this.d_transform;
    }

    public AnimRetargetMode getRetargetMode() {
        return this.d_retargetMode;
    }

    public String getRetargetSource() {
        return this.d_retargetSource;
    }

    public JSONObject getExtraProps() {
        return this.d_extraProps;
    }
}

