/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import merlin.data.AMerlinObj;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.property.PropertyDefs;
import merlin.util.Dependencies;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.framework.UndoFramework;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;

public class Proxy<T extends IMerlinObj>
extends AMerlinObj
implements IMerlinObj,
IDirectDependent<MerlinData>,
IEventObserver {
    static final long serialVersionUID = -3893471045648835311L;
    public static final PropertyDefs<Proxy<? extends IMerlinObj>> PROPS = PropertyDefs.defsRoot(theUtil.makeGeneric(Proxy.class), PropertyDefs.legacy(null));
    public static final TypedProp<IMerlinObj> OBJ = TypedProps.build("Proxy.OBJ", IMerlinObj.class, null).attrStoreAsReadOnly(PROPS).attrGetter(Proxy::getObj, Stream.empty()).attrDependency(prop -> Dependencies.newDependencyNoReplace(IMerlinObj.class)).attrSurrogateEquals((obj1, val1, obj2, val2, comparedSet) -> val1 == val2).attrFinish();
    public static final DisplayProp<String> NAME = PROPS.storeAsWrapper(NamedMerlinObj.NAME).attrGetter(obj -> obj.d_obj.getName(), Stream.of(OBJ)).attrSetter((obj, name) -> obj.d_obj.setName((String)name), null).attrUndoPropRestore((md, obj, prop) -> Proxy.getBaseUndoOp(md, obj, prop)).attrFinish();
    public static final DisplayProp<Boolean> ENABLED = PROPS.storeAsPlainOldData(MerlinData.ENABLED).attrGetter(Proxy::isEnabled, Stream.empty()).attrSetter(Proxy::setEnabled, null).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Boolean> VISIBLE = PROPS.storeAsWrapper(MerlinData.VISIBILITY).attrMarkersOverride(Set.of()).attrGetter(obj -> obj.d_obj.getWithDetails(MerlinData.VISIBILITY).orElse(true), OBJ).attrSetter((obj, val) -> {
        if (obj.d_obj.isSupportedLocallyCurrently(MerlinData.VISIBILITY)) {
            obj.d_obj.set(MerlinData.VISIBILITY, (Boolean)val);
        }
    }, null).attrUndoPropRestore((md, obj, prop) -> Proxy.getBaseUndoOp(md, obj, prop)).attrFinish();
    private final T d_obj;
    private boolean d_enabled = true;
    private static final Predicate<Object> DO_NOT_PASS_CHANGES = Filters.accept(MerlinData.PARENT_CHANGED, MerlinData.CHILD_ADDED, MerlinData.CHILD_REMOVED, MerlinData.CHILDREN_CHANGED);

    private static <T extends IMerlinObj, ValT, PropT extends TypedProp<ValT>> Optional<UndoFramework.UndoOp> getBaseUndoOp(MerlinData md, Proxy<T> obj, PropT prop) {
        return obj.getObj().getUndoOpPropRestore(List.of(prop));
    }

    public Proxy(T obj) {
        this.d_obj = obj;
    }

    @Override
    public Proxy<T> clone() {
        return (Proxy)super.clone();
    }

    @Override
    public String getName() {
        return this.get(NAME);
    }

    @Override
    public void setName(String name) {
        this.set(NAME, name);
    }

    @Override
    public boolean isSetNameSupported() {
        return this.d_obj.isSetNameSupported();
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROPS;
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(MerlinData.ENABLED, EventChannel.EVT_GENERAL);
        }
    }

    public T getObj() {
        return this.d_obj;
    }

    @Override
    protected void addToDomain(MerlinData domain, IMerlinObj parent) {
        super.addToDomain(domain, parent);
        domain.proxies.add(this);
        this.d_obj.notifyProxyAdded(this);
        domain.getEvents().addObserverInDomain((IEventObserver)this, this.d_obj.getClass(), false, false, NamedMerlinObj.NAME, MerlinData.VISIBILITY);
    }

    @Override
    protected void removeFromDomain(MerlinData domain, IMerlinObj parent) {
        domain.getEvents().removeObserverInDomain(this);
        this.d_obj.notifyProxyRemoved(this);
        domain.proxies.remove(this);
        super.removeFromDomain(domain, parent);
    }

    @Override
    public void update(Events events) {
        try (IDomainObject.EventPause paused = this.openPause();){
            if (events.isChanged(this.d_obj, NamedMerlinObj.NAME)) {
                this.changedEvt(NAME);
            }
            if (events.isChanged(this.d_obj, MerlinData.VISIBILITY)) {
                this.changedEvt(VISIBLE);
            }
        }
    }

    @Override
    protected Object[] targetChangesToParent(Object[] changes) {
        return this.removeIf(changes, DO_NOT_PASS_CHANGES);
    }

    private Object[] removeIf(Object[] changes, Predicate<Object> condition) {
        BitSet toRemove = new BitSet(changes.length);
        for (int m = 0; m < changes.length; ++m) {
            if (!condition.test(changes[m])) continue;
            toRemove.set(m);
        }
        if (toRemove.cardinality() == 0) {
            return changes;
        }
        Object[] newChanges = new Object[changes.length - toRemove.cardinality()];
        if (newChanges.length == 0) {
            return newChanges;
        }
        int ix = 0;
        for (int m = 0; m < changes.length; ++m) {
            if (toRemove.get(m)) continue;
            newChanges[ix++] = changes[m];
        }
        return newChanges;
    }

    public static Collection<Object> getProxyParents(IMerlinObj obj, boolean includeDisabledProxies) {
        Set<Proxy> allProxies;
        MerlinData md = (MerlinData)obj.getDomain();
        if (md == null) {
            return null;
        }
        Set<Proxy> set = allProxies = md.proxies != null ? md.proxies.getProxies(obj) : Collections.emptySet();
        if (allProxies.isEmpty()) {
            return null;
        }
        LinkedIdentityHashSet<Object> allParents = new LinkedIdentityHashSet<Object>();
        for (Proxy p : allProxies) {
            Object parent;
            if (!includeDisabledProxies && !p.isEnabled() || (parent = ((MerlinData)obj.getDomain()).hierarchy.getParent(p)) == null) continue;
            allParents.add(parent);
        }
        return allParents;
    }
}

