/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import merlin.data.Composite;
import merlin.data.CompositePropertyUtil;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.Proxy;
import merlin.data.egress.IEgressObj;
import merlin.data.property.PropertyDefs;
import merlin.data.scenario.ScenarioUtil;
import merlin.geom.IMerlinGeomSrc;
import merlin.io.MerlinOIS;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.gui.ADomainObject;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.ResultsIdGen;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public abstract class AMerlinObj
extends ADomainObject<MerlinData>
implements IMerlinObj,
Serializable {
    static final long serialVersionUID = 1L;
    public static final Logger LOGGER = Logger.getLogger(AMerlinObj.class.getSimpleName());
    private long d_resultsId = -1L;
    private static final Object[] s_emptyChanges = new Object[0];

    public AMerlinObj() {
        this.generateResultsIds();
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public Collection<? extends IMerlinObj> getChildren() {
        return Collections.emptyList();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public void generateResultsIds(ResultsIdGen ids) {
        this.d_resultsId = ids.nextId();
    }

    protected final void generateResultsIds() {
        this.generateResultsIds(ResultsIdGen.INSTANCE);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (MerlinOIS.getResetResultsId(in)) {
            this.generateResultsIds();
        }
    }

    @Override
    public AMerlinObj clone() {
        PropertyDefs<? extends IMerlinObj> mprops = this.getAllLocalProperties();
        AMerlinObj clone = (AMerlinObj)super.clone();
        clone.generateResultsIds();
        mprops.cloneValues(this, clone);
        return clone;
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public long getResultsId() {
        return this.d_resultsId;
    }

    public void setResultsId(long id) {
        this.d_resultsId = id;
    }

    protected void removeFromDomain(MerlinData domain, IMerlinObj parent) {
        if (this instanceof IEgressObj) {
            domain.topology.remove((IEgressObj)((Object)this));
        }
        if (this instanceof IMerlinGeomSrc) {
            domain.geomLocation.remove((IMerlinGeomSrc)((Object)this));
        }
        for (IMerlinObj iMerlinObj : this.getChildren()) {
            iMerlinObj.setDomain(null, this);
        }
        this.removedEvt((Object)this);
        ((MerlinData)this.getDomain()).hierarchy.removeFromHierarchy(this);
    }

    protected void addToDomain(MerlinData domain, IMerlinObj parent) {
        domain.hierarchy.addToHierarchy(parent, this);
        this.addedEvt((Object)this);
        for (IMerlinObj iMerlinObj : this.getChildren()) {
            iMerlinObj.setDomain(domain, this);
        }
        if (this instanceof IMerlinGeomSrc) {
            domain.geomLocation.add((IMerlinGeomSrc)((Object)this));
        }
        if (this instanceof IEgressObj) {
            domain.topology.add((IEgressObj)((Object)this));
        }
    }

    @Override
    public void setDomain(MerlinData domain, IMerlinObj parent) {
        if (this.getDomain() == domain) {
            return;
        }
        if (this.getDomain() != null) {
            this.pauseUpdates();
            this.removeFromDomain((MerlinData)this.getDomain(), parent);
            this.resumeUpdates();
        }
        super.setDomain(domain);
        if (domain != null) {
            this.pauseUpdates();
            this.addToDomain((MerlinData)this.getDomain(), parent);
            this.resumeUpdates();
        }
    }

    @Override
    @Deprecated
    public void setDomain(MerlinData owner) {
        super.setDomain(owner);
    }

    @Override
    public Set<TypedProp<?>> getSupportedProps(IMerlinObj.SupportMode mode) {
        PropertyDefs<? extends IMerlinObj> mprops = this.getAllLocalProperties();
        if (!this.isComposite()) {
            return mprops.props();
        }
        switch (mode) {
            case LOCAL_ONLY: {
                return mprops.props();
            }
            case UNION: 
            case INTERSECTION: {
                SequencedSet<TypedProp<?>> local = mprops.props();
                Predicate<? super TypedProp<?>> descendantFilter = this.getDescendantPropFilter();
                if (Filters.alwaysFalse(descendantFilter)) {
                    return local;
                }
                IFilteredCollection<TypedProp<?>> inherited = theUtil.filter(CompositePropertyUtil.getSupportedProps(mode, this.getChildren()), descendantFilter);
                if (!local.isEmpty() && !inherited.isEmpty()) {
                    LinkedHashSet result = new LinkedHashSet(inherited);
                    result.addAll(local);
                    return result;
                }
                if (!local.isEmpty()) {
                    return local;
                }
                if (!inherited.isEmpty()) {
                    return inherited;
                }
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    protected Predicate<? super TypedProp<?>> getDescendantPropFilter() {
        return Predicates.alwaysTrue();
    }

    @Override
    public <T> void set(TypedProp<T> prop, T val) {
        PropertyDefs<? extends IMerlinObj> mprops = this.getAllLocalProperties();
        if (!this.isComposite() || mprops.has(prop)) {
            mprops.setValue(this, prop, val);
            return;
        }
        try (IDomainObject.EventPause paused = this.openPause();){
            CompositePropertyUtil.setValue(prop, val, theUtil.filter(this.getChildren(), IMerlinObj.class));
            this.changedEvt(prop);
        }
    }

    protected final <T> boolean setToPropertySet(TypedProp<T> prop, T value) {
        PropertyDefs<? extends IMerlinObj> mprops = this.getAllLocalProperties();
        return mprops.compareAndSetDirect(this, prop, value);
    }

    protected final <T> T getFromPropertySet(TypedProp<T> prop) {
        PropertyDefs<? extends IMerlinObj> mprops = this.getAllLocalProperties();
        return mprops.getDirect(this, prop);
    }

    @Override
    public <T> PropValue<T> getWithDetails(TypedProp<T> prop) {
        PropertyDefs<? extends IMerlinObj> mprops = this.getAllLocalProperties();
        if (!this.isComposite() || mprops.has(prop)) {
            return mprops.getValue(this, prop);
        }
        return CompositePropertyUtil.getValue(prop, this.getChildren());
    }

    public Collection<? extends Proxy<? extends IMerlinObj>> getProxies() {
        MerlinData md = (MerlinData)this.getDomain();
        if (md == null) {
            return List.of();
        }
        return md.proxies.getProxies(this);
    }

    @Override
    public AMerlinObj getRestoreObj() {
        PropertyDefs<? extends IMerlinObj> mprops = this.getAllLocalProperties();
        return mprops.getRestoreObj(this, (AMerlinObj)super.clone());
    }

    @Override
    public void restoreFrom(Object obj) {
        if (obj == null) {
            return;
        }
        PropertyDefs<? extends IMerlinObj> mprops = this.getAllLocalProperties();
        if (!this.getClass().equals(obj.getClass())) {
            LOGGER.log(Level.WARNING, () -> String.format("Restore failed. Trying to restore from the wrong type. Expected to restore from %s; found %s", obj.getClass().getSimpleName(), this.getClass().getSimpleName()));
            return;
        }
        AMerlinObj other = (AMerlinObj)obj;
        mprops.restoreFrom(other, this);
    }

    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        PropertyDefs<? extends IMerlinObj> mprops = this.getAllLocalProperties();
        if (this == comparable) {
            return true;
        }
        if (comparable == null || !this.getClass().equals(comparable.getClass())) {
            return false;
        }
        AMerlinObj other = (AMerlinObj)comparable;
        return mprops.surrogateEquals(this, other, comparedSet);
    }

    public boolean surrogateEquals(Object comparable) {
        AMerlinObj aMerlinObj = this;
        if (aMerlinObj instanceof ICyclicSurrogate) {
            ICyclicSurrogate csurr = (ICyclicSurrogate)((Object)aMerlinObj);
            return csurr.cyclicEquals(comparable, new HashSet<UnorderedPair<Object, Object>>());
        }
        PropertyDefs<? extends IMerlinObj> mprops = this.getAllLocalProperties();
        if (this == comparable) {
            return true;
        }
        if (!this.getClass().isInstance(comparable)) {
            return false;
        }
        AMerlinObj other = (AMerlinObj)comparable;
        return mprops.surrogateEquals(this, other, null);
    }

    public void takeDepSnapshot(DepList<MerlinData> deps) {
        PropertyDefs<? extends IMerlinObj> mprops = this.getAllLocalProperties();
        mprops.takeDepSnapshot(this, deps);
    }

    public void writeTopology(ObjectOutputStream oos) throws IOException {
        PropertyDefs<? extends IMerlinObj> mprops = this.getAllLocalProperties();
        mprops.delayWriteObj(oos, this);
        for (IEgressObj child : theUtil.filter(this.getChildren(), IEgressObj.class)) {
            child.writeTopology(oos);
        }
    }

    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        PropertyDefs<? extends IMerlinObj> mprops = this.getAllLocalProperties();
        mprops.delayReadObj(ois, this);
        for (IEgressObj child : theUtil.filter(this.getChildren(), IEgressObj.class)) {
            child.readTopology(ois);
        }
    }

    protected <T extends IMerlinObj> void addChild(T child) {
        child.setDomain((MerlinData)this.getDomain(), this);
        this.changedEvt(MerlinData.CHILD_ADDED);
    }

    protected <T extends IMerlinObj> void addChildren(T ... children) {
        this.addChildren((Collection<T>)Arrays.asList(children));
    }

    protected <T extends IMerlinObj> void addChildren(Collection<T> children) {
        this.pauseUpdates();
        for (IMerlinObj child : children) {
            this.addChild(child);
        }
        this.resumeUpdates();
    }

    protected <T extends IMerlinObj> void removeChild(T child) {
        child.setDomain(null, this);
        this.changedEvt(MerlinData.CHILD_REMOVED);
    }

    protected <T extends IMerlinObj> void removeChildren(T ... children) {
        this.removeChildren((Collection<T>)Arrays.asList(children));
    }

    protected <T extends IMerlinObj> void removeChildren(Collection<T> children) {
        this.pauseUpdates();
        for (IMerlinObj child : children) {
            this.removeChild(child);
        }
        this.resumeUpdates();
    }

    protected static boolean allChangesMatch(Object[] changeList, Predicate<Object> changeTest) {
        if (changeList.length == 0) {
            return false;
        }
        return Stream.of(changeList).allMatch(changeTest);
    }

    protected Object[] targetChangesToParent(Object[] changes) {
        return s_emptyChanges;
    }

    @Override
    public boolean changedEvt(Object ... changes) {
        try (IDomainObject.EventPause paused = this.openPause();){
            MerlinData domain;
            Object parent;
            PropertyDefs<? extends IMerlinObj> mprops = this.getAllLocalProperties();
            mprops.changedEvt(this, changes);
            if (!AMerlinObj.allChangesMatch(changes, Filters.accept(MerlinData.SELECTION_CHANGED)) && (parent = this.getParent()) instanceof Composite) {
                if (AMerlinObj.allChangesMatch(changes, MerlinUtil::isVisibilityEvent)) {
                    ((Composite)parent).changedEvt(changes);
                } else {
                    ((Composite)parent).changedEvt(this.targetChangesToParent(changes));
                }
                ((Composite)parent).markPropsCacheDirty();
            }
            if ((domain = (MerlinData)this.getDomain()) != null) {
                AMerlinObj aMerlinObj;
                if (ScenarioUtil.getScenariosSupported(this)) {
                    domain.scenarios.notifyObjModified(this, changes);
                }
                if ((aMerlinObj = this) instanceof IMerlinGeomSrc) {
                    IMerlinGeomSrc mgeom = (IMerlinGeomSrc)((Object)aMerlinObj);
                    if (!AMerlinObj.allChangesMatch(changes, Filters.accept(MerlinData.SELECTION_CHANGED, MerlinData.VISIBILITY, MerlinData.CONNECTION).or(MerlinUtil::isVisibilityEvent))) {
                        domain.geomLocation.update(mgeom);
                    }
                }
                if (this instanceof IEgressObj && theUtil.contains(MerlinData.TOPOLOGY, changes)) {
                    domain.topology.changed((IEgressObj)((Object)this));
                }
            }
            boolean bl = super.changedEvt(changes);
            return bl;
        }
    }
}

