/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders.queues;

import javax.vecmath.Vector3d;
import merlin.builders.AQueueElementBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.data.egress.scripting.queues.QueuePathNode;
import merlin.geom.Geometry;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.units.UnitPoint3D;

public class QueuePathNodeBuilder
extends AQueueElementBuilder {
    public static final Object DEST_CHANGED = "QueuePathNodeBuilder.DEST_CHANGED";
    private UnitPoint3D d_dest = new UnitPoint3D(0.0, 0.0, 0.0, SI.METER);
    private IEgressOccupiable d_room = null;
    private Vector3d d_faceNormal = GeomConstants.VEC3D_ZPOS;

    public QueuePathNodeBuilder(MerlinData md) {
        super(md);
    }

    public void setDestination(UnitPoint3D dest, IEgressOccupiable room, Vector3d faceNormal) {
        if (!this.lock()) {
            return;
        }
        this.d_dest = dest;
        this.d_room = room;
        this.d_faceNormal = faceNormal;
        this.pause();
        this.firePropChanged(DEST_CHANGED);
        this.resume();
        this.release();
    }

    public UnitPoint3D getDestination() {
        return this.d_dest;
    }

    public IEgressOccupiable getRoom() {
        return this.d_room;
    }

    public Vector3d getFaceNormal() {
        return this.d_faceNormal;
    }

    @Override
    public boolean isValid() {
        return this.d_room != null;
    }

    @Override
    protected IQueueElement create() {
        return new QueuePathNode("Node", this.getDestination().getPoint3dValue(Geometry.LENGTH_UNIT), this.getRoom(), this.getFaceNormal());
    }

    @Override
    public void reset() {
    }
}

