/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import merlin.Intl;
import merlin.builders.CorridorBuilder;
import merlin.builders.CorridorUtil;
import merlin.builders.StairUtil;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressStair;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.Geometry;
import org.jscience.physics.units.NonSI;
import thunderheadeng.units.UnitDouble;

public class StairBuilder
extends CorridorBuilder {
    public static final Object TRISE_CHANGED = "StairBuilder.TRISE_CHANGED";
    public static final Object TRUN_CHANGED = "StairBuilder.TRUN_CHANGED";
    public static final Object[] VALIDITY_CHANGES = new Object[]{WIDTH_CHANGED, TRISE_CHANGED, TRUN_CHANGED, POINT_SET, TERM_CRITERIA_CHANGED};
    public UnitDouble d_treadRise = StairBuilder.getDefaultRise();
    public UnitDouble d_treadRun = new UnitDouble(11.0, NonSI.INCH);

    public StairBuilder(MerlinData data, CorridorBuilder.Mode mode) {
        super(data, mode, new StairUtil.StepCountTermCrit(17.0, StairBuilder.getDefaultRise().getValue(Geometry.LENGTH_UNIT)));
    }

    private static UnitDouble getDefaultRise() {
        return new UnitDouble(7.0, NonSI.INCH);
    }

    @Override
    protected EgressCorridor build(EgressCorridor.CorridorGeom geom, IEgressOccupiable room1, IEgressOccupiable room2) {
        EgressStair stair = new EgressStair(Intl.intl("Stair"), room1, room2, geom);
        stair.setTreadRise(this.d_treadRise);
        stair.setTreadRun(this.d_treadRun);
        return stair;
    }

    @Override
    protected String generateNextName(MerlinData md) {
        return md.stairNameGen.nextName();
    }

    @Override
    protected String getActionName() {
        return Intl.intl("New Stair");
    }

    @Override
    protected CorridorUtil.IBoundaryGen getBoundaryGen() {
        return new EgressStair.BoundaryGen(this.getTreadRise().getValue(Geometry.LENGTH_UNIT), this.getTreadRun().getValue(Geometry.LENGTH_UNIT));
    }

    public UnitDouble getTreadRise() {
        return this.d_treadRise;
    }

    public void setTreadRise(UnitDouble treadRise) {
        this.setProperty(StairBuilder.class, "d_treadRise", treadRise, true, TRISE_CHANGED);
        CorridorUtil.ITermCriteria criteria = this.getTermCriteria();
        if (criteria instanceof StairUtil.StepCountTermCrit) {
            StairUtil.StepCountTermCrit steps = (StairUtil.StepCountTermCrit)criteria;
            steps = new StairUtil.StepCountTermCrit(steps.d_numSteps, treadRise.getValue(Geometry.LENGTH_UNIT));
            this.setTermCriteria(steps);
        }
    }

    public UnitDouble getTreadRun() {
        return this.d_treadRun;
    }

    public void setTreadRun(UnitDouble treadRun) {
        this.setProperty(StairBuilder.class, "d_treadRun", treadRun, true, TRUN_CHANGED);
    }

    @Override
    protected void resetShifts() {
        super.resetShifts();
        this.shiftRun(false);
        this.shiftRise(false);
    }

    public void shiftRise(boolean makeNegative) {
        UnitDouble run = this.getTreadRise().abs();
        if (makeNegative) {
            run = run.negate();
        }
        this.setTreadRise(run);
    }

    public void shiftRun(boolean makeNegative) {
        UnitDouble run = this.getTreadRun().abs();
        if (makeNegative) {
            run = run.negate();
        }
        this.setTreadRun(run);
    }
}

