/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import merlin.Intl;
import merlin.builders.CorridorBuilder;
import merlin.builders.CorridorUtil;
import merlin.data.MerlinData;
import org.jscience.physics.units.NonSI;
import thunderheadeng.units.UnitDouble;

public class RampBuilder
extends CorridorBuilder {
    public static final Object SLOPE = "RampBuilder.SLOPE";
    private UnitDouble d_slopeAngle = new UnitDouble(5.0, NonSI.DEGREE_ANGLE);
    private Double d_slope = null;

    public RampBuilder(MerlinData data, CorridorBuilder.Mode mode) {
        super(data, mode, new CorridorUtil.LengthTermCrit(5.0));
    }

    public boolean isUsingSlopeAngle() {
        return this.d_slopeAngle != null;
    }

    public UnitDouble getSlopeAngle() {
        return this.d_slopeAngle;
    }

    public void setSlopeAngle(UnitDouble slopeAngle) {
        this.d_slope = null;
        this.setProperty(RampBuilder.class, "d_slopeAngle", slopeAngle, true, SLOPE);
    }

    public double getSlope() {
        return this.d_slope;
    }

    public void setSlope(double slope) {
        this.d_slopeAngle = null;
        this.setProperty(RampBuilder.class, "d_slope", slope, true, SLOPE);
    }

    public void shiftSlope(boolean makeNegative) {
        if (this.isUsingSlopeAngle()) {
            UnitDouble val = this.getSlopeAngle().abs();
            if (makeNegative) {
                val = val.negate();
            }
            this.setSlopeAngle(val);
        } else {
            double val = Math.abs(this.getSlope());
            if (makeNegative) {
                val = -val;
            }
            this.setSlope(val);
        }
    }

    @Override
    protected void resetShifts() {
        super.resetShifts();
        this.shiftSlope(false);
    }

    @Override
    protected String generateNextName(MerlinData md) {
        return md.rampNameGen.nextName();
    }

    @Override
    protected String getActionName() {
        return Intl.intl("New Ramp");
    }

    @Override
    protected CorridorUtil.IBoundaryGen getBoundaryGen() {
        return this.d_slopeAngle != null ? CorridorUtil.getSlopedBoundaryGenDeg(this.d_slopeAngle) : new CorridorUtil.SlopedBoundaryGen(this.d_slope);
    }
}

