/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.Area;
import java.util.Observable;
import java.util.Observer;
import javax.vecmath.Matrix4d;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.builders.WorkingPlane;
import merlin.data.MerlinData;
import merlin.geom.Geometry;
import merlin.util.MerlinProps;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.ShapeGeom;
import thunderheadeng.scene3d.text.IDimensionLabelSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;

public abstract class PlanarGeomBuilder
extends MerlinProps
implements Observer,
IPropertySet,
IDimensionLabelSrc {
    public static final Object NAME_CHANGED = "PlanarGeomBuilder.NAME_CHANGED";
    public static final Object NAV_GEOM_TYPE = "PlanarGeomBuilder.NAV_GEOM_TYPE";
    public static final Object COMPLETED = "PlanarGeomBuilder.COMPLETED";
    public static final Object CANCELLED = "PlanarGeomBuilder.CANCELLED";
    public static final IPropertySet.Prop<UnitDouble> Z_LOC = new IPropertySet.Prop<UnitDouble>("PlanarGeomBuilder.Z_LOC", new UnitDouble(0.0, SI.METER));
    private final MerlinData d_data;
    private final WorkingPlane d_workingPlane;
    private final IGeomBuilder d_builder;

    public abstract Shape getShape();

    protected abstract void reset();

    public abstract boolean isReadyToBegin();

    public PlanarGeomBuilder(MerlinData data, WorkingPlane workingPlane, IGeomBuilder builder) {
        this.d_data = data;
        this.d_builder = builder;
        this.d_workingPlane = workingPlane;
        this.d_workingPlane.addWeakObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.firePropChanged(Z_LOC);
    }

    protected MerlinData getModel() {
        return this.d_data;
    }

    public void setZLoc(UnitDouble zLoc) {
        this.d_workingPlane.setZLoc(zLoc);
    }

    public UnitDouble getZLoc() {
        return this.d_workingPlane.getZLoc();
    }

    public void cancel() {
        this.pause();
        this.reset();
        this.firePropChanged(CANCELLED);
        this.resume();
    }

    protected void addGeom(Component c) {
        Shape shape = this.getShape();
        Plane3d plane = new Plane3d(0.0, 0.0, 1.0, -this.getZLoc().getValue(Geometry.LENGTH_UNIT));
        Matrix4d lw = Util.getLocalToWorldXform(plane);
        Matrix4d wl = Util.getWorldToLocalXform(plane);
        Area area = new Area(shape);
        final ShapeGeom.ShapePrimitive geom = !area.isEmpty() ? new ShapeGeom.AreaFace(area, lw, wl, false) : new ShapeGeom.ShapeCurve(shape, lw, wl);
        AMerlinOp modOp = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                PlanarGeomBuilder.this.d_builder.build(md, PlanarGeomBuilder.this, geom);
            }
        };
        UIHook.run(c, "PlanarGeomBuilder.addGeom", modOp, 4);
    }

    public static interface IGeomBuilder {
        public void build(MerlinData var1, PlanarGeomBuilder var2, IGeom var3);
    }
}

