/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import merlin.Intl;
import merlin.actions.AddObject;
import merlin.actions.Undo;
import merlin.builders.PlanarGeomBuilder;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.INameGenerator;
import merlin.data.MerlinData;
import merlin.data.OccGroupTypeObj;
import merlin.data.OccSourceObj;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.scripting.Behavior;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.util.stat.Urn;

public class OccSourceBuilder
implements PlanarGeomBuilder.IGeomBuilder {
    private final double Z_TOLERANCE = 0.19;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(MerlinData md, PlanarGeomBuilder builder, IGeom geom) {
        AABox abox = geom.getBoundingBox(new AABox());
        if (!abox.isValid()) {
            return;
        }
        abox.set(abox.getMinX(), abox.getMinY(), abox.getMinZ() - 0.19, abox.getMaxX(), abox.getMaxY(), abox.getMaxZ() + 0.19);
        INameGenerator nameGenerator = md.occSourceNameGen;
        OccSourceObj obj = OccSourceBuilder.createOccSourceObj(md, abox, null, nameGenerator);
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("New Occupants Source"));
            try {
                AddObject.add((MerlinData)md, (Composite)md.occSources, (int)md.occSources.getMembers().size(), (IMerlinObj[])new OccSourceObj[]{obj});
            }
            finally {
                Undo.end(md);
                nameGenerator.nextName();
            }
        }
    }

    public static OccSourceObj createOccSourceObj(MerlinData md, AABox abox, IEgressComp comp, INameGenerator nameGenerator) {
        OccSourceObj obj;
        String name = nameGenerator.getCurrentName();
        if (abox != null) {
            obj = new OccSourceObj(name, abox);
        } else {
            assert (comp != null);
            obj = new OccSourceObj(name, comp);
        }
        obj.set(OccSourceObj.PROP_PROFILE_DIST, new Urn<OccProfile>(md.profiles.flatten(OccProfile.class).iterator().next()));
        obj.set(OccSourceObj.PROP_BEHAVIOR_DIST, new Urn<Behavior>(md.behaviors.flatten(Behavior.class).iterator().next()));
        obj.set(OccSourceObj.PROP_GROUP_TEMPLATE_DIST, new Urn<OccGroupTypeObj>(md.occGroupTypes.NO_GROUP_TYPE));
        return obj;
    }
}

