/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.util.Arrays;
import java.util.Collection;
import merlin.actions.FloorSortActions;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressComp;

public class NewCompUtil {
    public static void addEgressComp(MerlinData md, IEgressComp ... comps) {
        NewCompUtil.addEgressComp(md, true, comps);
    }

    public static void addEgressComp(MerlinData md, boolean doSelect, IEgressComp ... comps) {
        NewCompUtil.addEgressComps(md, doSelect, Arrays.asList(comps));
    }

    public static void addEgressComps(MerlinData md, boolean doSelect, Collection<? extends IEgressComp> comps) {
        for (IEgressComp iEgressComp : comps) {
            Composite<?> node = FloorSortActions.chooseGroup(md, iEgressComp);
            assert (node != null);
            Undo.insertUndoEntry_delete(md, node, iEgressComp);
            node.add(iEgressComp);
        }
        if (doSelect) {
            md.selection.set(comps);
        }
    }
}

