/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.awt.Component;
import java.util.Collections;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccLocation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.util.MerlinProps;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;

public class AgentDropper
extends MerlinProps
implements IEventObserver {
    public static final Object NAME_CHANGED = "AgentDropper.NAME_CHANGED";
    public static final Object LOC_CHANGED = "AgentDropper.LOC_CHANGED";
    public static final Object CREATE_AGENT = "AgentDropper.CREATE_AGENT";
    public static final Object PROFILE_CHANGED = "AgentDropper.PROFILE_CHANGED";
    public static final Object BEHAVIOR_CHANGED = "AgentDropper.BEHAVIOR_CHANGED";
    private final MerlinData d_data;
    private String d_name;
    private UnitPoint3D d_location = new UnitPoint3D(0.0, 0.0, 0.0, SI.METER);
    private IEgressOccupiable d_room = null;
    private boolean d_insideBlockage = false;
    private OccProfile d_parentProfile;
    private OccProfile d_currentProfile;
    private Behavior d_behavior;
    private long d_profileSeed = MerlinUtil.newSeed();

    public AgentDropper(MerlinData data) {
        this.d_data = data;
        this.d_parentProfile = (OccProfile)data.profiles.getMembers().iterator().next();
        this.d_currentProfile = new OccProfile(this.d_parentProfile);
        this.d_behavior = (Behavior)data.behaviors.getMembers().iterator().next();
        this.d_name = null;
        this.d_data.getEvents().addObserver(this);
    }

    public MerlinData getData() {
        return this.d_data;
    }

    public void setProfile(OccProfile prof) {
        if (!this.lock()) {
            return;
        }
        this.d_parentProfile = prof;
        this.d_currentProfile.setProfParent(this.d_parentProfile);
        this.firePropChanged(PROFILE_CHANGED);
        this.release();
    }

    public OccProfile getProfile() {
        return this.d_currentProfile;
    }

    public OccProfile getParentProfile() {
        return this.d_parentProfile;
    }

    public void setBehavior(Behavior behavior) {
        if (!this.lock()) {
            return;
        }
        this.d_behavior = behavior;
        this.firePropChanged(BEHAVIOR_CHANGED);
        this.release();
    }

    public Behavior getBehavior() {
        return this.d_behavior;
    }

    @Override
    public void update(Events events) {
        if (events.getEvents(OccProfile.class, new Class[0]).getRemovedObjs().contains(this.d_parentProfile)) {
            this.setProfile(this.d_data.profiles.getDeepMembers(OccProfile.class).iterator().next());
        }
        if (events.getEvents(Behavior.class, new Class[0]).getRemovedObjs().contains(this.d_behavior)) {
            this.setBehavior(this.d_data.behaviors.getDeepMembers(Behavior.class).iterator().next());
        }
    }

    public long getProfileSeed() {
        return this.d_profileSeed;
    }

    public boolean canCreate() {
        return this.d_room != null && !this.d_insideBlockage;
    }

    public void setName(String name) {
        if (!this.lock()) {
            return;
        }
        this.d_name = name;
        this.firePropChanged(NAME_CHANGED);
        this.release();
    }

    public String getName() {
        return this.d_name;
    }

    public Pair<IEgressOccupiable, UnitPoint3D> findRoom(UnitPoint3D loc) {
        return this.findRoom(loc, this.getShoulderWidth().get(Geometry.LENGTH_UNIT));
    }

    public Pair<IEgressOccupiable, UnitPoint3D> findRoom(UnitPoint3D loc, double maxDist) {
        int options = 8;
        double angleRad = this.getOrientation().getValue(SI.RADIAN);
        Predicate<IEgressOccupiable> roomFilter = EgressAgent.getRoomFilter(this.d_currentProfile);
        OccLocation result = this.d_data.findValidOccLocation((OccProfile.OccShape)this.d_currentProfile.get(OccProfile.PROP_SHAPE), loc.getPoint3dValue(Geometry.LENGTH_UNIT), this.getShoulderWidth(), maxDist, angleRad, options, roomFilter, Predicates.alwaysFalse());
        if (result.room == null || result.isOverlappingAgents() || result.overlapsWalls || result.failsFilter) {
            return null;
        }
        return new Pair<IEgressOccupiable, UnitPoint3D>(result.room, UnitPoint3D.convert(result.point, Geometry.LENGTH_UNIT, loc.getUnit()));
    }

    public void setLocation(IEgressOccupiable room, UnitPoint3D locOnRoom) {
        this.d_location = locOnRoom;
        this.d_room = room;
        this.updateInsideBlockage();
        this.firePropChanged(LOC_CHANGED);
    }

    public void setLocation(UnitPoint3D loc) {
        if (!this.lock()) {
            return;
        }
        try {
            Pair<IEgressOccupiable, UnitPoint3D> roomLoc = this.findRoom(loc);
            if (roomLoc == null) {
                this.setLocation(null, loc);
            } else {
                this.setLocation((IEgressOccupiable)roomLoc.v1, (UnitPoint3D)roomLoc.v2);
            }
        }
        finally {
            this.release();
        }
    }

    public void setOrientation(UnitDouble orientation) {
        if (!this.lock()) {
            return;
        }
        this.d_currentProfile.set(OccProfile.PROP_INIT_ORIENT, new ConstantCurve(orientation));
        this.firePropChanged(PROFILE_CHANGED);
        this.release();
    }

    public void removeOrientation() {
        if (!this.lock()) {
            return;
        }
        this.d_currentProfile.remove(OccProfile.PROP_INIT_ORIENT);
        this.firePropChanged(PROFILE_CHANGED);
        this.release();
    }

    public UnitPoint3D getLocation() {
        return this.d_location;
    }

    public IEgressOccupiable getRoom() {
        return this.d_room;
    }

    public OccLocation getOccLocation() {
        return new OccLocation(this.d_room, Collections.EMPTY_LIST, false, false, this.d_location.getPoint3dValue(Geometry.LENGTH_UNIT));
    }

    public UnitDouble getShoulderWidth() {
        ICurve diam = (ICurve)this.d_currentProfile.get(OccProfile.PROP_DIAMETER);
        return diam.getMax();
    }

    public UnitDouble getOrientation() {
        return this.d_currentProfile.toOccValue(OccProfile.PROP_INIT_ORIENT, this.d_profileSeed, this.d_profileSeed);
    }

    public UnitDouble getGeomShoulderWidth() {
        return this.getProfile().get(OccProfile.PROP_GEOM_DIAMETER);
    }

    public void reset() {
        this.removeOrientation();
    }

    public boolean isDefinedLocally(IPropertySet.Prop<?> prop) {
        return this.d_currentProfile.isDefinedLocally(prop);
    }

    public EgressAgent createAgent() {
        if (!this.canCreate()) {
            return null;
        }
        EgressAgent agent = new EgressAgent(this.d_currentProfile, this.d_behavior, this.d_profileSeed);
        agent.setName(this.d_data.occNameGen.nextName(false));
        agent.setLocation(this.getOccLocation());
        return agent;
    }

    public void createAndAddAgent(Component c) {
        final EgressAgent agent = this.createAgent();
        if (agent == null) {
            return;
        }
        boolean orientWasDefined = this.isDefinedLocally(OccProfile.PROP_INIT_ORIENT);
        UnitDouble prevOrient = this.getOrientation();
        this.d_profileSeed = MerlinUtil.newSeed();
        this.d_currentProfile = new OccProfile(this.d_parentProfile);
        if (orientWasDefined) {
            this.setOrientation(prevOrient);
        }
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData data) {
                try (MerlinData.WriteLock lock = data.lockWrite();){
                    Undo.begin(Intl.intl("New Occupant"));
                    Undo.insertUndoEntry_delete(AgentDropper.this.d_data, AgentDropper.this.d_data.agents, agent);
                    AgentDropper.this.d_data.agents.add(agent);
                    Undo.insertUndoEntry_restoreSelection(AgentDropper.this.d_data);
                    AgentDropper.this.d_data.selection.set(agent);
                    Undo.end(data);
                }
            }
        };
        UIHook.run(c, "AgentDropper.createAndAddAgent", op, 4);
        this.pause();
        this.firePropChanged(CREATE_AGENT);
        this.resume();
    }

    private void updateInsideBlockage() {
        OccLocation loc = this.getOccLocation();
        this.d_insideBlockage = GeomUtil.isPoint3dInPreventingBlockage(this.d_data, loc.point, 0);
    }

    public boolean isLocInObstacle() {
        return this.d_insideBlockage;
    }
}

