/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.importgeom;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javafx.stage.FileChooser;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.importgeom.IImporter;
import merlin.actions.importgeom.ImportOptions;
import merlin.data.GeomComposite;
import merlin.data.IMerlinObj;
import merlin.data.ImportType;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.data.material.Material;
import merlin.geom.Geometry;
import merlin.unitsystem.UnitSystem;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.cad.bim.BIMType;
import thunderheadeng.cad.in.CadImportUI;
import thunderheadeng.cad.in.CadImporter;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.wizard.AWizardCard;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Events;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ImportCAD
implements IImporter {
    @Override
    public FileChooser.ExtensionFilter[] getFileFilters() {
        return CadImporter.getSupportedFileFormats();
    }

    @Override
    public void initDefaultOptions(MerlinData md, String ext, IPropertySet options) {
    }

    @Override
    public boolean getAllowNewFile(MerlinData md, String ext, IPropertySet options) {
        return true;
    }

    @Override
    public void update(MerlinData md, Events events, IPropertySet options) {
    }

    @Override
    public AWizardCard<IPropertySet> getCard(IPropertySet options) {
        options.setIfNotDefault(IGeomImportSession.DST_LENGTH_UNIT, Geometry.LENGTH_UNIT);
        options.setIfNotDefault(CadImportUI.LENGTH_UNIT_SRC, UnitSystem.getType(0, false));
        options.setIfNotDefault(CadImportUI.MAT_FACTORY, (name, attrs) -> {
            Material mat = new Material((String)name, (IMatAttrs)attrs);
            return options.get(ImportOptions.MAT_CACHE).get().add(mat);
        });
        options.set(CadImportUI.FILE, options.get(ImportOptions.FILE));
        return CadImportUI.getFirstWizardCard(options);
    }

    @Override
    public void cleanup(IPropertySet options) {
        options.remove(IGeomImportSession.DST_LENGTH_UNIT);
        options.remove(CadImportUI.FILE);
        options.remove(CadImportUI.LENGTH_UNIT_SRC);
        options.remove(CadImportUI.DEF_OFFSET);
        options.remove(CadImportUI.MAT_FACTORY);
        options.remove(CadImportUI.WARNINGS);
        CadImportUI.cleanup(options);
    }

    private static IMerlinObj convert(IPropertySet options, Map<Long, IGeomNode> holeGeoms, TransformInfo parentToWorldXform, IGeomImportSession.Node node) {
        ArrayList<Object> objs = new ArrayList<Object>();
        TransformInfo nodeToWorld = parentToWorldXform.concatenate(node.transform);
        if (node.dg != DisplayGeom.EMPTY || node.props.getBIMType().isDescendentOf(BIMType.Building)) {
            ImportedGeom obj = new ImportedGeom(node.name, node.dg.transform(nodeToWorld));
            obj.set(ImportedGeom.PROP_OBJECT_TYPE, node.props.nodeType);
            obj.setBIMType(node.props.getBIMType());
            if (node.props.getBIMType().isDescendentOf(BIMType.Door)) {
                Vector3d doorDir;
                IGeomNode holeGeom;
                if (!Double.isNaN(node.props.doorWidth)) {
                    obj.set(ImportedGeom.PROP_DOOR_WIDTH, new UnitDouble(node.props.doorWidth, Geometry.LENGTH_UNIT));
                }
                if (!Double.isNaN(node.props.doorHeight)) {
                    obj.set(ImportedGeom.PROP_DOOR_HEIGHT, new UnitDouble(node.props.doorHeight, Geometry.LENGTH_UNIT));
                }
                if (node.props.doorOpening != -1L && (holeGeom = holeGeoms.get(node.props.doorOpening)) != null) {
                    obj.set(ImportedGeom.PROP_DOOR_VOID, holeGeom);
                }
                if (Util3D.safeNormalize(doorDir = new Vector3d(node.props.getDoorDir()), 0.0) != 0.0) {
                    obj.set(ImportedGeom.PROP_DOOR_DIR, doorDir);
                }
                obj.set(ImportedGeom.PROP_DOOR_IS_ACCESSIBLE, node.props.doorIsAccessible);
                if (!Double.isNaN(node.props.doorFlowrate) && node.props.doorFlowrate > 0.0) {
                    obj.set(ImportedGeom.PROP_DOOR_FLOWRATE, new UnitDouble(node.props.doorFlowrate, Unit.ONE.divide(SI.SECOND)));
                }
            }
            if (node.props.getBIMType().isDescendentOf(BIMType.Covering)) {
                obj.set(ImportedGeom.PROP_COVERING_TYPE, node.props.getBIMCoveringType());
            }
            if (node.props.getBIMType().isDescendentOf(BIMType.TransportElement)) {
                obj.set(ImportedGeom.PROP_TRANSPORT_TYPE, node.props.getBIMTransportType());
            }
            if (node.props.getBIMType().isDescendentOf(BIMType.Space)) {
                obj.set(ImportedGeom.PROP_SPACE_OCCUPANCY_NUMBER, node.props.spaceOccupancyNumber);
                if (!Double.isNaN(node.props.spaceAreaPerOccupant) && node.props.spaceAreaPerOccupant > 0.0) {
                    obj.set(ImportedGeom.PROP_SPACE_AREA_PER_OCCUPANT, new UnitDouble(node.props.spaceAreaPerOccupant, SI.METER.pow(2).divide(Unit.ONE.alternate("pers"))));
                }
                obj.set(ImportedGeom.PROP_SPACE_OCCUPANCY_NUMBER_PEAK, node.props.spaceOccupancyNumberPeak);
                if (node.props.spaceAreaPerOccupant == -1.0 && node.props.spaceOccupancyNumber == -1 && node.props.spaceOccupancyNumberPeak == -1) {
                    obj.setDisplayGeom(DisplayGeom.EMPTY);
                }
            }
            if (node.props.getBIMType().isDescendentOf(BIMType.Building)) {
                obj.set(ImportedGeom.PROP_BUILDING_PRE_EVACUATION_TIME, node.props.buildingPreEvacuationTime);
                obj.set(ImportedGeom.PROP_BUILDING_OCC_PROFILES_LIST, node.props.buildingOccProfilesList);
                obj.setDisplayGeom(DisplayGeom.EMPTY);
            }
            if (!ImportCAD.testFloorExtract(node)) {
                obj.setImportedType(ImportType.IGNORED);
            } else {
                obj.setImportedType(obj.getImportedTypeFromBIMType());
            }
            objs.add(obj);
            if (node.children.isEmpty()) {
                return (IMerlinObj)objs.get(0);
            }
        }
        for (IGeomImportSession.Node child : node.children) {
            objs.add(ImportCAD.convert(options, holeGeoms, nodeToWorld, child));
        }
        GeomComposite group = new GeomComposite(node.name);
        group.addAll(objs);
        return group;
    }

    private static boolean testFloorExtract(IGeomImportSession.Node node) {
        BIMType type = node.props.getBIMType();
        if (type.isDescendentOf(BIMType.Space) && node.dg.node == DisplayGeom.EMPTY.node) {
            return false;
        }
        if (type.isDescendentOf(BIMType.Building) && node.props.buildingPreEvacuationTime.equals("-1") && node.props.buildingOccProfilesList.equals("-1")) {
            return false;
        }
        if (!type.isDescendentOf(BIMType.BuildingElementProxy)) {
            return true;
        }
        String name = node.name;
        if (name.isEmpty()) {
            return true;
        }
        return !name.contains("Path of Travel") && !name.contains("RPC Male") && !name.contains("RPC Female");
    }

    private void getHoleGeom(TransformInfo parentXform, Collection<IGeomImportSession.Node> nodes, Map<Long, ArrayList<IGeomNode>> geoms) {
        for (IGeomImportSession.Node node : nodes) {
            TransformInfo nxform = parentXform.concatenate(node.transform);
            if (node.props.getBIMType().isDescendentOf(BIMType.FeatureElementSubtraction) && node.dg.node != DisplayGeom.EMPTY.node) {
                List holeGeom = geoms.computeIfAbsent(node.id, id -> new ArrayList());
                holeGeom.add(node.dg.node.transform(nxform));
            }
            this.getHoleGeom(nxform, node.children, geoms);
        }
    }

    private Map<Long, IGeomNode> getHoleGeom(Collection<IGeomImportSession.Node> nodes) {
        HashMap<Long, ArrayList<IGeomNode>> geoms = new HashMap<Long, ArrayList<IGeomNode>>();
        this.getHoleGeom(TransformUtil.IDENTITY_INFO, nodes, geoms);
        HashMap<Long, IGeomNode> hgeoms = new HashMap<Long, IGeomNode>();
        for (Map.Entry entry : geoms.entrySet()) {
            if (((ArrayList)entry.getValue()).size() == 1) {
                hgeoms.put((Long)entry.getKey(), (IGeomNode)((ArrayList)entry.getValue()).get(0));
                continue;
            }
            ((ArrayList)entry.getValue()).trimToSize();
            hgeoms.put((Long)entry.getKey(), GeomNodeUtil.newNode((Collection)entry.getValue()));
        }
        return hgeoms;
    }

    @Override
    public IImporter.Result read(MerlinApp app, String fn, IPropertySet options) throws IOException, CancelledException {
        ImportedGeom ig;
        System.out.println("Converting CAD file: " + fn);
        ArrayList<IMerlinObj> newGeoms = new ArrayList<IMerlinObj>();
        options.set(CadImportUI.INCLUDE_ELEMENT_SUBTRACTIONS, true);
        Collection<IGeomImportSession.Node> nodes = CadImportUI.finalizeResult(options);
        Map<Long, IGeomNode> holeGeom = this.getHoleGeom(nodes);
        Predicate<IGeomImportSession.Node> nodeFilter = n -> !n.props.getBIMType().isDescendentOf(BIMType.FeatureElementSubtraction);
        nodes = CadImportUI.filter(nodes, nodeFilter);
        for (IGeomImportSession.Node node : nodes) {
            newGeoms.add(ImportCAD.convert(options, holeGeom, TransformUtil.IDENTITY_INFO, node));
        }
        DisplayGeom bgquad = CadImportUI.createBackgroundQuad(options, () -> {
            AABox importBounds = new AABox();
            for (GeomComposite group : theUtil.filter(newGeoms, GeomComposite.class)) {
                for (ImportedGeom ig : group.getDeepMembers(ImportedGeom.class)) {
                    ig.getGeom().getBoundingBox(importBounds);
                }
            }
            return importBounds;
        });
        if (bgquad != null && !(ig = ImportCAD.createBackgroundQuad(bgquad)).getBounds().isInfinite()) {
            newGeoms.add(0, ig);
        }
        String name = new File(fn).getName();
        GeomComposite root = new GeomComposite(name);
        root.addAll(newGeoms);
        return new IImporter.Result(root, new Pair[0]);
    }

    public static ImportedGeom createBackgroundQuad(AABox geomBounds, Color color) {
        DisplayGeom dg = CadImportUI.createBackgroundQuad(geomBounds, color);
        return ImportCAD.createBackgroundQuad(dg);
    }

    public static ImportedGeom createBackgroundQuad(DisplayGeom dg) {
        String name = Intl.intl("background");
        ImportedGeom ig = new ImportedGeom(name, dg);
        ig.setImportedType(ImportType.IGNORED);
        return ig;
    }
}

