/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import merlin.MerlinApp;
import merlin.actions.copypaste.CopyPasteUtil;
import merlin.actions.copypaste.GeomPasteHandler;
import merlin.actions.copypaste.PasteHandler;
import merlin.actions.copypaste.PasteHints;
import merlin.data.Composite;
import merlin.data.MerlinData;
import merlin.data.OccSourceObj;
import merlin.data.egress.geom.IEgressComp;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Warning;

public class OccSourceObjPasteHandler
implements PasteHandler {
    @Override
    public boolean isHandlerFor(IDomainObject obj, String mdRootClassName) {
        return OccSourceObj.OccSourceComp.class.getName().equals(mdRootClassName);
    }

    @Override
    public PasteHints getPasteHints(MerlinData md, IDomainObject pasteObj) {
        IEgressComp component = this.getComponent(pasteObj);
        if (component != null) {
            return CopyPasteUtil.getGeomPasteHints(md, pasteObj);
        }
        return new PasteHints();
    }

    private IEgressComp getComponent(IDomainObject<MerlinData> pasteObj) {
        IEgressComp component = null;
        if (pasteObj instanceof OccSourceObj) {
            OccSourceObj oso = (OccSourceObj)pasteObj;
            component = oso.getComponent();
        }
        return component;
    }

    @Override
    public void pasteApply(MerlinData md, MerlinApp app, Predicate<? super IDomainObject> isPasteObj, Consumer<? super IDomainObject> allPastedObjs, Consumer<? super Warning> warnings, Collection<? extends PasteHandler.PasteEntry> entries) {
        for (PasteHandler.PasteEntry pasteEntry : entries) {
            Composite insertRoot = (Composite)pasteEntry.pasteLoc();
            CopyPasteUtil.pasteIntoAndTransform(md, app, pasteEntry.pasteObj(), pasteEntry.hints(), allPastedObjs, insertRoot, -1, CopyPasteUtil.DEFAULT_NAME_GEN);
            IEgressComp component = this.getComponent(pasteEntry.pasteObj());
            if (component == null || isPasteObj.test(component)) continue;
            GeomPasteHandler componentHandler = new GeomPasteHandler();
            componentHandler.pasteApply(md, app, isPasteObj, allPastedObjs, warnings, entries);
        }
    }
}

