/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import merlin.MerlinApp;
import merlin.actions.TransformAction;
import merlin.actions.copypaste.CopyPasteUtil;
import merlin.actions.copypaste.PasteHandler;
import merlin.actions.copypaste.PasteHints;
import merlin.builders.NewCompUtil;
import merlin.data.MerlinData;
import merlin.data.egress.FloorComposite;
import merlin.data.egress.geom.IEgressComp;
import merlin.geom.IMerlinGeomSrc;
import merlin.util.MerlinUtil;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Warning;
import thunderheadeng.util.theUtil;

public class FloorPasteHandler
implements PasteHandler {
    @Override
    public boolean isHandlerFor(IDomainObject obj, String mdRootClassName) {
        return FloorComposite.class.getName().equals(mdRootClassName);
    }

    @Override
    public PasteHints getPasteHints(MerlinData md, IDomainObject pasteObj) {
        return CopyPasteUtil.getGeomPasteHints(md, pasteObj);
    }

    @Override
    public void pasteApply(MerlinData md, MerlinApp app, Predicate<? super IDomainObject> isPasteObj, Consumer<? super IDomainObject> allPastedObjs, Consumer<? super Warning> warnings, Collection<? extends PasteHandler.PasteEntry> entries) {
        ArrayList xformObjs = new ArrayList();
        for (PasteHandler.PasteEntry pasteEntry : entries) {
            Collection<IEgressComp> egressObjs = MerlinUtil.flatten(pasteEntry.pasteObj(), IEgressComp.class);
            Collection<IMerlinGeomSrc> geomObjs = TransformAction.getGeom(md, egressObjs);
            geomObjs.stream().map(obj -> new Pair<IMerlinGeomSrc, TransformInfo>((IMerlinGeomSrc)obj, entry.hints().geomTransform)).forEach(xformObjs::add);
        }
        TransformAction.transform(app, md, xformObjs);
        Collection<IEgressComp> geomObjs = MerlinUtil.flatten(theUtil.map(entries, e -> e.pasteObj()), IEgressComp.class);
        NewCompUtil.addEgressComps(md, false, geomObjs);
        geomObjs.forEach(allPastedObjs);
    }
}

