/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.copypaste.CopyPasteUtil;
import merlin.actions.copypaste.Paste;
import merlin.actions.copypaste.PthCopyDataContainer;
import merlin.data.Composite;
import merlin.data.MerlinData;
import merlin.io.MerlinIO;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.io.ObjectSelection;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Warning;

public class Copy
extends AMerlinOp
implements IEventObserver {
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Copy16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Copy(), Intl.intl("&Copy...,C,Copy selected objects"), ICON);

    public Copy() {
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    public static boolean canCopy(MerlinData md) {
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        Map<IDomainObject, String> objMap = Copy.getPasteMap(md);
        boolean canCopy = false;
        for (Map.Entry<IDomainObject, String> entry : objMap.entrySet()) {
            if (Paste.isUnsupported(entry.getKey(), entry.getValue())) {
                warnings.add(CopyPasteUtil.getPasteSupportWarning(entry.getKey(), true));
                continue;
            }
            canCopy = true;
        }
        if (!canCopy) {
            Paste.showWarnings(MerlinApp.getApp(), warnings);
        }
        return canCopy;
    }

    public static Map<IDomainObject, String> getPasteMap(MerlinData md) {
        LinkedHashMap<IDomainObject, String> objMap = new LinkedHashMap<IDomainObject, String>();
        IFilteredCollection<IDomainObject> rawObjs = md.selection.get(IDomainObject.class, Predicates.alwaysTrue());
        ArrayDeque<IDomainObject> objQueue = new ArrayDeque<IDomainObject>(rawObjs);
        while (!objQueue.isEmpty()) {
            IDomainObject obj = (IDomainObject)objQueue.removeFirst();
            Object[] pathToObj = md.hierarchy.getPath(obj);
            if (pathToObj[0] != md) {
                System.err.printf("object not reachable from MerlinData, skipping: [%s] %s%n", obj.getClass().getName(), obj.toString());
                continue;
            }
            assert (pathToObj.length > 1 && pathToObj[0] == md);
            if (pathToObj.length == 2 || obj == md.attractors || obj == md.attractorTemplates) {
                assert (obj instanceof Composite);
                Composite predefinedComposite = (Composite)obj;
                objQueue.addAll(predefinedComposite.getChildren());
                continue;
            }
            if (pathToObj.length <= 1) continue;
            String mdRootClassName = pathToObj[1].getClass().getName();
            objMap.put(obj, mdRootClassName);
        }
        return objMap;
    }

    private static void checkScenarioWarning(MerlinApp app, MerlinData md, Map<IDomainObject, String> objMap) {
        if (md.scenarios.anyOverriden(objMap.keySet())) {
            Copy.showScenarioWarning(app.getActiveFrame());
        }
    }

    public static void showScenarioWarning(Component parent) {
        JOptionPane.showMessageDialog(parent, Intl.intl("Some selected objects have customized scenario properties. These customizations will not be copied. The copied objects will retain only their current properties."), Intl.intl("Warning: Scenario Setup Will not be Copied"), 2);
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        Clipboard systemClipboard = defaultToolkit.getSystemClipboard();
        if (Copy.canCopy(md)) {
            Map<IDomainObject, String> objMap = Copy.getPasteMap(md);
            Copy.checkScenarioWarning(app, md, objMap);
            PthCopyDataContainer data = new PthCopyDataContainer(MerlinIO.Version.curr().num, objMap);
            ObjectSelection contents = new ObjectSelection(data, data.toString(), PthCopyDataContainer.DATAFLAVOR_BINARY);
            systemClipboard.setContents(contents, null);
        }
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(!md.selection.isEmpty(IDomainObject.class));
    }
}

