/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.concurrent.Semaphore;
import javax.swing.Icon;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinBoolAction;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.unitsystem.EnglishUS;
import merlin.unitsystem.SIUS;
import merlin.unitsystem.UnitSystem;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class UnitsAction
extends AMerlinBoolAction {
    private static final long serialVersionUID = 1664063778508194962L;
    public static final Icon ICON_EN = UIHook.loadIcon("merlin/icons/en16.png");
    public static final Icon ICON_SI = UIHook.loadIcon("merlin/icons/si16.png");
    public static final UnitsAction SI_ACTION = new UnitsAction(SIUS.getInstance(), Intl.intl("SI"), ICON_SI);
    public static final UnitsAction ENGLISH_ACTION = new UnitsAction(EnglishUS.getInstance(), Intl.intl("English"), ICON_EN);
    private static Semaphore d_lock = new Semaphore(1);
    private static final IEventObserver s_actionUpdator = new IEventObserver(){

        @Override
        public void update(Events events) {
            for (EventChannel<MerlinData> channel : events.getAffectedChannels(MerlinData.class, new Class[0])) {
                if (!channel.hasChangedObjs(MerlinData.UNITSYSTEM_CHANGED)) continue;
                if (!d_lock.tryAcquire()) {
                    return;
                }
                MerlinApp app = MerlinApp.getApp();
                if (app.getUnitSystem() == SIUS.getInstance()) {
                    SI_ACTION.setSelected(true);
                } else {
                    ENGLISH_ACTION.setSelected(true);
                }
                d_lock.release();
                break;
            }
        }
    };
    public UnitSystem d_unitSys;

    public UnitsAction(UnitSystem unitSystem, String menuStr, Icon ico) {
        super(menuStr, MerlinApp.getApp().getData().getUnitSystem() == unitSystem, ico);
        this.putValue("ShortDescription", String.format(Intl.intl("Show values in %s units"), unitSystem.getSystemName()));
        this.d_unitSys = unitSystem;
    }

    @Override
    protected void stateChanged() {
        if (!d_lock.tryAcquire()) {
            return;
        }
        super.stateChanged();
        d_lock.release();
    }

    @Override
    protected void work(MerlinData data, boolean selected) {
        if (selected) {
            MerlinApp.getApp().getData().setUnitSystem(this.d_unitSys);
            MerlinApp.getApp().getPrefs().set(MerlinPrefs.KEY_UNITSYSTEM_PROP, this.d_unitSys.getSystemName());
        }
    }

    static {
        MerlinApp.getApp().getData().getEvents().addObserver(s_actionUpdator);
    }
}

