/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.ReorderGroupOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class SortAlphaAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SortAlphaAction(), Intl.intl("&Sort Alphabetically"));

    public SortAlphaAction() {
        SelectionObserver.add(this, Composite.class);
        this.update(null);
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        MerlinSelectionModel sel = md.selection;
        assert (!sel.isEmpty());
        Set comps = sel.getSelected(Composite.class);
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Sort Groups"));
            for (Composite comp : comps) {
                ArrayList<IMerlinObj> oldOrder = new ArrayList<IMerlinObj>(comp.getMembers());
                List<IMerlinObj> newOrder = SortAlphaAction.sort(oldOrder);
                ReorderGroupOp op = new ReorderGroupOp(comp, oldOrder, newOrder);
                Undo.insertEntry(md, op.perform());
            }
            Undo.end(md);
        }
    }

    private static List<IMerlinObj> sort(Collection<? extends IMerlinObj> objs) {
        ArrayList<IMerlinObj> toSort = new ArrayList<IMerlinObj>(objs);
        Collections.sort(toSort, new Comparator<IMerlinObj>(){

            @Override
            public int compare(IMerlinObj ice1, IMerlinObj ice2) {
                if (ice1 instanceof Composite && !(ice2 instanceof Composite)) {
                    return -1;
                }
                if (!(ice1 instanceof Composite) && ice2 instanceof Composite) {
                    return 1;
                }
                String name1 = ice1.getName();
                String name2 = ice2.getName();
                return name1.compareTo(name2);
            }
        });
        return toSort;
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData data = app.getData();
        MerlinSelectionModel sel = data.selection;
        this.setEnabled(!sel.isEmpty(Composite.class));
    }
}

