/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.Set;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.gui.PathObjsList;
import merlin.util.Dependencies;
import merlin.util.MerlinDepSnapshot;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.gui.dialogs.ShowObjectsDialog;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;

public class ShowReferencingObjects
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new ShowReferencingObjects(), Intl.intl("Show Referencing Objects..."));

    public ShowReferencingObjects() {
        SelectionObserver.add(this, IMerlinObj.class);
        this.update(null);
    }

    public static Set<IMerlinObj> getReferencing(MerlinData md) {
        LinkedIdentityHashSet<IMerlinObj> referencing = new LinkedIdentityHashSet<IMerlinObj>();
        Dependencies.getObjReferences(md, MerlinDepSnapshot.ACTIVE_SCENARIO, Predicates.alwaysTrue(), obj -> md.selection.isSelected(obj), (src, link, target) -> {
            if (link != null && link != DLink.CONTAINED_BY && EntryPointFactory.get(src).canShowInReferencingLists(md, (IMerlinObj)src)) {
                referencing.add(src);
            }
        });
        return referencing;
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Set<IMerlinObj> referencing = ShowReferencingObjects.getReferencing(md);
        ShowObjectsDialog<IMerlinObj> dlg = new ShowObjectsDialog<IMerlinObj>((Window)app.getActiveFrame(), Intl.intl("Show Referencing Objects"), new PathObjsList(md, Intl.intl("Select Referencing Objects"), true, true, referencing));
        dlg.doModeless();
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(!md.selection.isDeepEmpty(IMerlinObj.class));
    }
}

