/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import common.io.FileUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.ResultsUtil;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.data.scenario.ScenarioUtil;
import merlin.data.scenario.SimOutputDir;
import merlin.gui.guiUtil;
import thunderheadeng.util.Nullable;

public class ShowFile
extends AMerlinOp {
    public static final UIHook SHOW_SUMMARY_HOOK = new UIHook(new ShowFile(new IFilename(){

        @Override
        public File get(File parentFile, String rootFn) {
            return FileUtil.getSummaryFn(parentFile, rootFn);
        }
    }), Intl.intl("Show Summary File"));
    public static final UIHook SHOW_PERFORMANCE_HOOK = new UIHook(new ShowFile(new IFilename(){

        @Override
        public File get(File parentFile, String rootFn) {
            return FileUtil.getPerformanceFn(parentFile, rootFn);
        }
    }), Intl.intl("Show Performance File"));
    private final IFilename d_filename;

    public ShowFile(IFilename filename) {
        this.d_filename = filename;
    }

    private File promptFile(MerlinApp app, MerlinData md) {
        try {
            if (md.filename != null) {
                List<ScenarioUtil.ScenarioVariationKey> keys = ScenarioUtil.streamVariations(md).toList();
                ScenarioUtil.ScenarioVariationKey choice = ResultsUtil.pickScenario(md, app.getMainFrame(), keys, ScenarioUtil.ScenarioVariationKey::toString, new ScenarioUtil.ScenarioVariationKey(md.scenarios.getActive(), 0, 1), Intl.intl("Show file for scenario:"));
                if (choice == null) {
                    return null;
                }
                SimOutputDir outDir = ScenarioUtil.getOutputDir(md, choice.scenario(), choice.variationIndex());
                Optional<Nullable<File>> result = ResultsUtil.promptLegacyFile(app.getMainFrame(), outDir, dir -> this.d_filename.get(dir.outputDir().toFile(), dir.outputFileBasename().toString()));
                if (result.isEmpty()) {
                    return null;
                }
                if (result.get().val != null) {
                    return (File)result.get().val;
                }
            }
            String msg = Intl.intl("Unable to locate file. Have you run the simulation?");
            JOptionPane.showMessageDialog(app.getMainFrame(), msg);
        }
        catch (IOException e) {
            guiUtil.showError(app, Intl.intl("File Error"), Intl.intl("Failed to resolve output directory."), (Throwable)e);
        }
        return null;
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        File file = this.promptFile(app, md);
        if (file != null && file.exists()) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private static interface IFilename {
        public File get(File var1, String var2);
    }
}

