/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import merlin.actions.Undo;
import merlin.data.GeomComposite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import thunderheadeng.gui.framework.UndoFramework;

public class SetWorkingGroup {
    public static void setWorkingGroup(MerlinData md, Floor floor, GeomComposite<IMerlinObj> group) {
        ChangeWorkingGroupOp op = new ChangeWorkingGroupOp(floor, floor.getWorkingGeomGroup(), group);
        Undo.insertEntry(md, op.perform());
    }

    private static class ChangeWorkingGroupOp
    implements UndoFramework.UndoOp {
        private final Floor floor;
        private final GeomComposite<IMerlinObj> oldGroup;
        private final GeomComposite<IMerlinObj> newGroup;

        public ChangeWorkingGroupOp(Floor floor, GeomComposite<IMerlinObj> oldGroup, GeomComposite<IMerlinObj> newGroup) {
            this.floor = floor;
            this.oldGroup = oldGroup;
            this.newGroup = newGroup;
        }

        @Override
        public UndoFramework.UndoOp perform() {
            this.floor.setWorkingGeomGroup(this.newGroup);
            return new ChangeWorkingGroupOp(this.floor, this.newGroup, this.oldGroup);
        }

        @Override
        public boolean isMajor() {
            return true;
        }
    }
}

