/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Component;
import java.util.Collections;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.MerlinOpImpl;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.scenario.Scenario;
import merlin.data.scenario.ScenarioRoot;

public class SetActiveScenario {
    public static void setActiveScenario(Component c, Scenario scenario) {
        MerlinOpImpl op = new MerlinOpImpl((app, md) -> {
            try (MerlinData.WriteLock lock = md.lockWrite();){
                Undo.begin(Intl.intl("Set Active Scenario"));
                Undo.insertUndoEntry_propRestore(md, Collections.singleton(md.scenarios), ScenarioRoot.ACTIVE_SCENARIO);
                md.scenarios.setActive(scenario);
                Undo.end(md);
            }
        });
        UIHook.run(MerlinApp.getApp().getActiveFrame(), "ScenarioComboModel.setSelectedItem", op, 0);
    }
}

