/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Set;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.MerlinData;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class SelectSubitems
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SelectSubitems(), Intl.intl("Select Subitems"));

    public SelectSubitems() {
        SelectionObserver.add(this, Composite.class);
        this.update();
    }

    @Override
    public void update(Events events) {
        this.update();
    }

    private void update() {
        this.setEnabled(!MerlinApp.getApp().getData().selection.isDeepEmpty(Composite.class));
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Select Subitems"));
            Undo.insertUndoEntry_restoreSelection(md);
            Set selObjs = md.selection.getSelected(Composite.class);
            md.selection.clear();
            for (Composite selObj : selObjs) {
                md.selection.selectAll(selObj.getDeepMembers());
            }
            Undo.end(md);
        }
    }
}

