/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Set;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.ShowReferencingObjects;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class SelectReferencing
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SelectReferencing(), Intl.intl("Select Referencing Objects"));

    public SelectReferencing() {
        SelectionObserver.add(this, IMerlinObj.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(!md.selection.isDeepEmpty(IMerlinObj.class));
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Select Referencing Objects"));
            Undo.insertUndoEntry_restoreSelection(md);
            Set<IMerlinObj> referencing = ShowReferencingObjects.getReferencing(md);
            md.selection.set(referencing);
            Undo.end(md);
        }
    }
}

