/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.SimError;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.Predicates;

public class SelectInvalidObjs
extends AMerlinOp
implements IEventObserver {
    public static final UIHook CRITICAL_HOOK = new UIHook(new SelectInvalidObjs(SimError.Level.CRITICAL), Intl.intl("Select Errors"));
    public static final UIHook MODERATE_HOOK = new UIHook(new SelectInvalidObjs(SimError.Level.MODERATE), Intl.intl("Select Warnings"));
    private final SimError.Level d_level;

    public SelectInvalidObjs(SimError.Level level) {
        this.d_level = level;
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    private static boolean isValid(MerlinApp app, MerlinData md, Object obj, SimError.Level level) {
        if (!(obj instanceof IMerlinObj)) {
            return true;
        }
        Stream<? extends SimError> errors = app.getErrors().streamDeepErrors(obj);
        if (level == null) {
            return errors.findAny().isEmpty();
        }
        return errors.noneMatch(err -> err.level == level);
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData md = app.getData();
        if (md.selection.isEmpty()) {
            this.setEnabled(!SelectInvalidObjs.isValid(app, md, md, this.d_level));
        } else {
            boolean valid = true;
            Set sel = md.selection.getSelected(Object.class);
            for (Object selObj : sel) {
                if (SelectInvalidObjs.isValid(app, md, selObj, this.d_level)) continue;
                valid = false;
                break;
            }
            this.setEnabled(!valid);
        }
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        ArrayList<Object> invalidObjs = new ArrayList<Object>();
        Set sel = md.selection.getSelected(Object.class);
        if (sel.isEmpty()) {
            SelectInvalidObjs.collectInvalidLeaves(app, md, Arrays.asList(md), invalidObjs, this.d_level);
        } else {
            SelectInvalidObjs.collectInvalidLeaves(app, md, sel, invalidObjs, this.d_level);
        }
        if (!invalidObjs.isEmpty()) {
            try (MerlinData.WriteLock lock = md.lockWrite();){
                Undo.begin(this.d_level == SimError.Level.CRITICAL ? Intl.intl("Select Errors") : Intl.intl("Select Warnings"));
                Undo.insertUndoEntry_restoreSelection(md);
                md.selection.set(invalidObjs);
                Undo.end(md);
            }
        }
    }

    private static void collectInvalidLeaves(MerlinApp app, MerlinData md, Collection<?> objs, List<Object> invalidObjs, SimError.Level level) {
        for (Object obj : objs) {
            app.getErrors().streamDeepErrors(obj).filter(level == null ? Predicates.alwaysTrue() : error -> error.level == level).forEach(error -> invalidObjs.addAll(error.causeObjs));
        }
    }
}

