/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.Param;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.vecmath.Point3d;
import merlin.ErrorAnalysis;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.Behemoth;
import merlin.actions.InfernoUtil;
import merlin.actions.MerlinOp;
import merlin.actions.MonteCarloVariationGenerator;
import merlin.actions.Save;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.actions.WriteMesh;
import merlin.actions.WriteScenarios;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.ObjsFilter;
import merlin.data.OccSourceObj;
import merlin.data.RestorableProperties;
import merlin.data.SimParams;
import merlin.data.egress.ScenarioSimError;
import merlin.data.egress.SimError;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.AEgressComp;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.GotoExits;
import merlin.data.egress.scripting.GotoQueue;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.IUnreachable;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.montecarlo.MonteCarlo;
import merlin.data.montecarlo.SimulationInputList;
import merlin.data.property.PropertyDefs;
import merlin.data.scenario.Scenario;
import merlin.data.scenario.ScenarioRoot;
import merlin.data.scenario.ScenarioUtil;
import merlin.data.scenario.SimOutputDir;
import merlin.gui.RunSimDlg;
import merlin.gui.guiUtil;
import merlin.mv.ModelView;
import merlin.util.Dependencies;
import merlin.util.MerlinDepSnapshot;
import merlin.util.MerlinUtil;
import montecarlo.ProcessResults;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.NmtUtil;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.value.BooleanListDlg;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ITaskProgress;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.SmvParseUtil;
import thunderheadeng.util.SplitProgress;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class RunInferno
extends AMerlinOp {
    public static final Icon ICON = UIHook.loadIcon("merlin/icons/run16.png");
    public static final UIHook UI_HOOK_RUN = new UIHook((MerlinOp)new RunInferno(false), Intl.intl("&Run Simulation...,-,Run Simulation"), ICON);
    public static final UIHook UI_HOOK_DEBUG = new UIHook((MerlinOp)new RunInferno(true), Intl.intl("&Debug Simulation...,-,Debug Simulation"), null);
    private static final Logger LOGGER = Logger.getLogger(RunInferno.class.getName());
    public static final AtomicInteger COUNT = new AtomicInteger(0);
    private final boolean d_debug;

    public RunInferno(boolean debug) {
        this.d_debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        MultiSimulationOutputDir outDir;
        List infernos;
        List<Scenario> chosenScenarios;
        JFrame parentFrame = app.getActiveFrame();
        ArrayList<Scenario> existingScenarios = new ArrayList<Scenario>(md.scenarios.flatten(Scenario.class));
        existingScenarios.sort(ScenarioUtil.SCENARIO_SORTER);
        ActionProps props = (ActionProps)md.actionProperties.getActionProps("RunInferno.ActionProps");
        if (props == null) {
            props = new ActionProps();
            props.set(ActionProps.PROP_SCENARIOS, new IdentityHashSet<Scenario>(existingScenarios));
        }
        Set lastRunScenarios = props.get(ActionProps.PROP_SCENARIOS).stream().filter(scenario -> existingScenarios.contains(scenario)).collect(Collectors.toSet());
        if (existingScenarios.size() > 1) {
            BooleanListDlg<Scenario> dialog = RunInferno.newScenarioChooserDialog(parentFrame, Intl.intl("Run Scenarios"), Intl.intl("Scenarios"), Intl.intl("Select the Scenarios to run:"));
            dialog.setAvailObjs(existingScenarios);
            dialog.setObjectSelectionState(lastRunScenarios, Collections.emptySet());
            if (dialog.doModal() != 1) {
                return;
            }
            chosenScenarios = dialog.getSelectedObjs(Scenario.class).stream().sorted(ScenarioUtil.SCENARIO_SORTER).toList();
        } else {
            chosenScenarios = existingScenarios;
        }
        try (MerlinData.WriteLock lock = md.lockWrite();){
            props.set(ActionProps.PROP_SCENARIOS, new IdentityHashSet<Scenario>(chosenScenarios));
            md.actionProperties.setActionProps("RunInferno.ActionProps", props);
        }
        final RunSimDlg dlg = new RunSimDlg(parentFrame);
        dlg.beginWaitCursor();
        Runnable showDlg = new Runnable(){

            @Override
            public void run() {
                dlg.doModeless();
            }
        };
        Handler dlgHandler = dlg.createLogHandler();
        dlgHandler.setLevel(Level.INFO);
        Logger.getLogger("").addHandler(dlgHandler);
        final Runnable removeDefaultLogger = () -> Logger.getLogger("").removeHandler(dlgHandler);
        dlg.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowClosed(WindowEvent e) {
                removeDefaultLogger.run();
            }
        });
        try {
            RunInferno.checkInProgress(app);
            Pair<List<InfernoData>, MultiSimulationOutputDir> engines = RunInferno.prepareEngines(app, md, chosenScenarios, showDlg, this.d_debug);
            infernos = (List)engines.v1;
            outDir = (MultiSimulationOutputDir)engines.v2;
            if (infernos.isEmpty()) {
                return;
            }
            for (InfernoData inferno : infernos) {
                if (inferno != null) continue;
                return;
            }
        }
        catch (CancelledException e) {
            dlg.setVisible(false);
            return;
        }
        finally {
            dlg.endWaitCursor();
        }
        IRunApi api = RunInferno.run(dlg, dlg.prepareRunCallback(), app.getPrefs(), infernos, outDir);
        List<SimOutputDir> simKeys = infernos.stream().map(data -> data.outputDir).toList();
        infernos = null;
        Runnable showResults = () -> {
            HashMap nameScenarioLookup = new HashMap();
            md.scenarios.flatten(Scenario.class).forEach(s -> nameScenarioLookup.put(s.getName(), s));
            LinkedHashMap options = simKeys.stream().filter(key -> nameScenarioLookup.containsKey(key.scenarioName())).collect(Collectors.toMap(key -> new ScenarioUtil.ScenarioVariationKey((Scenario)nameScenarioLookup.get(key.scenarioName()), key.variationIndex(), key.variationCount()), key -> key, (v1, v2) -> v2, LinkedHashMap::new));
            if (options.isEmpty()) {
                return;
            }
            Map.Entry recentlyRunning = options.entrySet().stream().filter(pair -> api.getStatus((SimOutputDir)pair.getValue()) == ScenarioStatus.IN_PROGRESS).findFirst().orElseGet(() -> options.entrySet().stream().filter(entry -> api.getStatus((SimOutputDir)entry.getValue()) == ScenarioStatus.COMPLETED).findFirst().orElseGet(() -> {
                Map.Entry last2 = null;
                for (Map.Entry last2 : options.entrySet()) {
                }
                return last2;
            }));
            ScenarioUtil.ScenarioVariationKey defaultOption = (ScenarioUtil.ScenarioVariationKey)recentlyRunning.getKey();
            Function<Collection<ScenarioUtil.ScenarioVariationKey>, String> describeRun = variationKeys -> {
                ScenarioStatus status;
                if (variationKeys.isEmpty()) {
                    assert (false);
                    return "";
                }
                if (variationKeys.size() == 1) {
                    ScenarioUtil.ScenarioVariationKey key = (ScenarioUtil.ScenarioVariationKey)variationKeys.iterator().next();
                    return String.format(Intl.intl("%1$s [%2$s]"), key.scenario().getName(), api.getStatus((SimOutputDir)((SimOutputDir)options.get((Object)key))).desc);
                }
                HashMap<ScenarioStatus, Integer> statusCounts = new HashMap<ScenarioStatus, Integer>();
                for (ScenarioUtil.ScenarioVariationKey key : variationKeys) {
                    status = api.getStatus((SimOutputDir)options.get(key));
                    statusCounts.merge(status, 1, Integer::sum);
                }
                int numVariations = variationKeys.size();
                int completedVariations = statusCounts.getOrDefault((Object)ScenarioStatus.COMPLETED, 0);
                status = statusCounts.getOrDefault((Object)ScenarioStatus.IN_PROGRESS, 0) > 0 ? ScenarioStatus.IN_PROGRESS : (statusCounts.getOrDefault((Object)ScenarioStatus.ERROR, 0) > 0 ? ScenarioStatus.ERROR : (completedVariations == numVariations ? ScenarioStatus.COMPLETED : (statusCounts.getOrDefault((Object)ScenarioStatus.CANCELED, 0) > 0 && statusCounts.getOrDefault((Object)ScenarioStatus.CANCELED, 0) + statusCounts.getOrDefault((Object)ScenarioStatus.QUEUED, 0) == numVariations ? ScenarioStatus.CANCELED : (completedVariations > 0 && statusCounts.getOrDefault((Object)ScenarioStatus.CANCELED, 0) > 0 ? ScenarioStatus.INCOMPLETE : ScenarioStatus.QUEUED))));
                return String.format(Intl.intl("%1$s [%2$s; %3$d/%4$d Variations Completed]"), ((ScenarioUtil.ScenarioVariationKey)variationKeys.iterator().next()).scenario().getName(), status.desc, completedVariations, numVariations);
            };
            Behemoth.runScenarioPicker(app, dlg, options.keySet(), describeRun, options::get, defaultOption);
        };
        dlg.connect(api, false, showResults);
        new Thread(() -> {
            api.join(0L);
            removeDefaultLogger.run();
        }).start();
    }

    private static void getRoomFaces(AABox bounds, IEgressOccupiable room, Consumer<Face> result) {
        int[] boxid = new int[]{10463731};
        IntPredicate gtest = g -> g != boxid[0];
        try {
            Model model = room.getModel().clone();
            boolean allAdded = true;
            for (Point3d[] face : bounds.getFaces()) {
                Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(face), true);
                if (plane != null && model.addPolygonFace(plane, new Point3d[][]{face}, boxid, Collections.nCopies(4, boxid), Collections.emptyList())) continue;
                allAdded = false;
                break;
            }
            if (!allAdded) {
                return;
            }
            IdentityHashSet closedFaces = new IdentityHashSet();
            for (Edge edge : model.getEdges(boxid[0])) {
                for (Face eface : edge.faces) {
                    Point3d tp;
                    if (!closedFaces.add(eface) || !NmtUtil.testGroups(eface.groups, gtest) || (tp = model.findPointInFace(eface)) == null || !bounds.contains(tp, 1.0E-6)) continue;
                    result.accept(eface);
                }
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void getRoomLineSegs(AABox bounds, IEgressOccupiable room, Consumer<Edge> result) {
        int[] boxid = new int[]{10463731};
        try {
            Model model = room.getModel().clone();
            boolean anyAdded = false;
            for (Point3d[] face : bounds.getFaces()) {
                Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(face), true);
                anyAdded |= plane != null && model.addPolygonFace(plane, new Point3d[][]{face}, boxid, Collections.nCopies(4, boxid), Collections.emptyList());
            }
            if (!anyAdded) {
                return;
            }
            IntPredicate gtest = g -> g != boxid[0];
            for (Edge edge : model.getEdges(boxid[0])) {
                if (!NmtUtil.testGroups(edge.groups, gtest)) continue;
                result.accept(edge);
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static boolean isArea(AABox box) {
        return !theUtil.eq0(box.getWidth(), 1.0E-6) && !theUtil.eq0(box.getDepth(), 1.0E-6);
    }

    private static boolean testAABoxPartiallyContainsRoom(AABox bounds, IEgressOccupiable room) {
        boolean[] result = new boolean[]{false};
        try {
            RunInferno.getRoomFaces(bounds, room, f -> {
                result[0] = true;
                throw new CancellationException();
            });
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return result[0];
    }

    private static boolean testAABoxIntersectsRoom(AABox bounds, IEgressOccupiable room) {
        boolean[] result = new boolean[]{false};
        try {
            RunInferno.getRoomLineSegs(bounds, room, e -> {
                result[0] = true;
                throw new CancellationException();
            });
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return result[0];
    }

    private static void validateExits(MerlinData md, Consumer<SimError> addError, ITaskProgress progress) {
        IFilteredCollection<IEgressConnector> exits = theUtil.filter(md.getAllExits(), d -> !(d instanceof AEgressComp) || ((AEgressComp)((Object)d)).isEnabled());
        progress.setMessage(Intl.intl("Validating exits"));
        if (exits.isEmpty()) {
            IdentityHashSet closedBehaviors = new IdentityHashSet();
            Function<Behavior, SimError> getBehaviorError = behavior -> {
                Optional<GotoExits> badExit;
                if (closedBehaviors.add(behavior) && (badExit = behavior.deepFlatten(GotoExits.class).stream().filter(GotoExits::isGotoAny).findFirst()).isPresent()) {
                    return new SimError(SimError.Level.CRITICAL, Intl.intl("Simulation requires at least one exit door."), Intl.intl("Create at least one exit door."), badExit.get());
                }
                return null;
            };
            for (EgressAgent agent : md.agents.flatten(EgressAgent.class)) {
                progress.check();
                Behavior behavior2 = agent.getBehavior();
                SimError error = getBehaviorError.apply(behavior2);
                addError.accept(error);
            }
            for (OccSourceObj os : md.occSources.flatten(OccSourceObj.class)) {
                progress.check();
                List behaviors = os.get(OccSourceObj.PROP_BEHAVIOR_DIST).getUnique(ArrayList.class);
                for (Behavior behavior3 : behaviors) {
                    progress.check();
                    SimError error = getBehaviorError.apply(behavior3);
                    addError.accept(error);
                }
            }
        }
    }

    private static void validateSocialDistance(MerlinData md, Consumer<SimError> addError, Param p, ITaskProgress progress) {
        if (p.force_separation) {
            progress.setMessage(Intl.intl("Validating social distance"));
            LinkedIdentityHashSet badObjs = new LinkedIdentityHashSet();
            for (EgressAgent agent : md.agents.flatten(EgressAgent.class)) {
                progress.check();
                OccProfile occProfile = agent.getProfile();
                if (occProfile.get(OccProfile.PROP_SOCIAL_DIST_FILTER).mode == ObjsFilter.Mode.NONE) continue;
                if (occProfile.isDefinedLocally(OccProfile.PROP_SOCIAL_DIST_FILTER)) {
                    badObjs.add(agent);
                    continue;
                }
                badObjs.add(occProfile.getProfParent());
            }
            if (!badObjs.isEmpty()) {
                addError.accept(new SimError(SimError.Level.MODERATE, Intl.intl("Both Forced Separation and Social Distancing are enabled."), Intl.intl("Disable Forced Separation in the Simulation Parameters, or disable Social Distancing on affected Occupants."), badObjs));
            }
        }
    }

    private static void validateQueues(MerlinData md, Consumer<SimError> addError, ITaskProgress progress) throws CancellationException {
        progress.setMessage(Intl.intl("Validating queues"));
        HashSet<GotoQueue> gotosToCheck = new HashSet<GotoQueue>();
        for (EgressAgent occ : MerlinUtil.getEnabledMembers(md, md.agents, EgressAgent.class, true)) {
            progress.check();
            gotosToCheck.addAll(occ.getBehavior().deepFlatten(GotoQueue.class));
        }
        for (OccSourceObj src : MerlinUtil.getEnabledMembers(md, md.occSources, OccSourceObj.class, true)) {
            progress.check();
            for (Behavior behavior : src.getAllBehaviors()) {
                progress.check();
                gotosToCheck.addAll(behavior.deepFlatten(GotoQueue.class));
            }
        }
        for (GotoQueue gotoQ : gotosToCheck) {
            progress.check();
            if (gotoQ.getQueues().isEmpty()) {
                addError.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("No queues are selected."), Intl.intl("Specify queues to go to."), gotoQ));
            }
            Collection<QueueObject> needToTestQueues = gotoQ.getQueues();
            for (QueueObject qo : needToTestQueues) {
                progress.check();
                qo.validate(md, SimError.Level.CRITICAL, addError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateDestinations(MerlinApp app, MerlinData md, Consumer<SimError> addError, ITaskProgress progress) throws CancellationException {
        progress.setMessage(Intl.intl("Validating destinations"));
        Collection<EgressAgent> agents = md.agents.getDeepMembers(EgressAgent.class);
        ExecutorService runner = Executors.newFixedThreadPool(Engine.getNumProcThreads());
        try {
            HashMap uniqueFutures = new HashMap();
            ArrayList futures = new ArrayList();
            Function<Pair, Future> newFuture = key -> runner.submit(() -> ((IDestination)key.v2).getUnreachable((IEgressComp)key.v1));
            Consumer<Tuple3> submitTest = t -> {
                Pair<IEgressComp, IDestination> key = new Pair<IEgressComp, IDestination>((IEgressComp)t.v2, (IDestination)t.v3);
                Future future = (Future)uniqueFutures.computeIfAbsent(key, newFuture);
                futures.add(new Pair<IMerlinObj, Future>((IMerlinObj)t.v1, future));
            };
            LinkedIdentityHashMap behaviorDestMap = new LinkedIdentityHashMap();
            LinkedIdentityHashSet<Behavior> usedBehaviors = Dependencies.getObjReferences(md, MerlinDepSnapshot.ACTIVE_SCENARIO, Behavior.class, Predicates.alwaysTrue());
            for (Behavior behavior : usedBehaviors) {
                progress.check();
                ArrayList<Pair<IDestinationAction, IDestination>> dests = new ArrayList<Pair<IDestinationAction, IDestination>>();
                for (IDestinationAction iDestinationAction : behavior.getMembers(IDestinationAction.class)) {
                    dests.add(new Pair<IDestinationAction, IDestination>(iDestinationAction, iDestinationAction.getDestination()));
                }
                for (int m = 0; m < dests.size() - 1; ++m) {
                    Collection<? extends IEgressComp> exitComps;
                    progress.check();
                    Pair pair = (Pair)dests.get(m);
                    try {
                        exitComps = ((IDestination)pair.v2).getExitComponents();
                    }
                    catch (Exception e) {
                        break;
                    }
                    if (exitComps.isEmpty()) {
                        addError.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("Invalid destination."), "", behavior));
                        continue;
                    }
                    Pair dest2 = (Pair)dests.get(m + 1);
                    for (IEgressComp iEgressComp : exitComps) {
                        Behavior source = pair.v1 != null ? (IMerlinObj)pair.v1 : behavior;
                        submitTest.accept(new Tuple3<Behavior, IEgressComp, IDestination>(source, iEgressComp, (IDestination)dest2.v2));
                    }
                }
                behaviorDestMap.put(behavior, dests);
            }
            for (EgressAgent occ : agents) {
                progress.check();
                if (!occ.isEnabled()) continue;
                IEgressOccupiable room = occ.getRoom();
                List dests = (List)behaviorDestMap.get(occ.getBehavior());
                if (dests.isEmpty()) continue;
                IDestination iDestination = (IDestination)((Pair)dests.get((int)0)).v2;
                submitTest.accept(new Tuple3<EgressAgent, IEgressOccupiable, IDestination>(occ, room, iDestination));
            }
            TriConsumer<IMerlinObj, IEgressComp, Collection> addTests = (obj, comp, behaviors) -> {
                for (Behavior behavior : behaviors) {
                    progress.check();
                    List dests = (List)behaviorDestMap.get(behavior);
                    if (dests.isEmpty()) continue;
                    IDestination firstDest = (IDestination)((Pair)dests.get((int)0)).v2;
                    submitTest.accept(new Tuple3<IMerlinObj, IEgressComp, IDestination>((IMerlinObj)obj, (IEgressComp)comp, firstDest));
                }
            };
            for (OccSourceObj os : md.occSources.flatten(OccSourceObj.class)) {
                progress.check();
                if (!os.isEnabled()) continue;
                IEgressComp comp2 = os.getComponent();
                List list = os.get(OccSourceObj.PROP_BEHAVIOR_DIST).getUnique(ArrayList.class);
                if (comp2 != null) {
                    addTests.accept(os, comp2, list);
                    continue;
                }
                AABox bounds = os.getGeom().getBoundingBox(new AABox());
                IResult<IDisplayableGeomSrc> searchResult = (obj, ctmt) -> {
                    progress.check();
                    if (!(obj instanceof IEgressOccupiable) || !((IEgressOccupiable)obj).getOccupantsAllowed()) {
                        return;
                    }
                    IEgressOccupiable room = (IEgressOccupiable)obj;
                    boolean isArea = RunInferno.isArea(bounds);
                    if (isArea && RunInferno.testAABoxPartiallyContainsRoom(bounds, room) || !isArea && RunInferno.testAABoxIntersectsRoom(bounds, room)) {
                        addTests.accept(os, room, behaviors2);
                    }
                };
                md.geomLocation.getLocator().find((ITest<AABox>)new AABoxTest(bounds, 1.0E-6), searchResult, 1);
            }
            for (Pair entry : futures) {
                progress.check();
                try {
                    IUnreachable result = (IUnreachable)((Future)entry.v2).get();
                    if (result == null) continue;
                    addError.accept(result.getError((IMerlinObj)entry.v1));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getCause());
                }
                catch (InterruptedException interruptedException) {
                }
            }
            for (EgressAgent occ : agents) {
                progress.check();
                for (SimError simError : app.getErrors().getErrors(occ)) {
                    addError.accept(simError);
                }
            }
        }
        finally {
            try {
                runner.shutdownNow();
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
    }

    private static void validateBehaviors(MerlinData md, Consumer<SimError> addError, ITaskProgress progress) {
        progress.setMessage(Intl.intl("Validating behaviors"));
        IFilteredCollection<IEgressConnector> exits = theUtil.filter(md.getAllExits(), d -> !(d instanceof AEgressComp) || ((AEgressComp)((Object)d)).isEnabled());
        for (GotoExits b : MerlinUtil.getEnabledMembers(md, md.behaviors.flatten(), GotoExits.class)) {
            progress.check();
            if (exits.containsAll((Collection)b.get(GotoExits.PROP_EXITS))) continue;
            addError.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("Invalid behavior detected in the model."), Intl.intl("Check behavior's exits"), b));
        }
        for (EgressAgent agent : MerlinUtil.getEnabledMembers(md, md.agents.flatten(), EgressAgent.class)) {
            progress.check();
            Behavior behavior = agent.getBehavior();
            if (behavior.getDomain() != null) continue;
            addError.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("Invalid behavior detected in the model."), Intl.intl("Reassign agent's behavior."), agent));
        }
    }

    private static void validateOccOutput(MerlinData md, Consumer<SimError> addError, ITaskProgress progress) {
        progress.setMessage(Intl.intl("Validating occupant output"));
        int nOccOutput = 0;
        if (md.simParams.get(SimParams.SMV_DATA_ENABLE).booleanValue()) {
            for (EgressAgent agent : md.agents.flatten(EgressAgent.class)) {
                IUrn output;
                progress.check();
                if (!agent.isEnabled() || !((Boolean)UrnUtil.getDominant(output = (IUrn)agent.getProfile().get(OccProfile.PROP_PRINT_EXTRA_OUTPUT))).booleanValue()) continue;
                ++nOccOutput;
            }
            if (nOccOutput == 0) {
                addError.accept(new SimError(SimError.Level.MODERATE, Intl.intl("FDS integration is enabled with no detailed occupant output. Plots for FED, CO, etc. will not be available in results."), Intl.intl("Enable detailed occupant output."), md.agents));
            }
        }
    }

    private static List<ScenarioSimError> validate(Window parent, MerlinApp app, MerlinData md, Map<ScenarioUtil.ScenarioVariationKey, Param> params) throws CancellationException {
        TaskProgress progress = new TaskProgress();
        return MerlinUtil.execLongTaskNoThrow(parent, Intl.intl("Validating Model"), progress, () -> {
            Set scenarios = params.keySet().stream().map(ScenarioUtil.ScenarioVariationKey::scenario).collect(Collectors.toCollection(LinkedIdentityHashSet::new));
            ArrayList errors = new ArrayList();
            try (SplitProgress scenariosProg = progress.split(scenarios.size());){
                ScenarioUtil.forEachScenarioActivated(md, scenarios, true, (scenario, index, count, prevActive) -> {
                    Consumer<SimError> addError = e -> {
                        if (e != null) {
                            errors.add(new ScenarioSimError(scenario, (SimError)e));
                        }
                    };
                    try (MerlinData.ReadLock lock = md.lockRead();
                         SplitProgress checksProg = scenariosProg.split(5);){
                        checksProg.setParentMessage((curr, max) -> String.format(Intl.intl("Validating scenario %1$d/%2$d"), index + 1, count));
                        scenariosProg.check();
                        RunInferno.validateExits(md, addError, checksProg);
                        checksProg.incrementParent();
                        RunInferno.validateSocialDistance(md, addError, (Param)params.get(new ScenarioUtil.ScenarioVariationKey(scenario, 0, 1)), checksProg);
                        checksProg.incrementParent();
                        RunInferno.validateDestinations(app, md, addError, checksProg);
                        checksProg.incrementParent();
                        RunInferno.validateQueues(md, addError, checksProg);
                        checksProg.incrementParent();
                        RunInferno.validateBehaviors(md, addError, checksProg);
                        checksProg.incrementParent();
                        RunInferno.validateOccOutput(md, addError, checksProg);
                        checksProg.incrementParent();
                    }
                    scenariosProg.incrementParent();
                    return true;
                });
            }
            return errors;
        });
    }

    public static void quickCheckForErrors(MerlinApp app, MerlinData md, Collection<Scenario> scenarios) throws CancelledException {
        String msg2;
        ArrayList criticalScenarios = new ArrayList();
        ArrayList moderateScenarios = new ArrayList();
        TreeSet missingSMVFiles = new TreeSet();
        TreeSet missingFDSResultsFiles = new TreeSet();
        TreeSet invalidSMVPaths = new TreeSet();
        ScenarioUtil.forEachScenarioActivated(md, scenarios, true, (scenario, index, count, prevActive) -> {
            ErrorAnalysis analysis;
            ErrorAnalysis errorAnalysis = analysis = prevActive ? app.getErrors() : new ErrorAnalysis(md, false);
            if (analysis.streamDeepErrors(md).anyMatch(err -> err.level == SimError.Level.CRITICAL)) {
                criticalScenarios.add(scenario);
            } else if (analysis.streamDeepErrors(md).findAny().isPresent()) {
                moderateScenarios.add(scenario);
            }
            if (md.simParams.get(SimParams.SMV_DATA_ENABLE).booleanValue()) {
                String relSmv = md.simParams.get(SimParams.SMV_DATA_FILE_NAME);
                try {
                    File f = MerlinUtil.resolveFile(md, relSmv).toFile();
                    if (!f.exists() || !f.canRead()) {
                        if (!RunInferno.retryCheckingForResultsFiles(f, md.filename, md)) {
                            missingSMVFiles.add(relSmv);
                        }
                    } else if (!SmvParseUtil.isSmvValid(f)) {
                        missingFDSResultsFiles.add(relSmv);
                    }
                }
                catch (InvalidPathException e) {
                    invalidSMVPaths.add(relSmv);
                }
            }
            return true;
        });
        if (!criticalScenarios.isEmpty()) {
            String scenarioList = criticalScenarios.stream().map(NamedMerlinObj::getName).collect(Collectors.joining(", "));
            String msg3 = String.format(Intl.intl("The model contains errors in scenarios: %s. Activate the scenarios and expand the tree on the left to identify the errors."), scenarioList);
            JOptionPane.showMessageDialog(app.getActiveFrame(), msg3, Intl.intl("Model Errors"), 0);
            throw new CancelledException();
        }
        if (!moderateScenarios.isEmpty()) {
            String scenarioList = moderateScenarios.stream().map(NamedMerlinObj::getName).collect(Collectors.joining(", "));
            msg2 = String.format(Intl.intl("The model contains warnings in scenarios: %s. Activate the scenarios and expand the tree on the left to identify the warnings.\nWould you like to ignore the warnings and continue?"), scenarioList);
            int option = JOptionPane.showConfirmDialog(app.getActiveFrame(), msg2, Intl.intl("Model Problems"), 0, 2);
            if (option != 0) {
                throw new CancelledException();
            }
        }
        Consumer<String> showSmvErr = msg -> JOptionPane.showMessageDialog(app.getActiveFrame(), msg, Intl.intl("Model Error"), 0);
        if (!missingSMVFiles.isEmpty()) {
            msg2 = String.format(Intl.intl("FDS integration is enabled, but FDS output data not found:\n%s\n\nDisable FDS integration to continue."), String.join((CharSequence)"\n", missingSMVFiles));
            showSmvErr.accept(msg2);
            throw new CancelledException();
        }
        if (!missingFDSResultsFiles.isEmpty()) {
            msg2 = String.format(Intl.intl("FDS integration is enabled, but FDS results files are missing:\n%s\n\nDisable FDS integration to continue."), String.join((CharSequence)"\n", missingFDSResultsFiles));
            showSmvErr.accept(msg2);
            throw new CancelledException();
        }
        if (!invalidSMVPaths.isEmpty()) {
            msg2 = String.format(Intl.intl("FDS integration is enabled, but SMV paths are invalid:\n%s\n\nDisable FDS integration or fix paths to continue."), String.join((CharSequence)"\n", invalidSMVPaths));
            showSmvErr.accept(msg2);
            throw new CancelledException();
        }
    }

    private static boolean retryCheckingForResultsFiles(File smvFile, String pthFileName, MerlinData md) {
        File pthFile = new File(pthFileName);
        if (pthFile.getParentFile().exists()) {
            String smvFolderGuess = pthFile.getName().replace(" ", "_");
            int ix = smvFolderGuess.indexOf(".");
            if (ix == -1) {
                return false;
            }
            String smvPathGuess = pthFile.getParent() + File.separator + smvFolderGuess.substring(0, ix) + File.separator + smvFile.getName();
            System.out.println("smv path guess: " + smvPathGuess);
            File smvPathGuessFile = new File(smvPathGuess);
            if (SmvParseUtil.isSmvValid(smvPathGuessFile)) {
                LOGGER.warning(String.format("Original SMV file path invalid, replacing with %s", smvPathGuess));
                md.simParams.set(SimParams.SMV_DATA_FILE_NAME, smvPathGuess);
                return true;
            }
            return false;
        }
        return false;
    }

    public static void thoroughCheckForErrors(Window parent, MerlinApp app, MerlinData md, Map<ScenarioUtil.ScenarioVariationKey, Param> params) throws CancelledException {
        try {
            List<ScenarioSimError> errors = RunInferno.validate(parent, app, md, params);
            if (errors.isEmpty()) {
                return;
            }
            RunInferno.validateErrors(app, md, errors);
        }
        catch (CancellationException e) {
            throw new CancelledException(e);
        }
    }

    private static void validateErrors(MerlinApp app, final MerlinData md, Collection<? extends ScenarioSimError> errors) throws CancelledException {
        if (errors.isEmpty()) {
            return;
        }
        IFilteredCollection<ScenarioSimError> criticalErrors = theUtil.filter(errors, e -> e.error.level == SimError.Level.CRITICAL);
        IFilteredCollection<ScenarioSimError> moderateErrors = theUtil.filter(errors, e -> e.error.level == SimError.Level.MODERATE);
        IFilteredCollection<ScenarioSimError> showErrors = !criticalErrors.isEmpty() ? criticalErrors : moderateErrors;
        WarningReport<ScenarioSimError> report = new WarningReport<ScenarioSimError>(ScenarioSimError.class, new int[]{3, 0, 1, 2}, new String[]{Intl.intl("Scenario"), Intl.intl("Message"), Intl.intl("How to Fix"), Intl.intl("Components")}, 0);
        for (ScenarioSimError error : showErrors) {
            report.addWarning(error);
        }
        int investigateBtn = 2;
        WarningDlg<ScenarioSimError> dlg = new WarningDlg<ScenarioSimError>(app.getActiveFrame(), !criticalErrors.isEmpty() ? Intl.intl("Model Errors") : Intl.intl("Model Warnings"), !criticalErrors.isEmpty() ? Intl.intl("The following errors must be fixed before continuing.") : Intl.intl("The following issues might cause problems with the simulation. What would you like to do?"), report, !criticalErrors.isEmpty() ? investigateBtn | 0x10 : investigateBtn | 1 | 8 | 0x10, !criticalErrors.isEmpty() ? WarningDlg.Severity.ERROR : WarningDlg.Severity.WARNING);
        JButton resetToSelectedBtn = new JButton(Intl.intl("Show Selected Objects"));
        resetToSelectedBtn.setToolTipText(Intl.intl("Reset the view to the objects that may have caused the problems."));
        Consumer<List> selectObjs = objs -> {
            AMerlinOp selOp = new AMerlinOp((List)objs){
                final /* synthetic */ List val$objs;
                {
                    this.val$objs = list;
                }

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    try (MerlinData.WriteLock lock = md.lockWrite();){
                        Undo.begin(Intl.intl("Select Warning objects"));
                        Undo.insertUndoEntry_restoreSelection(md);
                        md.selection.set(this.val$objs);
                        Undo.end(md);
                    }
                }
            };
            UIHook.run(resetToSelectedBtn, "Select Warning Objects", selOp, 0);
        };
        resetToSelectedBtn.addActionListener(e -> {
            List warnings = dlg.getSelectedWarnings();
            if (warnings.isEmpty()) {
                JOptionPane.showMessageDialog(dlg, Intl.intl("Select at least one row first."), Intl.intl("Select a Row"), 2);
                return;
            }
            List objs = warnings.stream().flatMap(se -> se.error.causeObjs.stream()).collect(Collectors.toList());
            if (objs.isEmpty()) {
                JOptionPane.showMessageDialog(dlg, Intl.intl("There are no objects associated with the selected rows."), Intl.intl("No Objects"), 2);
                return;
            }
            selectObjs.accept(objs);
            ModelView mv = app.getModelView();
            mv.getResetViewToSelOp().run(UIHook.getComponent(e));
        });
        dlg.getActionPanel().add((Component)resetToSelectedBtn, 0);
        resetToSelectedBtn.setVisible(false);
        BiConsumer<Integer, String> changeBtnText = (i, text) -> {
            JButton btn = dlg.getButton((int)i);
            if (btn == null) {
                return;
            }
            btn.setPreferredSize(null);
            btn.setText((String)text);
        };
        BiConsumer<Integer, Boolean> setBtnVisible = (i, vis) -> {
            JButton btn = dlg.getButton((int)i);
            if (btn != null) {
                btn.setVisible((boolean)vis);
            }
        };
        setBtnVisible.accept(16, false);
        if (criticalErrors.isEmpty()) {
            dlg.getButton(1).setText(Intl.intl("Ignore"));
            dlg.getButton(1).setToolTipText(Intl.intl("Ignore the errors and continue with the simulation."));
            dlg.getButton(8).setToolTipText(Intl.intl("Cancel the simulation."));
        }
        changeBtnText.accept(investigateBtn, Intl.intl("Investigate"));
        dlg.getButton(investigateBtn).setToolTipText(Intl.intl("Cancel the simulation and investigate errors."));
        final IEventObserver cancelObserver = events -> {
            IEventRecord<IMerlinObj> oevts = events.getEvents(IMerlinObj.class, new Class[0]);
            if (oevts.hasRemovedObjs()) {
                Set<IMerlinObj> removed = oevts.getRemovedObjs();
                dlg.removeIf(err -> err.error.causeObjs.stream().anyMatch(removed::contains));
            }
        };
        md.getEvents().addObserver(cancelObserver);
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        final SecondaryLoop waitLoop = eq.createSecondaryLoop();
        boolean[] investigating = new boolean[]{false};
        dlg.getButton(investigateBtn).addActionListener(e -> {
            int opt;
            if (criticalErrors.isEmpty() && (opt = JOptionPane.showConfirmDialog(dlg, Intl.intl("Are you sure you want to cancel the simulation and investigate errors?"), Intl.intl("Cancel Simulation?"), 0, 3)) != 0) {
                return;
            }
            resetToSelectedBtn.setVisible(true);
            setBtnVisible.accept(16, true);
            setBtnVisible.accept(investigateBtn, false);
            setBtnVisible.accept(8, false);
            setBtnVisible.accept(1, false);
            dlg.setMessage(Intl.intl("Investigate the following errors:"));
            dlg.getTable().getSelectionModel().addListSelectionListener(le -> {
                if (!le.getValueIsAdjusting()) {
                    List objs = dlg.getSelectedWarnings().stream().flatMap(se -> se.error.causeObjs.stream()).collect(Collectors.toList());
                    if (objs.isEmpty()) {
                        return;
                    }
                    selectObjs.accept(objs);
                }
            });
            investigating[0] = true;
            waitLoop.exit();
        });
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                md.getEvents().removeObserver(cancelObserver);
                waitLoop.exit();
            }
        });
        dlg.doModeless();
        waitLoop.enter();
        int status = dlg.getStatus();
        if (investigating[0] || status != 1 || !criticalErrors.isEmpty()) {
            throw new CancelledException();
        }
    }

    public static void checkInProgress(MerlinApp app) throws CancelledException {
        if (COUNT.get() > 0) {
            guiDialog inProgressDlg = new guiDialog((Window)app.getMainFrame(), Intl.intl("Simulation In Progress"), 1);
            guiLabel errorIcon = new guiLabel(UIManager.getIcon("OptionPane.errorIcon"));
            guiPanel contents = new guiPanel(new MigLayout());
            contents.add(errorIcon);
            guiLabel messageLabel = new guiLabel(Intl.intl("A Pathfinder simulation is already in progress."));
            contents.add(messageLabel);
            inProgressDlg.add(contents);
            inProgressDlg.doModal();
            throw new CancelledException();
        }
    }

    public static Pair<List<InfernoData>, MultiSimulationOutputDir> prepareEngines(MerlinApp app, MerlinData md, Collection<Scenario> scenarios, Runnable preCheckCompleted, boolean debug) throws CancelledException {
        try (Events.EventPause pause = md.getEvents().openPause(false);){
            theTimer timer = new theTimer();
            Consumer<String> profileBegin = msg -> {
                LOGGER.info((String)msg);
                timer.reset();
            };
            Runnable profileEnd = () -> {
                LOGGER.info(String.format("Done (%.2f s)", timer.curr()));
                timer.reset();
            };
            profileBegin.accept(Intl.intl("Checking errors..."));
            RunInferno.quickCheckForErrors(app, md, scenarios);
            profileEnd.run();
            if (md.filename == null) {
                profileBegin.accept(Intl.intl("Saving model..."));
                if (!Save.saveToFile(app, md, false)) {
                    throw new CancelledException();
                }
                profileEnd.run();
            }
            ArrayList<Scenario> modelScenarios = new ArrayList<Scenario>(md.scenarios.flatten(Scenario.class));
            IdentityHashMap<Scenario, Integer> variationCounts = new IdentityHashMap<Scenario, Integer>();
            for (Scenario scenario2 : modelScenarios) {
                int count2 = (Integer)md.scenarios.getScenarioValue(scenario2, md.monteCarlo, MonteCarlo.VARIATION_COUNT).orElseGet(() -> new ScenarioRoot.ScenarioValue<Integer>(false, 1)).value();
                variationCounts.put(scenario2, count2);
            }
            MultiSimulationOutputDir outDir = null;
            HashMap<ScenarioUtil.ScenarioVariationKey, SimOutputDir> outputDirs = new HashMap<ScenarioUtil.ScenarioVariationKey, SimOutputDir>();
            do {
                try {
                    for (Scenario scenario3 : modelScenarios) {
                        int variationCount = (Integer)variationCounts.get(scenario3);
                        for (int variationIndex = 0; variationIndex < variationCount; ++variationIndex) {
                            outputDirs.put(new ScenarioUtil.ScenarioVariationKey(scenario3, variationIndex, variationCount), ScenarioUtil.getOutputDir(md, scenario3, variationIndex));
                        }
                    }
                    Path outputBaseName = Path.of(InfernoUtil.rootFn(md.filename), new String[0]);
                    Path outputRootDir = Path.of(md.filename, new String[0]).getParent().resolve(outputBaseName);
                    outDir = new MultiSimulationOutputDir(outputRootDir, outputRootDir.resolve(String.valueOf(outputBaseName) + "_simulations.json"), new SimulationInputList(md, scenarios, outputRootDir, outputDirs));
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(app.getActiveFrame(), Intl.intl("Could not determine output file path. Try saving the model in a different location."), Intl.intl("Error Creating Outputs"), 0);
                    outputDirs.clear();
                    profileBegin.accept(Intl.intl("Saving model..."));
                    if (!Save.saveToFile(app, md, true)) {
                        throw new CancelledException();
                    }
                    profileEnd.run();
                }
            } while (outputDirs.isEmpty());
            profileBegin.accept(Intl.intl("Creating scenario output directories..."));
            for (SimOutputDir outputDir : outputDirs.values()) {
                File dir = outputDir.current.outputDir().toFile();
                if (dir.getParentFile().isFile() || dir.isFile()) {
                    throw new CancelledException();
                }
                if (dir.isDirectory() || dir.mkdirs()) continue;
                throw new CancelledException();
            }
            profileEnd.run();
            LinkedHashMap<ScenarioUtil.ScenarioVariationKey, Param> params = new LinkedHashMap<ScenarioUtil.ScenarioVariationKey, Param>();
            MultiSimulationOutputDir finalOutDir = outDir;
            ScenarioUtil.forEachScenarioActivated(md, scenarios, false, (scenario, index, count, prevActive) -> {
                int variationCount = (Integer)variationCounts.get(scenario);
                for (int i = 0; i < variationCount; ++i) {
                    SimOutputDir outputDir = (SimOutputDir)outputDirs.get(new ScenarioUtil.ScenarioVariationKey(scenario, i, variationCount));
                    params.put(new ScenarioUtil.ScenarioVariationKey(scenario, i, variationCount), InfernoUtil.mkInfernoParam(app, md, outputDir.current.outputDir().toFile(), outputDir.current.outputFileBasename().toString(), outputDir.current.sharedOutputFileBasename().toString(), finalOutDir.simulationListFile.toFile(), variationCount, debug));
                }
                return true;
            });
            List<File> efiles = RunInferno.getExistingFiles(params.values().stream().flatMap(p -> Arrays.stream(p.getOuputFiles())).toList());
            if (!efiles.isEmpty()) {
                String msg2 = Intl.intl("Existing output files will be overwritten.\nWould you like to continue?");
                int option = JOptionPane.showConfirmDialog(MerlinApp.getApp().getActiveFrame(), msg2, Intl.intl("Overwrite Files?"), 0);
                if (option != 0) {
                    throw new CancelledException();
                }
            }
            if (preCheckCompleted != null) {
                preCheckCompleted.run();
            }
            profileBegin.accept(Intl.intl("Validating model..."));
            RunInferno.thoroughCheckForErrors(app.getActiveFrame(), app, md, params);
            profileEnd.run();
            profileBegin.accept(Intl.intl("Creating simulation data"));
            ArrayList errors = new ArrayList();
            AtomicReference inputFileError = new AtomicReference();
            LinkedHashMap kbs = new LinkedHashMap();
            TaskProgress progress = new TaskProgress();
            try {
                MerlinUtil.execLongTaskNoThrow(app.getActiveFrame(), Intl.intl("Preparing Simulator"), progress, () -> {
                    try (SplitProgress scenariosProg = progress.split(scenarios.size());){
                        ScenarioUtil.forEachScenarioActivated(md, scenarios, true, (scenario, scenarioIndex, scenarioCount, prevActive) -> {
                            ArrayList scenarioErrors = new ArrayList();
                            try (SplitProgress variationsProg = scenariosProg.split(md.monteCarlo.get(MonteCarlo.VARIATION_COUNT));){
                                variationsProg.check();
                                MonteCarloVariationGenerator.generateVariations(md, (variationIndex, variationCount, variationErrors) -> {
                                    try (SplitProgress stepsProg = variationsProg.split(2);){
                                        stepsProg.setParentMessage((curr, max) -> String.format(Intl.intl("Preparing scenario %1$d/%2$d; variation %3$d/%4$d"), scenarioIndex + 1, scenarioCount, variationIndex + 1, variationCount));
                                        stepsProg.check();
                                        InfernoUtil.KBInfo kbInfo = InfernoUtil.mkInfernoKB(md, (Param)params.get(new ScenarioUtil.ScenarioVariationKey(scenario, variationIndex, variationCount)), scenarioErrors, stepsProg);
                                        KB kb = kbInfo.kb;
                                        stepsProg.incrementParent();
                                        SimOutputDir outputDir = (SimOutputDir)outputDirs.get(new ScenarioUtil.ScenarioVariationKey(scenario, variationIndex, variationCount));
                                        if (scenarios.size() <= 1 && variationCount <= 1) {
                                            kbs.put(new ScenarioUtil.ScenarioVariationKey(scenario, variationIndex, variationCount), new KBSupplier(() -> kb, () -> {}));
                                        } else {
                                            Path kbPath = outputDir.current.getKBPath();
                                            kbPath.getParent().toFile().mkdirs();
                                            File kbFile = kbPath.toFile();
                                            try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(kbFile)));){
                                                oos.writeObject(kb);
                                                kbs.put(new ScenarioUtil.ScenarioVariationKey(scenario, variationIndex, variationCount), new KBSupplier(() -> {
                                                    KB loaded;
                                                    try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(kbFile)));){
                                                        loaded = (KB)ois.readObject();
                                                    }
                                                    catch (Exception e) {
                                                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                                                        return null;
                                                    }
                                                    return loaded;
                                                }, () -> {
                                                    try {
                                                        kbFile.delete();
                                                        File parentDir = kbFile.getParentFile();
                                                        try (Stream<Path> entries = Files.list(parentDir.toPath());){
                                                            if (entries.findFirst().isEmpty()) {
                                                                parentDir.delete();
                                                            }
                                                        }
                                                    }
                                                    catch (Exception e) {
                                                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                                                    }
                                                }));
                                            }
                                            catch (IOException e) {
                                                try {
                                                    kbFile.delete();
                                                }
                                                catch (Exception e2) {
                                                    LOGGER.log(Level.WARNING, e2.getMessage(), e2);
                                                }
                                                kbs.put(new ScenarioUtil.ScenarioVariationKey(scenario, variationIndex, variationCount), new KBSupplier(() -> kb, () -> {}));
                                            }
                                        }
                                        try {
                                            if (kb == null) {
                                                throw new IOException();
                                            }
                                            WriteMesh.writeInputFile(md, outputDir.current.outputDir().toFile(), outputDir.current.outputFileBasename().toString(), kbInfo, (Param)params.get(new ScenarioUtil.ScenarioVariationKey(scenario, variationIndex, variationCount)), variationIndex == 0, stepsProg);
                                        }
                                        catch (IOException e) {
                                            inputFileError.set(e);
                                        }
                                        stepsProg.incrementParent();
                                    }
                                    scenarioErrors.addAll(variationErrors);
                                    variationsProg.incrementParent();
                                    return true;
                                });
                            }
                            errors.addAll(scenarioErrors.stream().map(error -> new ScenarioSimError(scenario, (SimError)error)).toList());
                            scenariosProg.incrementParent();
                            return true;
                        });
                    }
                    return null;
                });
            }
            catch (CancellationException e) {
                kbs.values().forEach(kb -> kb.cleanUp.run());
                throw new CancelledException(e);
            }
            profileEnd.run();
            try {
                RunInferno.validateErrors(app, md, errors);
            }
            catch (CancelledException e) {
                kbs.values().forEach(kb -> kb.cleanUp.run());
                throw e;
            }
            if (inputFileError.get() != null) {
                thunderheadeng.gui.guiUtil.showError(app, Intl.intl("File Error"), Intl.intl("Could not write input file."), ((Exception)inputFileError.get()).getCause());
            }
            List<InfernoData> infernoData = kbs.entrySet().stream().map(entry -> new InfernoData((SimOutputDir)outputDirs.get(entry.getKey()), dlg -> {
                Supplier<Engine> createEngine = () -> RunInferno.finalizeEngine(dlg, (KBSupplier)entry.getValue());
                if (SwingUtilities.isEventDispatchThread()) {
                    return createEngine.get();
                }
                AtomicReference result = new AtomicReference();
                try {
                    SwingUtilities.invokeAndWait(() -> result.set((Engine)createEngine.get()));
                }
                catch (Throwable t) {
                    TeciLogging.log(LOGGER, t);
                    return null;
                }
                return (Engine)result.get();
            }, ((KBSupplier)entry.getValue()).cleanUp)).toList();
            Pair<List<InfernoData>, MultiSimulationOutputDir> pair = new Pair<List<InfernoData>, MultiSimulationOutputDir>(infernoData, outDir);
            return pair;
        }
    }

    private static List<File> getExistingFiles(Collection<File> files) {
        ArrayList<File> efiles = new ArrayList<File>();
        for (File file : files) {
            if (!file.exists()) continue;
            efiles.add(file);
        }
        return efiles;
    }

    private static Engine finalizeEngine(Window parent, KBSupplier loadKB) {
        KB kb = loadKB.get.get();
        loadKB.cleanUp.run();
        if (kb == null) {
            LOGGER.severe(Intl.intl("Error: Could not load cached simulation state. Skipping this scenario."));
            return null;
        }
        try {
            TaskProgress progress = new TaskProgress();
            return MerlinUtil.execLongTask(parent, Intl.intl("Finalizing simulator"), progress, () -> {
                try (SplitProgress sprog = progress.split(2);){
                    kb.init(sprog);
                    sprog.incrementParent();
                    Engine engine = new Engine(kb, kb.getParams(), null);
                    sprog.incrementParent();
                    Engine engine2 = engine;
                    return engine2;
                }
            });
        }
        catch (ExecutionException e) {
            LOGGER.severe(Intl.intl("Error: Could not write results files."));
            return null;
        }
        catch (CancellationException e) {
            return null;
        }
    }

    public static IRunApi run(Window parent, IRunCallback callback, TeciProps prefs, Collection<? extends InfernoData> sims, MultiSimulationOutputDir outDir) {
        ArrayDeque<InfernoData> infernos = new ArrayDeque<InfernoData>(sims);
        Responder api = new Responder(infernos);
        Thread t = new Thread(() -> {
            COUNT.incrementAndGet();
            try {
                if (outDir != null) {
                    LOGGER.info(Intl.intl("Writing simulation list..."));
                    try {
                        WriteScenarios.writeSimulationList(outDir.simulationList, outDir.simulationListFile);
                        LOGGER.info(Intl.intl("Finished writing simulation list."));
                    }
                    catch (Exception e) {
                        LOGGER.severe(Intl.intl("Error writing simulation list:"));
                        RunInferno.logExceptionChain(e);
                    }
                }
                int simCount = infernos.size();
                int currentSim = 0;
                while (!infernos.isEmpty()) {
                    InfernoData infernoData = (InfernoData)infernos.poll();
                    callback.setSimulationsRemaining(1 + infernos.size(), 1 + (int)infernos.stream().takeWhile(data -> data.outputDir.scenarioName().equals(infernoData.outputDir.scenarioName())).count());
                    api.setStatus(infernoData, ScenarioStatus.IN_PROGRESS);
                    Engine inferno = infernoData.createEngine.apply(parent);
                    if (inferno == null) {
                        currentSim = simCount - 1;
                        api.setEngine(null, "");
                        callback.setState(RunState.SIM_NEXT);
                        continue;
                    }
                    currentSim = simCount - 1 - infernos.size();
                    callback.nextSim(infernoData.getOutputDir().current.getResultsFile().toString(), currentSim, simCount, infernoData.getOutputDir().variationIndex(), infernoData.getOutputDir().variationCount(), inferno);
                    callback.setState(RunState.SIM_PRE);
                    api.setEngine(inferno, infernoData.outputDir.scenarioName());
                    inferno.addObserver(new RunCallbackUpdater(callback));
                    inferno.run(prefs);
                    try {
                        inferno.waitUntilFinished(100L);
                        if (!inferno.wasCanceled()) {
                            callback.completed();
                            api.setStatus(infernoData, ScenarioStatus.COMPLETED);
                        } else {
                            api.setStatus(infernoData, ScenarioStatus.CANCELED);
                        }
                    }
                    catch (FileNotFoundException e) {
                        LOGGER.severe(Intl.intl("The simulation cannot continue:"));
                        RunInferno.logExceptionChain(e);
                        api.setStatus(infernoData, ScenarioStatus.ERROR);
                    }
                    catch (ExecutionException e) {
                        callback.report(e.getCause() != null ? e.getCause() : e);
                        api.setStatus(infernoData, ScenarioStatus.ERROR);
                    }
                    api.setEngine(null, "");
                    callback.setState(RunState.SIM_NEXT);
                }
                if (outDir != null) {
                    LOGGER.info(Intl.intl("Collecting multi-simulation results..."));
                    try {
                        ProcessResults.processResults(outDir.simulationList, outDir.rootDir);
                        WriteScenarios.writeCleanScript(outDir.rootDir.resolve("_clean.bat"), outDir.simulationListFile.getFileName().toString(), MerlinApp.getApp().getInstallDir());
                        LOGGER.info(Intl.intl("Finished multi-simulation results."));
                    }
                    catch (Exception e) {
                        LOGGER.severe(Intl.intl("Error collecting multi-simulation results:"));
                        RunInferno.logExceptionChain(e);
                    }
                }
                callback.finished();
                callback.setState(RunState.SIM_FINISHED);
            }
            finally {
                COUNT.decrementAndGet();
            }
        });
        api.setSimThread(t);
        t.start();
        return api;
    }

    public static void logExceptionChain(Throwable t) {
        if (t != null) {
            String message = String.format("[%s] %s", t.getClass().getSimpleName(), t.getMessage());
            LOGGER.severe(message);
            RunInferno.logExceptionChain(t.getCause());
        }
    }

    public static BooleanListDlg<Scenario> newScenarioChooserDialog(Window parent, String title, String header, String desc) {
        return new BooleanListDlg<Scenario>(parent, title, header, desc, 8, false, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof Scenario) {
                    Scenario s = (Scenario)value;
                    this.setText(s.getName());
                    guiUtil.decorateCellRenderer(MerlinApp.getAppData(), () -> {}, MerlinUtil::getName, value, this, isSelected, hasFocus, true, false);
                }
                return this;
            }
        }, (mobj, bc) -> mobj.getName(), true);
    }

    public static class ActionProps
    extends RestorableProperties
    implements IDirectDependent<MerlinData> {
        private static final long serialVersionUID = 1L;
        private static final PropertyDefs<ActionProps> PROP_TYPES = PropertyDefs.defsInheritStorageAndProps(ActionProps.class, null, RestorableProperties.PROP_TYPES);
        public static final String KEY = "RunInferno.ActionProps";
        public static final TypedProp<Set<Scenario>> PROP_SCENARIOS = TypedProps.buildGeneric("RunInferno.SCENARIOS", Set.class, Set.of()).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyInSet(prop, DLink.WEAK, Scenario.class, null)).attrFinish();

        @Override
        public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
            return PROP_TYPES;
        }
    }

    public record MultiSimulationOutputDir(Path rootDir, Path simulationListFile, SimulationInputList simulationList) {
    }

    public static class InfernoData {
        public final SimOutputDir outputDir;
        public final Function<? super Window, Engine> createEngine;
        public final Runnable cleanUpEngine;

        public InfernoData(SimOutputDir outputDir, Function<? super Window, Engine> createEngine, Runnable cleanUpEngine) {
            this.outputDir = outputDir;
            this.createEngine = createEngine;
            this.cleanUpEngine = cleanUpEngine;
        }

        public SimOutputDir getOutputDir() {
            return this.outputDir;
        }
    }

    public static interface IRunCallback {
        public void setSimulationsRemaining(int var1, int var2);

        public void nextSim(String var1, int var2, int var3, int var4, int var5, Engine var6);

        public void setState(RunState var1);

        public void update(IPropertySet var1);

        public void report(Throwable var1);

        public void completed();

        public void finished();
    }

    public static interface IRunApi {
        public void cancel();

        public void pause();

        public void resume();

        public boolean stop();

        public void showDebugView(Window var1);

        public void clearQueue();

        public void clearVariations();

        public ScenarioStatus getStatus(SimOutputDir var1);

        public boolean join(long var1);
    }

    private static class Tuple3<T1, T2, T3> {
        public final T1 v1;
        public final T2 v2;
        public final T3 v3;

        public Tuple3(T1 v1, T2 v2, T3 v3) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
        }
    }

    private record KBSupplier(Supplier<KB> get, Runnable cleanUp) {
    }

    private static class Responder
    implements IRunApi {
        private Engine d_inferno = null;
        private String d_scenarioName = "";
        private final Queue<InfernoData> d_infernos;
        private final Map<SimOutputDir, ScenarioStatus> d_status = new IdentityHashMap<SimOutputDir, ScenarioStatus>();
        private WeakReference<Thread> d_simThread;

        public Responder(Queue<InfernoData> engines) {
            this.d_infernos = engines;
        }

        private void setSimThread(Thread t) {
            assert (this.d_simThread == null);
            this.d_simThread = new WeakReference<Thread>(t);
        }

        private synchronized void setEngine(Engine inferno, String scenarioName) {
            this.d_inferno = inferno;
            this.d_scenarioName = scenarioName;
        }

        private synchronized void setStatus(InfernoData inferno, ScenarioStatus status) {
            this.d_status.put(inferno.outputDir, status);
        }

        @Override
        public synchronized ScenarioStatus getStatus(SimOutputDir sim) {
            return this.d_status.getOrDefault(sim, ScenarioStatus.QUEUED);
        }

        @Override
        public boolean join(long timeoutMS) {
            if (this.d_simThread == null) {
                assert (false);
                return false;
            }
            try {
                Thread t = (Thread)this.d_simThread.get();
                if (t == null) {
                    return true;
                }
                t.join(timeoutMS);
                return !t.isAlive();
            }
            catch (InterruptedException e) {
                TeciLogging.log(LOGGER, e);
                return false;
            }
        }

        @Override
        public synchronized void cancel() {
            if (this.d_inferno != null && !this.d_inferno.isFinished()) {
                this.d_inferno.cancel();
            }
        }

        @Override
        public synchronized void showDebugView(Window parent) {
            if (this.d_inferno != null) {
                this.d_inferno.showVis();
            }
        }

        @Override
        public synchronized void pause() {
            if (this.d_inferno != null) {
                this.d_inferno.pause();
            }
        }

        @Override
        public synchronized void resume() {
            if (this.d_inferno != null) {
                this.d_inferno.resume();
            }
        }

        @Override
        public synchronized boolean stop() {
            if (this.d_inferno != null && !this.d_inferno.isFinished()) {
                this.d_inferno.scheduleSnapshot();
                this.d_inferno.cancel();
                return true;
            }
            return false;
        }

        @Override
        public synchronized void clearQueue() {
            this.d_infernos.forEach(inferno -> inferno.cleanUpEngine.run());
            this.d_infernos.clear();
        }

        @Override
        public synchronized void clearVariations() {
            if (this.d_inferno != null) {
                InfernoData next = this.d_infernos.peek();
                while (next != null && next.outputDir.scenarioName().equals(this.d_scenarioName)) {
                    next.cleanUpEngine.run();
                    this.d_infernos.poll();
                    next = this.d_infernos.peek();
                }
            }
        }
    }

    public static enum ScenarioStatus {
        QUEUED(Intl.intl("Not Started")),
        IN_PROGRESS(Intl.intl("In Progress")),
        COMPLETED(Intl.intl("Completed")),
        CANCELED(Intl.intl("Canceled")),
        ERROR(Intl.intl("Error")),
        INCOMPLETE(Intl.intl("Incomplete"));

        public final String desc;

        private ScenarioStatus(String desc) {
            this.desc = desc;
        }
    }

    public static enum RunState {
        SIM_PRE,
        SIM_RUNNING,
        SIM_PAUSED,
        SIM_FINISHED,
        SIM_NEXT;

    }

    private static class RunCallbackUpdater
    implements Observer {
        private IRunCallback d_callback;

        public RunCallbackUpdater(IRunCallback callback) {
            this.d_callback = callback;
        }

        @Override
        public void update(Observable o, Object arg) {
            assert (o instanceof Engine);
            IPropertySet meta = (IPropertySet)arg;
            this.d_callback.update(meta);
            RunState dlgState = switch (meta.get(Engine.META_STATE)) {
                case Engine.State.RUNNING -> RunState.SIM_RUNNING;
                case Engine.State.PAUSED -> RunState.SIM_PAUSED;
                default -> RunState.SIM_NEXT;
            };
            this.d_callback.setState(dlgState);
        }
    }

    public static class ScenarioRunObserver
    implements IEventObserver {
        private final MerlinData d_md;

        public ScenarioRunObserver(MerlinData md) {
            this.d_md = md;
            this.d_md.getEvents().addObserverInDomain((IEventObserver)this, Scenario.class, true, true, new Object[0]);
        }

        @Override
        public void update(Events events) {
            ActionProps props;
            IEventRecord<MerlinData> modelRecord = events.getEvents(MerlinData.class, new Class[0]);
            if (modelRecord.containsChange(MerlinData.MODEL_RESET) || modelRecord.containsChange(MerlinData.MODEL_LOADED) || modelRecord.containsChange(MerlinData.MODEL_SAVED)) {
                return;
            }
            IEventRecord<Scenario> scenarioRecord = events.getEvents(Scenario.class, new Class[0]);
            if ((scenarioRecord.hasAddedObjs() || scenarioRecord.hasRemovedObjs()) && (props = (ActionProps)this.d_md.actionProperties.getActionProps("RunInferno.ActionProps")) != null) {
                IdentityHashSet<Scenario> scenariosToRun = new IdentityHashSet<Scenario>((Collection)props.get(ActionProps.PROP_SCENARIOS));
                scenariosToRun.removeAll(scenarioRecord.getRemovedObjs());
                scenariosToRun.addAll((Collection<Scenario>)scenarioRecord.getAddedObjs());
                props.set(ActionProps.PROP_SCENARIOS, scenariosToRun);
                this.d_md.getEvents().changed(props, ActionProps.PROP_SCENARIOS);
            }
        }
    }

    private static class RunDlgEchoStream
    extends FilterOutputStream {
        public final PrintStream out;
        public final RunSimDlg dlg;
        private StringBuffer d_buffer;

        public RunDlgEchoStream(PrintStream consoleOut, RunSimDlg dlg) {
            super(consoleOut);
            this.out = consoleOut;
            this.dlg = dlg;
            this.d_buffer = new StringBuffer();
        }

        @Override
        public synchronized void flush() throws IOException {
            super.flush();
            if (0 < this.d_buffer.length()) {
                this.dlg.printToLog(this.d_buffer.toString());
                this.d_buffer.delete(0, this.d_buffer.length());
            }
        }

        @Override
        public synchronized void write(int b) throws IOException {
            super.write(b);
            if (b == 10) {
                this.dlg.printToLog(this.d_buffer.toString());
                this.d_buffer.delete(0, this.d_buffer.length());
            } else {
                this.d_buffer.append((char)b);
            }
        }
    }
}

