/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import inferno.io.SnapshotReader;
import inferno.sim.Engine;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.Behemoth;
import merlin.actions.MerlinOp;
import merlin.actions.RunInferno;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.data.scenario.Scenario;
import merlin.data.scenario.ScenarioUtil;
import merlin.data.scenario.SimOutputDir;
import merlin.gui.RunSimDlg;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.util.Global;
import thunderheadeng.util.theUtil;

public class ResumeInferno
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new ResumeInferno(), Intl.intl("Res&ume Simulation...,-,Resume Simulation"), null);
    private static final Logger LOGGER = Logger.getLogger(ResumeInferno.class.getName());

    @Override
    public void run(final MerlinApp app, MerlinData md) {
        String filename;
        try (MerlinData.ReadLock lock = md.lockRead();){
            filename = md.filename;
        }
        if (filename == null) {
            JOptionPane.showMessageDialog(app.getActiveFrame(), Intl.intl("An existing model must first be loaded."), Intl.intl("Model Not Loaded"), 0);
            return;
        }
        ArrayList<SnapshotReader.SnapshotInfo> snapshots = new ArrayList<SnapshotReader.SnapshotInfo>();
        Collection<Scenario> scenarios = md.scenarios.flatten(Scenario.class);
        for (Scenario scenario : scenarios) {
            int variationCount = ScenarioUtil.getVariationCount(md, scenario);
            for (int i = 0; i < variationCount; ++i) {
                try {
                    SimOutputDir outputDir = ScenarioUtil.getOutputDir(filename, scenario.getName(), scenarios.size(), i, variationCount);
                    File snapshotFile = outputDir.current.getSnapshotFile().toFile();
                    if (!snapshotFile.exists() || !snapshotFile.isFile()) continue;
                    snapshots.addAll(SnapshotReader.getSnapshots(outputDir));
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (snapshots.isEmpty()) {
            JOptionPane.showMessageDialog(app.getActiveFrame(), Intl.intl("There are no snapshots for the current model."), Intl.intl("No Snapshots"), 2);
            return;
        }
        JFrame parent = app.getActiveFrame();
        SnapshotDlg ssdlg = new SnapshotDlg((Window)parent, snapshots);
        if (ssdlg.doModal() != 1) {
            return;
        }
        final SnapshotReader.SnapshotInfo snapshot = ssdlg.getSnapshot();
        final RunSimDlg dlg = new RunSimDlg(parent);
        dlg.setTitleFromPath(snapshot.outDir.current.outputDir().toString(), snapshot.outDir.scenarioName(), snapshot.outDir.variationIndex(), snapshot.outDir.variationCount(), 0, 1);
        dlg.doModeless();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Engine inferno;
                dlg.beginWaitCursor();
                Consumer<String> printToLog = str -> SwingUtilities.invokeLater(() -> dlg.printToLog((String)str));
                try {
                    printToLog.accept(Intl.intl("Opening simulation snapshot..."));
                    inferno = SnapshotReader.openSnapshot(snapshot.outDir.current.getSnapshotFile().toFile(), snapshot, true);
                }
                catch (IOException e) {
                    String msg = String.format(Intl.intl("Error: Could not open snapshot:%n%s"), e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getClass().getSimpleName());
                    printToLog.accept(msg);
                    TeciLogging.log(LOGGER, e);
                    return;
                }
                finally {
                    dlg.endWaitCursor();
                }
                RunInferno.InfernoData infernoData = new RunInferno.InfernoData(snapshot.outDir, dlg -> inferno, () -> {});
                Runnable showResults = () -> Behemoth.runBehemoth(app, snapshot2.outDir.current.getResultsFile().toString(), snapshot2.outDir.current.visualizationFile().toString());
                RunInferno.IRunApi api = RunInferno.run(dlg, dlg.prepareRunCallback(), app.getPrefs(), List.of(infernoData), null);
                SwingUtilities.invokeLater(() -> dlg.connect(api, false, showResults));
            }
        }).start();
    }

    private static class SnapshotDlg
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        private final JList<SnapshotReader.SnapshotInfo> d_list;

        public SnapshotDlg(Window owner, List<SnapshotReader.SnapshotInfo> snapshots) {
            super(owner, Intl.intl("Choose Snapshot"), 9);
            this.d_list = new JList<SnapshotReader.SnapshotInfo>(theUtil.toArray(snapshots, SnapshotReader.SnapshotInfo.class));
            this.d_list.setSelectionMode(0);
            this.d_list.setCellRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    SnapshotReader.SnapshotInfo snapshot = (SnapshotReader.SnapshotInfo)value;
                    String text = String.format("%1$s %2$s", ScenarioUtil.formatScenarioAndVariation(snapshot.outDir.scenarioName(), snapshot.outDir.variationIndex(), snapshot.outDir.variationCount()), Global.format(snapshot.t, (Unit)SI.SECOND));
                    this.setText(text);
                    return c;
                }
            });
            this.d_list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        this.getButton(1).doClick();
                    }
                }
            });
            JScrollPane listsp = new JScrollPane(this.d_list);
            if (!snapshots.isEmpty()) {
                int lastix = snapshots.size() - 1;
                this.d_list.setSelectedIndex(lastix);
                this.d_list.scrollRectToVisible(this.d_list.getCellBounds(lastix, lastix));
            }
            guiPanel panel = this.getDialogPane();
            panel.setLayout(new MigLayout("insets 0, gap 6, fill"));
            panel.add((Component)new guiLabel(Intl.intl("Choose the snapshot to resume from:")), "grow 0, wrap");
            panel.add((Component)listsp, "grow, push, wrap");
            this.setResizable(true);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            int selIndex = this.d_list.getSelectedIndex();
            if (selIndex < 0) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(this, Intl.intl("You must choose a time from the list."), Intl.intl("Choose a Time"), 0);
                }
                return false;
            }
            if (selIndex < this.d_list.getModel().getSize() - 1 && showWarn) {
                SnapshotReader.SnapshotInfo snapshot = this.getSnapshot();
                int option = JOptionPane.showConfirmDialog(this, String.format(Intl.intl("Snapshots after t=%s will be overwritten.\nAre you sure you want to resume here?"), Global.format(snapshot.t, (Unit)SI.SECOND)), Intl.intl("Resume Snapshot?"), 0);
                if (option != 0) {
                    return false;
                }
            }
            return true;
        }

        public SnapshotReader.SnapshotInfo getSnapshot() {
            return this.d_list.getSelectedValue();
        }
    }
}

