/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.MerlinData;
import merlin.data.scenario.ScenarioUtil;
import merlin.data.scenario.SimOutputDir;
import merlin.gui.guiUtil;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.Nullable;

public class ResultsUtil {
    public static ScenarioUtil.ScenarioVariationKey pickScenario(MerlinData md, Component parent, Collection<ScenarioUtil.ScenarioVariationKey> scenarios, final Function<ScenarioUtil.ScenarioVariationKey, String> formatScenario, ScenarioUtil.ScenarioVariationKey defScenario, String msg) {
        if (scenarios.isEmpty()) {
            return null;
        }
        if (!scenarios.contains(defScenario)) {
            defScenario = scenarios.iterator().next();
        }
        if (scenarios.size() == 1) {
            return defScenario;
        }
        final guiComboBox<ScenarioUtil.ScenarioVariationKey> scenarioChooser = new guiComboBox<ScenarioUtil.ScenarioVariationKey>(scenarios);
        scenarioChooser.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof ScenarioUtil.ScenarioVariationKey) {
                    ScenarioUtil.ScenarioVariationKey s = (ScenarioUtil.ScenarioVariationKey)value;
                    guiUtil.decorateComboRenderer(MerlinApp.getAppData(), scenarioChooser, list, MerlinUtil::getName, value, this, isSelected, cellHasFocus, true);
                    this.setText((String)formatScenario.apply(s));
                    scenarioChooser.setFont(this.getFont());
                } else {
                    scenarioChooser.setFont(this.getFont().deriveFont(0));
                }
                return this;
            }
        });
        scenarioChooser.setSelectedItem(defScenario);
        guiPanel msgPanel = new guiPanel();
        GridBagHelper gb = new GridBagHelper(msgPanel);
        gb.addRow(msg);
        gb.addFilledRow(scenarioChooser);
        gb.finalizeRows();
        int choice = JOptionPane.showConfirmDialog(parent, msgPanel, Intl.intl("Select Scenario"), 2, 3);
        if (choice != 0) {
            return null;
        }
        return scenarioChooser.getSelectedItem();
    }

    public static Optional<Nullable<File>> promptLegacyFile(Component parent, SimOutputDir outDir, Function<SimOutputDir.ResolvedOutputDir, File> getExpectedFile) {
        File currentFile = getExpectedFile.apply(outDir.current);
        if (currentFile.exists()) {
            return Optional.of(Nullable.of(currentFile));
        }
        File existingLegacy = null;
        for (SimOutputDir.ResolvedOutputDir legacyDir : outDir.legacies) {
            File legacyFile = getExpectedFile.apply(legacyDir);
            if (!legacyFile.exists()) continue;
            existingLegacy = legacyFile;
            break;
        }
        if (existingLegacy == null) {
            return Optional.of(Nullable.getNull());
        }
        int legacyChoice = JOptionPane.showConfirmDialog(parent, Intl.intl("Results files were not found in the expected location. However, some existing results were found in a location used by a previous version of Pathfinder. Do you want to show these results?"), Intl.intl("Current Results Not Found"), 0);
        if (legacyChoice == 0) {
            return Optional.of(Nullable.of(existingLegacy));
        }
        return Optional.empty();
    }
}

