/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import javax.swing.Icon;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.SetWorkingGroup;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.gui.NewGroupDlg;
import merlin.gui.guiUtil;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.theUtil;

public class NewGroup
extends AMerlinOp
implements IEventObserver {
    public static final Icon newGroupNodeIcon = guiUtil.loadMerlinIcon("newcomposite16_2.gif", 16);
    public static final UIHook MENU_HOOK = new UIHook((MerlinOp)new NewGroup(false), Intl.intl("New Group Node...,-,Add a new group node"), newGroupNodeIcon);
    public static final UIHook CONTEXT_HOOK = new UIHook(new NewGroup(true), Intl.intl("New Group Node...,-,Add a new group node"));
    private final boolean d_context;
    private static final Predicate<Composite> s_filter = c -> c.canAddGroup();

    public NewGroup(boolean context) {
        this.d_context = context;
        if (this.d_context) {
            SelectionObserver.add(this, Composite.class);
            this.update(null);
        }
    }

    @Override
    public void update(Events events) {
        if (this.d_context) {
            MerlinData md = MerlinApp.getApp().getData();
            this.setEnabled(md.selection.getSelectionCount() == 1 && md.selection.isExclusive(Composite.class) && s_filter.test((Composite)md.selection.getSelected(Composite.class).iterator().next()));
        }
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Composite defRoot = null;
        if (this.d_context) {
            defRoot = (Composite)md.selection.getSelected(Composite.class).iterator().next();
        }
        ArrayList<Composite> roots = new ArrayList<Composite>();
        roots.addAll(theUtil.filter(md.getChildren(), Composite.class, s_filter));
        roots.addAll(theUtil.filter(md.attractorsRoot.getChildren(), Composite.class, s_filter));
        roots.addAll(md.floors.getMembers(Floor.class));
        if (defRoot == null) {
            defRoot = (Composite)roots.iterator().next();
        }
        NewGroup.addNewGroup(app, md, roots, defRoot);
    }

    public static void addNewGroup(MerlinApp app, MerlinData md, Collection<? extends Composite> roots, Composite<?> defRoot) {
        NewGroupDlg<Composite> dlg = new NewGroupDlg<Composite>(app.getMainFrame(), md, roots, defRoot, Composite.class, s_filter, Intl.intl("Group Node"));
        if (dlg.doModal() != 1) {
            return;
        }
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Composite parentGroup = dlg.getParentGroup();
            String newName = dlg.getNewGroupName();
            Composite<?> group = parentGroup.newGroup(newName);
            if (group == null) {
                return;
            }
            Undo.begin(Intl.intl("New Group Node"));
            Undo.insertUndoEntry_deletePreserveIx(md, parentGroup, group, 0);
            parentGroup.insert(Collections.singleton(group), 0);
            if (md.hierarchy.isDescendent(md.activeFloor(), group)) {
                SetWorkingGroup.setWorkingGroup(md, md.activeFloor(), (GeomComposite)group);
            }
            Undo.insertUndoEntry_restoreSelection(md);
            md.selection.set(group);
            Undo.end(md);
        }
    }
}

