/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import common.data.ClientAwareness;
import common.data.SpeedInSmoke;
import common.data.WaitMode;
import common.io.FileUtil;
import inferno.data2.ANode;
import inferno.data2.AnimatedGeom;
import inferno.data2.AttractorSim;
import inferno.data2.Blockage;
import inferno.data2.Camera;
import inferno.data2.IOccFilter;
import inferno.data2.Mesh;
import inferno.data2.MeshBuilder;
import inferno.data2.OccTarget;
import inferno.data2.Occupant;
import inferno.data2.PredefTag;
import inferno.data2.QBaseQueue;
import inferno.data2.QMetaQueue;
import inferno.data2.QPath;
import inferno.data2.QServicePoint;
import inferno.data2.SpeedInSmokeSim;
import inferno.data2.SpeedModifier;
import inferno.data2.Tag;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.data2.ai.AbandonOccTargetsGoal;
import inferno.data2.ai.AssistOccupantsGoal;
import inferno.data2.ai.ChangeBehaviorGoal;
import inferno.data2.ai.ChangeProfileGoal;
import inferno.data2.ai.ChangeTagGoal;
import inferno.data2.ai.CreateAttractorGoal;
import inferno.data2.ai.DestroyAttractorGoal;
import inferno.data2.ai.DetachGoal;
import inferno.data2.ai.DynamicTargetGoal;
import inferno.data2.ai.ExitGoal;
import inferno.data2.ai.FillRoomGoal;
import inferno.data2.ai.IEventTime;
import inferno.data2.ai.IGoal;
import inferno.data2.ai.ITargetPtSupplier;
import inferno.data2.ai.LookAheadGoal;
import inferno.data2.ai.LookAtGoal;
import inferno.data2.ai.OccTargetGoal;
import inferno.data2.ai.PointGoal;
import inferno.data2.ai.QueueGoal;
import inferno.data2.ai.RemoveSelfGoal;
import inferno.data2.ai.RoomGoal;
import inferno.data2.ai.SetOccPropGoal;
import inferno.data2.ai.SetOccPropToProfileGoal;
import inferno.data2.ai.SetTagGoal;
import inferno.data2.ai.WaitForAssistanceGoal;
import inferno.data2.ai.WaitGoal;
import inferno.data2.ai.WaitUntilEndGoal;
import inferno.data2.ai.WaitUntilGoal;
import inferno.elevator.ElevatorGoal;
import inferno.elevator.ElevatorLevel;
import inferno.elevator.ITimeEstimate;
import inferno.geom.Inter;
import inferno.parse2.SimpleParser;
import inferno.sim.BehaviorSim;
import inferno.sim.Engine;
import inferno.sim.EngineOp;
import inferno.sim.IDoorFlowrate;
import inferno.sim.KB;
import inferno.sim.OccAdder;
import inferno.sim.OccGroup;
import inferno.sim.OccGroupType;
import inferno.sim.OccProfileSim;
import inferno.sim.Param;
import inferno.sim.VehicleBody;
import inferno.sim.occsource.IOccSourceFlowrate;
import inferno.sim.occsource.OccSource;
import inferno.sim.path.PathGen;
import java.awt.Color;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.vecmath.Color4f;
import javax.vecmath.Point2d;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.CreateGroupsAction;
import merlin.actions.InfernoGeomBuilder;
import merlin.data.AMerlinObj;
import merlin.data.AssistedEvacTeam;
import merlin.data.IGetJson;
import merlin.data.IMerlinObj;
import merlin.data.ImportedGeom;
import merlin.data.JsonObj;
import merlin.data.MeasurementRegionObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.ObjsFilter;
import merlin.data.OccGroupObj;
import merlin.data.OccGroupTypeObj;
import merlin.data.OccSourceObj;
import merlin.data.PredefTags;
import merlin.data.Proxy;
import merlin.data.SimParams;
import merlin.data.camera.Camera;
import merlin.data.egress.Floor;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.SimError;
import merlin.data.egress.agents.ConstOccCount;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.IAvatar;
import merlin.data.egress.agents.IOccArea;
import merlin.data.egress.agents.IOccCount;
import merlin.data.egress.agents.IProfileProp;
import merlin.data.egress.agents.IProfilePropDist;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.ProfileProps;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.data.egress.agents.ShapeAvatar;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.egress.blockages.EgressBlockage;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorDoor;
import merlin.data.egress.elevators.ElevatorGroup;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.elevators.ElevatorUtil;
import merlin.data.egress.geom.AEgressComp;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressDoorDir;
import merlin.data.egress.geom.EgressStair;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.geom.IEgressFlowrate;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.AbandonOccTargets;
import merlin.data.egress.scripting.AssistOccupants;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.ChangeBehavior;
import merlin.data.egress.scripting.ChangeProfile;
import merlin.data.egress.scripting.ChangeProfileProp;
import merlin.data.egress.scripting.ChangeTags;
import merlin.data.egress.scripting.CreateAttractor;
import merlin.data.egress.scripting.DestroyAttractor;
import merlin.data.egress.scripting.DetachAssistants;
import merlin.data.egress.scripting.GotoCurrentAttractor;
import merlin.data.egress.scripting.GotoElevators;
import merlin.data.egress.scripting.GotoExits;
import merlin.data.egress.scripting.GotoOcc;
import merlin.data.egress.scripting.GotoOccTarget;
import merlin.data.egress.scripting.GotoQueue;
import merlin.data.egress.scripting.GotoRooms;
import merlin.data.egress.scripting.GotoWaypoint;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IWaitAction;
import merlin.data.egress.scripting.IWaitUntilSrc;
import merlin.data.egress.scripting.LookAhead;
import merlin.data.egress.scripting.LookAt;
import merlin.data.egress.scripting.RefugeFilter;
import merlin.data.egress.scripting.RemoveOcc;
import merlin.data.egress.scripting.ResumePrior;
import merlin.data.egress.scripting.RevertProfileProp;
import merlin.data.egress.scripting.Wait;
import merlin.data.egress.scripting.WaitForAssistance;
import merlin.data.egress.scripting.WaitUntil;
import merlin.data.egress.scripting.WaitUntilEnd;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.egress.scripting.queues.QueuePath;
import merlin.data.egress.scripting.queues.QueuePathNode;
import merlin.data.egress.scripting.queues.QueueService;
import merlin.data.material.Material;
import merlin.data.scripting.ScriptObj;
import merlin.data.tag.Tag;
import merlin.data.value.IFunction1d;
import merlin.geom.Geometry;
import merlin.geom.IMerlinDispProps;
import merlin.io.inferno.InfernoGeom;
import merlin.io.inferno.InfernoType;
import merlin.mv.MerlinColors;
import merlin.mv.displays.MerlinDispProps;
import merlin.unitsystem.SIUS;
import merlin.unitsystem.UnitSystem;
import merlin.util.MerlinDepSnapshot;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.IOUtil;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PlanarCoordMapper;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EmptyTaskProgress;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Global;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ITaskProgress;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.MutableInt;
import thunderheadeng.util.Nullable;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.SplitProgress;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.mtproc.MTListProcessor;
import thunderheadeng.util.mtproc.MTProcessor;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;
import thunderheadeng.util.value.DiscreteVariant;
import thunderheadeng.util.value.IVariant;
import thunderheadeng.util.value.VariantUtil;

public class InfernoUtil {
    public static final Unit LENGTH_UNIT = SI.METER;
    public static final Unit TIME_UNIT = SI.SECOND;
    public static final Unit VEL_UNIT = SI.METER.divide(SI.SECOND);
    public static final Unit OCC_DENSITY_UNIT = Unit.ONE.divide(SI.METER.pow(2));
    private static final Logger LOGGER = Logger.getLogger(InfernoUtil.class.getName());
    private static final Class<?>[] REFERENCED_TYPES = new Class[]{Behavior.class, AssistedEvacTeam.class, OccProfile.class};
    private static final double PROJECTED_DIST_TOL = 0.5;

    public static String rootFn(String pthFn) {
        int ixSlash = pthFn.lastIndexOf(92);
        if (ixSlash > -1) {
            pthFn = pthFn.substring(ixSlash + 1);
        }
        while (pthFn.toLowerCase().endsWith(".pth") || pthFn.toLowerCase().endsWith(".txt")) {
            pthFn = pthFn.substring(0, pthFn.length() - 4);
        }
        return pthFn;
    }

    public static Param mkInfernoParam(MerlinApp app, MerlinData md, File dir, String rootFn, String sharedRootFn, File simulationList, int variationCount, boolean debug) {
        SimParams sp = md.simParams;
        Param p = new Param(rootFn, simulationList != null ? simulationList.getAbsolutePath() : "", md.scenarios.getActive().getName(), dir.getAbsolutePath());
        Unit invOccDensityu = SIUS.unit(3);
        p.max_time = sp.get(SimParams.RUNTIME_MAX_FLAG) != false ? sp.get(SimParams.RUNTIME_MAX).getValue(SI.SECOND) : 0.0;
        p.show_vis = sp.get(SimParams.SHOW_RUNTIME_VIS);
        p.reactive_steering = sp.get(SimParams.REACTIVE_STEERING);
        p.inertia = sp.get(SimParams.REACTIVE_STEERING);
        boolean bl = p.vel_from_density = sp.get(SimParams.REACTIVE_STEERING) == false;
        p.specific_flowrate_max = sp.get(SimParams.REACTIVE_STEERING) == false ? 1.32 : (sp.get(SimParams.USE_DOOR_QUEUES) != false ? sp.get(SimParams.SPECIFIC_FLOW_STEERING).getValue(SIUS.unit(12)) : Double.POSITIVE_INFINITY);
        p.door_flow_from_density = sp.get(SimParams.DOOR_FLOW_DENSITY_FLAG);
        p.density_max = sp.get(SimParams.DENSITY_MAX).getValue(invOccDensityu);
        p.handle_collisions = sp.get(SimParams.HANDLE_COLLISIONS);
        p.force_separation = sp.get(SimParams.FORCE_SEPARATION);
        p.boundary_layer = sp.get(SimParams.DOOR_BOUNDARY_LAYER).getValue(SI.METER);
        p.dt_csv_data = sp.get(SimParams.DT_CSV).getValue(SI.SECOND);
        p.dt_init = sp.get(SimParams.DT_SIM).getValue(SI.SECOND);
        p.dt_vis = sp.get(SimParams.DT_VIS).getValue(SI.SECOND);
        p.dt_wall_meta = sp.get(SimParams.DT_STATUS).getValue(SI.SECOND);
        p.dt_snapshot = sp.get(SimParams.DT_SNAPSHOT).getValue(SI.SECOND);
        p.social_distance_csv_output = sp.get(SimParams.WRITE_SOCIAL_DISTANCE);
        p.social_distance_value = sp.get(SimParams.SOCIAL_DISTANCE).get(SI.METER);
        p.min_flowrate_factor = sp.get(SimParams.MIN_FLOWRATE_FACTOR);
        p.imported_geom = FileUtil.getVisFn(dir, sharedRootFn, variationCount).getPath();
        p.views = FileUtil.getViewsFn(dir, sharedRootFn, variationCount).getPath();
        p.max_trim_error = sp.get(SimParams.MAX_TRIM_ERROR).getValue(SI.METER);
        p.show_vis = debug;
        p.low_speed_threshold = sp.get(SimParams.LOW_SPEED_THRESHOLD).getValue(SI.METER.divide(SI.SECOND));
        p.low_speed_averaging_time = sp.get(SimParams.LOW_SPEED_AVERAGING_TIME).getValue(SI.SECOND);
        p.occ_csv_file_as_one = sp.get(SimParams.OCC_CSV_FILE_MERGE);
        p.write_occ_params_file = sp.get(SimParams.WRITE_OCCUPANT_PARAMS_FILE);
        p.measurement_region_seekspeed = sp.get(SimParams.MEASUREMENT_REGION_SEEK_SPEED);
        p.smvDataEnable = sp.get(SimParams.SMV_DATA_ENABLE);
        p.smvDataFilePath = null;
        p.smvDataLastModified = 0L;
        if (sp.get(SimParams.SMV_DATA_ENABLE).booleanValue()) {
            File smvFile = md.filename != null ? IOUtil.resolvePath(sp.get(SimParams.SMV_DATA_FILE_NAME), new File(md.filename), true) : new File(sp.get(SimParams.SMV_DATA_FILE_NAME));
            p.smvDataFilePath = FilenameManager.getRelativeFilename(dir, smvFile, false);
            p.smvDataLastModified = smvFile != null ? smvFile.lastModified() : 0L;
            p.smvHypoxiaLimit = sp.get(SimParams.HYPOXIA_LIMIT).get(Unit.ONE);
        }
        p.attr_default_idle_time = sp.get(SimParams.ATTRACTOR_DEFAULT_IDLE_TIME).get(SI.SECOND);
        p.occtarget_conflict_resolve_time = sp.get(SimParams.OCC_TARGET_CONFLICT_RESOLVE_TIME).get(SI.SECOND);
        p.dynamictarget_search_dt = sp.get(SimParams.DYNAMIC_TARGET_SEARCH_DT).get(SI.SECOND);
        p.enable_json_output = sp.get(SimParams.WRITE_JSON_FILES);
        return p;
    }

    public static KBInfo mkInfernoKB(MerlinData md, Param p, List<SimError> errors, ITaskProgress progress) {
        progress.setMessage(Intl.intl("Preparing simulator"));
        KB kb = new KB(p);
        MerlinDepSnapshot deps = new MerlinDepSnapshot(md, MerlinDepSnapshot.ACTIVE_SCENARIO, new TypeFilter<Object>(REFERENCED_TYPES));
        deps.start(md, md.getChildren());
        progress.check();
        TagGenerator tags = new TagGenerator(kb);
        LinkedIdentityHashMap<IEgressComp, ANode> nodeMap = new LinkedIdentityHashMap<IEgressComp, ANode>();
        HashMap<Elevator, inferno.elevator.Elevator> elevatorMap = new HashMap<Elevator, inferno.elevator.Elevator>();
        HashMap<Floor, Integer> floorIDMap = new HashMap<Floor, Integer>();
        InfernoGeomInfo igeoms = InfernoUtil.buildMesh(progress, md, kb, tags, errors, nodeMap, elevatorMap, floorIDMap);
        progress.check();
        InfernoUtil.addAnimatedGeoms(md, kb);
        progress.check();
        Map<Attractor, Behavior> attractors = InfernoUtil.finalizeAttractors(md);
        Collection<Attractor> attractorList = md.attractorsRoot.flatten(Attractor.class);
        Map<QueueObject, QBaseQueue> qMap = InfernoUtil.addQueueSubUnits(md, kb, errors);
        Collection<QueueObject> qList = md.queues.flatten(QueueObject.class);
        progress.check();
        Map<AssistedEvacTeam, inferno.data2.ai.AssistedEvacTeam> aeTeams = InfernoUtil.addAssistedEvacTeams(md, kb, deps);
        progress.check();
        Map<merlin.data.egress.agents.OccTarget, OccTarget> occTargets = InfernoUtil.addOccTargets(md, kb, errors);
        progress.check();
        LinkedIdentityHashMap<OccGroupObj, OccGroup> occGroups = new LinkedIdentityHashMap<OccGroupObj, OccGroup>();
        LinkedIdentityHashMap<OccGroupObj, OccGroupType> occGroupTypes = new LinkedIdentityHashMap<OccGroupObj, OccGroupType>();
        Map<Behavior, BehaviorSim> behaviorMap = InfernoUtil.addBehaviors(md, deps, kb, errors, tags, attractors);
        progress.check();
        Map<Attractor, AttractorSim> attrMap = InfernoUtil.addAttractors(md, kb, attractors, behaviorMap, nodeMap, tags, errors);
        progress.check();
        Set<OccProfile> profilesInUse = InfernoUtil.getProfilesInUse(md, deps, behaviorMap);
        Set<Behavior> behaviorsInUse = behaviorMap.keySet();
        Collection<EgressAgent> occsInUse = md.agents.flatten(EgressAgent.class, a -> a.isEnabled());
        Map<ObjsFilter<Attractor>, Predicate<AttractorSim>> attrSuscp = InfernoUtil.addAttrRestrictions(md, attrMap, occsInUse, profilesInUse, behaviorsInUse);
        progress.check();
        Map<VehicleShape, VehicleBody> vehicleMap = InfernoUtil.addVehicleBodies(md, kb, profilesInUse, behaviorMap.keySet());
        progress.check();
        Map<OccProfile.CompRestrictions, OccProfileSim.CompRestrictions> compRestrictionsMap = InfernoUtil.addCompRestrictions(md, nodeMap, igeoms, elevatorMap, occsInUse, behaviorsInUse, profilesInUse);
        progress.check();
        Map<OccProfile, OccProfileSim> profMap = InfernoUtil.addProfiles(profilesInUse, md, kb, vehicleMap, compRestrictionsMap, attrSuscp, tags);
        progress.check();
        Map<EgressAgent, Occupant> occMap = InfernoUtil.addOccs(md, kb, nodeMap, occsInUse, errors, vehicleMap, elevatorMap, profMap, behaviorMap, compRestrictionsMap, attrSuscp, tags);
        progress.check();
        InfernoUtil.finishBehaviors(md, kb, errors, tags, behaviorMap, new GoalObjMaps(nodeMap, elevatorMap, floorIDMap, aeTeams, qMap, occTargets, attrMap, vehicleMap, compRestrictionsMap, attrSuscp, behaviorMap, profMap));
        progress.check();
        InfernoUtil.finishAETeams(aeTeams, occMap);
        progress.check();
        InfernoUtil.addOccGroups(md, kb, occGroups, occGroupTypes, profMap, occMap);
        progress.check();
        InfernoUtil.addOccSources(md, kb, profMap, behaviorMap, nodeMap, occGroupTypes);
        progress.check();
        InfernoUtil.addJson(md, kb);
        progress.check();
        tags.commitToKb(kb);
        progress.check();
        return new KBInfo(kb, nodeMap, igeoms, qList, attractorList);
    }

    private static Map<Attractor, Behavior> finalizeAttractors(MerlinData md) {
        LinkedIdentityHashMap<Attractor, Behavior> result = new LinkedIdentityHashMap<Attractor, Behavior>();
        for (Attractor attr2 : md.attractorsRoot.flatten(Attractor.class, attr -> attr.isEnabled() || attr.isTemplate())) {
            Behavior behavior = attr2.get(Attractor.BEHAVIOR);
            if (behavior == Attractor.WAIT_AT_ATTRACTOR_BEHAVIOR) {
                behavior = new Behavior(String.format(Intl.intl("Goto %s"), attr2.getName()));
                behavior.add(new GotoCurrentAttractor(null, attr2.get(Attractor.WAIT_RADIUS), GotoCurrentAttractor.TargetUnreachable.WAIT));
                behavior.add(new Wait(attr2.get(Attractor.WAIT_TIME)));
            }
            result.put(attr2, behavior);
        }
        return result;
    }

    private static TriPoint findMeshLoc(KB kb, Consumer<? super SimError> errors, IMerlinObj sourceObj, String objectTypeName, String objectName, Point3d location) {
        Tri tri = kb.getMesh().getTri(location);
        if (tri != null) {
            return new TriPoint(tri, location);
        }
        TriPoint result = kb.getMesh().projectToMesh(Util3D.add(location, (Tuple3d)new Vector3d(0.0, 0.0, 0.125)));
        if (result == null) {
            errors.accept(new SimError(SimError.Level.MODERATE, String.format(Intl.intl("The %1$s, \"%2$s\", could not be found on the navigation mesh at %3$s."), objectTypeName, objectName, InfernoUtil.format(location, 1)), String.format(Intl.intl("Adjust the location of the %s or ignore to exclude the object from the simulation."), objectTypeName), sourceObj));
            return null;
        }
        if (result.p.distanceSquared(location) > 0.25) {
            errors.accept(new SimError(SimError.Level.MODERATE, String.format(Intl.intl("The location for \"%1$s\" was adjusted %2$.1f m to %3$s."), MerlinUtil.getName(sourceObj), result.p.distance(location), InfernoUtil.format(result.p, 1)), Intl.intl("Check that the adjusted location makes sense."), sourceObj));
        }
        return result;
    }

    private static Map<Attractor, AttractorSim> addAttractors(MerlinData md, KB kb, Map<Attractor, Behavior> attractors, Map<Behavior, BehaviorSim> behaviors, Map<IEgressComp, ANode> nodeMap, TagGenerator tags, List<SimError> errors) {
        LinkedIdentityHashMap<Attractor, AttractorSim> result = new LinkedIdentityHashMap<Attractor, AttractorSim>();
        for (Map.Entry<Attractor, Behavior> attrEntry : attractors.entrySet()) {
            Attractor attr = attrEntry.getKey();
            TriPoint tloc = null;
            if (attr.requiresLocation()) {
                Point3d location = attr.get(Attractor.LOCATION);
                tloc = InfernoUtil.findMeshLoc(kb, errors::add, attr, Intl.intl("Trigger"), attr.getName(), location);
                if (tloc == null) continue;
            }
            Set<ANode> rooms = Collections.emptySet();
            if (attr.get(Attractor.AWARENESS) == Attractor.Awareness.ROOMS) {
                rooms = new LinkedIdentityHashSet();
                for (IEgressOccupiable room : attr.get(Attractor.ROOMS)) {
                    ANode node;
                    if (!room.isEnabled() || (node = nodeMap.get(room)) == null) continue;
                    rooms.add(node);
                }
                if (rooms.isEmpty()) continue;
            }
            BehaviorSim behavior = behaviors.get(attrEntry.getValue());
            assert (behavior != null);
            AttractorSim.PlaceType type = AttractorSim.PlaceType.values()[attr.get(Attractor.TYPE).ordinal()];
            AttractorSim.Awareness awareness = AttractorSim.Awareness.values()[attr.get(Attractor.AWARENESS).ordinal()];
            AttractorSim.InfluenceFrom influenceFrom = AttractorSim.InfluenceFrom.values()[attr.get(Attractor.ATTR_INFLUENCE_FROM).ordinal()];
            IVariant<UnitDouble> influence = attr.get(Attractor.ATTR_INFLUENCE);
            List<Pair<Double, Double>> influenceCurve = influence.getDiscreteValues(true).stream().map(entry -> new Pair<Double, Double>(entry.t.getValue(SI.SECOND), ((UnitDouble)entry.val).getValue(Unit.ONE))).collect(Collectors.toList());
            ObjsFilter<inferno.data2.Tag> tagFilter = attr.get(Attractor.OCC_TAG_FILTER).mapTo(tagName -> tags.getTag((Tag)tagName));
            Predicate<Occupant> occFilter = InfernoUtil.filterOccsByTag(tagFilter);
            AttractorSim attrSim = new AttractorSim(new AttractorSim.Props(attr.getResultsId(), attr.getName(), type, attr.get(Attractor.RANK), behavior, attr.get(Attractor.REQUIRES_COMPLETION), awareness, attr.get(Attractor.AWARENESS_COUNT), attr.get(Attractor.AWARENESS_TIME).get(SI.SECOND), attr.get(Attractor.REMEMBER_OUTSIDE_AWARENESS), attr.get(Attractor.INFLUENCE_RADIUS).get(Geometry.LENGTH_UNIT), influence.getInitialValue().getValue(Unit.ONE), influenceCurve, influenceFrom, attr.get(Attractor.IGNORE_OCC_SUSC), rooms, attr.get(Attractor.OCC_REACT_TIME).toSim(), occFilter), tloc);
            kb.addAttractor(attrSim);
            result.put(attr, attrSim);
        }
        return result;
    }

    private static Predicate<Occupant> filterOccsByTag(ObjsFilter<inferno.data2.Tag> tagFilter) {
        switch (tagFilter.mode) {
            case ALL: {
                return Predicates.alwaysTrue();
            }
            case NONE: {
                return Predicates.alwaysFalse();
            }
            case FROM_LIST: {
                IOccFilter.ByTag.Logic logic = tagFilter.rejected ? IOccFilter.ByTag.Logic.NONE : IOccFilter.ByTag.Logic.ANY;
                return new IOccFilter.ByTag(logic, tagFilter.objects);
            }
        }
        assert (false);
        return Predicates.alwaysTrue();
    }

    private static Map<merlin.data.egress.agents.OccTarget, OccTarget> addOccTargets(MerlinData md, KB kb, List<SimError> errors) {
        int locid = 0;
        LinkedIdentityHashMap<merlin.data.egress.agents.OccTarget, OccTarget> result = new LinkedIdentityHashMap<merlin.data.egress.agents.OccTarget, OccTarget>();
        for (merlin.data.egress.agents.OccTarget target : md.occTargets.flatten(merlin.data.egress.agents.OccTarget.class, merlin.data.egress.agents.OccTarget::isEnabled)) {
            Point3d location = target.get(merlin.data.egress.agents.OccTarget.LOCATION);
            TriPoint meshLoc = InfernoUtil.findMeshLoc(kb, errors::add, target, Intl.intl("Occupant Target"), target.getName(), location);
            if (meshLoc == null) continue;
            UnitDouble angle = target.get(merlin.data.egress.agents.OccTarget.ORIENT);
            Vector3d orient = angle != null ? Util3D.rotate(GeomConstants.VEC3D_XPOS, GeomConstants.VEC3D_ZPOS, angle.get(Geometry.ANGLE_UNIT)) : null;
            OccTarget targetSim = new OccTarget(locid++, target.getName(), meshLoc, orient, target.get(merlin.data.egress.agents.OccTarget.PRIORITY));
            kb.getOccTargets().add(targetSim);
            result.put(target, targetSim);
        }
        kb.getOccTargets().initTargets();
        return result;
    }

    private static Set<OccProfile> getProfilesInUse(MerlinData md, MerlinDepSnapshot deps, Map<Behavior, BehaviorSim> behaviorMap) {
        LinkedHashSet<OccProfile> inUseProfs = new LinkedHashSet<OccProfile>();
        deps.getObjReferences(IMerlinObj.class, OccProfile.class, Filters.acceptAll(), (source, link, target) -> {
            if (!(source instanceof EgressAgent && !((EgressAgent)source).isEnabled() || source instanceof OccSourceObj && !((OccSourceObj)source).isEnabled())) {
                inUseProfs.add((OccProfile)target);
            }
        });
        for (Behavior behavior : behaviorMap.keySet()) {
            Collection<ChangeProfile> changeProfileActions = behavior.flatten(ChangeProfile.class);
            changeProfileActions.forEach(a -> inUseProfs.addAll(a.getAllTargetProfiles()));
        }
        return inUseProfs;
    }

    private static MerlinDispProps getDisplayProps(MerlinData md) {
        MerlinDispProps props = new MerlinDispProps(md, new MerlinColors(), Predicates.alwaysFalse());
        props.setColorRoomsBy(MerlinDispProps.ColorRoomsBy.SET_COLOR);
        props.setColorOccTargetsBy(MerlinDispProps.ColorOccTargetsBy.DEFAULT);
        props.setDoorDrawOptions(-1, false);
        props.setStairDrawOptions(-1, false);
        return props;
    }

    private static InfernoGeomInfo buildMesh(ITaskProgress progress, MerlinData md, KB kb, TagGenerator tags, List<SimError> errors, Map<IEgressComp, ANode> nodeMap, Map<Elevator, inferno.elevator.Elevator> elevatorMap, Map<Floor, Integer> floorIDMap) {
        try (SplitProgress sprog = progress.split(9);){
            MerlinDispProps dispProps = InfernoUtil.getDisplayProps(md);
            InfernoGeomInfo infernoGeom = InfernoUtil.collectInfernoGeom(sprog, dispProps, InfernoUtil.collectEnabledComps(md));
            sprog.incrementParent();
            List<InfernoGeom> igeoms = infernoGeom.igeoms;
            nodeMap.putAll(InfernoUtil.mkNodeMap(sprog, md, igeoms));
            sprog.incrementParent();
            Map<IMaterial, inferno.data2.Material> matMap = InfernoUtil.mkMatMap(sprog, md, kb, igeoms);
            sprog.incrementParent();
            InfernoUtil.addNodes(sprog, md, kb, infernoGeom, nodeMap, matMap, tags);
            sprog.incrementParent();
            HashMap<Camera, Integer> camIdMap = new HashMap<Camera, Integer>();
            InfernoUtil.addSecurityCameras(md, kb, camIdMap);
            sprog.incrementParent();
            InfernoGeomBuilder[] meshes = InfernoUtil.constructMeshes(sprog, md, igeoms, errors);
            sprog.incrementParent();
            Mesh mesh = InfernoUtil.createInfernoMesh(sprog, kb, igeoms, dispProps, nodeMap, matMap, meshes[0], errors);
            sprog.incrementParent();
            kb.setMesh(mesh);
            InfernoUtil.addElevators(sprog, md, kb, nodeMap, elevatorMap, floorIDMap);
            sprog.incrementParent();
            sprog.setMessage(Intl.intl("Initializing triangle connections"));
            kb.getElevatorModel().initTriSearchConnections(mesh.getTris());
            sprog.incrementParent();
            InfernoGeomInfo infernoGeomInfo = infernoGeom;
            return infernoGeomInfo;
        }
    }

    private static Map<OccProfile.CompRestrictions, OccProfileSim.CompRestrictions> addCompRestrictions(MerlinData md, Map<IEgressComp, ANode> nodeMap, InfernoGeomInfo igeoms, Map<Elevator, inferno.elevator.Elevator> elevatorMap, Collection<EgressAgent> occsInUse, Collection<Behavior> behaviorsInUse, Collection<OccProfile> profilesInUse) {
        LinkedIdentityHashMap<OccProfile.CompRestrictions, OccProfileSim.CompRestrictions> map = new LinkedIdentityHashMap<OccProfile.CompRestrictions, OccProfileSim.CompRestrictions>();
        Function<OccProfile.CompRestrictions, OccProfileSim.CompRestrictions> mapRestrictions = merlinComps -> {
            LinkedHashSet<ANode> restrictedNodes = new LinkedHashSet<ANode>();
            Predicate<IMerlinObj> filter = comp -> igeoms.finalComps.containsKey(comp) || comp instanceof Elevator && ((Elevator)comp).isEnabled();
            IFilteredCollection<IMerlinObj> rejectedComps = theUtil.filter(merlinComps.getAllRejected(md), filter);
            LinkedIdentityHashSet acceptedComps = new LinkedIdentityHashSet(theUtil.flatMap(theUtil.filter(merlinComps.getAllAccepted(md), filter), obj -> {
                List<InfernoGeom> objIGeoms = igeoms.finalComps.get(obj);
                if (objIGeoms == null) {
                    return Collections.singletonList(obj);
                }
                return theUtil.map(objIGeoms, igeom -> igeom.source);
            }));
            boolean reject = rejectedComps.size() <= acceptedComps.size();
            Set<IMerlinObj> comps = reject ? rejectedComps : acceptedComps;
            for (Object e : comps) {
                if (e instanceof Elevator) {
                    inferno.elevator.Elevator elevator = (inferno.elevator.Elevator)elevatorMap.get(e);
                    for (ElevatorLevel level : elevator.getLevels()) {
                        restrictedNodes.add(level.pickupNode);
                    }
                    continue;
                }
                ANode node = (ANode)nodeMap.get(e);
                if (node == null) continue;
                restrictedNodes.add(node);
            }
            return new OccProfileSim.CompRestrictions(restrictedNodes, reject, OccProfile.CompRestrictions.Mode.FROM_BEHAVIOR.equals((Object)merlinComps.getTypeInfo((OccProfile.CompRestrictions.Type)OccProfile.CompRestrictions.Type.ELEVATOR).mode));
        };
        Consumer<OccProfile.CompRestrictions> add = cr -> map.computeIfAbsent((OccProfile.CompRestrictions)cr, mapRestrictions);
        for (OccProfile prof : profilesInUse) {
            add.accept(prof.get(OccProfile.PROP_RESTRICTED_COMPONENTS));
        }
        for (EgressAgent a : occsInUse) {
            EgressAgent.AgentValue rcompsVal = a.getStoredProfileVal(OccProfile.PROP_RESTRICTED_COMPONENTS);
            if (!rcompsVal.isLocal()) continue;
            add.accept((OccProfile.CompRestrictions)rcompsVal.value());
        }
        for (ChangeProfileProp changeProp : MerlinUtil.flatten(behaviorsInUse, ChangeProfileProp.class)) {
            IProfileProp<?, ?> prop = changeProp.getProp();
            if (prop != OccProfile.PROP_RESTRICTED_COMPONENTS) continue;
            add.accept(changeProp.get(OccProfile.PROP_RESTRICTED_COMPONENTS));
        }
        return map;
    }

    private static Map<ObjsFilter<Attractor>, Predicate<AttractorSim>> addAttrRestrictions(MerlinData md, Map<Attractor, AttractorSim> attrMap, Collection<EgressAgent> occsInUse, Collection<OccProfile> profilesInUse, Collection<Behavior> behaviorsInUse) {
        LinkedHashMap<ObjsFilter<Attractor>, Predicate<AttractorSim>> map = new LinkedHashMap<ObjsFilter<Attractor>, Predicate<AttractorSim>>();
        Function<ObjsFilter, Predicate> mapRestrictions = restr -> {
            ObjsFilter<AttractorSim> restrSim = restr.mapTo(attrMap::get);
            return restrSim.getFilter();
        };
        Consumer<ObjsFilter> mapFilter = filter -> map.computeIfAbsent((ObjsFilter<Attractor>)filter, (Function<ObjsFilter<Attractor>, Predicate<AttractorSim>>)mapRestrictions);
        Consumer<OccProfile> mapProfile = prof -> mapFilter.accept(prof.get(OccProfile.PROP_ATTRACTOR_RESTRICTIONS));
        for (OccProfile prof2 : profilesInUse) {
            mapProfile.accept(prof2);
        }
        for (EgressAgent a : occsInUse) {
            OccProfile prof3 = a.getProfile();
            if (!prof3.isDefinedLocally(OccProfile.PROP_ATTRACTOR_RESTRICTIONS)) continue;
            mapProfile.accept(prof3);
        }
        for (Behavior behavior : behaviorsInUse) {
            for (ChangeProfileProp change : behavior.flatten(ChangeProfileProp.class)) {
                if (change.getProp() != OccProfile.PROP_ATTRACTOR_RESTRICTIONS) continue;
                ObjsFilter<Attractor> filter2 = change.get(OccProfile.PROP_ATTRACTOR_RESTRICTIONS);
                mapFilter.accept(filter2);
            }
        }
        return map;
    }

    private static Map<Behavior, BehaviorSim> addBehaviors(MerlinData md, MerlinDepSnapshot deps, KB kb, List<SimError> errors, TagGenerator tags, Map<Attractor, Behavior> attractors) {
        LinkedHashSet<Behavior> usedBehaviors = new LinkedHashSet<Behavior>();
        deps.getObjReferences(IMerlinObj.class, Behavior.class, Predicates.alwaysTrue(), (source, link, target) -> {
            if (!(source instanceof EgressAgent && !((EgressAgent)source).isEnabled() || source instanceof OccSourceObj && !((OccSourceObj)source).isEnabled())) {
                usedBehaviors.add((Behavior)target);
            }
        });
        usedBehaviors.addAll(attractors.values());
        LinkedHashSet allUsedBehaviors = new LinkedHashSet(usedBehaviors);
        usedBehaviors.forEach(b -> b.getReferencedBehaviors(allUsedBehaviors));
        LinkedIdentityHashMap<Behavior, BehaviorSim> result = new LinkedIdentityHashMap<Behavior, BehaviorSim>();
        Consumer<Behavior> createBehavior = behavior -> result.put((Behavior)behavior, new BehaviorSim(behavior.getName(), behavior.getColor(), Collections.emptyList()));
        allUsedBehaviors.forEach(createBehavior::accept);
        return result;
    }

    private static void finishBehaviors(MerlinData md, KB kb, List<SimError> errors, TagGenerator tags, Map<Behavior, BehaviorSim> behaviors, GoalObjMaps maps) {
        GoalBuilder goals = new GoalBuilder();
        for (Map.Entry<Behavior, BehaviorSim> entry : behaviors.entrySet()) {
            List<IGoal> goalList = InfernoUtil.generateGoals(md, kb, errors, tags, entry.getKey(), goals, maps);
            goalList = Collections.unmodifiableList(goalList);
            entry.getValue().initGoals(goalList);
        }
    }

    private static Map<OccProfile, OccProfileSim> addProfiles(Set<OccProfile> inUseProfs, MerlinData md, KB kb, Map<VehicleShape, VehicleBody> vehicleMap, Map<OccProfile.CompRestrictions, OccProfileSim.CompRestrictions> compRestrictionsMap, Map<ObjsFilter<Attractor>, Predicate<AttractorSim>> attrRestrMap, TagGenerator tags) {
        LinkedIdentityHashMap<OccProfile, OccProfileSim> profMap = new LinkedIdentityHashMap<OccProfile, OccProfileSim>();
        OccProfile advancedOverride = InfernoUtil.getAdvancedOverrideProfile(md);
        for (OccProfile prof : inUseProfs) {
            advancedOverride.setProfParent(prof);
            OccProfileSim simProf = InfernoUtil.convertProfile(md, advancedOverride, vehicleMap, compRestrictionsMap, attrRestrMap, tags);
            profMap.put(prof, simProf);
        }
        return profMap;
    }

    private static OccProfile getAdvancedOverrideProfile(MerlinData md) {
        OccProfile tempParent = new OccProfile();
        OccProfile advancedOverride = new OccProfile(tempParent);
        if (!md.simParams.get(SimParams.REACTIVE_STEERING).booleanValue() && !md.simParams.get(SimParams.USE_PROFILE_FUNDAMENTAL).booleanValue()) {
            advancedOverride.set(OccProfile.PROP_FUNDAMENTAL, OccProfile.getSFPEFundamentalCurve(md.simParams.get(SimParams.MIN_SFPE_VELOCITY_FRACTION)));
        }
        if (!md.simParams.get(SimParams.REACTIVE_STEERING).booleanValue() && !md.simParams.get(SimParams.USE_ADVANCED_PROFILE_SPEEDS).booleanValue()) {
            InfernoUtil.setToDefault(advancedOverride, OccProfile.PROP_RAMP_SPEED_DOWN);
            InfernoUtil.setToDefault(advancedOverride, OccProfile.PROP_RAMP_SPEED_UP);
            InfernoUtil.setToDefault(advancedOverride, OccProfile.PROP_RAMP_FUNDAMENTAL_DOWN);
            InfernoUtil.setToDefault(advancedOverride, OccProfile.PROP_RAMP_FUNDAMENTAL_UP);
            InfernoUtil.setToDefault(advancedOverride, OccProfile.PROP_STAIR_SPEED_DOWN);
            InfernoUtil.setToDefault(advancedOverride, OccProfile.PROP_STAIR_SPEED_UP);
            InfernoUtil.setToDefault(advancedOverride, OccProfile.PROP_STAIR_FUNDAMENTAL_DOWN);
            InfernoUtil.setToDefault(advancedOverride, OccProfile.PROP_STAIR_FUNDAMENTAL_UP);
        }
        return advancedOverride;
    }

    private static Map<AssistedEvacTeam, inferno.data2.ai.AssistedEvacTeam> addAssistedEvacTeams(MerlinData md, KB kb, MerlinDepSnapshot deps) {
        Set<AssistedEvacTeam> usedTeams = deps.getTargets(IMerlinObj.class, Filters.acceptAll(), AssistedEvacTeam.class, Filters.acceptAll());
        LinkedIdentityHashMap<AssistedEvacTeam, inferno.data2.ai.AssistedEvacTeam> result = new LinkedIdentityHashMap<AssistedEvacTeam, inferno.data2.ai.AssistedEvacTeam>();
        int ix = 0;
        for (AssistedEvacTeam team : usedTeams) {
            List<Integer> occIDs = Collections.emptyList();
            String teamName = team.getName();
            inferno.data2.ai.AssistedEvacTeam iteam = new inferno.data2.ai.AssistedEvacTeam(teamName, occIDs, ix++);
            result.put(team, iteam);
        }
        kb.setAssistedEvacTeams(result.values());
        return result;
    }

    private static void finishAETeams(Map<AssistedEvacTeam, inferno.data2.ai.AssistedEvacTeam> teams, Map<EgressAgent, Occupant> occMap) {
        for (Map.Entry<AssistedEvacTeam, inferno.data2.ai.AssistedEvacTeam> entry : teams.entrySet()) {
            List<EgressAgent> assistOrder = entry.getKey().get(AssistedEvacTeam.PROP_OCC_ASSIST_ORDER);
            ArrayList<Integer> occIDs = new ArrayList<Integer>();
            assistOrder.forEach(a -> {
                if (a.isEnabled()) {
                    occIDs.add(((Occupant)occMap.get((Object)a)).id);
                }
            });
            entry.getValue().setAssistOrder(occIDs);
        }
    }

    private static void addOccGroups(MerlinData md, KB kb, Map<OccGroupObj, OccGroup> occGroups, Map<OccGroupObj, OccGroupType> occGroupTypes, Map<OccProfile, OccProfileSim> profMap, Map<EgressAgent, Occupant> occMap) {
        int[] groupIDs = new int[]{0, 0};
        Consumer<OccGroupObj> processGroup = group -> {
            double maxDistance = group.get(OccGroupObj.PROP_MAX_DISTANCE).get(LENGTH_UNIT);
            double slowdownTime = group.get(OccGroupObj.PROP_SLOWDOWN_TIME).get(SI.SECOND);
            boolean requiresLeader = group.get(OccGroupObj.PROP_REQUIRES_GROUP_LEADER);
            boolean respectSocialDist = group.get(OccGroupObj.PROP_SOCIAL_DIST_IN_GROUP);
            Collection<Proxy> proxies = group.flatten(Proxy.class);
            ArrayList<Occupant> members = new ArrayList<Occupant>();
            for (Proxy proxy : proxies) {
                Object obj;
                PropValue<Boolean> enabled = proxy.getWithDetails(MerlinData.ENABLED);
                if (!enabled.asOption().orElse(false).booleanValue() || !((obj = proxy.getObj()) instanceof EgressAgent) || !((EgressAgent)obj).isEnabled()) continue;
                members.add((Occupant)occMap.get(obj));
            }
            if (group instanceof OccGroupTypeObj) {
                ICurve minNumMembers = group.get(OccGroupTypeObj.PROP_MIN_NUMBER_OF_MEMBERS);
                ICurve prefNumMembers = group.get(OccGroupTypeObj.PROP_PREF_NUMBER_OF_MEMBERS);
                boolean allowSmallerGroups = group.get(OccGroupTypeObj.PROP_ALLOW_SMALLER_GROUPS);
                boolean useExactCalc = group.get(OccGroupTypeObj.PROP_USE_EXACT_DIST_CALCULATION);
                double heightMultiplier = group.get(OccGroupTypeObj.PROP_HEIGHT_MULTIPLIER).getValue(Unit.ONE);
                LinkedHashMap<OccProfileSim, OccGroupType.GroupCreationData> infernoProfMap = null;
                OccProfileSim leaderProfile = null;
                if (group.get(OccGroupTypeObj.PROP_SPECIFY_PROFILES).booleanValue()) {
                    Map<OccProfile, OccGroupTypeObj.GroupCreationDataObj> merlinProfMap = group.get(OccGroupTypeObj.PROP_PROFILE_DATA);
                    infernoProfMap = new LinkedHashMap<OccProfileSim, OccGroupType.GroupCreationData>();
                    for (Map.Entry<OccProfile, OccGroupTypeObj.GroupCreationDataObj> entry : merlinProfMap.entrySet()) {
                        OccProfile prof = entry.getKey();
                        OccGroupTypeObj.GroupCreationDataObj merlinGroupData = entry.getValue();
                        if (!(merlinGroupData.prefNumberOfMembers != null && merlinGroupData.prefNumberOfMembers.getMax().get(Unit.ONE) > 0.0) && (merlinGroupData.minNumberOfMembers == null || !(merlinGroupData.minNumberOfMembers.getMax().get(Unit.ONE) > 0.0))) continue;
                        infernoProfMap.put((OccProfileSim)profMap.get(prof), new OccGroupType.GroupCreationData(merlinGroupData.prefNumberOfMembers, merlinGroupData.allowSmallerGroups, merlinGroupData.minNumberOfMembers));
                    }
                    OccProfile leaderProf = group.get(OccGroupTypeObj.PROP_LEADER_PROFILE);
                    if (leaderProf != null) {
                        leaderProfile = (OccProfileSim)profMap.get(leaderProf);
                    }
                }
                Color c = group.get(OccGroupObj.PROP_COLOR);
                int n = groupIDs[1];
                groupIDs[1] = n + 1;
                OccGroupType groupType = new OccGroupType(n, group.getName(), maxDistance, slowdownTime, requiresLeader, minNumMembers, prefNumMembers, allowSmallerGroups, useExactCalc, heightMultiplier, group.get(OccGroupTypeObj.PROP_SPECIFY_PROFILES), infernoProfMap, leaderProfile, false, c, group == md.occGroupTypes.NO_GROUP_TYPE, respectSocialDist);
                occGroupTypes.put((OccGroupObj)group, groupType);
            } else {
                if (members.isEmpty()) {
                    return;
                }
                Color c = group.get(OccGroupObj.PROP_COLOR);
                Color tc = group.get(OccGroupObj.PROP_TEMPLATE_COLOR);
                int n = groupIDs[0];
                groupIDs[0] = n + 1;
                OccGroup igroup = new OccGroup(n, group.getName(), maxDistance, slowdownTime, requiresLeader, respectSocialDist, c, tc);
                for (Occupant occ : members) {
                    igroup.addOccOnInit(occ);
                }
                if (requiresLeader) {
                    EgressAgent leader = group.get(OccGroupObj.PROP_GROUP_LEADER);
                    igroup.addLeaderOnInit((Occupant)occMap.get(leader));
                }
                occGroups.put((OccGroupObj)group, igroup);
            }
        };
        for (OccGroupObj occGroupObj : md.occGroups.flatten(OccGroupObj.class)) {
            processGroup.accept(occGroupObj);
        }
        for (OccGroupObj occGroupObj : md.occGroupTypes.flatten(OccGroupTypeObj.class)) {
            processGroup.accept(occGroupObj);
        }
        processGroup.accept(md.occGroupTypes.NO_GROUP_TYPE);
        kb.addOccupantGroups(occGroups.values());
    }

    private static void addOccSources(MerlinData md, KB kb, Map<OccProfile, OccProfileSim> profMap, Map<Behavior, BehaviorSim> behaviorMap, Map<IEgressComp, ANode> nodeMap, Map<OccGroupObj, OccGroupType> occGroupTypesMap) {
        LinkedIdentityHashSet usedGroupTypes = new LinkedIdentityHashSet();
        for (OccSourceObj merlinOccSource : md.occSources.flatten(OccSourceObj.class)) {
            if (!merlinOccSource.isEnabled()) continue;
            long sourceSeed = merlinOccSource.getSeed();
            IOccSourceFlowrate flowRate = merlinOccSource.get(OccSourceObj.PROP_FLOW_RATE).toInfernoOccSourceFlowrate(sourceSeed);
            boolean enforceFlowrate = merlinOccSource.get(OccSourceObj.PROP_ENFORCE_FLOWRATE).getValue(new Random());
            boolean emitMaxVel = merlinOccSource.get(OccSourceObj.PROP_EMIT_AT_MAX_VEL).getValue(new Random());
            ICurve initialOrient = merlinOccSource.isOccProfilePropOverridden(OccProfile.PROP_INIT_ORIENT) ? merlinOccSource.getProfileValue(OccProfile.PROP_INIT_ORIENT) : null;
            IUrn<OccProfile> profUrn = merlinOccSource.get(OccSourceObj.PROP_PROFILE_DIST);
            Map<OccProfile, Double> profWeights = profUrn.getWeights();
            LinkedIdentityHashMap<OccProfileSim, Double> simProfWeights = new LinkedIdentityHashMap<OccProfileSim, Double>();
            for (OccProfile prof : profWeights.keySet()) {
                simProfWeights.put(profMap.get(prof), profWeights.get(prof));
            }
            IUrn<Behavior> behaviorUrn = merlinOccSource.get(OccSourceObj.PROP_BEHAVIOR_DIST);
            Map<Behavior, Double> behaviorWeights = behaviorUrn.getWeights();
            LinkedIdentityHashMap<BehaviorSim, Double> simBehaviorWeights = new LinkedIdentityHashMap<BehaviorSim, Double>();
            for (Behavior behavior : behaviorWeights.keySet()) {
                simBehaviorWeights.put(behaviorMap.get(behavior), behaviorWeights.get(behavior));
            }
            LinkedIdentityHashMap<OccGroupType, Double> simGroupTemplateWeights = null;
            IUrn<OccGroupTypeObj> groupTemplateUrn = merlinOccSource.get(OccSourceObj.PROP_GROUP_TEMPLATE_DIST);
            Map<OccGroupTypeObj, Double> groupTemplateWeights = groupTemplateUrn.getWeights();
            simGroupTemplateWeights = new LinkedIdentityHashMap<OccGroupType, Double>();
            for (OccGroupTypeObj groupTemplate : groupTemplateWeights.keySet()) {
                simGroupTemplateWeights.put(occGroupTypesMap.get(groupTemplate), groupTemplateWeights.get(groupTemplate));
                usedGroupTypes.add(occGroupTypesMap.get(groupTemplate));
            }
            IEgressComp component = merlinOccSource.get(OccSourceObj.PROP_COMPONENT);
            ANode comp = null;
            if (component != null) {
                comp = nodeMap.get(component);
            }
            List<Point3d> spawnLocs = merlinOccSource.get(OccSourceObj.PROP_SPAWN_LOCS);
            OccSource occSource = new OccSource(kb, merlinOccSource.getName(), merlinOccSource.getBounds(), flowRate, UrnUtil.newUrn(simProfWeights), UrnUtil.newUrn(simBehaviorWeights), sourceSeed, enforceFlowrate, initialOrient, emitMaxVel, comp, simGroupTemplateWeights != null ? UrnUtil.newUrn(simGroupTemplateWeights) : null, spawnLocs);
            kb.addOccSource(occSource);
        }
        ArrayList<OccGroupType> usedGroupTypesList = new ArrayList<OccGroupType>(usedGroupTypes);
        Collections.sort(usedGroupTypesList, (g1, g2) -> g1.getID() - g2.getID());
        kb.setOccupantGroupTypes(usedGroupTypesList);
    }

    private static void addJson(MerlinData md, KB kb) {
        ArrayList<AMerlinObj> stuffToWriteAsJson = new ArrayList<AMerlinObj>();
        stuffToWriteAsJson.addAll(md.json.flatten(JsonObj.class));
        stuffToWriteAsJson.addAll(md.regions.flatten(MeasurementRegionObj.class, r -> r.isEnabled()));
        stuffToWriteAsJson.addAll(md.customScripts.flatten(ScriptObj.class));
        for (IGetJson iGetJson : stuffToWriteAsJson) {
            String str = iGetJson.getJson();
            try {
                SimpleParser.parseJSON(kb, str);
            }
            catch (Throwable e) {
                String name = iGetJson.getClass().getName();
                LOGGER.log(Level.SEVERE, "Error adding JSON object type=" + name);
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    private static Map<QueueObject, QBaseQueue> addQueueSubUnits(MerlinData md, KB kb, List<SimError> errors) {
        LinkedHashMap<QueueObject, QBaseQueue> qMap = new LinkedHashMap<QueueObject, QBaseQueue>();
        for (QueueObject qo : md.queues.flatten(QueueObject.class)) {
            ArrayList<QServicePoint> infernoServs = new ArrayList<QServicePoint>();
            Collection<QueueService> services = qo.flatten(QueueService.class);
            for (QueueService queueService : services) {
                QServicePoint servSim = InfernoUtil.convertQueueService(queueService, kb, errors::add);
                if (servSim == null) continue;
                infernoServs.add(servSim);
            }
            if (infernoServs.isEmpty() && !services.isEmpty()) {
                errors.add(new SimError(SimError.Level.MODERATE, String.format(Intl.intl("Could not find a location for any services in %s."), qo.getName()), Intl.intl("Adjust the locations of the services."), qo));
            }
            ArrayList<QPath> infernoPaths = new ArrayList<QPath>();
            for (QueuePath path : qo.flatten(QueuePath.class)) {
                QPath simPath = InfernoUtil.convertQueuePath(path, kb, errors);
                if (simPath == null) continue;
                infernoPaths.add(simPath);
            }
            QBaseQueue qBaseQueue = new QBaseQueue(qo.getName(), qo.getColor() != null ? qo.getColor() : MerlinDispProps.QUEUE_COLOR, qo.getRestrictedProfiles_Strings(), infernoServs, infernoPaths, null, QMetaQueue.QBalancingType.TIME, null);
            qBaseQueue.setResultsID(qo.getResultsId());
            qMap.put(qo, qBaseQueue);
            kb.addBaseQueue(qBaseQueue);
        }
        return qMap;
    }

    private static QServicePoint convertQueueService(QueueService service, KB kb, Consumer<SimError> errors) {
        Point3d serviceP3d = service.getLocation();
        TriPoint serviceTri = InfernoUtil.findMeshLoc(kb, errors, service, Intl.intl("Queue Service"), service.getName(), serviceP3d);
        if (serviceTri == null) {
            return null;
        }
        return new QServicePoint(service.getName(), serviceTri, service.getServiceTime());
    }

    private static QPath convertQueuePath(QueuePath path, KB kb, List<SimError> errors) {
        ArrayList<TriPoint> nodes = new ArrayList<TriPoint>();
        ArrayList<String> pointNames = new ArrayList<String>();
        for (QueuePathNode node : path.getMembers(QueuePathNode.class)) {
            Point3d loc = node.getLocation();
            TriPoint meshLoc = InfernoUtil.findMeshLoc(kb, errors::add, node, Intl.intl("Path point"), Integer.toString(nodes.size() + 1), loc);
            if (meshLoc == null) continue;
            nodes.add(meshLoc);
            pointNames.add(node.getName());
        }
        if (nodes.isEmpty()) {
            errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("None of the path's points could be found on the navigation mesh."), Intl.intl("Adjust the path so it lies on the navigation mesh."), Collections.singleton(path)));
            return null;
        }
        Collections.reverse(nodes);
        QPath simPath = new QPath(path.getName(), kb, nodes, pointNames);
        simPath.setForceFollowPath(path.isForceFollowPath());
        simPath.setCustomSpacing(path.getCustomSpacing());
        simPath.setRestrictedProfiles(path.getRestrictedProfiles_Strings());
        return simPath;
    }

    public static Set<IEgressComp> collectEnabledComps(MerlinData md) {
        LinkedIdentityHashSet<IEgressComp> enabledComps = new LinkedIdentityHashSet<IEgressComp>();
        Collection<Elevator> elevators = md.elevators.getDeepMembers(Elevator.class);
        LinkedHashSet<AEgressComp> elevatorComps = new LinkedHashSet<AEgressComp>();
        for (Elevator el : elevators) {
            Collection<ElevatorDoor> elDoors = el.getDeepMembers(ElevatorDoor.class);
            IFilteredCollection<ElevatorDoor> enabledDoors = theUtil.filter(elDoors, c -> c.isEnabled());
            if (enabledDoors.isEmpty()) continue;
            elevatorComps.addAll(el.getDeepMembers(ElevatorRoom.class));
            elevatorComps.addAll(enabledDoors);
        }
        enabledComps.addAll(elevatorComps);
        InfernoUtil.collectAllComponents(md, md.floors.getDeepMembers(IEgressComp.class), enabledComps);
        return enabledComps;
    }

    private static InfernoGeomInfo collectInfernoGeom(ITaskProgress progress, IMerlinDispProps dprops, Set<IEgressComp> comps) {
        progress.setMessage(Intl.intl("Collecting geometry"));
        InfernoGeomInfo result = new InfernoGeomInfo();
        progress.reset(0, comps.size());
        for (IEgressComp comp : comps) {
            progress.incrementAndCheck();
            ArrayList<InfernoGeom> compGeoms = new ArrayList<InfernoGeom>(3);
            comp.getInfernoGeom(compGeoms, dprops);
            if (compGeoms.isEmpty()) continue;
            result.igeoms.addAll(compGeoms);
            result.finalComps.put(comp, compGeoms);
        }
        return result;
    }

    public static InfernoGeomInfo collectInfernoGeom(ITaskProgress progress, MerlinData md) {
        return InfernoUtil.collectInfernoGeom(progress, InfernoUtil.getDisplayProps(md), InfernoUtil.collectEnabledComps(md));
    }

    private static void collectAllComponents(MerlinData md, Collection<? extends IEgressComp> objs, Set<IEgressComp> result) {
        objs = MerlinUtil.getEnabledMembers(md, objs, IEgressComp.class);
        for (IEgressComp iEgressComp : objs) {
            result.add(iEgressComp);
        }
    }

    private static UnitDouble getOccWidth(EgressAgent occ) {
        UnitDouble width = occ.toOccValue(OccProfile.PROP_DIAMETER);
        VehicleShape vehicleShape = occ.getProfile().get(OccProfile.PROP_VEHICLE_SHAPE);
        if (vehicleShape != null) {
            Point3d pivot = vehicleShape.get(VehicleShape.PROP_PIVOT);
            Point3d[] points = vehicleShape.getBodyPoints();
            double widthD = 2.0 * VehicleBody.computeRadius(pivot, points);
            width = new UnitDouble(widthD, Geometry.LENGTH_UNIT);
        }
        return width;
    }

    private static void addElevators(ITaskProgress progress, MerlinData md, KB kb, Map<IEgressComp, ANode> nodeMap, Map<Elevator, inferno.elevator.Elevator> elevatorMap, Map<Floor, Integer> floorIDMap) {
        progress.setMessage(Intl.intl("Adding elevators"));
        for (Floor floor : md.floors.getMembers(Floor.class)) {
            floorIDMap.put(floor, floorIDMap.size());
        }
        Collection<Elevator> elevators = MerlinUtil.getEnabledMembers(md, md.elevators, Elevator.class, true);
        progress.reset(0, elevators.size());
        for (Elevator elevator : elevators) {
            progress.incrementAndCheck();
            ANode discharge = nodeMap.get(elevator.getDischargeRoom());
            UnitDouble area = elevator.getDischargeRoom().getArea();
            double pers = elevator.getNominalLoad().getValue(SIUS.unit(9));
            double szFactor = Elevator.getSizeFactorFromLoad(area, pers);
            double maxDensity = pers / area.getValue(SIUS.unit(4));
            ANode initRoom = nodeMap.get(elevator.getInitRoom());
            boolean isDoubleDeck = elevator.isDoubleDeck();
            double callDistance = elevator.getCallDistance().getValue(LENGTH_UNIT);
            ArrayList<ElevatorLevel> levels = new ArrayList<ElevatorLevel>();
            for (ElevatorRoom ev : elevator.getDeepMembers(ElevatorRoom.class)) {
                boolean enabled;
                Object floor = ElevatorUtil.getFloor(md, ev, false);
                boolean bl = enabled = floor != null;
                if (!enabled) {
                    floor = ElevatorUtil.getFloor(md, ev, true);
                }
                if (floor == null) continue;
                int floorid = floorIDMap.get(floor);
                ANode node = nodeMap.get(ev);
                Elevator.LevelData ld = elevator.getLevelData(ev);
                ElevatorLevel ilevel = new ElevatorLevel(floorid, node, ld.openTime.getValue(SI.SECOND), ld.closeTime.getValue(SI.SECOND), ld.delay.getValue(SI.SECOND), enabled);
                levels.add(ilevel);
            }
            List<Floor> floorPriority = elevator.getFloorPriority();
            ArrayList<Integer> ifloorPriority = new ArrayList<Integer>(floorPriority.size());
            if (!floorPriority.isEmpty()) {
                for (Floor floor : floorPriority) {
                    ifloorPriority.add(floorIDMap.get(floor));
                }
            }
            inferno.elevator.Elevator ielevator = kb.getElevatorModel().addElevator(elevator.getName(), elevator.getType(), Optional.ofNullable(discharge), levels, ifloorPriority, elevator.getOpenDelay().getValue(SI.SECOND), elevator.getCloseDelay().getValue(SI.SECOND), szFactor, maxDensity, initRoom, callDistance, isDoubleDeck, elevator.getTimingModel());
            elevatorMap.put(elevator, ielevator);
        }
        progress.reset();
        for (ElevatorGroup eg : MerlinUtil.getEnabledMembers(md, md.elevators, ElevatorGroup.class, false)) {
            ArrayList<inferno.elevator.Elevator> linkedElevators = new ArrayList<inferno.elevator.Elevator>();
            for (Elevator elevator : MerlinUtil.getEnabledMembers(md, eg, Elevator.class, true)) {
                linkedElevators.add(InfernoUtil.getNonNull(elevatorMap, elevator));
            }
            if (linkedElevators.size() <= 1) continue;
            kb.getElevatorModel().linkElevators(linkedElevators);
        }
    }

    private static <K, V> V getNonNull(Map<K, V> map, K key) {
        V result = map.get(key);
        assert (result != null);
        return result;
    }

    private static Map<IEgressComp, ANode> mkNodeMap(ITaskProgress progress, MerlinData md, List<InfernoGeom> igeoms) {
        progress.setMessage(Intl.intl("Creating nodes"));
        IdentityHashSet closed = new IdentityHashSet();
        LinkedIdentityHashMap<IEgressComp, ANode> nodeMap = new LinkedIdentityHashMap<IEgressComp, ANode>();
        progress.reset(0, igeoms.size());
        for (InfernoGeom ig : igeoms) {
            progress.incrementAndCheck();
            if (!closed.add(ig.source) || !(ig.source instanceof IEgressComp)) continue;
            IEgressComp node = (IEgressComp)ig.source;
            String name = InfernoUtil.getPathName(md, InfernoUtil.getStopParent(md, node), node, false);
            String annotatedName = InfernoUtil.getPathName(md, InfernoUtil.getStopParent(md, node), node, true);
            ANode anode = new ANode(name, annotatedName);
            anode.setResultsID(node.getResultsId());
            nodeMap.put(node, anode);
        }
        return nodeMap;
    }

    private static Object getStopParent(MerlinData md, IEgressComp obj) {
        if (md.hierarchy.isDescendent(md.floors, obj)) {
            return md.floors;
        }
        if (md.hierarchy.isDescendent(md.elevators, obj)) {
            return md.elevators;
        }
        return md;
    }

    private static IDoorFlowrate getFlowrate(MerlinData md, IEgressConnector door) {
        IEgressFlowrate flowrate = door.getFlowrate();
        if (flowrate == null || !(flowrate instanceof IEgressFlowrate.Limited)) {
            return null;
        }
        IEgressFlowrate.Limited lflow = (IEgressFlowrate.Limited)flowrate;
        double flowVal = lflow.maxVal.getValue(SIUS.unit(13));
        if (Double.isInfinite(flowVal)) {
            return IDoorFlowrate.UNLIMITED;
        }
        return new IDoorFlowrate.Fixed(flowVal);
    }

    private static void addNodes(ITaskProgress progress, MerlinData md, KB kb, InfernoGeomInfo igeoms, Map<IEgressComp, ANode> nodeMap, Map<IMaterial, inferno.data2.Material> materials, TagGenerator tags) {
        progress.setMessage(Intl.intl("Adding nodes"));
        SimParams merP = md.simParams;
        Param params = kb.getParams();
        int animId = 0;
        HashMap<Set, List> tagsCache = new HashMap<Set, List>();
        progress.reset(0, nodeMap.size());
        for (Map.Entry<IEgressComp, ANode> entry : nodeMap.entrySet()) {
            IEgressOccupiable room;
            progress.incrementAndCheck();
            IEgressComp comp = entry.getKey();
            ANode node = entry.getValue();
            kb.addNode(node);
            if (comp instanceof IEgressConnector) {
                IEgressConnector connector = (IEgressConnector)comp;
                IEgressOccupiable[] conns = connector.getConnectedComps();
                UnitDouble wid = connector.getUDWidth();
                double dWid = wid.getValue(LENGTH_UNIT);
                double boundaryLayer = 0.0;
                if (merP.get(SimParams.USE_DOOR_QUEUES).booleanValue()) {
                    boundaryLayer = merP.get(SimParams.DOOR_BOUNDARY_LAYER).getValue(LENGTH_UNIT);
                }
                if ((dWid -= 2.0 * boundaryLayer) < 0.0) {
                    dWid = 0.0;
                }
                IDoorFlowrate flowrate = InfernoUtil.getFlowrate(md, connector);
                IDistributedVal<UnitDouble> waitTime = connector.getWaitTime();
                if (waitTime instanceof ConstantCurve && theUtil.eq0(((ConstantCurve)waitTime).getAvg().getValueNoUnit(), 1.0E-6)) {
                    waitTime = null;
                }
                ANode connNode1 = nodeMap.get(conns[0]);
                ANode connNode2 = nodeMap.get(conns[1]);
                node.createDoorQueueData(kb, params, connNode1, connNode2, flowrate, dWid, waitTime);
            }
            if (comp instanceof EgressStair) {
                EgressStair stair = (EgressStair)comp;
                node.createStairData(kb, stair.getTreadRise().getValue(LENGTH_UNIT), stair.getTreadRun().getValue(LENGTH_UNIT));
            }
            if (comp instanceof ElevatorRoom) {
                Elevator parent = (Elevator)md.hierarchy.getParent(comp);
                if (parent != null && parent.getDischargeRoom() == comp) {
                    node.setAnimationId(animId++);
                } else if (parent != null && parent.isDoubleDeck() && InfernoUtil.findDoubleDeckTopDischargeRoom(parent) == comp) {
                    node.setAnimationId(animId++);
                }
            }
            if (comp instanceof EgressDoor) {
                EgressDoor door = (EgressDoor)comp;
                IVariant<EgressDoorDir> state = door.getState();
                List<DiscreteVariant.Entry<EgressDoorDir>> vals = VariantUtil.getDiscreteValues(state, true);
                boolean willClose = false;
                for (DiscreteVariant.Entry<EgressDoorDir> entryVal : vals) {
                    if (entryVal.val != EgressDoorDir.NONE) continue;
                    willClose = true;
                    break;
                }
                if (willClose || door.getRoom1() instanceof ElevatorRoom || door.getRoom2() instanceof ElevatorRoom) {
                    node.setAnimationId(animId++);
                }
            }
            if (comp instanceof IEgressOccupiable && (room = (IEgressOccupiable)comp).getCapacityEnabled()) {
                IOccCount occCount = room.getCapacity();
                ANode.Capacity capacity = null;
                if (occCount instanceof ConstOccCount) {
                    capacity = new ANode.Count(((ConstOccCount)occCount).count);
                } else if (occCount instanceof IOccArea) {
                    capacity = new ANode.Density(1.0 / ((IOccArea)occCount).getArea().getValue(SIUS.unit(2)), node);
                } else assert (false);
                node.setCapacity(capacity);
            }
            Set<String> occTagNames = comp.getOccTags();
            List occTags = tagsCache.computeIfAbsent(occTagNames, names -> {
                Set tagsSet = names.stream().map(name -> tags.getTag((String)name)).collect(Collectors.toCollection(() -> new LinkedIdentityHashSet()));
                return tagsSet.isEmpty() ? Collections.emptyList() : new ArrayList(tagsSet);
            });
            node.setOccTags(occTags);
            node.calcElevatorRestrictions(kb.getElevatorModel());
            List geoms = igeoms.finalComps.getOrDefault(comp, Collections.emptyList());
            Predicate<InfernoGeom> igtest = node.isDoor() ? ig -> ig.type.door : ig -> ig.type.face;
            Optional<InfernoGeom> nodeGeom = geoms.stream().filter(igtest).findFirst();
            if (!nodeGeom.isPresent()) continue;
            IPrimProps dprops = nodeGeom.get().displayProps;
            node.setColor(dprops.getColor());
            node.setMaterial(materials.get(dprops.getMaterial()));
        }
    }

    private static IEgressComp findDoubleDeckTopDischargeRoom(Elevator elevator) {
        ArrayList<ElevatorRoom> elevatorRooms = new ArrayList<ElevatorRoom>(elevator.getDeepMembers(ElevatorRoom.class));
        int dischargeIndex = elevatorRooms.indexOf(elevator.getDischargeRoom());
        assert (dischargeIndex < elevatorRooms.size() - 1);
        return (IEgressComp)elevatorRooms.get(dischargeIndex + 1);
    }

    private static Map<IMaterial, inferno.data2.Material> mkMatMap(ITaskProgress progress, MerlinData md, KB kb, List<InfernoGeom> components) {
        progress.setMessage(Intl.intl("Creating materials"));
        File outDir = new File(kb.getParams().out_results).getParentFile();
        LinkedIdentityHashMap<IMaterial, inferno.data2.Material> mats = new LinkedIdentityHashMap<IMaterial, inferno.data2.Material>();
        Consumer<IMaterial> createMat = mat -> {
            if (mat == null) {
                return;
            }
            mats.computeIfAbsent((IMaterial)mat, m -> {
                double width = 1.0;
                double height = 1.0;
                if (m instanceof Material) {
                    Material pmat = (Material)m;
                    width = pmat.getWidth().get(LENGTH_UNIT);
                    height = pmat.getHeight().get(LENGTH_UNIT);
                }
                IMatAttrs newAttrs = m.getAttributes().saveImagesTo(outDir);
                return new inferno.data2.Material(newAttrs, width, height);
            });
        };
        Collection<EgressBlockage> blockages = MerlinUtil.flatten(md.floors.getMembers(), EgressBlockage.class);
        progress.reset(0, blockages.size() + components.size());
        for (EgressBlockage blkg : blockages) {
            progress.incrementAndCheck();
            createMat.accept(blkg.getSimpleDisplayMaterial());
        }
        for (InfernoGeom obj : components) {
            progress.incrementAndCheck();
            createMat.accept(obj.displayProps.getMaterial());
        }
        return mats;
    }

    /*
     * WARNING - void declaration
     */
    private static Mesh createInfernoMesh(ITaskProgress progress, KB kb, List<InfernoGeom> igeoms, IMerlinDispProps dispProps, Map<IEgressComp, ANode> nodeMap, Map<IMaterial, inferno.data2.Material> matMap, InfernoGeomBuilder triMesh, List<SimError> errors) {
        progress.setMessage(Intl.intl("Constructing global mesh"));
        List<Point3d> allPoints = triMesh.getPoints();
        MeshBuilder mb = new MeshBuilder(allPoints);
        LinkedIdentityHashMap<MeshBuilder.MTri, InfernoGeomBuilder.NavTriangle> triMap = new LinkedIdentityHashMap<MeshBuilder.MTri, InfernoGeomBuilder.NavTriangle>();
        LinkedIdentityHashMap<void, InfernoGeomBuilder.MarkedEdge> edgeMap = new LinkedIdentityHashMap<void, InfernoGeomBuilder.MarkedEdge>();
        LinkedIdentityHashMap<EgressBlockage, ArrayList<MeshBuilder.MTri>> blockageMap = new LinkedIdentityHashMap<EgressBlockage, ArrayList<MeshBuilder.MTri>>();
        PlanarCoordMapper texMapper = new PlanarCoordMapper(mat -> {
            inferno.data2.Material imat = (inferno.data2.Material)mat;
            return new Point2d(imat.worldWidth, imat.worldHeight);
        }, GeomConstants.PNT3D_ORIGIN);
        IdentityHashMap<inferno.data2.Material, Boolean> matHasTex = new IdentityHashMap<inferno.data2.Material, Boolean>();
        Function<inferno.data2.Material, Boolean> getMatHasTex = mat -> mat.attrs.hasTexture();
        for (InfernoGeomBuilder.NavTriangle tri : triMesh.getTriangles()) {
            void var20_32;
            progress.check();
            InfernoGeom ig = tri.getBestSource();
            if (ig == null || !(ig.source instanceof IEgressComp)) continue;
            ANode aNode = InfernoUtil.getNode(nodeMap, (IEgressComp)ig.source);
            if (aNode.getMaterial() != null && matHasTex.computeIfAbsent(aNode.getMaterial(), getMatHasTex).booleanValue()) {
                Triangle gtri = new Triangle(allPoints.get(tri.i1), allPoints.get(tri.i2), allPoints.get(tri.i3));
                Point2f[] point2fArray = new Point2f[3];
                MutableInt mutableInt = new MutableInt();
                texMapper.generate(Point2d.class, (IPrimitive)gtri, Elements.Orient.CCW, new IPrimProps.Face(aNode.getColor(), aNode.getMaterial(), 0), vuv -> {
                    uv[uvix.postInc()] = new Point2f((float)vuv.x, (float)vuv.y);
                });
            } else {
                Object var20_34 = null;
            }
            MeshBuilder.MTri t = mb.addTri(aNode, InfernoUtil.mkTerrain((IEgressComp)ig.source), tri.i1, tri.i2, tri.i3, (Point2f[])var20_32);
            if (t == null) continue;
            triMap.put(t, tri);
            for (InfernoGeom igeom : tri.igeoms) {
                if (igeom.type != InfernoType.REMOVABLE) continue;
                assert (igeom.source instanceof EgressBlockage);
                EgressBlockage eb = (EgressBlockage)igeom.source;
                ArrayList<MeshBuilder.MTri> tris = (ArrayList<MeshBuilder.MTri>)blockageMap.get(eb);
                if (tris == null) {
                    tris = new ArrayList<MeshBuilder.MTri>();
                    blockageMap.put(eb, tris);
                }
                tris.add(t);
            }
        }
        for (InfernoGeomBuilder.MarkedEdge bedge : triMesh.getMarkedEdges()) {
            void var19_26;
            progress.check();
            ANode node = InfernoUtil.getNode(nodeMap, bedge.igeom.source);
            Object var19_21 = null;
            switch (bedge.igeom.type) {
                case EXIT_DOOR: {
                    MeshBuilder.MEdge mEdge = mb.addExitDoorEdge(node, bedge.i1, bedge.i2);
                    break;
                }
                case INTERNAL_DOOR: {
                    MeshBuilder.MEdge mEdge = mb.addDoorEdge(node, bedge.i1, bedge.i2);
                    break;
                }
                case BOUNDARY: {
                    MeshBuilder.MEdge mEdge = mb.addBoundaryEdge(bedge.i1, bedge.i2);
                    break;
                }
                default: {
                    Object var19_25 = null;
                }
            }
            if (var19_26 == null) continue;
            edgeMap.put(var19_26, bedge);
        }
        ArrayList<MeshBuilder.Error> mbErrors = new ArrayList<MeshBuilder.Error>();
        Mesh mesh = mb.finish(kb.getParams(), mbErrors, UnitSystem.getType(0, false));
        for (Map.Entry entry : nodeMap.entrySet()) {
            progress.check();
            IEgressComp iEgressComp = (IEgressComp)entry.getKey();
            InfernoUtil.addEvents(kb, iEgressComp, (ANode)entry.getValue());
        }
        ToIntFunction<MeshBuilder.MTri> getTriIx = mb.getTriIndexes();
        for (Map.Entry entry : blockageMap.entrySet()) {
            progress.check();
            InfernoUtil.addBlockages(kb, mb, matMap, dispProps, getTriIx, (EgressBlockage)entry.getKey(), (List)entry.getValue());
        }
        for (MeshBuilder.Error error : mbErrors) {
            if (error.level == MeshBuilder.ErrorLevel.LIGHT) {
                LOGGER.log(Level.WARNING, "Error: " + error.msg);
                LOGGER.log(Level.WARNING, "Fix:   " + error.fix);
                continue;
            }
            LinkedIdentityHashSet offendingObjs = new LinkedIdentityHashSet();
            ArrayDeque<? extends MeshBuilder.MObj> arrayDeque = new ArrayDeque<MeshBuilder.MObj>(error.offendingObjs);
            while (!arrayDeque.isEmpty()) {
                progress.check();
                MeshBuilder.MObj mobj = (MeshBuilder.MObj)arrayDeque.removeFirst();
                if (mobj instanceof MeshBuilder.MEdge) {
                    MeshBuilder.MEdge iedge = (MeshBuilder.MEdge)mobj;
                    InfernoGeomBuilder.MarkedEdge se = (InfernoGeomBuilder.MarkedEdge)edgeMap.get(iedge);
                    if (se != null) {
                        if (se.igeom.source == null) continue;
                        offendingObjs.add(se.igeom.source);
                        continue;
                    }
                    for (MeshBuilder.MTri mtri : mb.getAdjTris(iedge)) {
                        arrayDeque.addFirst(mtri);
                    }
                    continue;
                }
                if (!(mobj instanceof MeshBuilder.MTri)) continue;
                MeshBuilder.MTri mtri = (MeshBuilder.MTri)mobj;
                InfernoGeomBuilder.NavTriangle nt = (InfernoGeomBuilder.NavTriangle)triMap.get(mtri);
                InfernoGeom igeom = nt.getBestSource();
                if (igeom.source == null) continue;
                offendingObjs.add(igeom.source);
            }
            if (offendingObjs.isEmpty()) continue;
            errors.add(new SimError(switch (error.level) {
                case MeshBuilder.ErrorLevel.CRITICAL -> SimError.Level.CRITICAL;
                default -> SimError.Level.MODERATE;
            }, error.msg, error.fix, offendingObjs));
        }
        IdentityHashMap<ANode, IEgressComp> identityHashMap = new IdentityHashMap<ANode, IEgressComp>();
        for (Map.Entry<IEgressComp, ANode> entry : nodeMap.entrySet()) {
            identityHashMap.put(entry.getValue(), entry.getKey());
        }
        for (InfernoGeom ig : igeoms) {
            ANode aNode;
            progress.check();
            if (!(ig.source instanceof IEgressComp) || (aNode = nodeMap.get(ig.source)) != null) continue;
            String name = ig.source.getName();
            String err = String.format(Intl.intl("Component, \"%s\", could not be represented in the simulation."), name);
            String fix = Intl.intl("Check the geometry of the component.");
            errors.add(new SimError(SimError.Level.MODERATE, err, fix, ig.source));
        }
        for (InfernoGeom ig : igeoms) {
            String fix;
            String err;
            IEgressComp adjComp;
            IEgressObj name = ig.source;
            if (!(name instanceof IEgressComp)) continue;
            IEgressComp iEgressComp = (IEgressComp)name;
            progress.check();
            ANode node = nodeMap.get(ig.source);
            if (node == null || !node.isDoor()) continue;
            LinkedIdentityHashSet<ANode> logicallyAdjNodes = new LinkedIdentityHashSet<ANode>(node.getAdjacentNodes());
            LinkedIdentityHashSet physicallyAdjNodes = new LinkedIdentityHashSet();
            for (WingedEdge we : node.getDoorEdges()) {
                ANode node1 = we.getNode1();
                ANode node2 = we.getNode2();
                if (node2 != null) {
                    physicallyAdjNodes.add(node2);
                }
                if (node1 == null) continue;
                physicallyAdjNodes.add(node1);
            }
            LinkedIdentityHashSet<ANode> missingLogical = new LinkedIdentityHashSet<ANode>((Collection<ANode>)logicallyAdjNodes);
            LinkedIdentityHashSet unexpectedPhysical = new LinkedIdentityHashSet(physicallyAdjNodes);
            missingLogical.removeAll(physicallyAdjNodes);
            unexpectedPhysical.removeAll(logicallyAdjNodes);
            for (ANode lanode : missingLogical) {
                adjComp = (IEgressComp)identityHashMap.get(lanode);
                assert (adjComp != null);
                if (adjComp == null) continue;
                err = String.format(Intl.intl("Component, \"%1$s\", did not connect to \"%2$s\"."), iEgressComp.getName(), adjComp.getName());
                fix = Intl.intl("Check the geometry of the two components where they connect and adjust if necessary.");
                errors.add(new SimError(SimError.Level.MODERATE, err, fix, Arrays.asList(iEgressComp, adjComp)));
            }
            for (ANode panode : unexpectedPhysical) {
                adjComp = (IEgressComp)identityHashMap.get(panode);
                assert (adjComp != null);
                if (adjComp == null) continue;
                err = String.format(Intl.intl("Component, \"%1$s\", unexpectedly connected to \"%2$s\"."), iEgressComp.getName(), adjComp.getName());
                fix = Intl.intl("Check the geometry of the two components where they connect and adjust if necessary.");
                errors.add(new SimError(SimError.Level.MODERATE, err, fix, Arrays.asList(iEgressComp, adjComp)));
            }
        }
        return mesh;
    }

    private static Map<EgressAgent, Occupant> addOccs(MerlinData md, KB kb, Map<IEgressComp, ANode> nodeMap, Collection<EgressAgent> occsInUse, List<SimError> errors, Map<VehicleShape, VehicleBody> vehicleMap, Map<Elevator, inferno.elevator.Elevator> elevatorMap, Map<OccProfile, OccProfileSim> profMap, Map<Behavior, BehaviorSim> behaviorMap, Map<OccProfile.CompRestrictions, OccProfileSim.CompRestrictions> compRestrictionsMap, Map<ObjsFilter<Attractor>, Predicate<AttractorSim>> attrSuscpMap, TagGenerator tags) {
        LinkedIdentityHashMap<EgressAgent, Occupant> occMap = new LinkedIdentityHashMap<EgressAgent, Occupant>();
        OccAdder adder = new OccAdder(kb.getMesh());
        Random rnd = new Random();
        theTimer timer = new theTimer();
        OccProfile advancedOverride = InfernoUtil.getAdvancedOverrideProfile(md);
        for (EgressAgent a : occsInUse) {
            BehaviorSim behavior = behaviorMap.get(a.getBehavior());
            advancedOverride.setProfParent(a.getProfile());
            PropGetter props = new PropGetter(a);
            Point3d shiftedLoc = InfernoUtil.getShiftedLoc(advancedOverride, props, a);
            OccProfileSim parentProfile = profMap.get(a.getProfile().getProfParent());
            assert (parentProfile != null);
            Occupant occ = adder.add(a.getName(), a.getProfileSeed(), a.getOrientSeed(), parentProfile, behavior, shiftedLoc, kb);
            if (occ == null) {
                String error = String.format(Intl.intl("Invalid occupant, \"%1$s\", being added to simulation at%nlocation %2$s."), a.getName(), InfernoUtil.format(a.getLocPoint()));
                String fix = Intl.intl("The navigation mesh may not have triangulated correctly or\nthe occupant may need to be moved.");
                errors.add(new SimError(SimError.Level.MODERATE, error, fix, a));
                continue;
            }
            OccProfileSim profile = InfernoUtil.convertProfile(md, advancedOverride, vehicleMap, compRestrictionsMap, attrSuscpMap, tags);
            tags.commitToKb(kb);
            profile.applyToOcc(occ, rnd, occ.rseed, Filters.acceptAll(), kb);
            profile.applyToOcc(occ, rnd, occ.orientSeed, OccProfileSim.PROP_INIT_ORIENT, kb);
            occ.name = a.getName();
            occMap.put(a, occ);
        }
        adder.finish(kb);
        LOGGER.log(Level.FINE, String.format("Convert occs: %g%n", timer.curr()));
        return occMap;
    }

    private static Map<VehicleShape, VehicleBody> addVehicleBodies(MerlinData md, KB kb, Set<OccProfile> profilesInUse, Set<Behavior> behaviorsInUse) {
        LinkedIdentityHashMap<VehicleShape, VehicleBody> vehicleMap = new LinkedIdentityHashMap<VehicleShape, VehicleBody>();
        IdentityHashSet usedVehicles = new IdentityHashSet();
        Consumer<OccProfile.OccShape> addVehicle = shape -> {
            if (shape != null && shape.type.equals(VehicleShape.ShapeType.POLYGON)) {
                usedVehicles.add(shape.vehicleShape);
            }
        };
        for (EgressAgent agent : md.agents.flatten(EgressAgent.class)) {
            if (!agent.isEnabled()) continue;
            OccProfile.OccShape shape2 = agent.toOccValue(OccProfile.PROP_SHAPE);
            addVehicle.accept(shape2);
        }
        for (OccProfile profile : profilesInUse) {
            addVehicle.accept((OccProfile.OccShape)profile.get(OccProfile.PROP_SHAPE));
        }
        for (ChangeProfileProp changeProp : MerlinUtil.flatten(behaviorsInUse, ChangeProfileProp.class)) {
            IProfileProp<?, ?> prop = changeProp.getProp();
            if (prop != OccProfile.PROP_SHAPE) continue;
            addVehicle.accept((OccProfile.OccShape)changeProp.get(OccProfile.PROP_SHAPE));
        }
        for (VehicleShape vehicleShape : usedVehicles) {
            Point3d[] bodyShapePoints = PolyUtil.getLoop(vehicleShape.get(VehicleShape.PROP_POINTS), 0, false);
            UnitDouble height = vehicleShape.get(VehicleShape.PROP_HEIGHT);
            Point3d[] attachedAgentsPositions = vehicleShape.get(VehicleShape.PROP_ATTACHED_AGENTS_POSITIONS);
            Point3d pivot = vehicleShape.get(VehicleShape.PROP_PIVOT);
            Set<String> iAnimTags = vehicleShape.get(VehicleShape.PROP_ANIM_TAGS);
            IAvatar model = vehicleShape.get(VehicleShape.PROP_MODEL);
            String modelFile = InfernoUtil.getAvatarId(model);
            Point3d avatarOffset = vehicleShape.get(VehicleShape.PROP_OCCAVATAR_OFFSET).getPoint3dValue(Geometry.LENGTH_UNIT);
            Point3d origin = new Point3d(-pivot.x, -pivot.y, -pivot.z);
            VehicleBody vehicleBody = new VehicleBody(vehicleShape.getName(), origin, InfernoUtil.translatePoints(bodyShapePoints, origin), height.get(LENGTH_UNIT), md.simParams.get(SimParams.ENABLE_VEHICLE_LATERAL_MOVEMENT_VIS) != false && vehicleShape.get(VehicleShape.PROP_ALLOW_LATERAL) != false, attachedAgentsPositions != null ? Arrays.asList(InfernoUtil.translatePoints(attachedAgentsPositions, origin)) : Collections.emptyList(), iAnimTags, Util3D.add(avatarOffset, (Tuple3d)origin), modelFile);
            vehicleMap.put(vehicleShape, vehicleBody);
        }
        return vehicleMap;
    }

    private static Point3d[] translatePoints(Point3d[] points, Point3d offset) {
        Point3d[] translated = new Point3d[points.length];
        for (int i = 0; i < points.length; ++i) {
            translated[i] = Util3D.add(points[i], (Tuple3d)offset);
        }
        return translated;
    }

    private static <T> void setToDefault(OccProfile profile, TypedProp<T> prop) {
        profile.set(prop, prop.defVal);
    }

    public static String getAvatarId(IAvatar avatar) {
        if (avatar instanceof ResourceAvatar) {
            return ((ResourceAvatar)avatar).path;
        }
        if (avatar instanceof ShapeAvatar) {
            return "";
        }
        return null;
    }

    private static Point3d getShiftedLoc(OccProfile prof, PropGetter props, EgressAgent a) {
        VehicleShape vehicleShape = prof.get(OccProfile.PROP_VEHICLE_SHAPE);
        if (vehicleShape == VehicleShape.NONE) {
            return a.getLocPoint();
        }
        Point3d pivot = vehicleShape.get(VehicleShape.PROP_PIVOT);
        double angleRad = props.getCurved(OccProfile.PROP_INIT_ORIENT, SI.RADIAN);
        Vector3d rotatedPivot = new Vector3d(pivot);
        Inter.rotateTuple2D(rotatedPivot, angleRad, new Point3d(0.0, 0.0, 0.0));
        Point3d loc = new Point3d(a.getLocPoint());
        loc.add(rotatedPivot);
        return loc;
    }

    private static OccProfileSim convertProfile(MerlinData md, OccProfile profile, Map<VehicleShape, VehicleBody> vehicleMap, Map<OccProfile.CompRestrictions, OccProfileSim.CompRestrictions> compRestrictionsMap, Map<ObjsFilter<Attractor>, Predicate<AttractorSim>> attrSuscpMap, TagGenerator tags) {
        OccProfileSim simProf = new OccProfileSim();
        Predicate propFilter = Filters.acceptAll();
        Map<Object, IPropertySet.Prop<?>> simPropsMap = OccProfileSim.PROFILE_PROPS_MAP;
        OccProfile.streamProfileProps().filter(propFilter).forEach(uiProp -> {
            Object uiVal = profile.get(uiProp.asProp());
            Object simKey = uiProp.getSimKey();
            IPropertySet.Prop simProp = (IPropertySet.Prop)simPropsMap.get(simKey);
            if (simProp == null) {
                return;
            }
            Optional simVal = InfernoUtil.convertProfileProp(vehicleMap, compRestrictionsMap, attrSuscpMap, tags, uiProp.asProp(), simProp, uiVal);
            if (simVal.isEmpty()) {
                return;
            }
            simProf.setProperty((Object)simProp, simVal.get().val);
        });
        simProf.setProperty(OccProfileSim.PROP_REAC_TIME, Float.valueOf((float)md.simParams.get(SimParams.DT_STEER_UPDATE).getValue(TIME_UNIT)));
        return simProf;
    }

    private static <UiT, SimT> Optional<Nullable<SimT>> convertProfileProp(Map<VehicleShape, VehicleBody> vehicleMap, Map<OccProfile.CompRestrictions, OccProfileSim.CompRestrictions> compRestrictionsMap, Map<ObjsFilter<Attractor>, Predicate<AttractorSim>> attrSuscpMap, TagGenerator tags, IPropertySet.Prop<UiT> uiProp, IPropertySet.Prop<SimT> simProp, UiT uiVal) {
        Object simVal;
        if (simProp == OccProfileSim.PROP_ATTRACTOR_RESTRICTIONS) {
            assert (uiProp == null || ObjsFilter.class.isInstance(uiVal));
            ObjsFilter restr = (ObjsFilter)uiVal;
            simVal = attrSuscpMap.get(restr);
            if (simVal == null) {
                return Optional.empty();
            }
        } else if (simProp == OccProfileSim.PROP_SOCIAL_DIST_FILTER) {
            assert (uiVal instanceof ObjsFilter);
            ObjsFilter stringFilter = (ObjsFilter)uiVal;
            ObjsFilter<inferno.data2.Tag> tagFilter = stringFilter.mapTo(tags::getTag);
            simVal = InfernoUtil.filterOccsByTag(tagFilter);
        } else if (uiVal instanceof IFunction1d) {
            assert (uiProp instanceof ProfileProps.ProfileFunction1dProp);
            ProfileProps.ProfileFunction1dProp fop = (ProfileProps.ProfileFunction1dProp)uiProp;
            simVal = ((IFunction1d)uiVal).toInfernoFunction(SIUS.unit(fop.fprop.x.unitType), SIUS.unit(fop.fprop.y.unitType));
        } else if (uiVal instanceof OccProfile.FromLevelFundamental) {
            simVal = OccProfileSim.FromLevelFundamental.INSTANCE;
        } else if (uiVal instanceof OccProfile.ConstProfileFunction) {
            assert (uiProp instanceof ProfileProps.ProfileFunctionProp);
            ProfileProps.ProfileFunctionProp pfp = (ProfileProps.ProfileFunctionProp)uiProp;
            IFunction1d func = ((OccProfile.ConstProfileFunction)uiVal).function;
            simVal = new OccProfileSim.ConstProfileFunction(func.toInfernoFunction(SIUS.unit(pfp.fprop.x.unitType), SIUS.unit(pfp.fprop.y.unitType)));
        } else if (uiVal instanceof OccProfile.Spacing) {
            OccProfile.SpacingType type = ((OccProfile.Spacing)uiVal).type;
            OccProfileSim.SpacingType newType = null;
            switch (type) {
                case AREA: {
                    newType = OccProfileSim.SpacingType.AREA;
                    break;
                }
                case COMFORT_DIST: {
                    newType = OccProfileSim.SpacingType.COMFORT_DIST;
                    break;
                }
                case DENSITY: {
                    newType = OccProfileSim.SpacingType.DENSITY;
                }
            }
            simVal = new OccProfileSim.Spacing(newType, ((OccProfile.Spacing)uiVal).val);
        } else if (uiVal instanceof OccProfile.SpeedInSmokeConfig) {
            OccProfile.SpeedInSmokeConfig uiData = (OccProfile.SpeedInSmokeConfig)uiVal;
            Unit customFuncX = LENGTH_UNIT;
            Unit customFuncY = uiData.customFuncVisType == SpeedInSmoke.FuncType.AS_GIVEN ? VEL_UNIT : Unit.ONE;
            simVal = new SpeedInSmokeSim(uiData.mode, uiData.customFuncVisThreshold, uiData.customFuncVisType, uiData.customFuncVis != null ? uiData.customFuncVis.toInfernoFunction(customFuncX, customFuncY) : null);
        } else if (simProp == OccProfileSim.PROP_OCCMODEL) {
            Map map = ((IUrn)uiVal).getWeights();
            LinkedHashMap<String, Double> stringMap = new LinkedHashMap<String, Double>();
            for (Map.Entry entry : map.entrySet()) {
                stringMap.put(InfernoUtil.getAvatarId((IAvatar)entry.getKey()), entry.getValue());
            }
            simVal = UrnUtil.newUrn(stringMap);
        } else if (simProp == OccProfileSim.PROP_RESTRICTED_COMPONENTS) {
            simVal = compRestrictionsMap.get(uiVal);
            assert (simVal != null);
        } else if (simProp == OccProfileSim.PROP_SHAPE) {
            OccProfile.OccShape shape = (OccProfile.OccShape)uiVal;
            switch (shape.type) {
                case CYLINDER: {
                    simVal = new OccProfileSim.CylShapeGen(shape.shoulderWidth, shape.geomShoulderWidth, shape.height);
                    break;
                }
                case POLYGON: {
                    simVal = new OccProfileSim.PolyShapeGen(vehicleMap.get(shape.vehicleShape));
                    break;
                }
                default: {
                    assert (false);
                    return Optional.empty();
                }
            }
        } else if (simProp == OccProfileSim.PROP_TAGS) {
            Set<Object> tagSet;
            Set uiTagSet = (Set)uiVal;
            if (uiTagSet.isEmpty()) {
                tagSet = Collections.emptySet();
            } else if (uiTagSet.size() == 1) {
                tagSet = Collections.singleton(tags.getTag((Tag)uiTagSet.iterator().next()));
            } else {
                tagSet = new LinkedIdentityHashSet(uiTagSet.size());
                uiTagSet.forEach(s -> tagSet.add(tags.getTag((Tag)s)));
            }
            simVal = new Urn(Collections.singleton(tagSet));
        } else {
            simVal = uiVal;
        }
        return Optional.of(Nullable.of(simVal));
    }

    public static String getPathName(MerlinData md, Object stopParent, Object obj, boolean annotate) {
        if (stopParent == null) {
            stopParent = md;
        }
        Object[] path = md.hierarchy.getPath(obj, stopParent, false);
        StringBuffer pathName = new StringBuffer();
        if (annotate) {
            for (int m = 0; m < path.length; ++m) {
                if (m != 0) {
                    pathName.append("->");
                }
                assert (path[m] instanceof IMerlinObj);
                IMerlinObj node = (IMerlinObj)path[m];
                pathName.append(node.getName());
            }
        } else {
            int size = path.length;
            assert (path[size - 1] instanceof IMerlinObj);
            IMerlinObj node = (IMerlinObj)path[size - 1];
            pathName.append(node.getName());
        }
        return pathName.toString();
    }

    private static String format(Point3d p, int precision) {
        String dblFormat = "%." + precision + "f";
        String format = String.format("(%1$s, %1$s, %1$s) %2$s", dblFormat, Geometry.LENGTH_UNIT.toString());
        return String.format(format, p.x, p.y, p.z);
    }

    private static String format(Point3d p) {
        return String.format("(%s, %s, %s)", Global.format(p.x), Global.format(p.y), Global.format(p.z));
    }

    private static List<IGoal> generateGoals(MerlinData md, KB kb, List<SimError> errors, TagGenerator tags, Behavior behavior, GoalBuilder goalBuilder, GoalObjMaps maps) {
        goalBuilder.newList();
        Collection<Elevator> allElevators = MerlinUtil.getEnabledMembers(md, md.elevators, Elevator.class, true);
        BiConsumer<WaitMode, IDistributedVal> addWait = (mode, wait) -> {
            if (!(wait instanceof ConstantCurve) || !(((ConstantCurve)wait).getValue().get(SI.SECOND) <= 0.0)) {
                goalBuilder.add(new WaitGoal((WaitMode)mode, (IDistributedVal<UnitDouble>)wait));
            }
        };
        AssistInfo assistInfo = new AssistInfo();
        Runnable addDetachTeams = () -> {
            if (assistInfo.currAssistTeams == null || !assistInfo.currAssistTeams.isEmpty()) {
                goalBuilder.add(FillRoomGoal.ONLY_IF_NECESSARY);
                if (assistInfo.currAssistTeams == null) {
                    goalBuilder.add(DetachGoal.DETACH_ALL);
                } else {
                    goalBuilder.add(new DetachGoal(assistInfo.currAssistTeams));
                }
                assistInfo.currAssistTeams = Collections.emptyList();
            }
        };
        BiConsumer<PredefTag, WaitMode> addWaitUntilEndGoals = (reportTag, waitMode) -> {
            addDetachTeams.run();
            goalBuilder.add(ChangeTagGoal.tag(tags.getTag((PredefTag)((Object)reportTag))));
            goalBuilder.add(new WaitUntilEndGoal((WaitMode)waitMode));
        };
        addWait.accept(WaitMode.AVOID, behavior.getInitialDelay());
        ArrayList<IBehaviorAction> actions = new ArrayList<IBehaviorAction>(behavior.getMembers(IBehaviorAction.class));
        for (int m = 0; m < actions.size(); ++m) {
            LinkedIdentityHashSet<inferno.data2.Tag> targetTags;
            List<AttractorSim> attractors;
            IPropertySet.Prop<?> simProp;
            Map<Object, IPropertySet.Prop<?>> simPropsMap;
            IProfileProp<?, ?> uiProp;
            NamedMerlinObj cpp;
            NamedMerlinObj go;
            NamedMerlinObj ge;
            ArrayList<inferno.data2.Tag> tagsToAdd = new ArrayList<inferno.data2.Tag>();
            IBehaviorAction action = (IBehaviorAction)actions.get(m);
            if (m == actions.size() - 1 && !(action instanceof ChangeBehavior)) {
                tagsToAdd.add(tags.getTag(PredefTags.LAST_GOAL_STARTED));
            }
            if (!tagsToAdd.isEmpty()) {
                goalBuilder.add(new ChangeTagGoal(ChangeTagGoal.Op.TAG, tagsToAdd));
            }
            if (action instanceof Wait) {
                Wait wait2 = (Wait)action;
                addWait.accept(wait2.get(IWaitAction.MODE), wait2.getWaitTime());
                continue;
            }
            if (action instanceof WaitUntil) {
                WaitUntil wu = (WaitUntil)action;
                goalBuilder.add(new WaitUntilGoal(wu.get(IWaitAction.MODE), InfernoUtil.convertWaitSrc(wu.getSource())));
                continue;
            }
            if (action instanceof GotoWaypoint) {
                GotoWaypoint wp = (GotoWaypoint)action;
                TriPoint tp = InfernoUtil.findMeshLoc(kb, errors::add, wp, Intl.intl("Waypoint"), wp.getName(), wp.getLocation());
                if (tp == null) continue;
                goalBuilder.add(new PointGoal(tp, wp.getArriveRadius().getValue(Geometry.LENGTH_UNIT)));
                continue;
            }
            if (action instanceof GotoElevators) {
                ge = (GotoElevators)action;
                Collection<Elevator> occElevators = ((GotoElevators)ge).getElevators().isEmpty() ? allElevators : ((GotoElevators)ge).getElevators();
                ArrayList<inferno.elevator.Elevator> ielevs = new ArrayList<inferno.elevator.Elevator>();
                for (Elevator e2 : occElevators) {
                    if (!maps.elevatorMap.containsKey(e2)) continue;
                    ielevs.add(maps.elevatorMap.get(e2));
                }
                ElevatorGoal eg = new ElevatorGoal(((GotoElevators)ge).getElevators().isEmpty(), Collections.unmodifiableList(ielevs), maps.floorIDMap.get(((GotoElevators)ge).getTargetDischarge()));
                goalBuilder.add(eg);
                continue;
            }
            if (action instanceof GotoOccTarget) {
                go = (GotoOccTarget)action;
                Set<merlin.data.egress.agents.OccTarget> targets = go.get(GotoOccTarget.PROP_TARGETS);
                List<Object> targetsSim = new ArrayList(targets.size());
                for (merlin.data.egress.agents.OccTarget target : targets) {
                    OccTarget targetSim = maps.occTargets.get(target);
                    if (targetSim == null) continue;
                    targetsSim.add(targetSim);
                }
                if (targetsSim.isEmpty()) {
                    targetsSim = Collections.emptyList();
                }
                OccTargetGoal.DistancePref choice = OccTargetGoal.DistancePref.values()[go.get(GotoOccTarget.PROP_DIST_PREF).ordinal()];
                OccTargetGoal.PriorityPref priority = OccTargetGoal.PriorityPref.values()[go.get(GotoOccTarget.PROP_PRIORITY_PREF).ordinal()];
                OccTargetGoal og = new OccTargetGoal(targetsSim, choice, priority);
                goalBuilder.add(og);
                continue;
            }
            if (action instanceof GotoOcc) {
                go = (GotoOcc)action;
                Set tagStr = go.get(GotoOcc.PROP_GOTO_TAGS).stream().map(tag -> tag.getName()).collect(Collectors.toSet());
                Set targetTags2 = tagStr.stream().map(s -> tags.getTag((String)s)).collect(Collectors.toCollection(() -> new LinkedIdentityHashSet()));
                ITargetPtSupplier.BasicTaggedOccSupplier occChooser = new ITargetPtSupplier.BasicTaggedOccSupplier(targetTags2, InfernoUtil.convertEnumSameName(go.get(GotoOcc.PROP_TAG_LOGIC), ITargetPtSupplier.BasicTaggedOccSupplier.Logic.class), InfernoUtil.convertEnumSameName(go.get(GotoOcc.PROP_DIST_PREF), ITargetPtSupplier.BasicTaggedOccSupplier.DistancePref.class));
                DynamicTargetGoal goal = new DynamicTargetGoal(occChooser, InfernoUtil.convertEnumSameName(go.get(GotoOcc.PROP_TRACKING), DynamicTargetGoal.Tracking.class), go.get(GotoOcc.PROP_ARRIVAL_RADIUS).get(SI.METER), InfernoUtil.convertEnumSameName(go.get(GotoOcc.PROP_NO_OCCUPANTS), DynamicTargetGoal.TargetNotFound.class), InfernoUtil.convertEnumSameName(go.get(GotoOcc.PROP_UNREACHABLE), DynamicTargetGoal.TargetUnreachable.class));
                goalBuilder.add(goal);
                continue;
            }
            if (action instanceof GotoCurrentAttractor) {
                GotoCurrentAttractor gca = (GotoCurrentAttractor)action;
                DynamicTargetGoal goal = new DynamicTargetGoal(ITargetPtSupplier.CURRENT_ATTRACTOR_SUPPLIER, InfernoUtil.convertEnumSameName(gca.get(GotoCurrentAttractor.PROP_TRACKING), DynamicTargetGoal.Tracking.class), gca.get(GotoCurrentAttractor.PROP_ARRIVAL_RADIUS).getValue(Geometry.LENGTH_UNIT), DynamicTargetGoal.TargetNotFound.SKIP, InfernoUtil.convertEnumSameName(gca.get(GotoCurrentAttractor.PROP_UNREACHABLE), DynamicTargetGoal.TargetUnreachable.class));
                goalBuilder.add(goal);
                continue;
            }
            if (action instanceof GotoRooms) {
                GotoRooms gr = (GotoRooms)action;
                Collection<IEgressOccupiable> rooms = gr.getRooms();
                if (rooms.isEmpty() && gr.getAnyAllowed()) {
                    rooms = md.floors.flatten(IEgressOccupiable.class, gr.getFilter());
                }
                ArrayList<ANode> nodes = new ArrayList<ANode>(rooms.size());
                for (IEgressOccupiable room : rooms) {
                    if (!room.isEnabled()) continue;
                    assert (maps.nodeMap.get(room) != null) : "Null lookup for room=" + String.valueOf(room);
                    nodes.add(maps.nodeMap.get(room));
                }
                if (nodes.isEmpty()) {
                    errors.add(new SimError(SimError.Level.MODERATE, String.format(Intl.intl("\"%s\" has no destination rooms. Occupants may become stuck."), MerlinUtil.getName(action)), Intl.intl("Add destination rooms."), action));
                }
                goalBuilder.add(new RoomGoal(nodes));
                if (!(gr.getFilter() instanceof RefugeFilter)) continue;
                addWaitUntilEndGoals.accept(PredefTag.REPORT_REFUGE_REACHED, WaitMode.AVOID);
                continue;
            }
            if (action instanceof WaitUntilEnd) {
                WaitUntilEnd wue = (WaitUntilEnd)action;
                addWaitUntilEndGoals.accept(PredefTag.REPORT_WAITING_UNTIL_END, wue.get(IWaitAction.MODE));
                continue;
            }
            if (action instanceof GotoExits) {
                ArrayList exitNodes;
                ge = (GotoExits)action;
                Set<EgressDoor> exits = ge.get(GotoExits.PROP_EXITS);
                if (exits.isEmpty()) {
                    exitNodes = null;
                } else {
                    LinkedIdentityHashSet allowedExitNodes = new LinkedIdentityHashSet(exits.size());
                    for (EgressDoor exit : exits) {
                        allowedExitNodes.add(maps.nodeMap.get(exit));
                    }
                    exitNodes = new ArrayList(allowedExitNodes);
                }
                goalBuilder.add(new ExitGoal(exitNodes));
                continue;
            }
            if (action instanceof WaitForAssistance) {
                LinkedIdentityHashSet<inferno.data2.ai.AssistedEvacTeam> iteams;
                addDetachTeams.run();
                WaitForAssistance wfa = (WaitForAssistance)action;
                Set<AssistedEvacTeam> teams = wfa.get(WaitForAssistance.TEAMS);
                if (teams.isEmpty()) {
                    iteams = new LinkedIdentityHashSet<inferno.data2.ai.AssistedEvacTeam>(maps.aeTeamMap.values());
                } else {
                    iteams = new LinkedIdentityHashSet(teams.size());
                    for (AssistedEvacTeam team : teams) {
                        inferno.data2.ai.AssistedEvacTeam iteam = maps.aeTeamMap.get(team);
                        assert (iteam != null);
                        iteams.add(iteam);
                    }
                }
                goalBuilder.add(new WaitForAssistanceGoal(wfa.get(IWaitAction.MODE), iteams));
                assistInfo.currAssistTeams = iteams;
                continue;
            }
            if (action instanceof DetachAssistants) {
                addDetachTeams.run();
                continue;
            }
            if (action instanceof AbandonOccTargets) {
                AbandonOccTargets aol = (AbandonOccTargets)action;
                AbandonOccTargetsGoal.Which which = AbandonOccTargetsGoal.Which.values()[aol.get(AbandonOccTargets.WHICH).ordinal()];
                goalBuilder.add(new AbandonOccTargetsGoal(which));
                continue;
            }
            if (action instanceof AssistOccupants) {
                addDetachTeams.run();
                AssistOccupants ao = (AssistOccupants)action;
                inferno.data2.ai.AssistedEvacTeam iteam = maps.aeTeamMap.get(ao.get(AssistOccupants.TEAM));
                assert (iteam != null);
                ClientAwareness awareness = ao.get(AssistOccupants.CLIENT_AWARENESS);
                Set<ANode> rooms = Collections.emptySet();
                if (awareness == ClientAwareness.ROOMS) {
                    rooms = new LinkedIdentityHashSet();
                    for (IEgressOccupiable room : ao.get(AssistOccupants.ROOMS)) {
                        ANode node;
                        if (!room.isEnabled() || (node = maps.nodeMap.get(room)) == null) continue;
                        rooms.add(node);
                    }
                }
                double radius = Double.POSITIVE_INFINITY;
                if (awareness == ClientAwareness.LINE_OF_SIGHT) {
                    radius = ao.get(AssistOccupants.AWARENESS_RADIUS).getValue(LENGTH_UNIT);
                }
                goalBuilder.add(new AssistOccupantsGoal(iteam, awareness, rooms, radius));
                continue;
            }
            if (action instanceof ChangeBehavior) {
                ChangeBehavior changeBehavior = (ChangeBehavior)action;
                IUrn<Behavior> behaviorUrn = changeBehavior.get(ChangeBehavior.PROP_BEHAVIOR_DIST);
                Map<Behavior, Double> behaviorWeights = behaviorUrn.getWeights();
                LinkedIdentityHashMap simBehaviorWeights = new LinkedIdentityHashMap();
                assert (behaviorWeights.entrySet().stream().allMatch(e -> maps.behaviorMap.get(e.getKey()) != null));
                behaviorWeights.forEach((k, v) -> simBehaviorWeights.put(maps.behaviorMap.get(k), v));
                goalBuilder.add(new ChangeBehaviorGoal(UrnUtil.newUrn(simBehaviorWeights)));
                continue;
            }
            if (action instanceof ChangeProfile) {
                ChangeProfile changeProfile = (ChangeProfile)action;
                Map<OccProfile, Double> weights = changeProfile.get(ChangeProfile.PROP_PROFILE_DIST).getWeights();
                LinkedIdentityHashMap simProfileWeights = new LinkedIdentityHashMap();
                assert (weights.entrySet().stream().allMatch(e -> maps.profilesMap.get(e.getKey()) != null));
                weights.forEach((k, v) -> simProfileWeights.put(maps.profilesMap.get(k), v));
                goalBuilder.add(new ChangeProfileGoal(ChangeProfileGoal.UI_PROP_FILTER, UrnUtil.newUrn(simProfileWeights)));
                continue;
            }
            if (action instanceof ChangeProfileProp) {
                cpp = (ChangeProfileProp)action;
                uiProp = ((ChangeProfileProp)cpp).getProp();
                assert (uiProp != null);
                simPropsMap = OccProfileSim.PROFILE_PROPS_MAP;
                simProp = simPropsMap.get(uiProp.getKey());
                assert (simProp instanceof OccProfileSim.IOccProp);
                OccProfileSim.IOccProp simOccProp = (OccProfileSim.IOccProp)((Object)simProp);
                Object uiVal = cpp.get(uiProp.asProp());
                Optional<Nullable<?>> simVal = InfernoUtil.convertProfileProp(maps.vehicles, maps.compRestrictions, maps.attrSuscp, tags, (IPropertySet.Prop)((Object)uiProp), simProp, uiVal);
                if (!simVal.isPresent()) continue;
                goalBuilder.add(new SetOccPropGoal(simOccProp, simVal.get().val));
                continue;
            }
            if (action instanceof CreateAttractor) {
                CreateAttractor createAttractor = (CreateAttractor)action;
                attractors = createAttractor.getAttractors().stream().map(maps.attractors::get).collect(Collectors.toList());
                CreateAttractorGoal.LocationMode locationMode = CreateAttractorGoal.LocationMode.values()[createAttractor.getLocation().ordinal()];
                TriPoint fixedLocation = null;
                if (locationMode == CreateAttractorGoal.LocationMode.FIXED_LOCATION) {
                    Point3d location = createAttractor.getFixedLocation();
                    Tri tri = kb.getMesh().getTri(location);
                    if (tri == null) {
                        errors.add(new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("The target location for \"%s\" could not be found on the navigation mesh."), createAttractor.getName()), Intl.intl("The navigation mesh may not have triangulated correctly or\nthe location may need to be moved."), createAttractor));
                    }
                    fixedLocation = new TriPoint(tri, location);
                }
                goalBuilder.add(new CreateAttractorGoal(attractors, locationMode, fixedLocation));
                continue;
            }
            if (action instanceof DestroyAttractor) {
                DestroyAttractor destroyAttractor = (DestroyAttractor)action;
                attractors = destroyAttractor.getAttractors().stream().map(maps.attractors::get).collect(Collectors.toList());
                goalBuilder.add(new DestroyAttractorGoal(attractors));
                continue;
            }
            if (action instanceof RevertProfileProp) {
                cpp = (RevertProfileProp)action;
                uiProp = cpp.get(RevertProfileProp.PROFILE_PROP);
                assert (uiProp != null);
                simPropsMap = OccProfileSim.PROFILE_PROPS_MAP;
                simProp = simPropsMap.get(uiProp.getKey());
                assert (simProp instanceof OccProfileSim.IOccProp);
                OccProfileSim.IOccProp simOccProp = (OccProfileSim.IOccProp)((Object)simProp);
                goalBuilder.add(new SetOccPropToProfileGoal(simOccProp));
                continue;
            }
            if (action instanceof GotoQueue) {
                GotoQueue merlinGotoAction = (GotoQueue)action;
                if (merlinGotoAction.getQueues().size() == 1) {
                    QueueObject merlinTargetQueue = merlinGotoAction.getQueues().iterator().next();
                    QMetaQueue infernoTargetQueue = maps.qMap.get(merlinTargetQueue);
                    goalBuilder.add(new QueueGoal(infernoTargetQueue));
                    continue;
                }
                LinkedIdentityHashSet<QBaseQueue> targetQs = new LinkedIdentityHashSet<QBaseQueue>();
                for (QueueObject qo : merlinGotoAction.getQueues()) {
                    targetQs.add(maps.qMap.get(qo));
                }
                Iterator<Tag> key = new MetaQueueHasher(targetQs);
                QMetaQueue meta = maps.metaQMap.computeIfAbsent((MetaQueueHasher)((Object)key), k -> {
                    QMetaQueue mq = new QMetaQueue(QMetaQueue.QBalancingType.TIME, null);
                    mq.addChildren(k.queues);
                    kb.addMetaQueue(mq);
                    return mq;
                });
                goalBuilder.add(new QueueGoal(meta));
                continue;
            }
            if (action instanceof RemoveOcc) {
                goalBuilder.add(RemoveSelfGoal.INSTANCE);
                continue;
            }
            if (action instanceof ResumePrior) continue;
            if (action instanceof ChangeTags) {
                ChangeTags ct = (ChangeTags)action;
                targetTags = new LinkedIdentityHashSet<inferno.data2.Tag>(ct.get(ChangeTags.TAGS).size());
                for (Tag tag2 : ct.get(ChangeTags.TAGS)) {
                    targetTags.add(tags.getTag(tag2));
                }
                switch (ct.get(ChangeTags.OPERATION)) {
                    case ADD: {
                        goalBuilder.add(new ChangeTagGoal(ChangeTagGoal.Op.TAG, targetTags));
                        break;
                    }
                    case REMOVE: {
                        goalBuilder.add(new ChangeTagGoal(ChangeTagGoal.Op.UNTAG, targetTags));
                        break;
                    }
                    case SET: {
                        goalBuilder.add(new SetTagGoal(targetTags));
                    }
                }
                continue;
            }
            if (action instanceof LookAt) {
                LookAt la = (LookAt)action;
                targetTags = new LinkedIdentityHashSet(la.get(LookAt.PROP_TAGS).size());
                for (Tag tag2 : la.get(LookAt.PROP_TAGS)) {
                    targetTags.add(tags.getTag(tag2));
                }
                ITargetPtSupplier.BasicTaggedOccSupplier occChooser = new ITargetPtSupplier.BasicTaggedOccSupplier(targetTags, InfernoUtil.convertEnumSameName(la.get(LookAt.PROP_TAG_LOGIC), ITargetPtSupplier.BasicTaggedOccSupplier.Logic.class), InfernoUtil.convertEnumSameName(la.get(LookAt.PROP_DIST_PREF), ITargetPtSupplier.BasicTaggedOccSupplier.DistancePref.class));
                LookAtGoal goal = new LookAtGoal(occChooser);
                goalBuilder.add(goal);
                continue;
            }
            if (action instanceof LookAhead) {
                goalBuilder.add(new LookAheadGoal());
                continue;
            }
            assert (false);
        }
        return goalBuilder.finishList();
    }

    private static <T1 extends Enum<T1>, T2 extends Enum<T2>> T2 convertEnumSameName(T1 v1, Class<T2> t2) {
        assert (t2.isEnum());
        return Enum.valueOf(t2, v1.name());
    }

    private static IEventTime convertWaitSrc(IWaitUntilSrc mWait) {
        return mWait.toSim();
    }

    private static ANode getNode(Map<IEgressComp, ANode> nodeMap, IEgressObj modComp) {
        ANode node = nodeMap.get(modComp);
        assert (node != null);
        return node;
    }

    private static Tri.Terrain mkTerrain(IEgressComp comp) {
        if (comp instanceof EgressStair) {
            return Tri.Terrain.STAIR;
        }
        if (comp instanceof EgressCorridor) {
            return Tri.Terrain.RAMP;
        }
        return Tri.Terrain.OPEN;
    }

    private static void addSecurityCameras(MerlinData md, KB kb, Map<Camera, Integer> camIdMap) {
        int id = 0;
        for (Camera cam : md.cameras.getDeepMembers(Camera.class)) {
            double fov;
            if (!cam.get(Camera.PROP_SECURITY).booleanValue()) continue;
            inferno.data2.Camera icam = new inferno.data2.Camera(id);
            String name = InfernoUtil.getPathName(md, md.cameras, cam, false);
            icam.set(inferno.data2.Camera.PROP_NAME, name);
            CameraRecord cr = cam.getCameraState();
            Camera.Type itype = null;
            if (cr.frustum instanceof OrthoCamera.FrustumRecord) {
                itype = Camera.Type.ORTHO;
                fov = ((OrthoCamera.FrustumRecord)cr.frustum).worldHeight;
            } else {
                itype = Camera.Type.PERSPECTIVE;
                fov = ((PerspectiveCamera.FrustumRecord)cr.frustum).fov;
            }
            icam.set(inferno.data2.Camera.PROP_TYPE, itype);
            icam.set(inferno.data2.Camera.PROP_LOC, cr.loc);
            icam.set(inferno.data2.Camera.PROP_REF, cr.ref);
            icam.set(inferno.data2.Camera.PROP_UP, cr.up);
            icam.set(inferno.data2.Camera.PROP_ZOOM, cr.zoom);
            icam.set(inferno.data2.Camera.PROP_ZOOM_LOC, cr.zoomLoc);
            icam.set(inferno.data2.Camera.PROP_FOV, fov);
            InfernoUtil.copyProps(cam, icam, Camera.PROP_SECURITY, inferno.data2.Camera.PROP_SECURITY);
            InfernoUtil.copyPTZProps(cam, icam, Camera.PROP_PAN_INFO, inferno.data2.Camera.PROP_PAN_INFO);
            InfernoUtil.copyPTZProps(cam, icam, Camera.PROP_TILT_INFO, inferno.data2.Camera.PROP_TILT_INFO);
            InfernoUtil.copyPTZProps(cam, icam, Camera.PROP_ZOOM_INFO, inferno.data2.Camera.PROP_ZOOM_INFO);
            InfernoUtil.copyProps(cam, icam, Camera.PROP_PTZ_ORIENT, inferno.data2.Camera.PROP_PTZ_ORIENT);
            kb.addCamera(icam);
            camIdMap.put(cam, id);
            ++id;
        }
    }

    private static <T> void copyProps(IMerlinObj set1, IPropertySet set2, TypedProp<T> set1Prop, IPropertySet.Prop<T> set2Prop) {
        set2.set(set2Prop, set1.get(set1Prop));
    }

    private static void copyPTZProps(IMerlinObj set1, IPropertySet set2, TypedProp<Camera.PTZSpec> set1Prop, IPropertySet.Prop<Camera.PTZSpec> set2Prop) {
        Camera.PTZSpec spec = set1.get(set1Prop);
        set2.set(set2Prop, new Camera.PTZSpec(spec.rangeMin, spec.rangeMax, spec.maxSpeed));
    }

    private static void addBlockages(KB kb, MeshBuilder mb, Map<IMaterial, inferno.data2.Material> matMap, IMerlinDispProps dispProps, ToIntFunction<MeshBuilder.MTri> getTriIx, EgressBlockage eblockage, List<MeshBuilder.MTri> tris) {
        int[] triids = new int[tris.size()];
        for (int m = 0; m < tris.size(); ++m) {
            triids[m] = getTriIx.applyAsInt(tris.get(m));
        }
        int id = kb.getBlockages().size();
        Material tex = null;
        Color color = Color.WHITE;
        long cadGeomId = -1L;
        switch (eblockage.getDisplayType()) {
            case CAD_GEOM: {
                cadGeomId = eblockage.getResultsId();
                break;
            }
            case SIMPLE: {
                IPrimProps props = eblockage.getRoomFaceProps(dispProps);
                color = props.getColor();
                tex = (Material)props.getMaterial();
                break;
            }
        }
        float[] cc = new float[4];
        color.getComponents(cc);
        Color4f color4f = new Color4f(cc[0], cc[1], cc[2], cc[3]);
        inferno.data2.Material imat = tex != null ? matMap.get(tex) : null;
        merlin.data.egress.geom.SpeedModifier smod = eblockage.getSpeedModifier();
        boolean preventOccPlacement = eblockage.getPreventOccPlacement();
        Blockage iblockage = new Blockage(id, eblockage.getName(), eblockage.getResultsId(), triids, Blockage.DisplayType.values()[eblockage.getDisplayType().ordinal()], imat, color4f, cadGeomId, preventOccPlacement);
        kb.addBlockage(iblockage);
        boolean prevActive = false;
        for (DiscreteVariant.Entry<UnitDouble> ventry : VariantUtil.getDiscreteValues(smod.value, true)) {
            double t = ventry.t.getValue(SI.SECOND);
            SpeedModifier imod = InfernoUtil.toSpeedModifier(smod, (UnitDouble)ventry.val);
            boolean currActive = imod.isImpeding();
            if (prevActive && !currActive) {
                kb.addEvent(t, new EngineOp.RemoveBlockage(iblockage));
            }
            kb.addEvent(t, new EngineOp.SetBlockageSpeedModifier(iblockage, imod));
            if (!prevActive && currActive) {
                kb.addEvent(t, new EngineOp.AddBlockage(iblockage));
            }
            prevActive = currActive;
        }
    }

    private static void addAnimatedGeoms(MerlinData md, KB kb) {
        Predicate<ImportedGeom> filter = ig -> ig.get(MerlinData.ENABLED) != false && !ig.get(ImportedGeom.PROP_RESULTS_VISIBILITY).isAlways(true);
        for (ImportedGeom ig2 : md.sceneGeom.flatten(ImportedGeom.class, filter)) {
            AnimatedGeom ag = new AnimatedGeom(ig2.getName(), InfernoUtil.getPathName(md, md.sceneGeom, ig2, false), ig2.getResultsId());
            kb.addAnimatedGeom(ag);
            boolean prevVal = true;
            for (DiscreteVariant.Entry<Boolean> ventry : VariantUtil.getDiscreteValues(ig2.get(ImportedGeom.PROP_RESULTS_VISIBILITY), true)) {
                if (prevVal == (Boolean)ventry.val) continue;
                double t = ventry.t.get(SI.SECOND);
                kb.addEvent(t, new EngineOp.SetAnimatedGeomVisible(ag, (Boolean)ventry.val));
                prevVal = (Boolean)ventry.val;
            }
        }
    }

    private static void addEvents(KB kb, IEgressComp comp, ANode node) {
        if (comp instanceof IEgressOccupiable) {
            InfernoUtil.addSpeedModifierEvents(kb, (IEgressOccupiable)comp, node);
        }
        if (comp instanceof EgressDoor) {
            InfernoUtil.addDoorStateEvents(kb, (EgressDoor)comp, node);
        }
    }

    private static void addDoorStateEvents(KB kb, EgressDoor door, ANode node) {
        IVariant<EgressDoorDir> state = door.get(IEgressConnector.STATE);
        InfernoUtil.addComponentStateEvents(kb, node, state, doorDir -> door.adjustForDoor((EgressDoorDir)doorDir));
    }

    private static ITimeEstimate getComponentReopenTimeEst(List<DiscreteVariant.Entry<EgressDoorDir>> tableEntries, int from) {
        for (int i = from; i < tableEntries.size(); ++i) {
            DiscreteVariant.Entry<EgressDoorDir> ventry = tableEntries.get(i);
            if (ventry.val == EgressDoorDir.NONE) continue;
            return new ITimeEstimate.Specific(ventry.t.getValue(SI.SECOND));
        }
        return ITimeEstimate.FOREVER;
    }

    private static void addComponentStateEvents(KB kb, ANode node, IVariant<EgressDoorDir> state, Function<EgressDoorDir, Vector2d> adjustForDoor) {
        List<DiscreteVariant.Entry<EgressDoorDir>> tableEntries = VariantUtil.getDiscreteValues(state, true);
        for (int i = 0; i < tableEntries.size(); ++i) {
            DiscreteVariant.Entry<EgressDoorDir> ventry = tableEntries.get(i);
            EngineOp.SetDoorState op = null;
            switch ((EgressDoorDir)ventry.val) {
                case ALL: {
                    if (!theUtil.gt0(ventry.t.get(SI.SECOND), 0.0)) break;
                    op = EngineOp.SetDoorState.openDoor(node);
                    break;
                }
                case NONE: {
                    ITimeEstimate estReopen = InfernoUtil.getComponentReopenTimeEst(tableEntries, i + 1);
                    op = EngineOp.SetDoorState.closeDoor(node, estReopen);
                    break;
                }
                case EAST: 
                case WEST: 
                case NORTH: 
                case SOUTH: {
                    op = EngineOp.SetDoorState.openAndSetDirection(node, adjustForDoor.apply((EgressDoorDir)ventry.val));
                }
            }
            if (op == null) continue;
            kb.addEvent(ventry.t.getValue(SI.SECOND), op);
        }
    }

    private static void addSpeedModifierEvents(KB kb, IEgressOccupiable comp, ANode node) {
        List<Tri> mesh = node.getMesh();
        if (mesh.isEmpty()) {
            return;
        }
        PropValue<merlin.data.egress.geom.SpeedModifier> modObj = comp.getWithDetails(IEgressOccupiable.SPEED_MODIFIER);
        if (modObj.isEmptyOrNull()) {
            return;
        }
        merlin.data.egress.geom.SpeedModifier modifier = modObj.get();
        List<DiscreteVariant.Entry<UnitDouble>> vals = VariantUtil.getDiscreteValues(modifier.value, true);
        for (int m = 0; m < vals.size(); ++m) {
            DiscreteVariant.Entry<UnitDouble> entry = vals.get(m);
            double t = entry.t.getValue(SI.SECOND);
            SpeedModifier iModifier = InfernoUtil.toSpeedModifier(modifier, (UnitDouble)entry.val);
            if (m == 0 && iModifier.equals(SpeedModifier.IDENTITY)) continue;
            kb.addEvent(t, new EngineOp.SetSpeedModifier(node, iModifier));
        }
    }

    private static SpeedModifier toSpeedModifier(merlin.data.egress.geom.SpeedModifier smod, UnitDouble val) {
        return new SpeedModifier(smod.type.itype, val.getValue(SIUS.unit(smod.type.valueUnitType)));
    }

    public static InfernoGeomBuilder[] constructMeshes(ITaskProgress progress, MerlinData md, List<InfernoGeom> igeoms, List<SimError> errors) {
        UnitDouble maxWidth = new UnitDouble(0.0, SI.METER);
        for (EgressAgent occ : MerlinUtil.getEnabledMembers(md, md.agents, EgressAgent.class, true)) {
            progress.check();
            UnitDouble width = InfernoUtil.getOccWidth(occ);
            if (width.compareTo(maxWidth) <= 0) continue;
            maxWidth = width;
        }
        for (OccSourceObj occSource : MerlinUtil.getEnabledMembers(md, md.occSources, OccSourceObj.class, true)) {
            progress.check();
            UnitDouble occSourceWidth = occSource.getMaxWidth();
            if (occSourceWidth.compareTo(maxWidth) <= 0) continue;
            maxWidth = occSourceWidth;
        }
        InfernoGeomBuilder.Param refineParams = md.simParams.getMeshBuilderParams();
        return InfernoGeomBuilder.constructMeshes(progress, igeoms, errors, maxWidth.getValue(SI.METER) * 0.5, refineParams);
    }

    private static class TagGenerator {
        public final Map<String, inferno.data2.Tag> tags = new LinkedHashMap<String, inferno.data2.Tag>();
        private final Map<String, PredefTags> d_uiTags = new LinkedHashMap<String, PredefTags>();
        private final Set<inferno.data2.Tag> d_committedToKb = new IdentityHashSet<inferno.data2.Tag>();
        private static final Function<String, inferno.data2.Tag> s_newTag = name -> new inferno.data2.Tag((String)name, (String)name, EnumSet.of(Tag.Options.CLEARABLE));

        public TagGenerator(KB kb) {
            for (PredefTag predefTag : PredefTag.values()) {
                inferno.data2.Tag tag = kb.getPredefTag(predefTag);
                this.add(tag);
            }
            for (Enum enum_ : PredefTags.values()) {
                this.d_uiTags.put(((PredefTags)enum_).name, (PredefTags)enum_);
                if (!((PredefTags)enum_).includeIfUnused) continue;
                this.getTag((PredefTags)enum_);
            }
        }

        public void add(inferno.data2.Tag tag) {
            this.tags.put(tag.name, tag);
        }

        public inferno.data2.Tag getTag(PredefTag tag) {
            return this.tags.get(tag.name);
        }

        public inferno.data2.Tag getTag(Tag tag) {
            return this.getTag(tag.getName());
        }

        public inferno.data2.Tag getTag(PredefTags tag) {
            return this.tags.computeIfAbsent(tag.name, n -> new inferno.data2.Tag(tag.name, tag.desc, inferno.data2.Tag.NO_OPTIONS));
        }

        public inferno.data2.Tag getTag(String name) {
            PredefTags pre = this.d_uiTags.get(name);
            if (pre != null) {
                return this.getTag(pre);
            }
            return this.tags.computeIfAbsent(name, s_newTag);
        }

        public void commitToKb(KB kb) {
            Collection newTags = this.tags.values().stream().filter(Predicates.and(t -> !t.isPredefined(), Filters.reject(this.d_committedToKb))).collect(Collectors.toList());
            kb.addTags(newTags);
            this.d_committedToKb.addAll(newTags);
        }
    }

    public static class InfernoGeomInfo {
        public final List<InfernoGeom> igeoms = new ArrayList<InfernoGeom>();
        public final Map<IEgressComp, List<InfernoGeom>> finalComps = new LinkedIdentityHashMap<IEgressComp, List<InfernoGeom>>();
    }

    private static class GoalObjMaps {
        public final Map<IEgressComp, ANode> nodeMap;
        public final Map<Elevator, inferno.elevator.Elevator> elevatorMap;
        public final Map<Floor, Integer> floorIDMap;
        public final Map<AssistedEvacTeam, inferno.data2.ai.AssistedEvacTeam> aeTeamMap;
        public final Map<Behavior, BehaviorSim> behaviorMap;
        public final Map<OccProfile, OccProfileSim> profilesMap;
        public final Map<QueueObject, QBaseQueue> qMap;
        public final Map<MetaQueueHasher, QMetaQueue> metaQMap;
        public final Map<merlin.data.egress.agents.OccTarget, OccTarget> occTargets;
        public final Map<Attractor, AttractorSim> attractors;
        public final Map<VehicleShape, VehicleBody> vehicles;
        public final Map<OccProfile.CompRestrictions, OccProfileSim.CompRestrictions> compRestrictions;
        public final Map<ObjsFilter<Attractor>, Predicate<AttractorSim>> attrSuscp;

        public GoalObjMaps(Map<IEgressComp, ANode> nodeMap, Map<Elevator, inferno.elevator.Elevator> elevatorMap, Map<Floor, Integer> floorIDMap, Map<AssistedEvacTeam, inferno.data2.ai.AssistedEvacTeam> aeTeamMap, Map<QueueObject, QBaseQueue> qMap, Map<merlin.data.egress.agents.OccTarget, OccTarget> occTargets, Map<Attractor, AttractorSim> attractors, Map<VehicleShape, VehicleBody> vehicles, Map<OccProfile.CompRestrictions, OccProfileSim.CompRestrictions> compRestrictions, Map<ObjsFilter<Attractor>, Predicate<AttractorSim>> attrSuscp, Map<Behavior, BehaviorSim> behaviors, Map<OccProfile, OccProfileSim> profiles) {
            this.nodeMap = nodeMap;
            this.elevatorMap = elevatorMap;
            this.floorIDMap = floorIDMap;
            this.aeTeamMap = aeTeamMap;
            this.profilesMap = profiles;
            this.qMap = qMap;
            this.occTargets = occTargets;
            this.attractors = attractors;
            this.vehicles = vehicles;
            this.compRestrictions = compRestrictions;
            this.attrSuscp = attrSuscp;
            this.behaviorMap = behaviors;
            this.metaQMap = new HashMap<MetaQueueHasher, QMetaQueue>();
        }
    }

    public static class KBInfo {
        public final KB kb;
        public final Map<IEgressComp, ANode> nodeMap;
        public final InfernoGeomInfo igeoms;
        public final Collection<QueueObject> queueList;
        public final Collection<Attractor> attractorList;

        public KBInfo(KB kb, Map<IEgressComp, ANode> nodeMap, InfernoGeomInfo igeoms, Collection<QueueObject> queueList, Collection<Attractor> attractorList) {
            this.kb = kb;
            this.nodeMap = nodeMap;
            this.igeoms = igeoms;
            this.queueList = queueList;
            this.attractorList = attractorList;
        }
    }

    private static class GoalBuilder {
        private ArrayList<IGoal> goals = new ArrayList();
        private final Map<IGoal, IGoal> goalCache = new LinkedHashMap<IGoal, IGoal>();

        private GoalBuilder() {
        }

        public void add(IGoal goal) {
            IGoal existing = this.goalCache.putIfAbsent(goal, goal);
            if (existing == null) {
                existing = goal;
            }
            this.goals.add(existing);
        }

        public void newList() {
            this.goals = new ArrayList();
        }

        public List<IGoal> finishList() {
            this.goals.trimToSize();
            return this.goals;
        }
    }

    private static class PropGetter {
        public final EgressAgent agent;

        public PropGetter(EgressAgent agent) {
            this.agent = agent;
        }

        public double getCurved(IProfilePropDist<UnitDouble, ICurve> prop, Unit unit) {
            return this.agent.toOccValue(prop).getValue(unit);
        }
    }

    private static class AssistInfo {
        public Collection<inferno.data2.ai.AssistedEvacTeam> currAssistTeams = null;

        private AssistInfo() {
        }
    }

    private static class MetaQueueHasher {
        public final Set<QBaseQueue> queues;

        public MetaQueueHasher(Set<QBaseQueue> queues) {
            this.queues = queues;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(this.getClass())) {
                return false;
            }
            MetaQueueHasher hasher = (MetaQueueHasher)obj;
            return hasher.queues.equals(this.queues);
        }

        public int hashCode() {
            return 0xAF73298 ^ this.queues.hashCode();
        }
    }

    public static class InfernoGetter {
        KB kb;

        public void initKBForAStar(MerlinData md, List<Double> allRadii) {
            Param p = new Param("", "", "", "");
            this.kb = new KB(p);
            TagGenerator tags = new TagGenerator(this.kb);
            InfernoUtil.buildMesh(EmptyTaskProgress.INSTANCE, md, this.kb, tags, new ArrayList<SimError>(), new LinkedIdentityHashMap<IEgressComp, ANode>(), new HashMap<Elevator, inferno.elevator.Elevator>(), new HashMap<Floor, Integer>());
            this.kb.trimMeshes(p.max_trim_error, allRadii);
        }

        public Optional<Double> getPathLength(Point3d startPt, Point3d goalPt, double bodyRadius, double abortDist, MerlinData md) {
            Tri startTri = this.kb.getMesh().getTri(startPt);
            Tri goalTri = this.kb.getMesh().getTri(goalPt);
            if (startTri == null || goalTri == null) {
                return Optional.empty();
            }
            PathGen.PointGoal goal = new PathGen.PointGoal(new TriPoint(goalTri, goalPt));
            PathGen.IPathResult result = PathGen.getPath(this.kb.getMesh(), startTri, null, null, startPt, goal, bodyRadius, abortDist, Predicates.alwaysTrue(), null);
            if (!result.isSuccessful()) {
                return Optional.empty();
            }
            double pathLength = result.getLength();
            return Optional.of(pathLength);
        }

        public void updateClusteringDistancesParallel(List<CreateGroupsAction.SizeConstrainedKMeans.DataPoint> dataPoints) {
            block2: {
                MTListProcessor<CreateGroupsAction.SizeConstrainedKMeans.DataPoint> processor = new MTListProcessor<CreateGroupsAction.SizeConstrainedKMeans.DataPoint>(Engine.getNumProcThreads(), MTProcessor.Schedule.DYNAMIC, this.kb.getThreadPool());
                processor.setList(dataPoints);
                try {
                    processor.process(new MTProcessor.IProc<CreateGroupsAction.SizeConstrainedKMeans.DataPoint>(this){

                        @Override
                        public void process(CreateGroupsAction.SizeConstrainedKMeans.DataPoint dataPoint, int threadNum, int ix) {
                            dataPoint.updateDistances();
                        }
                    });
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof CancellationException) break block2;
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
        }

        public void verifyClusters(Collection<CreateGroupsAction.SizeConstrainedKMeans.Cluster> clusters, final Function<CreateGroupsAction.SizeConstrainedKMeans.Cluster, Boolean> verifyCluster, final Set<CreateGroupsAction.SizeConstrainedKMeans.Cluster> toRemove) {
            block2: {
                MTListProcessor<CreateGroupsAction.SizeConstrainedKMeans.Cluster> processor = new MTListProcessor<CreateGroupsAction.SizeConstrainedKMeans.Cluster>(Engine.getNumProcThreads(), MTProcessor.Schedule.DYNAMIC, this.kb.getThreadPool());
                processor.setList(new ArrayList<CreateGroupsAction.SizeConstrainedKMeans.Cluster>(clusters));
                try {
                    processor.process(new MTProcessor.IProc<CreateGroupsAction.SizeConstrainedKMeans.Cluster>(){

                        @Override
                        public void process(CreateGroupsAction.SizeConstrainedKMeans.Cluster c, int threadNum, int ix) {
                            if (!((Boolean)verifyCluster.apply(c)).booleanValue()) {
                                toRemove.add(c);
                            }
                        }
                    });
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof CancellationException) break block2;
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }
}

