/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import merlin.actions.ChangeGroupAction;
import merlin.actions.Delete;
import merlin.actions.NewFloor;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.FloorSort;
import merlin.data.egress.geom.IEgressComp;
import merlin.geom.Geometry;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.AABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class FloorSortActions {
    public static Collection<IEgressComp> getSortableObjs(final MerlinData md, Collection<? extends IMerlinObj> objs) {
        return MerlinUtil.flatten(objs, IEgressComp.class, new Predicate<IEgressComp>(){

            @Override
            public boolean test(IEgressComp o) {
                return md.hierarchy.isDescendent(md.floors, o);
            }
        });
    }

    public static void updateComponentFloors(MerlinData md, Collection<? extends IEgressComp> comps) {
        if (!md.floorSortOptions.get(FloorSort.AUTO_SELECT_FLOOR).booleanValue()) {
            return;
        }
        for (IEgressComp iEgressComp : comps) {
            FloorSortActions.chooseFloor(md, iEgressComp);
        }
        FloorSortActions.resortComponents(md, comps, md.floors.getMembers(Floor.class));
    }

    public static void resortComponents(MerlinData md, Collection<? extends IEgressComp> components, Collection<? extends Floor> allowedFloors) {
        if (components.isEmpty() || allowedFloors.isEmpty()) {
            return;
        }
        Set<Object> floors = allowedFloors instanceof Set ? (Set<Object>)allowedFloors : new IdentityHashSet<Floor>(allowedFloors);
        components = new ArrayList<IEgressComp>(components);
        LinkedIdentityHashMap groupMap = new LinkedIdentityHashMap();
        LinkedIdentityHashMap<Composite, List> moves = new LinkedIdentityHashMap<Composite, List>();
        for (IEgressComp iEgressComp : components) {
            Floor desiredFloor = FloorSortActions.findFloor(md, iEgressComp);
            if (!floors.contains(desiredFloor) || FloorSortActions.getParentFloor(md, iEgressComp) == desiredFloor) continue;
            Composite<?> moveToGroup = FloorSortActions.getMoveToGroup(md, desiredFloor, iEgressComp, groupMap);
            moves.computeIfAbsent(moveToGroup, g -> new ArrayList()).add(iEgressComp);
        }
        for (Map.Entry entry : moves.entrySet()) {
            ChangeGroupAction.move(md, (Collection)entry.getValue(), (Composite)entry.getKey(), ((Composite)entry.getKey()).getChildren().size());
        }
        LinkedIdentityHashSet delGroups = new LinkedIdentityHashSet();
        for (Pair oldGroup : groupMap.keySet()) {
            if (!((Composite)oldGroup.v2).isEmpty()) continue;
            delGroups.add((Composite)oldGroup.v2);
        }
        Delete.headlessDelete(md, delGroups, true);
    }

    private static Floor getParentFloor(MerlinData md, Object comp) {
        Object parent = md.hierarchy.getParent(comp);
        while (parent != null && !(parent instanceof Floor)) {
            parent = md.hierarchy.getParent(parent);
        }
        return (Floor)parent;
    }

    private static Composite<?> getMoveToGroup(MerlinData md, Floor newFloor, IMerlinObj obj, Map<Pair<Floor, Composite<?>>, Composite<?>> groupMap) {
        Object[] path = md.hierarchy.getPath(obj);
        Composite currGroup = newFloor;
        boolean replicatingGroups = false;
        for (int m = 0; m < path.length - 1; ++m) {
            Object oldParent = path[m];
            if (!replicatingGroups) {
                replicatingGroups |= oldParent instanceof Floor;
                continue;
            }
            Composite oldGroup = (Composite)oldParent;
            Composite<?> newGroup = FloorSortActions.getNewGroup(md, newFloor, currGroup, oldGroup, groupMap);
            assert (newGroup != null);
            currGroup = newGroup;
        }
        return currGroup;
    }

    private static Composite<?> getNewGroup(MerlinData md, Floor newFloor, Composite<?> parent, Composite<?> oldGroup, Map<Pair<Floor, Composite<?>>, Composite<?>> groupMap) {
        Composite<?> newGroup = groupMap.get(new Pair(newFloor, oldGroup));
        if (newGroup == null) {
            newGroup = FloorSortActions.findGroup(parent, oldGroup.getName());
            if (newGroup == null) {
                newGroup = new GeomComposite(oldGroup.getName());
                Undo.insertUndoEntry_delete(md, parent, newGroup);
                parent.add(newGroup);
            }
            groupMap.put(new Pair(newFloor, oldGroup), newGroup);
        }
        return newGroup;
    }

    private static Composite<?> findGroup(Composite<?> parent, String name) {
        Collection<Composite> members = parent.getMembers(Composite.class);
        for (Composite member : members) {
            if (!member.getName().equals(name)) continue;
            return member;
        }
        return null;
    }

    public static Composite<?> chooseGroup(MerlinData md, IEgressComp comp) {
        Floor floor = FloorSortActions.chooseFloor(md, comp);
        if (floor == FloorSortActions.getParentFloor(md, comp)) {
            return (Composite)md.hierarchy.getParent(comp);
        }
        return floor.getWorkingGeomGroup();
    }

    public static Floor chooseFloor(MerlinData md, IEgressComp comp) {
        AABox bounds;
        if (md.floorSortOptions.get(FloorSort.AUTO_SELECT_FLOOR).booleanValue() && (bounds = comp.getBounds()).isValid()) {
            UnitDouble z = new UnitDouble(bounds.getMinZ(), Geometry.LENGTH_UNIT);
            return FloorSortActions.chooseFloor(md, z);
        }
        Floor existing = FloorSortActions.getParentFloor(md, comp);
        if (existing != null) {
            return existing;
        }
        return md.activeFloor();
    }

    public static Floor chooseFloor(MerlinData md, UnitDouble z) {
        if (!md.floorSortOptions.get(FloorSort.AUTO_SELECT_FLOOR).booleanValue()) {
            return md.activeFloor();
        }
        Floor[] surrFloors = md.floors.getSurroundingFloors(z);
        z = FloorSortActions.calcFloorLoc(md, surrFloors, z);
        if (FloorSortActions.isEmptyModel(md)) {
            Undo.insertUndoEntry_propRestore(md, Arrays.asList(md.floors.getActive()), Floor.WORKING_Z);
            md.floors.getActive().setWorkingZ(z);
            return md.floors.getActive();
        }
        if (FloorSortActions.shouldCreateNewFloor(md, z, surrFloors)) {
            return NewFloor.createFloor(md, z, false, false);
        }
        return FloorSortActions.findFloor(surrFloors);
    }

    private static boolean isEmptyModel(MerlinData md) {
        return FloorSortActions.hasExactlyOneDescendent(md.floors, IMerlinObj.class) && md.floors.getActive().getWorkingZ().equals(new UnitDouble(0.0, SI.METER));
    }

    private static boolean hasExactlyOneDescendent(Composite<?> c, Class<?> type) {
        Iterator<?> it = c.getDeepMembers(type).iterator();
        if (!it.hasNext()) {
            return false;
        }
        it.next();
        return !it.hasNext();
    }

    private static boolean shouldCreateNewFloor(MerlinData md, UnitDouble z, Floor[] surrFloors) {
        if (md.floorSortOptions.get(FloorSort.AUTO_CREATE_FLOOR).booleanValue()) {
            if (surrFloors[0] == null) {
                return true;
            }
            double minDist = md.floorSortOptions.get(FloorSort.MIN_AUTO_FLOOR_DIST).getValue(Geometry.LENGTH_UNIT);
            for (Floor floor : surrFloors) {
                double dist;
                if (floor == null || !theUtil.lt(dist = floor.getWorkingZ().diff(z).getValue(Geometry.LENGTH_UNIT), minDist, 1.0E-6)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static UnitDouble calcFloorLoc(MerlinData md, Floor[] surrFloors, UnitDouble zud) {
        double div;
        Floor baseFloor = FloorSortActions.findFloor(surrFloors);
        double z = zud.getValue(Geometry.LENGTH_UNIT);
        double baseZ = baseFloor.getWorkingZ().getValue(Geometry.LENGTH_UNIT);
        double dist = z - baseZ;
        double minDist = md.floorSortOptions.get(FloorSort.MIN_AUTO_FLOOR_DIST).getValue(Geometry.LENGTH_UNIT);
        double v2 = baseZ + minDist * Math.ceil(div = dist / minDist);
        if (theUtil.eq(z, v2, 1.0E-6)) {
            return new UnitDouble(v2, Geometry.LENGTH_UNIT);
        }
        double v1 = baseZ + minDist * Math.floor(div);
        return new UnitDouble(v1, Geometry.LENGTH_UNIT);
    }

    public static Floor findFloor(MerlinData md, UnitDouble z) {
        return FloorSortActions.findFloor(md.floors.getSurroundingFloors(z));
    }

    private static Floor findFloor(Floor[] surrFloors) {
        return surrFloors[0] != null ? surrFloors[0] : surrFloors[1];
    }

    public static Floor findFloor(MerlinData md, IEgressComp comp) {
        AABox bounds = comp.getBounds();
        if (!bounds.isValid()) {
            return md.activeFloor();
        }
        return FloorSortActions.findFloor(md, new UnitDouble(bounds.getMinZ(), Geometry.LENGTH_UNIT));
    }
}

