/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.data.AssistedEvacTeam;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.OccGroupTypeObj;
import merlin.data.animation.Animation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.scenario.Scenario;
import merlin.data.scenario.ScenarioUtil;
import merlin.gui.AnimationsDlg;
import merlin.gui.AssistedEvacTeamsDlg;
import merlin.gui.LibraryDlg;
import merlin.gui.ManagerDlg;
import merlin.gui.OccGroupTypesDlg;
import merlin.gui.ProfilesDlg;
import merlin.gui.ScenariosDlg;
import merlin.gui.VehicleShapesDlg;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TypedProp;

public class EditObjects<T extends IMerlinObj>
extends AMerlinOp {
    public static final UIHook UI_HOOK_PROFILE = new UIHook(new EditObjects<OccProfile>(OccProfile.PROP_NAME, md -> md.profiles, (mgr, obj) -> {
        ProfilesDlg dlg = new ProfilesDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
        dlg.init(MerlinApp.getApp().getData(), (ManagerDlg.IManager<OccProfile>)mgr, (OccProfile)obj);
        dlg.doModal();
    }, OccProfile.class), Intl.intl("Edit &Profiles..."), EntryPointFactory.occupantProfileIcon);
    public static final UIHook UI_HOOK_VEHICLE_SHAPE = new UIHook(new EditObjects<VehicleShape>(VehicleShape.PROP_NAME, md -> md.vehicleShapes, (mgr, obj) -> {
        VehicleShapesDlg dlg = new VehicleShapesDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getData(), MerlinApp.getApp().getUnitSystem());
        dlg.init(MerlinApp.getApp().getData(), (ManagerDlg.IManager<VehicleShape>)mgr, (VehicleShape)obj);
        dlg.doModal();
    }, VehicleShape.class), Intl.intl("Edit Vehicle Shapes..."), EntryPointFactory.vehicleIcon);
    public static final UIHook UI_HOOK_ASSISTED_EVAC_TEAM = new UIHook(new EditObjects<AssistedEvacTeam>(AssistedEvacTeam.PROP_NAME, md -> md.assistedEvacTeams, (mgr, obj) -> {
        AssistedEvacTeamsDlg dlg = new AssistedEvacTeamsDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
        dlg.init(MerlinApp.getApp().getData(), (CompositeManager<?>)mgr, (AssistedEvacTeam)obj);
        dlg.doModal();
    }, AssistedEvacTeam.class), Intl.intl("Edit Assisted Evacuation Teams..."), EntryPointFactory.assistedEvacTeamIcon);
    public static final UIHook UI_HOOK_OCC_GROUP_TYPES = new UIHook(new EditObjects<OccGroupTypeObj>(OccGroupTypeObj.NAME, md -> md.occGroupTypes, (mgr, obj) -> {
        OccGroupTypesDlg dlg = new OccGroupTypesDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
        dlg.init(MerlinApp.getApp().getData(), (CompositeManager<?>)mgr, (OccGroupTypeObj)obj);
        dlg.doModal();
    }, OccGroupTypeObj.class), Intl.intl("Edit Movement Group Templates..."), EntryPointFactory.occupantGroupIcon);
    public static final UIHook UI_HOOK_LIBRARIES = new UIHook(new EditObjects<OccProfile>(OccProfile.PROP_NAME, md -> md.profiles, (mgr, obj) -> {
        MerlinApp app = MerlinApp.getApp();
        assert (app != null);
        LibraryDlg dlg = new LibraryDlg(app.getMainFrame(), app, app.getData());
        dlg.doModal();
    }, OccProfile.class), Intl.intl("Edit Profile Libraries..."));
    public static final UIHook UI_HOOK_ANIMATIONS = new UIHook(new EditObjects<Animation>(NamedMerlinObj.NAME, md -> md.animations, (mgr, obj) -> {
        AnimationsDlg dlg = new AnimationsDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
        dlg.init(MerlinApp.getApp().getData(), (ManagerDlg.IManager<Animation>)mgr, (Animation)obj);
        dlg.doModal();
    }, Animation.class), Intl.intl("Manage Animation Database..."));
    public static final UIHook UI_HOOK_SCENARIOS = new UIHook(new EditObjects<Scenario>(NamedMerlinObj.NAME, md -> md.scenarios, (mgr, obj) -> {
        ScenariosDlg dlg = new ScenariosDlg(MerlinApp.getApp().getMainFrame());
        MerlinData md = MerlinApp.getApp().getData();
        dlg.init(md, (ManagerDlg.IManager<Scenario>)mgr, md.scenarios.getActive());
        dlg.doModal();
    }, Scenario.class), Intl.intl("Edit Scenarios...,-,Edit the model's scenarios."), EntryPointFactory.scenariosIcon);
    private TypedProp<String> d_propName;
    private Function<MerlinData, Composite<? super T>> d_getRoot;
    private BiConsumer<CompositeManager<T>, T> d_createDlg;
    private Class<T> d_clazz;

    public EditObjects(TypedProp<String> propName, Function<MerlinData, Composite<? super T>> getRoot, BiConsumer<CompositeManager<T>, T> createDlg, Class<T> clazz) {
        this.d_propName = propName;
        this.d_getRoot = getRoot;
        this.d_createDlg = createDlg;
        this.d_clazz = clazz;
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Composite<? super T> group = this.d_getRoot.apply(md);
        EditObjects.editObject(app, md, null, this.d_propName, group, this.d_createDlg, this.d_clazz);
    }

    public static <T extends IMerlinObj, TDlg extends ManagerDlg<?, ?>> void editObject(MerlinApp app, MerlinData md, T init, TypedProp<String> propName, Composite<? extends IMerlinObj> group, BiConsumer<CompositeManager<T>, T> createDlg, Class<T> clazz) {
        if (clazz.isAssignableFrom(Scenario.class)) {
            ScenarioManager mgr = new ScenarioManager(md, group);
            createDlg.accept(mgr, (ScenarioManager)((Object)init));
        } else {
            Comparator cmp = (o1, o2) -> {
                String n1 = (String)o1.get(propName);
                String n2 = (String)o2.get(propName);
                return n1.compareToIgnoreCase(n2);
            };
            CompositeManager<T> mgr = new CompositeManager<T>(md, group, cmp, clazz);
            createDlg.accept((CompositeManager<ScenarioManager>)mgr, (ScenarioManager)((Object)init));
        }
    }

    public static class ScenarioManager
    extends CompositeManager<Scenario> {
        public ScenarioManager(MerlinData md, Composite<?> objs) {
            super(md, objs, ScenarioUtil.SCENARIO_SORTER, Scenario.class);
        }
    }

    public static class CompositeManager<T extends IMerlinObj>
    implements ManagerDlg.IManager<T> {
        private Composite<?> d_objs;
        private Class<T> d_clazz;
        private Comparator<T> d_cmp;
        private Predicate<T> d_filter = Predicates.alwaysTrue();

        public CompositeManager(MerlinData md, Composite<?> objs, Comparator<T> cmp, Class<T> clazz) {
            this.d_objs = objs;
            this.d_clazz = clazz;
            this.d_cmp = cmp;
        }

        @Override
        public String describe(T obj) {
            String name = obj.getName();
            return name;
        }

        @Override
        public Collection<T> getSorted() {
            ArrayList<T> sorted = new ArrayList<T>(this.d_objs.flatten(this.d_clazz, this.d_filter));
            Collections.sort(sorted, this.d_cmp);
            return sorted;
        }

        @Override
        public int size() {
            int size = this.d_objs.flatten(this.d_clazz, this.d_filter).size();
            return size;
        }

        @Override
        public void filter(Predicate<T> filter) {
            this.d_filter = filter;
        }
    }
}

