/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.geom.IEgressOccupiable;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.util.LinkedIdentityHashSet;

public class ConvertToRoom {
    public static ConvertedRoom convertToRoom(IEgressOccupiable geom, boolean cloneIfRoom, Set<? extends IEgressOccupiable> mergeRooms) {
        if (geom instanceof EgressRoom) {
            EgressRoom room = cloneIfRoom ? (EgressRoom)geom.clone() : (EgressRoom)geom;
            return new ConvertedRoom(geom, room, Collections.EMPTY_LIST);
        }
        Model model = ConvertToRoom.getModel(geom);
        if (model == null || model.getFaces().isEmpty()) {
            return null;
        }
        EgressRoom room = new EgressRoom(geom.getName(), model);
        room.setColor(geom.getColor());
        room.setOpacity(geom.getOpacity());
        room.setVisible(geom.isVisible());
        ArrayList<IEgressConnector> exits = new ArrayList<IEgressConnector>();
        LinkedIdentityHashSet conns = new LinkedIdentityHashSet(2);
        geom.getConnectors(conns);
        for (IEgressConnector conn : conns) {
            if (!ConvertToRoom.includeDoor(conn, mergeRooms)) continue;
            exits.add(conn);
        }
        return new ConvertedRoom(geom, room, exits);
    }

    private static Model getModel(IEgressOccupiable geom) {
        Model model = geom.getModel().clone();
        int[] bndIDs = new int[]{1};
        for (Face face : model.getFaces()) {
            for (FaceLoop loop : face.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    if (eu.edge.partOfGroup(1) || eu.edge.faces.size() != 1 || face.getInternalEdges().contains(eu.edge)) continue;
                    eu.edge.groups = bndIDs;
                }
            }
        }
        return model;
    }

    private static boolean includeDoor(IEgressConnector conn, Set<? extends IEgressOccupiable> mergeRooms) {
        if (conn.isExit()) {
            return true;
        }
        for (IEgressOccupiable doorComp : conn.getConnectedComps()) {
            if (mergeRooms.contains(doorComp)) continue;
            return true;
        }
        return false;
    }

    public static class ConvertedRoom {
        public final IEgressOccupiable source;
        public final EgressRoom room;
        public final List<IEgressConnector> doors;

        public ConvertedRoom(IEgressOccupiable source, EgressRoom room, List<IEgressConnector> doors) {
            this.source = source;
            this.room = room;
            this.doors = doors;
        }
    }
}

