/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import common.io.FileUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JFrame;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.Version;
import merlin.actions.AMerlinOp;
import merlin.actions.InfernoUtil;
import merlin.actions.MerlinOp;
import merlin.actions.Pipe;
import merlin.actions.ResultsUtil;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.data.SimParams;
import merlin.data.scenario.ScenarioUtil;
import merlin.data.scenario.SimOutputDir;
import merlin.gui.guiUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.Application;
import thunderheadeng.scene3d.gui.RenderPrefs;
import thunderheadeng.util.Nullable;
import thunderheadeng.util.Win32Native;

public class Behemoth
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Behemoth(), Intl.intl("View &Results...") + ",-," + Intl.intl("View 3D Results"), guiUtil.loadMerlinIcon("pf_results_16.png"));
    private static final int s_commPort;
    private static final Map<String, ResultsProcess> s_runningBehemoths;

    private static File getDefaultFile(String filename) {
        if (filename != null) {
            File f = new File(filename);
            String rootFn = InfernoUtil.rootFn(f.getPath());
            return FileUtil.getResultsFn(f.getParentFile(), rootFn);
        }
        return null;
    }

    private static void getFileArg(String param, String file, List<String> args, boolean mustExist) {
        if (file != null && (!mustExist || new File(file).exists())) {
            args.add(param);
            args.add(file);
        }
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        if (md.filename == null) {
            Behemoth.runBehemoth(app, null, null);
        } else {
            try {
                List<ScenarioUtil.ScenarioVariationKey> keys = ScenarioUtil.streamVariations(md).toList();
                LinkedHashMap<ScenarioUtil.ScenarioVariationKey, SimOutputDir> dirs = new LinkedHashMap<ScenarioUtil.ScenarioVariationKey, SimOutputDir>();
                for (ScenarioUtil.ScenarioVariationKey key : keys) {
                    dirs.put(key, ScenarioUtil.getOutputDir(md, key.scenario(), key.variationIndex()));
                }
                Behemoth.runScenarioPicker(app, app.getActiveFrame(), keys, scenarioKeys -> ((ScenarioUtil.ScenarioVariationKey)scenarioKeys.iterator().next()).scenario().getName(), s -> (SimOutputDir)dirs.get(s), new ScenarioUtil.ScenarioVariationKey(md.scenarios.getActive(), 0, 1));
            }
            catch (IOException e) {
                Behemoth.runBehemoth(app, null, null);
            }
        }
    }

    public static void runScenarioPicker(MerlinApp app, Component parent, Collection<ScenarioUtil.ScenarioVariationKey> keys, Function<Collection<ScenarioUtil.ScenarioVariationKey>, String> formatScenario, Function<ScenarioUtil.ScenarioVariationKey, SimOutputDir> getOutputDir, ScenarioUtil.ScenarioVariationKey defScenario) {
        LinkedHashMap<String, List> nameToKeys = new LinkedHashMap<String, List>();
        for (ScenarioUtil.ScenarioVariationKey scenarioVariationKey : keys) {
            nameToKeys.compute(scenarioVariationKey.scenario().getName(), (name, scenarioKeys) -> {
                if (scenarioKeys == null) {
                    scenarioKeys = new ArrayList<ScenarioUtil.ScenarioVariationKey>();
                }
                scenarioKeys.add(scenarioVariationKey);
                return scenarioKeys;
            });
        }
        LinkedHashMap<ScenarioUtil.ScenarioVariationKey, List> keyToKeys = new LinkedHashMap<ScenarioUtil.ScenarioVariationKey, List>(nameToKeys.size());
        for (List keyList : nameToKeys.values()) {
            keyToKeys.put((ScenarioUtil.ScenarioVariationKey)keyList.getFirst(), keyList);
        }
        ScenarioUtil.ScenarioVariationKey scenarioVariationKey = ResultsUtil.pickScenario(app.getData(), parent, keyToKeys.keySet(), key -> (String)formatScenario.apply((Collection)keyToKeys.get(key)), defScenario, Intl.intl("Show results for scenario:"));
        if (scenarioVariationKey == null) {
            return;
        }
        SimOutputDir outDir = getOutputDir.apply(scenarioVariationKey);
        Optional<Nullable<File>> outputFile = ResultsUtil.promptLegacyFile(parent, outDir, dir -> dir.getResultsFile().toFile());
        if (outputFile.isPresent()) {
            File pfrFile = (File)outputFile.get().val;
            if (pfrFile == null) {
                Behemoth.runBehemoth(app, null, null);
            } else {
                if (pfrFile.toPath().equals(outDir.current.getResultsFile())) {
                    Behemoth.runBehemoth(app, pfrFile.toString(), outDir.current.visualizationFile().toString());
                }
                Behemoth.runBehemoth(app, pfrFile.toString(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runBehemoth(MerlinApp app, final String resultsPath, String visualizationPath) {
        Map<String, ResultsProcess> map = s_runningBehemoths;
        synchronized (map) {
            if (s_runningBehemoths.containsKey(resultsPath)) {
                ResultsProcess p = s_runningBehemoths.get(resultsPath);
                Integer pid = p.call(ClientCommand.GET_PID, Integer.class);
                if (pid != null) {
                    Win32Native.allowSetForegroundWindow(pid);
                    p.run(ClientCommand.REFRESH);
                }
                return;
            }
            Runtime rt = Runtime.getRuntime();
            try {
                boolean openInSocket = s_commPort != -1 && MerlinPrefs.getBoolean(MerlinPrefs.OPEN_RESULTS_THROUGH_SOCKET);
                ArrayList<String> args = new ArrayList<String>();
                args.add(Behemoth.getBehemothLoc());
                if (Application.isVerbose()) {
                    args.add("-debug");
                }
                File resultsFile = resultsPath != null && !resultsPath.isEmpty() ? new File(resultsPath) : null;
                File visFile = visualizationPath != null && !visualizationPath.isEmpty() ? new File(visualizationPath) : null;
                if (!openInSocket) {
                    if (visFile != null) {
                        Behemoth.getFileArg("-r", visFile.getPath(), args, false);
                    }
                    if (resultsFile != null) {
                        Behemoth.getFileArg("-r", resultsFile.getPath(), args, true);
                    }
                }
                args.add("-locale");
                args.add(Locale.getDefault().toString());
                JFrame mainFrame = MerlinApp.getApp().getMainFrame();
                Point loc = mainFrame.getLocationOnScreen();
                Dimension size = (mainFrame.getExtendedState() & 6) == 6 ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : mainFrame.getSize();
                args.add("-x");
                args.add(Integer.toString(loc.x));
                args.add("-y");
                args.add(Integer.toString(loc.y));
                args.add("-w");
                args.add(Integer.toString(size.width));
                args.add("-h");
                args.add(Integer.toString(size.height));
                int commId = (int)(Math.random() * 2.147483647E9);
                if (s_commPort != -1) {
                    args.add("-commport");
                    args.add(Integer.toString(s_commPort));
                    args.add("-commid");
                    args.add(Integer.toString(commId));
                }
                if (app.getPrefs().getSystemOverLocal(MerlinPrefs.GL_TRANSFER_TO_RESULTS).booleanValue()) {
                    for (RenderPrefs.ResultsGlTransferProps glProp : RenderPrefs.ResultsGlTransferProps.values()) {
                        glProp.addArgs(app.getPrefs(), args::add);
                    }
                }
                SimParams sp = null;
                try {
                    sp = app.getData().simParams;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                if (sp != null && sp.get(SimParams.WRITE_SOCIAL_DISTANCE).booleanValue()) {
                    try {
                        args.add("-social_distance");
                        args.add(Double.toString(sp.get(SimParams.SOCIAL_DISTANCE).get(SI.METER)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                System.out.println(args);
                final Process p = rt.exec(args.toArray(new String[args.size()]));
                Pipe oPipe = new Pipe(p.getInputStream(), System.out);
                new Thread(oPipe).start();
                Pipe ePipe = new Pipe(p.getErrorStream(), System.err);
                new Thread(ePipe).start();
                ResultsProcess process = new ResultsProcess(p, commId);
                if (openInSocket && resultsFile != null && resultsFile.exists()) {
                    process.onConnect(proc -> {
                        Integer pid = proc.call(ClientCommand.GET_PID, Integer.class);
                        if (pid != null) {
                            Win32Native.allowSetForegroundWindow(pid);
                        }
                        if (visFile != null) {
                            proc.openResultsAndVis(resultsFile, visFile);
                        } else {
                            proc.openFile(resultsFile);
                        }
                    });
                }
                s_runningBehemoths.put(resultsPath, process);
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            p.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Map<String, ResultsProcess> map = s_runningBehemoths;
                        synchronized (map) {
                            ResultsProcess proc = s_runningBehemoths.remove(resultsPath);
                            if (proc != null) {
                                proc.close();
                            }
                        }
                    }
                }.start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getBehemothLoc() {
        String installDir = Application.getApp().getInstallDir();
        String behemothLoc = ".";
        if (installDir != null) {
            behemothLoc = installDir;
        }
        LinkedHashSet<String> behemothNames = new LinkedHashSet<String>();
        behemothNames.add("PathfinderResults.exe");
        boolean debug = Application.isDebug();
        if (Version.is64Bit() && debug) {
            behemothNames.add("bin/x64/Debug/PathfinderResults/PathfinderResults_x64_Debug.exe");
        }
        if (Version.is64Bit() && !debug) {
            behemothNames.add("bin/x64/Release/PathfinderResults/PathfinderResults_x64_Release.exe");
        }
        if (!Version.is64Bit() && debug) {
            behemothNames.add("bin/x86/Debug/PathfinderResults/PathfinderResults_x86_Debug.exe");
        }
        if (!Version.is64Bit() && !debug) {
            behemothNames.add("bin/x86/Release/PathfinderResults/PathfinderResults_x86_Release.exe");
        }
        behemothNames.add("bin/x64/Debug/PathfinderResults/PathfinderResults_x64_Debug.exe");
        behemothNames.add("bin/x64/Release/PathfinderResults/PathfinderResults_x64_Release.exe");
        behemothNames.add("bin/x86/Debug/PathfinderResults/PathfinderResults_x86_Debug.exe");
        behemothNames.add("bin/x86/Release/PathfinderResults/PathfinderResults_x86_Release.exe");
        for (String behemothName : behemothNames) {
            File f = new File(behemothLoc, behemothName);
            if (!f.exists()) continue;
            System.out.println("Behemoth Loc: " + f.getAbsolutePath());
            return f.getAbsolutePath();
        }
        assert (false);
        return null;
    }

    static {
        s_runningBehemoths = new HashMap<String, ResultsProcess>();
        ClientListener clientListener = new ClientListener();
        s_commPort = clientListener.getCommPort();
        if (s_commPort != -1) {
            new Thread(clientListener).start();
        }
    }

    private static class ResultsProcess {
        public final Process process;
        public final int commId;
        public Socket resultsSocket;
        public DataOutputStream out;
        public DataInputStream in;
        public List<Consumer<ResultsProcess>> onConnect;

        public ResultsProcess(Process process, int commId) {
            this.process = process;
            this.commId = commId;
            this.onConnect = new ArrayList<Consumer<ResultsProcess>>();
            this.resultsSocket = null;
            this.out = null;
            this.in = null;
        }

        public synchronized void onConnect(Consumer<ResultsProcess> func) {
            if (this.resultsSocket != null) {
                func.accept(this);
            } else {
                this.onConnect.add(func);
            }
        }

        public synchronized boolean connect(Socket resultsSocket) {
            if (this.resultsSocket != null) {
                return false;
            }
            try {
                this.out = new DataOutputStream(new BufferedOutputStream(resultsSocket.getOutputStream()));
                this.in = new DataInputStream(resultsSocket.getInputStream());
                this.resultsSocket = resultsSocket;
                for (Consumer<ResultsProcess> proc : this.onConnect) {
                    proc.accept(this);
                }
                this.onConnect.clear();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.out = null;
                this.in = null;
                return false;
            }
            return true;
        }

        public synchronized void close() {
            if (this.resultsSocket != null) {
                try {
                    this.resultsSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.resultsSocket = null;
                this.out = null;
                this.in = null;
            }
        }

        public synchronized void run(ClientCommand method) {
            if (this.resultsSocket == null) {
                return;
            }
            try {
                this.out.writeInt(method.id);
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public synchronized void openFile(File file) {
            if (this.resultsSocket == null) {
                return;
            }
            if (!file.exists()) {
                return;
            }
            try {
                this.out.writeInt(ClientCommand.LOAD_RESULTS.id);
                this.out.writeUTF(file.getPath());
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public synchronized void openResultsAndVis(File resultsFile, File visFile) {
            if (this.resultsSocket == null) {
                return;
            }
            if (!resultsFile.exists()) {
                return;
            }
            try {
                this.out.writeInt(ClientCommand.LOAD_RESULTS_AND_VIS.id);
                this.out.writeUTF(resultsFile.getPath());
                this.out.writeUTF(visFile.getPath());
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public synchronized <T> T call(ClientCommand method, Class<T> returnType) {
            if (this.resultsSocket == null) {
                return null;
            }
            try {
                this.out.writeInt(method.id);
                this.out.flush();
                if (returnType.equals(Integer.class)) {
                    return (T)Integer.valueOf(this.in.readInt());
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    private static enum ClientCommand {
        REFRESH(0),
        GET_PID(1),
        LOAD_RESULTS(2),
        PREVIEW_FDS(3),
        LOAD_RESULTS_AND_VIS(4);

        public final int id;

        private ClientCommand(int id) {
            this.id = id;
        }
    }

    private static class ClientListener
    implements Runnable {
        private final int d_commPort;
        private final ServerSocket d_serverSkt;

        public ClientListener() {
            ServerSocket serverSkt = null;
            int commPort = -1;
            try {
                serverSkt = new ServerSocket(0, 0, InetAddress.getByName(null));
                commPort = serverSkt.getLocalPort();
            }
            catch (IOException e) {
                System.err.println("[0x23489f] Failed creating a ServerSocket for results refreshing.");
                e.printStackTrace();
            }
            this.d_serverSkt = serverSkt;
            this.d_commPort = commPort;
        }

        public int getCommPort() {
            return this.d_commPort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Socket clientSkt = this.d_serverSkt.accept();
                        DataInputStream din = new DataInputStream(clientSkt.getInputStream());
                        int commId = din.readInt();
                        Map<String, ResultsProcess> map = s_runningBehemoths;
                        synchronized (map) {
                            for (ResultsProcess proc : s_runningBehemoths.values()) {
                                if (proc.commId != commId || !proc.connect(clientSkt)) continue;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("[0x6723f] Failed trying to accept a results client. Trying again in 1 second.");
                    e.printStackTrace();
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                        continue;
                    }
                }
                break;
            }
        }
    }
}

