/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.builders.OccSourceBuilder;
import merlin.data.INameGenerator;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.OccSourceObj;
import merlin.data.egress.geom.IEgressComp;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class AddOccupantSourceAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new AddOccupantSourceAction(), Intl.intl("Add Occupant Source"));

    public AddOccupantSourceAction() {
        MerlinApp.getApp().getData().getEvents().addObserver(this);
        this.update(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        INameGenerator nameGenerator = md.occSourceNameGen;
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("New Occupants Source"));
            try {
                AddOccupantSourceAction.addOccSources(md, nameGenerator, this.getComps(md.selection));
            }
            finally {
                Undo.end(md);
            }
        }
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData data = app.getData();
        MerlinSelectionModel sel = data.selection;
        this.setEnabled(!this.getComps(sel).isEmpty());
    }

    private Collection<IEgressComp> getComps(MerlinSelectionModel sel) {
        return sel.flatten(IEgressComp.class, OccSourceObj.occsAllowedFilter());
    }

    public static void addOccSources(MerlinData md, INameGenerator nameGenerator, Collection<? extends IEgressComp> comps) {
        ArrayList<OccSourceObj> sources = new ArrayList<OccSourceObj>(comps.size());
        for (IEgressComp iEgressComp : comps) {
            OccSourceObj obj = OccSourceBuilder.createOccSourceObj(md, null, iEgressComp, nameGenerator);
            sources.add(obj);
            nameGenerator.nextName();
        }
        AddObject.add(md, md.occSources, md.occSources.getMembers().size(), sources);
    }
}

