/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.Delete;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.agents.OccTargetComp;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.framework.Deletion;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;

public class AddOccTargetsFromOccs
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new AddOccTargetsFromOccs(), Intl.intl("Create Occupant Targets...,-,Creates occupant target objects based on the selected occupants."));

    public AddOccTargetsFromOccs() {
        SelectionObserver.add(this, EgressAgent.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        IFilteredCollection<EgressAgent> agents = MerlinApp.getApp().getData().selection.flatten(EgressAgent.class);
        this.setEnabled(!agents.isEmpty());
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        boolean delOccs;
        int selOpt = md.ui(() -> JOptionPane.showConfirmDialog(app.getActiveFrame(), Intl.intl("Would you like to delete the selected occupants?"), Intl.intl("Delete selected occupants?"), 1));
        if (selOpt == 0) {
            delOccs = true;
        } else if (selOpt == 1) {
            delOccs = false;
        } else {
            return;
        }
        Runnable delTask = () -> {};
        IFilteredCollection<EgressAgent> agents = MerlinApp.getApp().getData().selection.flatten(EgressAgent.class);
        if (delOccs) {
            Pair<Deletion.DelStatus, Runnable> status = Delete.startUiDelete(app, md, agents, false);
            if (status.v1 == Deletion.DelStatus.CANCELLED) {
                return;
            }
            if (status.v1 == Deletion.DelStatus.SUCCESS) {
                delTask = (Runnable)status.v2;
            }
        }
        try (MerlinData.WriteLock lock = md.lockWrite();){
            IdentityHashMap<Object, OccTargetComp> groupMap = new IdentityHashMap<Object, OccTargetComp>();
            ArrayList groups = new ArrayList();
            ArrayList<OccTarget> locs = new ArrayList<OccTarget>();
            for (EgressAgent occ : agents) {
                UnitDouble orient = occ.toOccValue(OccProfile.PROP_INIT_ORIENT);
                OccTarget target = new OccTarget(String.format(Intl.intl("OccTarget: %s"), occ.getName()));
                target.set(OccTarget.LOCATION, occ.getLocPoint());
                target.set(OccTarget.ORIENT, orient);
                Object[] path = md.hierarchy.getPath(occ, md.agents, false);
                if (path.length <= 1) {
                    locs.add(target);
                    continue;
                }
                OccTargetComp parent = AddOccTargetsFromOccs.getParentGroup(groupMap, path, path.length - 2, groups);
                assert (parent != null);
                parent.add(target);
            }
            groups.addAll(locs);
            Undo.begin(Intl.intl("Add Occupant Targets"));
            delTask.run();
            AddObject.add(md, md.occTargets, groups);
            Undo.end(md);
        }
    }

    private static OccTargetComp getParentGroup(Map<Object, OccTargetComp> groupMap, Object[] agentsPath, int index, List<? super OccTargetComp> roots) {
        if (index < 0) {
            return null;
        }
        Object agentGroup = agentsPath[index];
        return groupMap.computeIfAbsent(agentGroup, g -> {
            OccTargetComp lgroup = new OccTargetComp(g instanceof IMerlinObj ? MerlinUtil.getName((IMerlinObj)g) : Intl.intl("Group"));
            OccTargetComp parent = AddOccTargetsFromOccs.getParentGroup(groupMap, agentsPath, index - 1, roots);
            if (parent == null) {
                roots.add(lgroup);
            } else {
                parent.add(lgroup);
            }
            return lgroup;
        });
    }
}

