/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Color;
import java.util.Collection;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.actions.importgeom.ImportCAD;
import merlin.data.Composite;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import thunderheadeng.geometry.AABox;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class AddBackgroundQuad
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new AddBackgroundQuad(), Intl.intl("Add Background Rectangle"));

    public AddBackgroundQuad() {
        SelectionObserver.add(this, ImportedGeom.class);
        this.update(null);
    }

    protected Collection<ImportedGeom> getObjs(MerlinData md) {
        return md.selection.getDeepSelected(ImportedGeom.class);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(!this.getObjs(MerlinApp.getApp().getData()).isEmpty());
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Collection<ImportedGeom> geom = this.getObjs(md);
            AABox bounds = new AABox();
            for (ImportedGeom ig : geom) {
                bounds.add(ig.getBounds());
            }
            if (!bounds.isValid()) {
                return;
            }
            ImportedGeom quad = ImportCAD.createBackgroundQuad(bounds, Color.BLACK);
            Object commonParent = md.hierarchy.getCommonParent(geom);
            if (commonParent instanceof Composite && ((Composite)commonParent).getFilter().test(quad)) {
                Undo.begin(Intl.intl("Add Background Rectangle"));
                Undo.insertUndoEntry_delete(md, (Composite)commonParent, quad);
                ((Composite)commonParent).add(quad);
                Undo.insertUndoEntry_restoreSelection(md);
                md.selection.set(quad);
                Undo.end(md);
            }
        }
    }
}

