/*
 * Decompiled with CFR 0.152.
 */
package merlin;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.unitsystem.UnitSystem;
import results.DefaultResultsFactory;
import results.api.IApi;
import results.api.ICallbacks;
import results.api.ISession;
import results.api.IView;
import results.api.UnitType;
import results.api.ViewType;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.Mediator;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.util.TeciProps;

public class MerlinAppResultsTest
extends MerlinApp {
    private final IView d_resultsMV;
    private static final String pfrfn = "D:/okonski/Documents/Pathfinder/Validation/Simulator/2017.1.1222/elevators/disabled_doors/disabled_doors_STEERING.pfr";
    private static final String smvfn = "Z:/temp/fdsoutput/Particles/carport/carport.smv";

    public MerlinAppResultsTest(String[] cmdLineArgs) {
        super(cmdLineArgs);
        DefaultResultsFactory resultsFactory = new DefaultResultsFactory();
        final IApi resultsApi = resultsFactory.newApi();
        String resultsPrefsFilename = Application.getPrefsFilename(MerlinAppResultsTest.getAppDataDir("Pathfinder"), "Behemoth");
        final ISession resultsSession = resultsApi.newRootSession(resultsPrefsFilename);
        Mediator resultsMediator = resultsApi.newMediator(resultsSession, new ResultsCallbacks());
        this.d_resultsMV = resultsFactory.newView(ViewType.MODELVIEW, resultsMediator);
        this.hijackLayout();
        AMerlinOp resultsOp = new AMerlinOp(this){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                ArrayList<String> warnings = new ArrayList<String>();
                try {
                    resultsApi.attachResults(resultsSession, IApi.ResultsType.PATHFINDER, MerlinAppResultsTest.pfrfn, warnings);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    resultsApi.attachResults(resultsSession, IApi.ResultsType.FDS, MerlinAppResultsTest.smvfn, warnings);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        UIHook.run(null, "Open initialize results", resultsOp, 0);
        Thread readConsole = new Thread(() -> {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            try {
                while (true) {
                    String line = br.readLine();
                    EventQueue.invokeLater(() -> resultsApi.executeCommand(resultsSession, line));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        });
        readConsole.start();
    }

    public void connect() {
        this.d_resultsMV.connect();
    }

    private void hijackLayout() {
        JPanel panel3dCont = null;
        JPanel treePanel = null;
        JSplitPane oldSplitPane = null;
        JFrame frm = this.getMainFrame();
        ArrayList<Component> comps = new ArrayList<Component>();
        comps.addAll(Arrays.asList(frm.getComponents()));
        while (!comps.isEmpty()) {
            Component c = (Component)comps.remove(0);
            if (c instanceof Container) {
                comps.addAll(Arrays.asList(((Container)c).getComponents()));
            }
            if (c.getName() == null) continue;
            if (c.getName().equals("MerlinApp.panel3dCont")) {
                panel3dCont = (JPanel)c;
            }
            if (c.getName().equals("MerlinApp.treePanel")) {
                treePanel = (JPanel)c;
            }
            if (!c.getName().equals("MerlinApp.splitPane")) continue;
            oldSplitPane = (JSplitPane)c;
        }
        assert (panel3dCont != null);
        assert (treePanel != null);
        assert (oldSplitPane != null);
        JTabbedPane viewsPanel = new JTabbedPane(3);
        viewsPanel.setBorder(BorderFactory.createEmptyBorder(-2, -2, -1, -4));
        viewsPanel.add("Designer", panel3dCont);
        viewsPanel.add("Results", this.d_resultsMV.getViewUI());
        JSplitPane splitPane = new JSplitPane(1, true, treePanel, viewsPanel);
        splitPane.setDividerLocation(200);
        splitPane.setDividerSize(9);
        frm.getContentPane().remove(oldSplitPane);
        frm.getContentPane().add((Component)splitPane, "Center");
        frm.getContentPane().validate();
    }

    private class ResultsCallbacks
    implements ICallbacks {
        private ResultsCallbacks() {
        }

        @Override
        public IUnitSrc getUnit(UnitType type) {
            switch (type) {
                case LENGTH: {
                    return UnitSystem.getType(0, true);
                }
                case TIME: {
                    return UnitSystem.getType(1, true);
                }
            }
            assert (false);
            return null;
        }

        @Override
        public File getRootDir() {
            if (MerlinAppResultsTest.this.getData().filename == null) {
                String lastDir = MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF);
                if (lastDir == null) {
                    return new File("");
                }
                return new File(lastDir);
            }
            return new File(MerlinAppResultsTest.this.getData().filename).getParentFile();
        }

        @Override
        public String getRootName() {
            return MerlinAppResultsTest.this.getData().filename == null ? Intl.intl("untitled") : FilenameManager.splitFilename(new File(MerlinAppResultsTest.this.getData().filename).getName())[0];
        }

        @Override
        public TeciProps getPreferences() {
            return MerlinAppResultsTest.this.getPrefs();
        }
    }
}

