/*
 * Decompiled with CFR 0.152.
 */
package merlin;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import common.PathfinderLM;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import merlin.AdditionalLogParams;
import merlin.CrashHandler;
import merlin.ErrorAnalysis;
import merlin.Intl;
import merlin.MerlinPrefs;
import merlin.Version;
import merlin.actions.AMerlinOp;
import merlin.actions.AboutAction;
import merlin.actions.AddBGImage;
import merlin.actions.AddBackgroundQuad;
import merlin.actions.AddDoorsForRoomEdges;
import merlin.actions.AddOccTargetsFromOccs;
import merlin.actions.AddOccsFromOccTargets;
import merlin.actions.AddOccupantSourceAction;
import merlin.actions.AddOccupants;
import merlin.actions.AlignBlockageNormalAction;
import merlin.actions.Behemoth;
import merlin.actions.CaptureCamera;
import merlin.actions.ChangeGroupAction;
import merlin.actions.CheckForUpdatesAction;
import merlin.actions.ClearSelection;
import merlin.actions.CloseGapsAction;
import merlin.actions.ConvertToAttractorTemplate;
import merlin.actions.ConvertToBlockage;
import merlin.actions.CreateElevator;
import merlin.actions.CreateGroupsAction;
import merlin.actions.CreateSingleGroupAction;
import merlin.actions.Delete;
import merlin.actions.EditCustomScripts;
import merlin.actions.EditJsonObjs;
import merlin.actions.EditMonteCarlo;
import merlin.actions.EditObjects;
import merlin.actions.EditPreferences;
import merlin.actions.EditProps;
import merlin.actions.EditSimParams;
import merlin.actions.EnableAction;
import merlin.actions.Exit;
import merlin.actions.ExportObj;
import merlin.actions.FilterVisible;
import merlin.actions.FindAction;
import merlin.actions.FindAdvancedAction;
import merlin.actions.Hide;
import merlin.actions.IgnoreImportedGeom;
import merlin.actions.License;
import merlin.actions.MakeDoorsOneway;
import merlin.actions.ManageMaterials;
import merlin.actions.MergeImportedGeomAction;
import merlin.actions.MerlinActionMap;
import merlin.actions.MerlinOp;
import merlin.actions.MerlinOpImpl;
import merlin.actions.MonteCarloResults;
import merlin.actions.New;
import merlin.actions.NewAttractorTemplateObject;
import merlin.actions.NewBehavior;
import merlin.actions.NewFloor;
import merlin.actions.NewGroup;
import merlin.actions.NewObject;
import merlin.actions.NewQueueObject;
import merlin.actions.NewSeeds;
import merlin.actions.NewViewFromCamera;
import merlin.actions.Open;
import merlin.actions.OpenExternalLinkAction;
import merlin.actions.OrientOnAction;
import merlin.actions.PrioritizeOccTargetOnDist;
import merlin.actions.RandomizeOccPositions;
import merlin.actions.RandomizeOrientAction;
import merlin.actions.RecentFilesAction;
import merlin.actions.ReducePopulation;
import merlin.actions.RemoveImportedUVAction;
import merlin.actions.RenameAction;
import merlin.actions.ResumeInferno;
import merlin.actions.ReversePathAction;
import merlin.actions.RunInferno;
import merlin.actions.Save;
import merlin.actions.SaveAs;
import merlin.actions.SaveOutputLogAction;
import merlin.actions.Screenshot;
import merlin.actions.SelectByColor;
import merlin.actions.SelectByMaterial;
import merlin.actions.SelectConflictingComps;
import merlin.actions.SelectConnectedComps;
import merlin.actions.SelectConnectedObjs;
import merlin.actions.SelectCustomOccs;
import merlin.actions.SelectInvalidObjs;
import merlin.actions.SelectNonGroupDescendants;
import merlin.actions.SelectReferencing;
import merlin.actions.SelectSubitems;
import merlin.actions.SetActiveFloor;
import merlin.actions.SetGroupLeaderAction;
import merlin.actions.SetZAction;
import merlin.actions.Show;
import merlin.actions.ShowAll;
import merlin.actions.ShowAllFloors;
import merlin.actions.ShowFile;
import merlin.actions.ShowOverridingScenarios;
import merlin.actions.ShowReferencingObjects;
import merlin.actions.ShowTaggedObjects;
import merlin.actions.ShowView;
import merlin.actions.SortAlphaAction;
import merlin.actions.SortByFloor;
import merlin.actions.TimeHistoryPlots;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.actions.UnitsAction;
import merlin.actions.WriteMesh;
import merlin.actions.WriteScenarios;
import merlin.actions.WriteViews;
import merlin.actions.WriteVis;
import merlin.actions.copypaste.Copy;
import merlin.actions.copypaste.Paste;
import merlin.actions.floorextract.GenerateModelFromBIM;
import merlin.actions.geomops.CleanupRooms;
import merlin.actions.geomops.MergeGeom;
import merlin.actions.geomops.SeparateGeom;
import merlin.actions.importgeom.Import;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.gui.ActivationDlg;
import merlin.gui.CheckForUpdatesDlg;
import merlin.gui.FloorComboBox;
import merlin.gui.ScenarioComboBox;
import merlin.gui.guiUtil;
import merlin.mv.MerlinColors;
import merlin.mv.ModelView;
import merlin.treeview.TreeView;
import merlin.unitsystem.EnglishUS;
import merlin.unitsystem.SIUS;
import merlin.unitsystem.UnitSystem;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.CrashCatcher;
import thunderheadeng.gui.DropDownButton;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.MRUMenu;
import thunderheadeng.gui.ResourcePaths;
import thunderheadeng.gui.ThemeChooserMenu;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.framework.property.IFormatValue;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiMenu;
import thunderheadeng.gui.guiToolBar;
import thunderheadeng.io.KeyboardAcceleratorIO;
import thunderheadeng.license3.LicensePrompt;
import thunderheadeng.scene3d.gui.RenderPrefs;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.nativebuffered.RenderComponent;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.VersionUtil;
import thunderheadeng.util.WebUrls;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.theUtil;

public class MerlinApp
extends Application {
    private static final Logger LOGGER = Logger.getLogger(MerlinApp.class.getSimpleName());
    public static final IRenderSurface.Version GL_MIN_VERSION = new IRenderSurface.Version(3, 2, 0);
    private final MerlinData d_data;
    private final MerlinColors d_colorMgr;
    private final TreeView d_tv;
    private final ModelView d_mv;
    private final RecentFilesAction d_recentFilesAction;
    private final Undo.StackSizePrefObserver d_undoStackSize;
    private final Undo.RecentUndosAction d_recentUndosAction;
    private final Undo.RecentRedosAction d_recentRedosAction;
    private final RunInferno.ScenarioRunObserver d_scenarioRunObserver;
    private final ErrorAnalysis d_errorAnalysis;
    private Runnable d_finishInit;
    private final ResourcePaths d_docPaths;
    private final JToolBar d_toolbar;
    public static final Object PATHFINDER_INIT = "MerlinApp.PATHFINDER_INIT";
    private final TitleUpdater d_titleUpdater = new TitleUpdater();
    public static final KeyStroke AWT_CRASH_ACCEL = KeyStroke.getKeyStroke(117, 640);
    private static final AWTCrashAction AWT_CRASH_PATHFINDER = new AWTCrashAction();
    public static final KeyStroke WORKER_CRASH_ACCEL = KeyStroke.getKeyStroke(118, 640);
    public static final KeyStroke WORKER_AWT_CRASH_ACCEL = KeyStroke.getKeyStroke(119, 640);

    private static native void setNativeInstallDir(String var0);

    private static native void addNativeResourceDir(String var0);

    public MerlinApp(String[] cmdLineArgs) {
        super("Pathfinder", cmdLineArgs, MerlinApp.class.getResource("pathfinder-splash.png"), 3);
        MerlinApp.registerDefaultValueFormatters();
        this.d_docPaths = new ResourcePaths(this, "", "doc", "../Results/doc/Pathfinder");
        Stream.of("../Results/lib", "../thunderheadeng/lib").forEach(d -> {
            this.getResourcePaths().addDir((String)d);
            MerlinApp.addNativeResourceDir(d);
        });
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setDismissDelay(20000);
        MerlinApp.setNativeInstallDir(this.getInstallDir() + "\\");
        this.getMainFrame().setTitle("Pathfinder 2026.1.211");
        if (!Application.isDev()) {
            CrashCatcher.install("Pathfinder", "2026.1.211", CrashHandler.INSTANCE, AdditionalLogParams.INSTANCE, 3, new Thread[0]);
        }
        try {
            if (this.getPrefs().get(MerlinPrefs.VERSION) <= 4) {
                LOGGER.log(Level.INFO, "Changing theme to default Light theme");
                UIManager.setLookAndFeel(FlatLightLaf.class.getName());
                ThemeChooserMenu.updateUIKeys(FlatLightLaf.class.getName());
                FlatLaf.updateUI();
                SwingUtilities.updateComponentTreeUI(this.getMainFrame());
                this.setPreference("Theme.LaFPackageName", FlatLightLaf.class.getName());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
        try {
            this.getMainFrame().setIconImages(Arrays.asList(ImageIO.read(this.getClass().getResource("/merlin/icons/pathfinder_16x16.png")), ImageIO.read(this.getClass().getResource("/merlin/icons/pathfinder_40x40.png"))));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.d_colorMgr = new MerlinColors();
        this.d_colorMgr.load(this.d_props);
        this.d_data = new MerlinData(true);
        String unitSystemPref = this.getPrefs().getString(MerlinPrefs.KEY_UNITSYSTEM_PROP);
        if (unitSystemPref != null && unitSystemPref.equals(EnglishUS.getInstance().getSystemName())) {
            this.d_data.setInitialUnitSystem(EnglishUS.getInstance());
        } else {
            this.d_data.setInitialUnitSystem(SIUS.getInstance());
        }
        this.d_recentFilesAction = new RecentFilesAction(this.d_data, this.d_props);
        this.d_undoStackSize = new Undo.StackSizePrefObserver(this);
        this.d_recentUndosAction = new Undo.RecentUndosAction(this.d_data);
        this.d_recentRedosAction = new Undo.RecentRedosAction(this.d_data);
        this.d_scenarioRunObserver = new RunInferno.ScenarioRunObserver(this.d_data);
        this.d_errorAnalysis = new ErrorAnalysis(this.d_data, true);
        this.d_toolbar = this.createMainToolbar();
        this.d_mv = new ModelView(this.d_data, this.d_colorMgr);
        this.d_mv.addResourceInitListener(RenderPrefs.getResourceInitHandler(this, () -> {
            assert (this.d_finishInit != null);
            return this.d_finishInit;
        }, prefs -> {
            MerlinOpImpl op = new MerlinOpImpl((app, md) -> {
                try (MerlinData.WriteLock lock = md.lockWrite();){
                    MerlinApp.setPrefs(prefs);
                    app.savePrefsToDisk();
                }
            });
            UIHook.run(this.getActiveFrame(), null, op, 20);
        }));
        this.d_tv = new TreeView(this.d_data);
        JScrollPane tvSP = new JScrollPane(this.d_tv);
        tvSP.setHorizontalScrollBarPolicy(32);
        JPanel treePanel = new JPanel(new BorderLayout());
        treePanel.setName("MerlinApp.treePanel");
        JPanel northPanel = new JPanel(new BorderLayout());
        JPanel actives = new JPanel(new BorderLayout());
        JPanel scenarioPanel = new JPanel(new GridBagLayout());
        JToolBar scenarioTb = new JToolBar();
        scenarioTb.setFloatable(false);
        ScenarioComboBox combo = new ScenarioComboBox(this.d_data, true);
        combo.setMinimumSize(new Dimension(35, combo.getHeight()));
        scenarioTb.add(combo);
        scenarioTb.add(EditObjects.UI_HOOK_SCENARIOS);
        Utils.noToolBarFocus(scenarioTb);
        GridBagHelper gb = new GridBagHelper(scenarioPanel);
        gb.addBorder(1, 6, 1, 0);
        gb.addRow(guiUtil.lbl(Intl.intl("Scenario:"), "<html>" + Intl.intl("Sets the active scenario. Properties that are customized in the active scenario<br>are marked with the active scenario's color in the Property Panel and in dialogs.")), scenarioTb, 1.0);
        this.registerHorizontalViewToolbar(scenarioPanel);
        JPanel floorPanel = new JPanel(new GridBagLayout());
        JToolBar floorTb = new JToolBar();
        floorTb.setFloatable(false);
        floorTb.add(new FloorComboBox(this.d_data));
        Utils.noToolBarFocus(floorTb);
        gb = new GridBagHelper(floorPanel);
        gb.add(Intl.intl("Floor:"), floorTb, 1.0);
        floorPanel.setBorder(scenarioPanel.getBorder());
        this.registerHorizontalViewToolbar(floorPanel);
        actives.add((Component)scenarioPanel, "North");
        actives.add((Component)new JSeparator(0), "Center");
        actives.add((Component)floorPanel, "South");
        JToolBar tbTree = new JToolBar(0);
        tbTree.add(this.d_tv.getAutoExpandButton());
        tbTree.addSeparator();
        tbTree.add(this.d_tv.getCollapseAllButton());
        tbTree.add(this.d_tv.getExpandAllButton());
        tbTree.setFloatable(false);
        Utils.noToolBarFocus(tbTree);
        northPanel.add((Component)actives, "North");
        northPanel.add((Component)tbTree, "South");
        treePanel.add((Component)northPanel, "North");
        treePanel.add((Component)tvSP, "Center");
        this.createMainMenuBar();
        JComponent panel3d = this.d_mv.getMainPanel();
        JFrame frm = this.getMainFrame();
        Container pane = frm.getContentPane();
        JPanel panel3dCont = new JPanel(new BorderLayout());
        panel3dCont.setName("MerlinApp.panel3dCont");
        panel3dCont.add((Component)panel3d, "Center");
        JSplitPane splitPane = new JSplitPane(1, true, treePanel, panel3dCont);
        splitPane.setName("MerlinApp.splitPane");
        splitPane.setDividerLocation(200);
        splitPane.setDividerSize(9);
        pane.add((Component)this.d_toolbar, "North");
        pane.add((Component)splitPane, "Center");
        this.d_data.getEvents().addObserver(this.d_titleUpdater);
        this.d_finishInit = () -> {
            this.d_finishInit = null;
            this.checkLicense();
            MerlinPrefs.instance();
            VersionUtil.checkForUpdatesOnStartup("Pathfinder", this.getPrefs(), MerlinPrefs.CHECK_VERSION_STARTUP, MerlinPrefs.SKIP_UPDATE, MerlinPrefs.SKIP_UPDATE_VERSION, VersionUtil.getVersionSupplier(PathfinderLM.getInstance()), versionSource -> new CheckForUpdatesDlg(this, true, CompletableFuture.completedFuture(versionSource)), checkOnStartup -> this.getPrefs().set(MerlinPrefs.CHECK_VERSION_STARTUP, checkOnStartup));
            AMerlinOp matdbOp = new AMerlinOp(this){

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    try (MerlinData.WriteLock lock = md.lockWrite();){
                        md.materials.scan();
                        md.modified = false;
                        md.getEvents().changed(md, MerlinData.MODIFIED_CHANGED);
                        md.getEvents().changed(md, MerlinData.MODEL_RESET);
                    }
                }
            };
            UIHook.run(null, String.format("Scanning material database", new Object[0]), matdbOp, 0);
            AMerlinOp animdbOp = new AMerlinOp(this){

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    try (MerlinData.WriteLock lock = md.lockWrite();){
                        md.animations.scan();
                        md.modified = false;
                        md.getEvents().changed(md, MerlinData.MODIFIED_CHANGED);
                        md.getEvents().changed(md, MerlinData.MODEL_RESET);
                    }
                }
            };
            UIHook.run(null, String.format("Scanning animation database", new Object[0]), animdbOp, 0);
            KeyboardAcceleratorIO.loadHotKeys(new MerlinActionMap.MerlinKeyboardAcceleratorIOHelper(this));
            this.registerContextHooksToModelView(panel3dCont);
            final File initFile = this.procArgs(cmdLineArgs);
            if (initFile != null) {
                AMerlinOp op = new AMerlinOp(){

                    @Override
                    public void run(MerlinApp app, MerlinData md) {
                        Open.open(MerlinApp.this, MerlinApp.this.getData(), initFile.getPath());
                        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, initFile.getAbsolutePath());
                    }
                };
                UIHook.run(null, String.format("Open initial file: %s", initFile.getAbsolutePath()), op, 0);
            }
        };
    }

    public RenderComponent.ContextRequest getDefaultOpenGLContextRequest() {
        return super.getDefaultOpenGLContextRequest(GL_MIN_VERSION);
    }

    public ErrorAnalysis getErrors() {
        return this.d_errorAnalysis;
    }

    public MRUMenu getMruMenu() {
        return this.d_recentFilesAction.getMenu();
    }

    public static TeciProps loadAppPreferences() throws IOException {
        return MerlinApp.loadPreferences("Pathfinder");
    }

    @Override
    public void saveKeyboardAccelerators() {
        KeyboardAcceleratorIO.exportHotKeys(new MerlinActionMap.MerlinKeyboardAcceleratorIOHelper(this));
    }

    public static <T> void removePref(TypedProp<T> prop) {
        TeciProps prefs = MerlinApp.getApp().getPrefs();
        if (prefs.isDefined(prop)) {
            prefs.remove(prop);
            MerlinData mod = MerlinApp.getApp().getData();
            mod.getEvents().changed(mod, prop);
            mod.getEvents().changed(mod, MerlinData.PREFS_CHANGED);
        }
    }

    public static <T> void setPref(TypedProp<T> prop, T val) {
        TeciProps prefs = MerlinApp.getApp().getPrefs();
        T existing = prefs.get(prop);
        if (Objects.equals(val, existing)) {
            return;
        }
        MerlinPrefs.set(prop, val);
        MerlinData mod = MerlinApp.getApp().getData();
        mod.getEvents().changed(mod, prop);
        mod.getEvents().changed(mod, MerlinData.PREFS_CHANGED);
    }

    public static void setPrefs(TeciProps srcPrefs) {
        IdentityHashMap keyPropMap = new IdentityHashMap();
        for (IPropertySet.Prop<?> prop : IPropertySet.getAllDeclaredPublicStaticProps(MerlinPrefs.class)) {
            keyPropMap.put(prop.key, prop);
        }
        MerlinData mod = MerlinApp.getApp().getData();
        TeciProps prefs = MerlinApp.getApp().getPrefs();
        boolean modified = false;
        for (Map.Entry<Object, Object> entry : srcPrefs.entrySet()) {
            Object existing = prefs.put(entry.getKey(), entry.getValue());
            if (Objects.equals(existing, entry.getValue())) continue;
            modified = true;
            IPropertySet.Prop prop = (IPropertySet.Prop)keyPropMap.get(entry.getKey());
            if (prop == null) continue;
            mod.getEvents().changed(mod, prop);
        }
        if (modified) {
            mod.getEvents().changed(mod, MerlinData.PREFS_CHANGED);
        }
    }

    @Override
    public boolean isInstallFolder(File folder) {
        return this.isInstallFolderDefault(folder);
    }

    @Override
    protected void loadSafeModeProps(TeciProps props) {
        super.loadSafeModeProps(props);
        MerlinPrefs.loadSafeModeProps(props);
        RenderPrefs.loadSafeModeProps(props);
    }

    @Override
    protected void loadLibraries() {
        if (theUtil.testSystemProp("richards_debug_build")) {
            MerlinApp.loadLib("FreeImaged", new String[0]);
        }
        MerlinApp.loadLib("FreeImage", "FreeImaged");
        MerlinApp.loadLib("Pathfinder_jni", new String[0]);
    }

    private void checkLicense() {
        PathfinderLM licenseMgr = null;
        try {
            licenseMgr = PathfinderLM.getInstance();
            assert (licenseMgr != null);
            boolean status = licenseMgr.startFromPrefs(this.getPrefs(), MerlinPrefs.KEY_LICENSEDIR_PROP, MerlinPrefs.KEY_LICENSESERVER_PROP, MerlinPrefs.KEY_LICENSESERVERPWD_PROP);
            System.out.println(licenseMgr.getDescription());
            if (!status) {
                ActivationDlg rlmdlg = new ActivationDlg(this.getMainFrame(), licenseMgr);
                rlmdlg.doModal();
            }
        }
        catch (Throwable everything) {
            everything.printStackTrace();
            System.exit(-1);
        }
        if (licenseMgr == null || !licenseMgr.isAuthorized()) {
            this.quit(false);
            return;
        }
        super.savePrefsToDisk();
        LicensePrompt.checkRenewPrompt(this.getActiveFrame(), licenseMgr, "Pathfinder", "www.thunderheadeng.com/pathfinder", null, License.UI_HOOK, 30, null);
    }

    public static boolean isFP() {
        return System.getProperty("fp") != null;
    }

    public File procArgs(String[] args) {
        File initFile = null;
        for (String arg : args) {
            if (arg.length() >= 3 && arg.substring(0, 3).equals("-sz")) {
                try {
                    String[] sz = arg.substring(3, arg.length()).split("x");
                    this.getActiveFrame().setSize(Integer.parseInt(sz[0]), Integer.parseInt(sz[1]));
                    this.getActiveFrame().setLocationRelativeTo(null);
                }
                catch (NumberFormatException t) {
                    t.printStackTrace();
                }
                continue;
            }
            if (initFile == null && !arg.startsWith("-")) {
                File f = new File(arg);
                if (!f.exists() || !f.canRead()) continue;
                initFile = f;
                continue;
            }
            System.out.println("Unused Parameter: " + arg);
        }
        return initFile;
    }

    @Override
    public JMenuBar createMenuBar() {
        return new JMenuBar();
    }

    private JMenuBar createMainMenuBar() {
        JMenuBar menuBar = super.createMenuBar();
        guiMenu fileMenu = new guiMenu(Intl.intl("&File"));
        fileMenu.add(New.UI_HOOK.getMenuItem());
        fileMenu.add(Open.UI_HOOK.getMenuItem());
        fileMenu.addSeparator();
        fileMenu.add(Save.UI_HOOK.getMenuItem());
        fileMenu.add(SaveAs.UI_HOOK.getMenuItem());
        fileMenu.addSeparator();
        fileMenu.add(EditPreferences.UI_HOOK.getMenuItem());
        if (MerlinApp.isDev()) {
            fileMenu.add(ExportObj.UI_HOOK.getMenuItem());
        }
        fileMenu.addSeparator();
        fileMenu.add(Import.UI_HOOK.getMenuItem());
        guiMenu exportMenu = new guiMenu(Intl.intl("Export"));
        exportMenu.add(WriteScenarios.UI_HOOK.getMenuItem());
        exportMenu.addSeparator();
        exportMenu.add(WriteMesh.UI_HOOK.getMenuItem());
        exportMenu.add(WriteViews.UI_HOOK.getMenuItem());
        exportMenu.add(WriteVis.UI_HOOK.getMenuItem());
        fileMenu.add(exportMenu);
        fileMenu.add(Screenshot.UI_HOOK.getMenuItem());
        fileMenu.addSeparator();
        fileMenu.add(this.d_recentFilesAction.getMenu());
        fileMenu.addSeparator();
        fileMenu.add(Exit.UI_HOOK.getMenuItem());
        guiMenu editMenu = new guiMenu(Intl.intl("&Edit"));
        editMenu.add(this.d_recentUndosAction.getMenu());
        editMenu.add(Undo.UI_HOOK_UNDO_MAJOR.getMenuItem());
        editMenu.add(this.d_recentRedosAction.getMenu());
        editMenu.add(Undo.UI_HOOK_REDO_MAJOR.getMenuItem());
        editMenu.addSeparator();
        editMenu.add(Copy.UI_HOOK.getMenuItem());
        editMenu.add(Paste.UI_HOOK.getMenuItem());
        editMenu.addSeparator();
        editMenu.add(Delete.UI_HOOK.getMenuItem());
        editMenu.addSeparator();
        editMenu.add(FindAction.UI_HOOK.getMenuItem());
        editMenu.add(FindAdvancedAction.UI_HOOK_FIND_ADVANCED.getMenuItem());
        editMenu.add(FindAdvancedAction.UI_HOOK_FIND_ADVANCED_IN_SELECTION.getMenuItem());
        editMenu.addSeparator();
        editMenu.add(Hide.UI_HOOK.getMenuItem());
        editMenu.add(Show.UI_HOOK.getMenuItem());
        editMenu.add(FilterVisible.UI_HOOK.getMenuItem());
        editMenu.add(ShowAll.UI_HOOK.getMenuItem());
        guiMenu modelMenu = new guiMenu(Intl.intl("&Model"));
        modelMenu.add(EditObjects.UI_HOOK_LIBRARIES.getMenuItem());
        modelMenu.add(EditObjects.UI_HOOK_SCENARIOS.getMenuItem());
        modelMenu.add(ManageMaterials.UI_HOOK.getMenuItem());
        modelMenu.add(EditObjects.UI_HOOK_ANIMATIONS.getMenuItem());
        modelMenu.addSeparator();
        modelMenu.add(EditObjects.UI_HOOK_PROFILE.getMenuItem());
        modelMenu.add(EditObjects.UI_HOOK_VEHICLE_SHAPE.getMenuItem());
        modelMenu.add(EditObjects.UI_HOOK_ASSISTED_EVAC_TEAM.getMenuItem());
        modelMenu.add(EditObjects.UI_HOOK_OCC_GROUP_TYPES.getMenuItem());
        modelMenu.addSeparator();
        modelMenu.add(NewGroup.MENU_HOOK.getMenuItem());
        modelMenu.add(NewViewFromCamera.MENU_HOOK.getMenuItem());
        modelMenu.add(AddBGImage.UI_HOOK.getMenuItem());
        modelMenu.add(NewBehavior.MENU_HOOK.getMenuItem());
        modelMenu.add(NewQueueObject.MENU_HOOK.getMenuItem());
        modelMenu.add(NewAttractorTemplateObject.MENU_HOOK.getMenuItem());
        modelMenu.add(AddOccupants.UI_HOOK.getMenuItem());
        modelMenu.add(CreateElevator.UI_HOOK.getMenuItem());
        modelMenu.addSeparator();
        modelMenu.add(GenerateModelFromBIM.UI_HOOK_GLOBAL);
        if (MerlinApp.isDev()) {
            modelMenu.add(EditJsonObjs.UI_HOOK.getMenuItem());
        }
        if (EditCustomScripts.isCustomScriptingEnabled()) {
            modelMenu.add(EditCustomScripts.UI_HOOK.getMenuItem());
        }
        modelMenu.addSeparator();
        modelMenu.add(MergeGeom.UI_HOOK.getMenuItem());
        modelMenu.add(SeparateGeom.UI_HOOK.getMenuItem());
        guiMenu analysisMenu = new guiMenu(Intl.intl("&Simulation"));
        analysisMenu.add(EditSimParams.UI_HOOK.getMenuItem());
        analysisMenu.add(EditMonteCarlo.UI_HOOK.getMenuItem());
        analysisMenu.addSeparator();
        analysisMenu.add(RunInferno.UI_HOOK_RUN.getMenuItem());
        analysisMenu.add(RunInferno.UI_HOOK_DEBUG.getMenuItem());
        analysisMenu.add(ResumeInferno.UI_HOOK.getMenuItem());
        guiMenu resultsMenu = new guiMenu(Intl.intl("&Results"));
        resultsMenu.add(Behemoth.UI_HOOK.getMenuItem());
        resultsMenu.add(TimeHistoryPlots.UI_HOOK_ROOM_USAGE.getMenuItem());
        resultsMenu.add(TimeHistoryPlots.UI_HOOK_DOOR_FLOW.getMenuItem());
        resultsMenu.add(TimeHistoryPlots.UI_HOOK_MEASUREMENT_REGIONS_RATES.getMenuItem());
        resultsMenu.add(MonteCarloResults.UI_HOOK_COMPLETION_TIMES.getMenuItem());
        resultsMenu.add(MonteCarloResults.UI_HOOK_TRAVEL_DISTANCES.getMenuItem());
        resultsMenu.add(ShowFile.SHOW_SUMMARY_HOOK.getMenuItem());
        if (MerlinApp.isDev()) {
            resultsMenu.add(ShowFile.SHOW_PERFORMANCE_HOOK.getMenuItem());
        }
        JMenu viewMenu = this.d_mv.getMainMenu();
        JMenu helpMenu = this.createHelpMenu();
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(modelMenu);
        menuBar.add(analysisMenu);
        menuBar.add(resultsMenu);
        menuBar.add(viewMenu);
        menuBar.add(helpMenu);
        JFrame frame = this.getMainFrame();
        frame.getRootPane().getInputMap(1).put(AWT_CRASH_ACCEL, AWT_CRASH_PATHFINDER);
        frame.getRootPane().getActionMap().put(AWT_CRASH_PATHFINDER, AWT_CRASH_PATHFINDER);
        frame.getRootPane().getInputMap(1).put(WORKER_CRASH_ACCEL, WorkerCrashAction.UI_HOOK);
        frame.getRootPane().getActionMap().put(WorkerCrashAction.UI_HOOK, WorkerCrashAction.UI_HOOK);
        frame.getRootPane().getInputMap(1).put(WORKER_AWT_CRASH_ACCEL, WorkerAWTCrashAction.UI_HOOK);
        frame.getRootPane().getActionMap().put(WorkerAWTCrashAction.UI_HOOK, WorkerAWTCrashAction.UI_HOOK);
        frame.setJMenuBar(menuBar);
        return menuBar;
    }

    public ResourcePaths getDocPaths() {
        return this.d_docPaths;
    }

    public JMenu createHelpMenu() {
        UIHook[] docLinks;
        WebUrls.SupportVersion ver = WebUrls.SupportVersion.get(Version.INTVER.yyyy, Version.INTVER.n);
        for (UIHook obj : docLinks = new UIHook[]{new UIHook(new OpenExternalLinkAction(OpenExternalLinkAction.Type.URL, WebUrls.getSupportUrl(WebUrls.SupportProduct.Pathfinder, WebUrls.SupportDoc.Manual, ver)), Intl.intl("Pathfinder User &Manual"), null, 84), new UIHook(new OpenExternalLinkAction(OpenExternalLinkAction.Type.URL, WebUrls.getSupportUrl(WebUrls.SupportProduct.Pathfinder, WebUrls.SupportDoc.ResultsManual, ver)), Intl.intl("&Results User Manual"), null, 84), new UIHook(new OpenExternalLinkAction(OpenExternalLinkAction.Type.URL, WebUrls.getSupportUrl(WebUrls.SupportProduct.Pathfinder, WebUrls.SupportDoc.TechRef, ver)), Intl.intl("&Technical Reference"), null, 84), new UIHook(new OpenExternalLinkAction(OpenExternalLinkAction.Type.URL, WebUrls.getSupportUrl(WebUrls.SupportProduct.Pathfinder, WebUrls.SupportDoc.VerificationValidation, ver)), Intl.intl("&Verification and Validation"), null, 84), new UIHook(new OpenExternalLinkAction(OpenExternalLinkAction.Type.URL, WebUrls.getSupportUrl(WebUrls.SupportProduct.Pathfinder, WebUrls.SupportDoc.None, ver)), Intl.intl("More Help &Online"), null, 84)}) {
            Collection<String> targets;
            MerlinOp op = obj.getMerOp();
            if (!(op instanceof OpenExternalLinkAction) || (targets = ((OpenExternalLinkAction)op).getTargets()).isEmpty()) continue;
            String urlTarget = targets.iterator().next();
            obj.setShortDesc(urlTarget);
        }
        guiMenu helpMenu = new guiMenu(Intl.intl("&Help"));
        for (UIHook obj : docLinks) {
            helpMenu.add(obj.getMenuItem());
        }
        helpMenu.addSeparator();
        helpMenu.add(License.UI_HOOK.getMenuItem());
        helpMenu.add(CheckForUpdatesAction.UI_HOOK.getMenuItem());
        helpMenu.addSeparator();
        helpMenu.add(SaveOutputLogAction.UI_HOOK.getMenuItem());
        helpMenu.add(AboutAction.UI_HOOK.getMenuItem());
        return helpMenu;
    }

    private JToolBar createMainToolbar() {
        guiToolBar toolbar = new guiToolBar();
        toolbar.setFloatable(false);
        toolbar.add(New.UI_HOOK);
        toolbar.add(Open.UI_HOOK);
        toolbar.add(Save.UI_HOOK);
        toolbar.add(Import.UI_HOOK);
        toolbar.addSeparator();
        ((Container)toolbar).add(new Undo.UndoDropdownButton(this.d_data));
        ((Container)toolbar).add(new Undo.RedoDropdownButton(this.d_data));
        toolbar.addSeparator();
        guiUtil.addMEToolbarItems(toolbar, UnitsAction.SI_ACTION, UnitsAction.ENGLISH_ACTION);
        toolbar.addSeparator();
        toolbar.add(RunInferno.UI_HOOK_RUN);
        DropDownButton timeHistoryBtn = new DropDownButton(TimeHistoryPlots.UI_HOOK_ROOM_USAGE, TimeHistoryPlots.UI_HOOK_DOOR_FLOW, TimeHistoryPlots.UI_HOOK_MEASUREMENT_REGIONS_RATES);
        timeHistoryBtn.setHideActionText(true);
        ((Container)toolbar).add(timeHistoryBtn);
        toolbar.add(Behemoth.UI_HOOK);
        Utils.noToolBarFocus(toolbar);
        toolbar.setMinimumSize(new Dimension(0, 0));
        return toolbar;
    }

    private static void addHook(List<UIHook> hooks, UIHook hook) {
        if (hook.isEnabled()) {
            hooks.add(hook);
        }
    }

    private static void addSeparatorHook(List<UIHook> hooks) {
        if (hooks.size() > 0 && hooks.get(hooks.size() - 1) != null) {
            hooks.add(null);
        }
    }

    private static JPopupMenu generateContextMenu(List<UIHook> hooks) {
        JPopupMenu ctxMenu = new JPopupMenu();
        for (int m = 0; m < hooks.size(); ++m) {
            UIHook hook = hooks.get(m);
            if (hook != null) {
                ctxMenu.add(hook);
                continue;
            }
            if (m <= 0 || m >= hooks.size() - 1) continue;
            ctxMenu.addSeparator();
        }
        return ctxMenu;
    }

    public static JPopupMenu getContextMenu() {
        ArrayList<UIHook> hooks = new ArrayList<UIHook>();
        MerlinApp.addHook(hooks, EnableAction.UI_ENABLE_HOOK);
        MerlinApp.addHook(hooks, EnableAction.UI_DISABLE_HOOK);
        MerlinApp.addHook(hooks, IgnoreImportedGeom.UI_HOOK);
        MerlinApp.addHook(hooks, AddBackgroundQuad.UI_HOOK);
        MerlinApp.addHook(hooks, SelectSubitems.UI_HOOK);
        MerlinApp.addHook(hooks, SelectNonGroupDescendants.UI_HOOK);
        MerlinApp.addHook(hooks, SelectInvalidObjs.CRITICAL_HOOK);
        MerlinApp.addHook(hooks, SelectInvalidObjs.MODERATE_HOOK);
        MerlinApp.addHook(hooks, SelectConflictingComps.UI_HOOK);
        MerlinApp.addHook(hooks, SelectReferencing.UI_HOOK);
        MerlinApp.addHook(hooks, ShowReferencingObjects.UI_HOOK);
        MerlinApp.addHook(hooks, ShowOverridingScenarios.UI_HOOK);
        MerlinApp.addHook(hooks, ShowTaggedObjects.UI_HOOK);
        MerlinApp.addHook(hooks, SelectCustomOccs.UI_HOOK);
        MerlinApp.addSeparatorHook(hooks);
        MerlinApp.addHook(hooks, NewBehavior.CONTEXT_HOOK);
        MerlinApp.addHook(hooks, NewQueueObject.CONTEXT_HOOK);
        MerlinApp.addHook(hooks, NewAttractorTemplateObject.CONTEXT_HOOK);
        MerlinApp.addHook(hooks, ConvertToAttractorTemplate.CONTEXT_HOOK);
        MerlinApp.addHook(hooks, NewObject.UI_HOOK_PROFILE);
        MerlinApp.addHook(hooks, NewObject.UI_HOOK_VEHICLE_SHAPE);
        MerlinApp.addHook(hooks, NewObject.UI_HOOK_ASSISTED_EVAC_TEAM);
        MerlinApp.addHook(hooks, NewObject.UI_HOOK_OCCGROUP_TYPE);
        MerlinApp.addHook(hooks, NewViewFromCamera.CONTEXT_HOOK);
        MerlinApp.addHook(hooks, SetActiveFloor.UI_HOOK);
        MerlinApp.addHook(hooks, NewGroup.CONTEXT_HOOK);
        MerlinApp.addHook(hooks, ChangeGroupAction.UI_HOOK);
        MerlinApp.addHook(hooks, Delete.UI_HOOK);
        MerlinApp.addHook(hooks, RenameAction.UI_HOOK);
        MerlinApp.addHook(hooks, SortAlphaAction.UI_HOOK);
        MerlinApp.addHook(hooks, SortByFloor.UI_HOOK);
        MerlinApp.addHook(hooks, NewSeeds.UI_HOOK);
        MerlinApp.addHook(hooks, RandomizeOrientAction.UI_HOOK);
        MerlinApp.addSeparatorHook(hooks);
        MerlinApp.addHook(hooks, Copy.UI_HOOK);
        MerlinApp.addHook(hooks, Paste.UI_HOOK);
        MerlinApp.addSeparatorHook(hooks);
        MerlinApp.addHook(hooks, ShowView.CONTEXT_HOOK);
        MerlinApp.addHook(hooks, CaptureCamera.CONTEXT_HOOK);
        MerlinApp.addHook(hooks, SelectConnectedObjs.ROOM_OCCS);
        MerlinApp.addHook(hooks, SelectConnectedObjs.ROOM_TARGETS);
        MerlinApp.addHook(hooks, SelectConnectedObjs.ROOM_BLOCKAGES);
        MerlinApp.addHook(hooks, SelectConnectedObjs.BLOCKAGE_ROOMS);
        MerlinApp.addHook(hooks, SelectConnectedComps.UI_HOOK);
        MerlinApp.addHook(hooks, AddOccupants.UI_HOOK);
        MerlinApp.addHook(hooks, AddOccupantSourceAction.UI_HOOK);
        MerlinApp.addHook(hooks, ReducePopulation.UI_HOOK);
        MerlinApp.addHook(hooks, RandomizeOccPositions.UI_HOOK);
        MerlinApp.addHook(hooks, CreateSingleGroupAction.UI_HOOK);
        MerlinApp.addHook(hooks, CreateGroupsAction.UI_HOOK);
        MerlinApp.addHook(hooks, SetGroupLeaderAction.UI_HOOK);
        MerlinApp.addHook(hooks, SelectByColor.UI_HOOK);
        MerlinApp.addHook(hooks, SelectByMaterial.UI_HOOK);
        MerlinApp.addHook(hooks, RemoveImportedUVAction.UI_HOOK);
        MerlinApp.addSeparatorHook(hooks);
        MerlinApp.addHook(hooks, GenerateModelFromBIM.UI_HOOK_CONTEXT);
        MerlinApp.addHook(hooks, CreateElevator.UI_HOOK);
        MerlinApp.addHook(hooks, MakeDoorsOneway.UI_HOOK);
        MerlinApp.addHook(hooks, AddDoorsForRoomEdges.UI_HOOK);
        MerlinApp.addSeparatorHook(hooks);
        MerlinApp.addHook(hooks, MergeGeom.UI_HOOK);
        MerlinApp.addHook(hooks, MergeImportedGeomAction.UI_HOOK);
        MerlinApp.addHook(hooks, ConvertToBlockage.UI_HOOK);
        MerlinApp.addHook(hooks, SeparateGeom.UI_HOOK);
        MerlinApp.addHook(hooks, CloseGapsAction.UI_HOOK);
        MerlinApp.addHook(hooks, CleanupRooms.UI_HOOK);
        MerlinApp.addHook(hooks, SetZAction.UI_HOOK);
        MerlinApp.addHook(hooks, AlignBlockageNormalAction.UI_HOOK);
        MerlinApp.addHook(hooks, OrientOnAction.UI_HOOK);
        MerlinApp.addHook(hooks, PrioritizeOccTargetOnDist.UI_HOOK);
        MerlinApp.addHook(hooks, AddOccTargetsFromOccs.UI_HOOK);
        MerlinApp.addHook(hooks, AddOccsFromOccTargets.UI_HOOK);
        MerlinApp.addHook(hooks, ReversePathAction.CONTEXT_HOOK);
        MerlinApp.addSeparatorHook(hooks);
        MerlinApp.addHook(hooks, Hide.UI_HOOK);
        MerlinApp.addHook(hooks, Show.UI_HOOK);
        MerlinApp.addHook(hooks, FilterVisible.UI_HOOK);
        MerlinApp.addHook(hooks, ShowAll.UI_HOOK);
        MerlinApp.addSeparatorHook(hooks);
        MerlinApp.addHook(hooks, EditProps.UI_HOOK);
        return MerlinApp.generateContextMenu(hooks);
    }

    public void registerContextHooksToModelView(JPanel comp) {
        Stream.of(EnableAction.UI_ENABLE_HOOK, EnableAction.UI_DISABLE_HOOK, IgnoreImportedGeom.UI_HOOK, AddBackgroundQuad.UI_HOOK, SelectSubitems.UI_HOOK, SelectNonGroupDescendants.UI_HOOK, SelectInvalidObjs.CRITICAL_HOOK, SelectInvalidObjs.MODERATE_HOOK, SelectConflictingComps.UI_HOOK, SelectReferencing.UI_HOOK, ShowTaggedObjects.UI_HOOK, ShowReferencingObjects.UI_HOOK, ShowOverridingScenarios.UI_HOOK, SelectCustomOccs.UI_HOOK, NewBehavior.CONTEXT_HOOK, NewQueueObject.CONTEXT_HOOK, NewAttractorTemplateObject.CONTEXT_HOOK, ConvertToAttractorTemplate.CONTEXT_HOOK, NewObject.UI_HOOK_PROFILE, NewObject.UI_HOOK_VEHICLE_SHAPE, NewObject.UI_HOOK_ASSISTED_EVAC_TEAM, NewObject.UI_HOOK_OCCGROUP_TYPE, NewViewFromCamera.CONTEXT_HOOK, SetActiveFloor.UI_HOOK, NewGroup.CONTEXT_HOOK, ReversePathAction.CONTEXT_HOOK, ChangeGroupAction.UI_HOOK, Delete.UI_HOOK, RenameAction.UI_HOOK, SortAlphaAction.UI_HOOK, SortByFloor.UI_HOOK, NewSeeds.UI_HOOK, ShowView.CONTEXT_HOOK, CaptureCamera.CONTEXT_HOOK, SelectConnectedObjs.ROOM_OCCS, SelectConnectedObjs.ROOM_TARGETS, SelectConnectedObjs.ROOM_BLOCKAGES, SelectConnectedObjs.BLOCKAGE_ROOMS, AddOccupants.UI_HOOK, AddOccupantSourceAction.UI_HOOK, ReducePopulation.UI_HOOK, RandomizeOccPositions.UI_HOOK, CreateSingleGroupAction.UI_HOOK, SetGroupLeaderAction.UI_HOOK, CreateGroupsAction.UI_HOOK, SelectByColor.UI_HOOK, SelectByMaterial.UI_HOOK, RemoveImportedUVAction.UI_HOOK, GenerateModelFromBIM.UI_HOOK_CONTEXT, CreateElevator.UI_HOOK, MakeDoorsOneway.UI_HOOK, MergeGeom.UI_HOOK, SeparateGeom.UI_HOOK, CloseGapsAction.UI_HOOK, CleanupRooms.UI_HOOK, SetZAction.UI_HOOK, AlignBlockageNormalAction.UI_HOOK, PrioritizeOccTargetOnDist.UI_HOOK, OrientOnAction.UI_HOOK, RandomizeOrientAction.UI_HOOK, MergeImportedGeomAction.UI_HOOK, ConvertToBlockage.UI_HOOK, AddOccTargetsFromOccs.UI_HOOK, AddOccsFromOccTargets.UI_HOOK, Hide.UI_HOOK, Show.UI_HOOK, FilterVisible.UI_HOOK, ShowAll.UI_HOOK, EditProps.UI_HOOK, NewFloor.UI_HOOK, ShowAllFloors.UI_HOOK, SelectConnectedComps.UI_HOOK, ClearSelection.UI_HOOK, this.getModelView().getQueueServiceHook(), this.getModelView().getQueuePathHook(), this.getModelView().getQueueNodeHook()).forEach(hook -> hook.registerUIComponent(comp));
    }

    public static void registerDefaultValueFormatters() {
        TeciDisplayProps.registerValFormatter(IMerlinObj.class, (src, val) -> MerlinUtil.getName(val));
        IFormatValue<Object, Object> objFormatter = TeciDisplayProps.formatToString();
        TeciDisplayProps.registerValFormatter(Point3f.class, objFormatter);
        TeciDisplayProps.registerValFormatter(Point3d.class, objFormatter);
        TeciDisplayProps.registerValFormatter(Vector3f.class, objFormatter);
        TeciDisplayProps.registerValFormatter(Vector3d.class, objFormatter);
        TeciDisplayProps.registerValFormatter(ICurve.class, objFormatter);
    }

    public static void crash(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        while (t.getCause() != null) {
            t = t.getCause();
        }
        throw new RuntimeException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitOn() {
        MerlinApp merlinApp = MerlinApp.getApp();
        synchronized (merlinApp) {
            try {
                MerlinApp.getApp().wait();
                return true;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyAwaiting() {
        MerlinApp merlinApp = MerlinApp.getApp();
        synchronized (merlinApp) {
            MerlinApp.getApp().notifyAll();
        }
    }

    public static MerlinApp getApp() {
        Application app = Application.getApp();
        return app instanceof MerlinApp ? (MerlinApp)app : null;
    }

    public static Optional<ErrorAnalysis> getGlobalErrors() {
        return MerlinApp.getAppOpt().map(app -> app.getErrors());
    }

    public static Optional<MerlinApp> getAppOpt() {
        return Optional.ofNullable(MerlinApp.getApp());
    }

    public static MerlinData getAppData() {
        MerlinApp app = MerlinApp.getApp();
        return app != null ? app.getData() : null;
    }

    public MerlinData getData() {
        return this.d_data;
    }

    public ModelView getModelView() {
        return this.d_mv;
    }

    public TreeView getTreeView() {
        return this.d_tv;
    }

    public AMerlinOp getQuitOp(final boolean allowCancel) {
        return new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                int numSims = RunInferno.COUNT.get();
                if (numSims > 0) {
                    if (!allowCancel) {
                        String msg = String.format(Intl.intl("%d simulation(s) will terminate."), numSims);
                        JOptionPane.showMessageDialog(MerlinApp.this.getMainFrame(), msg, Intl.intl("Simulation(s) in Progress"), 1);
                    } else {
                        int sel = JOptionPane.showConfirmDialog(MerlinApp.this.getMainFrame(), String.format(Intl.intl("Exit and terminate %d simulation(s)?"), numSims), Intl.intl("Simulation(s) in Progress"), 2);
                        if (sel != 0 && allowCancel) {
                            return;
                        }
                    }
                }
                boolean cancelled = !MerlinApp.this.promptSaveIfModified();
                MerlinApp.this.d_recentFilesAction.store(MerlinApp.this.d_props);
                if (!cancelled || !allowCancel) {
                    md.ui(() -> {
                        PathfinderLM.getInstance().closeLM();
                        MerlinApp.super.quit(allowCancel);
                    });
                }
            }
        };
    }

    @Override
    public void quit(boolean allowCancel) {
        AMerlinOp op = this.getQuitOp(allowCancel);
        UIHook.run(null, "quit", op, 0);
    }

    public boolean promptSaveIfModified() {
        if (this.d_data.modified) {
            String msg = Intl.intl("Save changes to current model?");
            String title = Intl.intl("Save Changes");
            int opts = 1;
            int result = JOptionPane.showConfirmDialog(this.getActiveFrame(), msg, title, opts);
            switch (result) {
                case 0: {
                    return Save.saveToFile(this, this.d_data, false);
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void savePreferences() {
        this.d_mv.savePreferences();
        this.getPrefs().set(MerlinPrefs.KEY_UNITSYSTEM_PROP, this.d_data.getUnitSystem().getSystemName());
        this.d_colorMgr.store(this.d_props);
        super.savePreferences();
    }

    @Override
    public void savePrefsToDisk() {
        MerlinPrefs.updateVersion();
        super.savePrefsToDisk();
    }

    @Override
    public void readPreferences() {
        super.readPreferences();
        MerlinPrefs.Version ver = MerlinPrefs.getVersion();
        if (ver.ordinal() < MerlinPrefs.Version.VER_0004.ordinal() && this.d_props.get(RenderPrefs.PREF_ANISOTROPIC_FILTERING) == 16.0) {
            this.d_props.set(RenderPrefs.PREF_ANISOTROPIC_FILTERING, (Double)RenderPrefs.PREF_ANISOTROPIC_FILTERING.defVal);
        }
    }

    public UnitSystem getUnitSystem() {
        return this.d_data.getUnitSystem();
    }

    public MerlinColors getColorManager() {
        return this.d_colorMgr;
    }

    private class TitleUpdater
    implements IEventObserver {
        private TitleUpdater() {
        }

        @Override
        public void update(Events e) {
            Object filename = MerlinApp.this.d_data.filename;
            if (filename == null || ((String)filename).compareTo("null") == 0) {
                filename = "untitled";
            } else {
                for (int i = ((String)filename).length() - 2; i >= 0; --i) {
                    if (((String)filename).charAt(i) != '\\') continue;
                    filename = ((String)filename).substring(i + 1);
                    break;
                }
            }
            if (MerlinApp.this.d_data.modified) {
                filename = "*" + (String)filename;
            }
            filename = " - " + (String)filename;
            MerlinApp.this.getMainFrame().setTitle("Pathfinder 2026.1.211" + (String)filename);
        }
    }

    private static class AWTCrashAction
    extends guiAction {
        private static final long serialVersionUID = -2960229483197444995L;

        public AWTCrashAction() {
            super("x_x");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new RuntimeException();
        }
    }

    private static class WorkerCrashAction
    extends AMerlinOp {
        private static final UIHook UI_HOOK = new UIHook(new WorkerCrashAction(), "Worker Crash Test");

        private WorkerCrashAction() {
        }

        @Override
        public void run(MerlinApp app, MerlinData md) {
            throw new RuntimeException();
        }
    }

    private static class WorkerAWTCrashAction
    extends AMerlinOp {
        private static final UIHook UI_HOOK = new UIHook((MerlinOp)new WorkerAWTCrashAction(), "Worker AWT Crash Test", 0);

        private WorkerAWTCrashAction() {
        }

        @Override
        public void run(MerlinApp app, MerlinData md) {
            throw new RuntimeException();
        }
    }
}

