/*
 * Decompiled with CFR 0.152.
 */
package merlin;

import java.lang.ref.Cleaner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.SimError;
import merlin.util.MerlinUtil;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;

public class ErrorAnalysis
implements IEventObserver {
    private final MerlinData d_data;
    private final Map<IMerlinObj, List<SimError>> d_errors = new LinkedIdentityHashMap<IMerlinObj, List<SimError>>();
    private final Set<IErrorGenerator<?>> d_errorGenObjs = new LinkedIdentityHashSet();
    private final Map<Object, SharedItem<?>> d_sharedCache = new HashMap();
    private final ExecutorService d_executor = Executors.newFixedThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors() / 2));

    public ErrorAnalysis(MerlinData md, boolean live) {
        this.d_data = md;
        ExecutorService executor = this.d_executor;
        Cleaner.create().register(this, () -> executor.shutdown());
        this.updateAllErrors();
        if (live) {
            this.connect(false);
        }
    }

    public void connect(boolean forceUpdate) {
        this.d_data.getEvents().addPreObserver(this);
        if (forceUpdate) {
            this.updateAllErrors();
        }
    }

    public void disconnect() {
        this.d_data.getEvents().removeObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Events events) {
        Map<Object, SharedItem<?>> map = this.d_sharedCache;
        synchronized (map) {
            this.d_sharedCache.entrySet().removeIf(entry -> {
                SharedItem val = (SharedItem)entry.getValue();
                boolean clear = val.testClear.test(this.d_data, events);
                if (clear) {
                    val.val.cancel(true);
                    return true;
                }
                return false;
            });
        }
        Set objSources = this.d_errorGenObjs.stream().filter(gen -> gen.isDirty(events)).map(gen -> gen.getObjects(this.d_data)).collect(Collectors.toSet());
        LinkedIdentityHashSet dirtyObjs = objSources.stream().flatMap(source -> source.streamObjects(this.d_data)).filter(o -> o instanceof IMerlinObj).map(o -> (IMerlinObj)o).collect(Collectors.toCollection(() -> new LinkedIdentityHashSet()));
        IEventRecord<IMerlinObj> objEvts = events.getEvents(IMerlinObj.class, new Class[0]);
        this.d_errors.keySet().removeAll(objEvts.getRemovedObjs());
        dirtyObjs.addAll(objEvts.getAddedObjs());
        Predicate<Object> rejectSelVis = evt -> evt != MerlinData.SELECTION_CHANGED && evt != MerlinData.VISIBILITY;
        dirtyObjs.addAll(objEvts.filterChanges(rejectSelVis));
        this.updateErrors(dirtyObjs);
    }

    private void updateAllErrors() {
        this.d_errors.clear();
        this.d_sharedCache.clear();
        this.updateErrors(MerlinUtil.flatten(this.d_data, IMerlinObj.class));
    }

    private void updateErrors(Collection<? extends IMerlinObj> objs) {
        for (IMerlinObj iMerlinObj : objs) {
            ArrayList errors = new ArrayList();
            Collection<IErrorGenerator<IMerlinObj>> gens = EntryPointFactory.get(iMerlinObj).getErrorGenerators(this.d_data, iMerlinObj);
            for (IErrorGenerator<IMerlinObj> gen : gens) {
                this.d_errorGenObjs.add(gen);
                gen.generate(this.d_data, this, iMerlinObj, errors::add);
            }
            if (errors.isEmpty()) {
                this.d_errors.remove(iMerlinObj);
                continue;
            }
            this.d_errors.put(iMerlinObj, errors);
        }
    }

    public Collection<? extends SimError> getErrors(Object object) {
        return this.d_errors.getOrDefault(object, Collections.emptyList());
    }

    public Collection<? extends SimError> getCollapsedErrors(IMerlinObj object) {
        Collection<? extends SimError> errors = this.getErrors(object);
        if (!object.isComposite()) {
            return errors;
        }
        class LevelInfo {
            int count = 0;
            List<IMerlinObj> objs = new ArrayList<IMerlinObj>();

            LevelInfo(ErrorAnalysis this$0) {
            }
        }
        EnumMap<SimError.Level, LevelInfo> levelErrs = new EnumMap<SimError.Level, LevelInfo>(SimError.Level.class);
        for (IMerlinObj descendant : MerlinUtil.flatten(object.getChildren(), IMerlinObj.class)) {
            Collection<? extends SimError> descErrs = this.getErrors(descendant);
            for (SimError simError : descErrs) {
                LevelInfo info = levelErrs.computeIfAbsent(simError.level, l -> new LevelInfo(this));
                ++info.count;
                info.objs.addAll(simError.causeObjs);
            }
        }
        if (levelErrs.isEmpty()) {
            return errors;
        }
        return Stream.concat(errors.stream(), levelErrs.entrySet().stream().map(entry -> {
            LevelInfo info = (LevelInfo)entry.getValue();
            return new CompositeSimError((SimError.Level)entry.getKey(), info.count, info.objs);
        })).toList();
    }

    public Stream<? extends SimError> streamDeepErrors(Object obj) {
        return MerlinUtil.flatten(obj, IMerlinObj.class).stream().flatMap(o -> this.getErrors(o).stream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <KeyT, ValT> ValT getSharedValue(KeyT key, ComputeVal<? super KeyT, ? extends ValT> computeValue, TestClear<? super ValT> testClear) {
        SharedItem cached;
        Map<Object, SharedItem<?>> map = this.d_sharedCache;
        synchronized (map) {
            cached = this.d_sharedCache.computeIfAbsent(key, k -> new SharedItem<Object>(this.d_executor.submit(() -> {
                try (MerlinData.ReadLock lock = this.d_data.lockRead();){
                    Object ValT = computeValue.apply(this.d_data, key);
                    return ValT;
                }
            }), testClear));
        }
        try {
            return cached.val.get();
        }
        catch (InterruptedException | CancellationException e) {
            return computeValue.apply(this.d_data, key);
        }
        catch (ExecutionException e) {
            RuntimeException rexc;
            Throwable throwable = e.getCause();
            throw throwable instanceof RuntimeException ? (rexc = (RuntimeException)throwable) : new RuntimeException(e.getCause());
        }
    }

    public static interface IErrorGenerator<T> {
        public IObjectSource<? extends T> getObjects(MerlinData var1);

        public boolean isDirty(Events var1);

        public void generate(MerlinData var1, ErrorAnalysis var2, T var3, Consumer<? super SimError> var4);
    }

    public static interface ComputeVal<KeyT, ValT> {
        public ValT apply(MerlinData var1, KeyT var2);
    }

    public static interface TestClear<ValT> {
        public boolean test(MerlinData var1, Events var2);
    }

    private record SharedItem<ValT>(Future<ValT> val, TestClear<? super ValT> testClear) {
    }

    public static class CompositeSimError
    extends SimError {
        public final int errorCount;

        public CompositeSimError(SimError.Level level, int errorCount, Collection<? extends IMerlinObj> causeObjs) {
            super(level, Integer.toString(errorCount), "", causeObjs);
            this.errorCount = errorCount;
        }

        @Override
        public String format() {
            return String.format(Intl.intl("Group %1$s: %2$s"), this.level.label, this.cause);
        }
    }

    public static interface IObjectSource<T> {
        public Stream<T> streamObjects(MerlinData var1);
    }

    public static interface IGenerateErrors<T> {
        public void accept(MerlinData var1, ErrorAnalysis var2, T var3, Consumer<? super SimError> var4);
    }

    public static interface IIsDirtyPredicate<T> {
        public boolean test(Events var1);
    }

    public record ErrorGenerator<T>(IObjectSource<? extends T> objSource, IIsDirtyPredicate<? super T> isDirty, IGenerateErrors<? super T> generate) implements IErrorGenerator<T>
    {
        @Override
        public IObjectSource<? extends T> getObjects(MerlinData md) {
            return this.objSource;
        }

        @Override
        public boolean isDirty(Events events) {
            return this.isDirty.test(events);
        }

        @Override
        public void generate(MerlinData md, ErrorAnalysis analysis, T obj, Consumer<? super SimError> errors) {
            this.generate.accept(md, analysis, obj, errors);
        }
    }
}

