/*
 * Decompiled with CFR 0.152.
 */
package merlin;

import common.data.ClientAwareness;
import inferno.sim.KnownFuncs;
import java.awt.Font;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.vecmath.Point3d;
import merlin.EntryPoint;
import merlin.ErrorAnalysis;
import merlin.Intl;
import merlin.actions.CreateElevator;
import merlin.actions.EditCustomScripts;
import merlin.actions.RenameAction;
import merlin.actions.RunInferno;
import merlin.data.AMerlinObj;
import merlin.data.ActionProps;
import merlin.data.AssistedEvacTeam;
import merlin.data.AssistedEvacTeamComp;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.IMerlinObj;
import merlin.data.INamed;
import merlin.data.ImportedGeom;
import merlin.data.JsonObj;
import merlin.data.MeasurementRegionObj;
import merlin.data.MeasurementRegions;
import merlin.data.MerlinData;
import merlin.data.ObjsFilter;
import merlin.data.OccGroupObj;
import merlin.data.OccGroupTypeObj;
import merlin.data.OccSourceObj;
import merlin.data.Proxy;
import merlin.data.SequentialNameGen;
import merlin.data.SimParams;
import merlin.data.animation.Animation;
import merlin.data.animation.AnimationDB;
import merlin.data.camera.Camera;
import merlin.data.camera.CameraList;
import merlin.data.camera.CameraTour;
import merlin.data.camera.ICameraObj;
import merlin.data.egress.Floor;
import merlin.data.egress.FloorComposite;
import merlin.data.egress.SimError;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.egress.agents.IProfileProp;
import merlin.data.egress.agents.OccLocation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.OccProfileComp;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.agents.OccTargetComp;
import merlin.data.egress.agents.PredefOccArea;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.egress.agents.VehicleShapeComp;
import merlin.data.egress.blockages.EgressBlockage;
import merlin.data.egress.blockages.EgressBlockageComp;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorDoor;
import merlin.data.egress.elevators.ElevatorGroup;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.elevators.ElevatorUtil;
import merlin.data.egress.elevators.IElevatorComp;
import merlin.data.egress.geom.AEgressComp;
import merlin.data.egress.geom.EgressConnectorState;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.EgressStair;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.AbandonOccTargets;
import merlin.data.egress.scripting.AssistOccupants;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.BehaviorRoot;
import merlin.data.egress.scripting.ChangeBehavior;
import merlin.data.egress.scripting.ChangeProfile;
import merlin.data.egress.scripting.ChangeProfileProp;
import merlin.data.egress.scripting.ChangeTags;
import merlin.data.egress.scripting.CreateAttractor;
import merlin.data.egress.scripting.DestroyAttractor;
import merlin.data.egress.scripting.DetachAssistants;
import merlin.data.egress.scripting.GotoCurrentAttractor;
import merlin.data.egress.scripting.GotoElevators;
import merlin.data.egress.scripting.GotoExits;
import merlin.data.egress.scripting.GotoOcc;
import merlin.data.egress.scripting.GotoOccTarget;
import merlin.data.egress.scripting.GotoQueue;
import merlin.data.egress.scripting.GotoRooms;
import merlin.data.egress.scripting.GotoWaypoint;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.JoinOccGroup;
import merlin.data.egress.scripting.LookAhead;
import merlin.data.egress.scripting.LookAt;
import merlin.data.egress.scripting.RefugeFilter;
import merlin.data.egress.scripting.RemoveOcc;
import merlin.data.egress.scripting.ResumePrior;
import merlin.data.egress.scripting.RevertProfileProp;
import merlin.data.egress.scripting.Wait;
import merlin.data.egress.scripting.WaitForAssistance;
import merlin.data.egress.scripting.WaitUntil;
import merlin.data.egress.scripting.WaitUntilEnd;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.egress.scripting.attractors.AttractorComp;
import merlin.data.egress.scripting.attractors.AttractorRootComp;
import merlin.data.egress.scripting.attractors.AttractorTemplateComp;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.egress.scripting.queues.QueueObjectComp;
import merlin.data.egress.scripting.queues.QueuePath;
import merlin.data.egress.scripting.queues.QueuePathNode;
import merlin.data.egress.scripting.queues.QueueService;
import merlin.data.image.BGImage;
import merlin.data.image.RasterImage;
import merlin.data.material.Material;
import merlin.data.material.MaterialDB;
import merlin.data.montecarlo.MonteCarlo;
import merlin.data.property.PropertyDefs;
import merlin.data.scenario.Scenario;
import merlin.data.scenario.ScenarioRoot;
import merlin.data.scenario.ScenarioUtil;
import merlin.data.scripting.ScriptObj;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsComp;
import merlin.data.value.IFunction1d;
import merlin.data.value.ImpulseFunction1d;
import merlin.data.value.RandomizedImpulseFunction1d;
import merlin.geom.GeomUtil;
import merlin.gui.OccGroupsPanel;
import merlin.gui.guiUtil;
import merlin.mv.ModelView;
import merlin.mv.displays.IMerlinDispMgr;
import merlin.treeview.TVEntryPoint;
import merlin.unitsystem.SIUS;
import merlin.util.MerlinUtil;
import merlin.util.StringTagsUtil;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.PointInAABoxTest;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.NmtSolidUtil;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TriFunction;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.theUtil;
import thunderheadeng.util.value.DiscreteVariant;
import thunderheadeng.util.value.VariantUtil;

public class EntryPointFactory {
    private static final Map<Class<?>, EntryPoint> s_entryPoints = new LinkedHashMap();
    private static final Map<Pair<Class<?>, FuncType>, EntryPoint.Func<?>> s_funcs = new LinkedHashMap();
    private static final Map<FuncType, EntryPoint.Func> s_defaults = new HashMap<FuncType, EntryPoint.Func>();
    public static final Icon mgrIcon = guiUtil.loadMerlinIcon("manager8.png");
    public static final Icon occupantIcon = guiUtil.loadMerlinIcon("occupant16.png", 16);
    public static final Icon occupantGroupIcon = guiUtil.loadMerlinIcon("occ_group16.png", 16);
    public static final Icon occupantProfileIcon = guiUtil.loadMerlinIcon("occ_profile16.png", 16);
    public static final Icon changeOccProfilePropIcon = guiUtil.loadMerlinIcon("change_profile_prop16.png", 16);
    public static final Icon revertOccProfilePropIcon = guiUtil.loadMerlinIcon("reset_profile_prop16.png", 16);
    public static final Icon changeTagsIcon = guiUtil.loadMerlinIcon("tag16.png", 16);
    public static final Icon lookAtIcon = guiUtil.loadMerlinIcon("lookat16.png", 16);
    public static final Icon lookAheadIcon = guiUtil.loadMerlinIcon("lookahead16.png", 16);
    public static final Icon vehicleGroupIcon = guiUtil.loadMerlinIcon("vehicleShapes_16.png", 16);
    public static final Icon assistedEvacTeamGroupIcon = guiUtil.loadMerlinIcon("ae_team16.png", 16);
    public static final Icon vehicleIcon = guiUtil.loadMerlinIcon("vehicleShapes_16.png", 16);
    public static final Icon assistedEvacTeamIcon = guiUtil.loadMerlinIcon("ae_team16.png", 16);
    public static final Icon cameraListIcon = guiUtil.loadMerlinIcon("cameras16.png", 16);
    public static final Icon cameraIcon = guiUtil.loadMerlinIcon("camera16.png", 16);
    public static final Icon cameraTourIcon = guiUtil.loadMerlinIcon("camera_tour16.png", 16);
    public static final Icon floorIcon = guiUtil.loadMerlinIcon("floor16.png", 16);
    public static final Icon stairsIcon = guiUtil.loadMerlinIcon("stairs216.png", 16);
    public static final Icon exitIcon = guiUtil.loadMerlinIcon("exit16.png", 16);
    public static final Icon doorIcon = guiUtil.loadMerlinIcon("door216.png", 16);
    public static final Icon rampIcon = guiUtil.loadMerlinIcon("ramp16.png", 16);
    public static final Icon roomIcon = guiUtil.loadMerlinIcon("openrect16.png", 16);
    public static final Icon removeOccIcon = guiUtil.loadMerlinIcon("remove_occ16.png", 16);
    public static final Icon resumePriorIcon = guiUtil.loadMerlinIcon("return16.png", 16);
    public static final Icon refugeRoomIcon = guiUtil.loadMerlinIcon("refugeRoom16.png", 16);
    public static final Icon importedGeometry2DIcon = guiUtil.loadMerlinIcon("2Dgeometry16.png", 16);
    public static final Icon importedGeometry3DIcon = guiUtil.loadMerlinIcon("block16_2.gif", 16);
    public static final Icon importedGeometryGroupIcon = guiUtil.loadMerlinIcon("composite16.png", 16);
    public static final Icon floorGroupIcon = guiUtil.loadMerlinIcon("mesh16.png", 16);
    public static final Icon backgroundImageIcon = guiUtil.loadMerlinIcon("backgroundImage16.gif", 16);
    public static final Icon blankIcon = null;
    public static final Icon behaviorIcon = guiUtil.loadMerlinIcon("script16.png", 16);
    public static final Icon gotoIcon = guiUtil.loadMerlinIcon("flag16.png", 16);
    public static final Icon attractorIcon = guiUtil.loadMerlinIcon("attractor16.png", 16);
    public static final Icon attractorGroupIcon = EntryPointFactory.getManagerIcon(attractorIcon);
    public static final Icon abandonOccTargetsIcon = guiUtil.loadMerlinIcon("abandon_occloc16.png", 16);
    public static final Icon occTargetIcon;
    public static final Icon gotoOccTargetIcon;
    public static final Icon gotoOccIcon;
    public static final Icon gotoCurrentAttractorIcon;
    public static final Icon occTargetGroupIcon;
    public static final Icon waitIcon;
    public static final Icon waitUntilEndIcon;
    public static final Icon elevatorIcon;
    public static final Icon measurementRegionGroupIcon;
    public static final Icon measurementRegionIcon;
    public static final Icon occupantSourceGroupIcon;
    public static final Icon occupantSourceIcon;
    public static final Icon assistIcon;
    public static final Icon waitForAssistanceIcon;
    public static final Icon detachIcon;
    public static final Icon joinGroupIcon;
    public static final Icon leaveGroupIcon;
    public static final Icon queueIcon;
    public static final Icon queueGroupIcon;
    public static final Icon queuePathIcon;
    public static final Icon queueServiceIcon;
    public static final Icon queuePathNodeIcon;
    public static final Icon blockageIcon;
    public static final Icon blockageGroupIcon;
    public static final Icon createAttractorIcon;
    public static final Icon destroyAtttractorIcon;
    public static final Icon scenariosIcon;
    private static final Font s_plain;
    private static final Font s_bold;
    private static final Font s_italic;
    private static final Font s_italicBold;
    private static final Map<Class, ErrorAnalysis.IObjectSource> s_objSources;

    private static Icon getManagerIcon(Icon itemIcon) {
        return itemIcon == null ? null : new DecoratedIcon(itemIcon, mgrIcon, 3);
    }

    private static void registerDefault(FuncType funcType, EntryPoint.Func<?> func) {
        s_defaults.put(funcType, func);
    }

    private static <T> void register(Class<T> type, FuncType funcType, EntryPoint.Func<?> func) {
        s_funcs.put(new Pair<Class<T>, FuncType>(type, funcType), func);
    }

    private static <T, ReturnT> void register(Class<T> type, FuncType funcType, EntryPoint.Getter<T, ReturnT> getter) {
        EntryPointFactory.register(type, funcType, getter);
    }

    private static <T, ReturnT> void register(Class<T> type, FuncType funcType, EntryPoint.Supplier<T, ReturnT> supplier) {
        EntryPointFactory.register(type, funcType, supplier);
    }

    private static <T, ReturnT, ArgT> void register(Class<T> type, FuncType funcType, EntryPoint.Action<T, ReturnT, ArgT> action) {
        EntryPointFactory.register(type, funcType, action);
    }

    private static <T, ArgT> void register(Class<T> type, FuncType funcType, EntryPoint.Setter<T, ArgT> setter) {
        EntryPointFactory.register(type, funcType, setter);
    }

    private static void registerIcon(Class<?> type, Icon icon) {
        EntryPointFactory.register(type, FuncType.TV_GetIcon, new ConstantAsyncGetter(icon));
    }

    private static <T extends IMerlinObj> void registerType(Class<?> type, PropertyDefs<? super T> propertyDefs, String category, boolean searchable) {
        EntryPointFactory.registerType(type, propertyDefs, category, EntryPointFactory.makeValidType(category), searchable);
    }

    private static <T extends IMerlinObj> void registerType(Class<?> type, PropertyDefs<? super T> propertyDefs, String categoryName, String typeString, boolean searchable) {
        EntryPointFactory.register(type, FuncType.GetPropertyDefs, new ConstantSupplier(propertyDefs));
        EntryPointFactory.register(type, FuncType.TypeString, new ConstantGetter(typeString));
        EntryPointFactory.register(type, FuncType.CategoryName, new ConstantGetter(categoryName));
        EntryPointFactory.register(type, FuncType.IsSearchType, new ConstantSupplier(searchable));
    }

    public static <T> EntryPoint<T> get(T obj) {
        return EntryPointFactory.get(obj.getClass());
    }

    public static synchronized <T> EntryPoint<T> get(Class<T> clazz) {
        EntryPoint<T> ep = s_entryPoints.get(clazz);
        if (ep != null) {
            return ep;
        }
        TVEntryPoint tvep = new TVEntryPoint((EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetName), (EntryPoint.Setter)EntryPointFactory.findFunc(clazz, FuncType.TV_SetName), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_CanRename), (EntryPoint.AsyncGetter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetIcon), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetBaseFont), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_IsVisible), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_IsEnabled), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetForcedAutoexpand), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_IsLeaf), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetChildren), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetParent));
        ep = new EntryPoint<T>(clazz, tvep, (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetDeletionErr), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetConflict), (EntryPoint.Action)EntryPointFactory.findFunc(clazz, FuncType.Delete), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsAutoDeleteGroup), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsDelUndoable), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsVisible), (EntryPoint.Setter)EntryPointFactory.findFunc(clazz, FuncType.SetVisible), (EntryPoint.Supplier)EntryPointFactory.findFunc(clazz, FuncType.GetCompositeRoot), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetNameFormatRules), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetNameGenerator), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetUniqueNameGroup), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsIndexed), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsMovable), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.ShowBounds), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TypeString), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.CategoryName), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.DomainRequiredType), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.CanShowInReferencingLists), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetErrorGens), (EntryPoint.Supplier)EntryPointFactory.findFunc(clazz, FuncType.GetPropertyDefs), (EntryPoint.Supplier)EntryPointFactory.findFunc(clazz, FuncType.IsSearchType));
        s_entryPoints.put(clazz, ep);
        return ep;
    }

    private static Collection<SimError> lazyAdd(Collection<SimError> coll, SimError err) {
        if (coll.isEmpty()) {
            coll = new ArrayDeque<SimError>();
        }
        coll.add(err);
        return coll;
    }

    private static <T extends IMerlinObj> EntryPoint.Func<T> findFunc(Class<?> clazz, FuncType funcType) {
        EntryPoint.Func func = EntryPointFactory.findFuncHelper(clazz, funcType);
        return func != null ? func : s_defaults.get((Object)funcType);
    }

    private static <T extends IMerlinObj> EntryPoint.Func<T> findFuncHelper(Class<?> clazz, FuncType funcType) {
        if (clazz == null) {
            return null;
        }
        EntryPoint.Func<Object> func = s_funcs.get(new Pair(clazz, funcType));
        if (func != null) {
            return func;
        }
        func = EntryPointFactory.findFuncHelper(clazz.getSuperclass(), funcType);
        if (func != null) {
            return func;
        }
        for (Class<?> ifaceClass : clazz.getInterfaces()) {
            func = EntryPointFactory.findFuncHelper(ifaceClass, funcType);
            if (func == null) continue;
            return func;
        }
        return null;
    }

    public static synchronized Collection<EntryPoint> getAll() {
        return s_entryPoints.values();
    }

    private static <T> EntryPoint.Getter<T, T> getStandardConflictGetter(final Class<T> clazz) {
        return new EntryPoint.Getter<T, T>(){

            @Override
            public T get(MerlinData md, T comparable) {
                Collection members = EntryPointFactory.get(comparable).getRootComposite(md).flatten(clazz);
                for (Object conflict : members) {
                    if (!theUtil.equal(comparable, conflict)) continue;
                    return conflict;
                }
                return null;
            }
        };
    }

    private static <T, RetT> EntryPoint.Getter<T, RetT> always(RetT value) {
        return new ConstantGetter(value);
    }

    private static <T> ErrorAnalysis.IIsDirtyPredicate<? super T> getBasicErrorsDirtyTest() {
        return events -> false;
    }

    private static <T> ErrorAnalysis.IObjectSource<? extends T> objSourceFromRoot(Class<T> type) {
        return s_objSources.computeIfAbsent(type, t -> md -> EntryPointFactory.get(t).getRootComposite(md).flatten(t).stream());
    }

    private static <T> void registerBasicErrors(Class<T> type, boolean getSuperClassErrors, Collection<Class<? super T>> interfaceErrors, TriFunction<? super MerlinData, ? super ErrorAnalysis, ? super T, Collection<? extends SimError>> getErrors) {
        EntryPointFactory.registerErrors(type, getSuperClassErrors, interfaceErrors, EntryPointFactory.getBasicErrorsDirtyTest(), (MerlinData md, ErrorAnalysis analysis, ? super T obj, Consumer<SimError> consumeErrors) -> {
            Collection errors = (Collection)getErrors.apply(md, analysis, (Object)obj);
            errors.forEach(consumeErrors);
        });
    }

    private static <T> void registerErrors(Class<T> type, boolean getSuperClassErrors, Collection<Class<? super T>> interfaceErrors, ErrorAnalysis.IIsDirtyPredicate<? super T> isDirty, ErrorAnalysis.IGenerateErrors<? super T> generate) {
        EntryPointFactory.registerErrors(type, getSuperClassErrors, interfaceErrors, new ErrorAnalysis.ErrorGenerator<T>(EntryPointFactory.objSourceFromRoot(type), isDirty, generate));
    }

    private static <T> void registerErrors(Class<T> type, boolean getSuperClassErrors, Collection<Class<? super T>> interfaceErrors, ErrorAnalysis.IErrorGenerator<? super T> ... generators) {
        Stream<Class<Object>> superClassStream = getSuperClassErrors && type.getSuperclass() != null ? Stream.concat(Stream.of(type.getSuperclass()), interfaceErrors.stream()) : interfaceErrors.stream();
        Set superClasses = superClassStream.collect(Collectors.toSet());
        if (superClasses.isEmpty()) {
            EntryPointFactory.register(type, FuncType.GetErrorGens, EntryPointFactory.always(Arrays.asList(generators)));
        } else {
            EntryPointFactory.register(type, FuncType.GetErrorGens, (MerlinData md, T obj) -> {
                ArrayList<ErrorAnalysis.IErrorGenerator> gens = new ArrayList<ErrorAnalysis.IErrorGenerator>(superClasses.size() + generators.length);
                for (Class superType : superClasses) {
                    gens.addAll(EntryPointFactory.get(superType).getErrorGenerators(md, obj));
                }
                gens.addAll(Arrays.asList(generators));
                return gens;
            });
        }
    }

    private static int getTotNumOccs(MerlinData md, OccSourceObj os) {
        IFunction1d flowRate = os.get(OccSourceObj.PROP_FLOW_RATE);
        return flowRate.getMaxNumOccs(os.getSeed(), md.simParams.get(SimParams.RUNTIME_MAX));
    }

    private static NotEnoughAssisting getNotEnoughAssisting(ErrorAnalysis errAnalysis) {
        return errAnalysis.getSharedValue("NOT_ENOUGH_ASSISTING", (md, key) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, (md, events) -> {
            Predicate<Class> isModified = type -> EntryPointFactory.isModified(events, type);
            return isModified.test(OccProfile.class) || isModified.test(EgressAgent.class) || isModified.test(OccSourceObj.class) || isModified.test(Behavior.class) || isModified.test(VehicleShape.class) || isModified.test(SimParams.class);
        });
    }

    private static void getNotEnoughAssistingErrors(Consumer<? super SimError> errors, MerlinData md, ErrorAnalysis errAnalysis, EgressAgent agent) {
        VehicleShape shape = agent.getProfile().get(OccProfile.PROP_VEHICLE_SHAPE);
        if (shape == VehicleShape.NONE) {
            return;
        }
        Behavior behavior = agent.getBehavior();
        List<int[]> nNeeded = EntryPointFactory.getNotEnoughAssisting((ErrorAnalysis)errAnalysis).getOccHelpersNeeded.apply(shape, behavior);
        if (nNeeded.isEmpty()) {
            return;
        }
        for (int[] error : nNeeded) {
            String cause = String.format(Intl.intl("Occupant might not be assisted by enough occupants in Behavior:\"%s\" action %d."), guiUtil.escapeHTML(behavior.getName()), error[0] + 1);
            String fix = String.format(Intl.intl("Have at least %d more occupants assist the teams in this behavior action."), error[1]);
            errors.accept(new SimError(SimError.Level.MODERATE, cause, fix, agent));
        }
    }

    private static void getNotEnoughAssistingErrors(Consumer<? super SimError> errors, MerlinData md, ErrorAnalysis errAnalysis, OccSourceObj os) {
        double totNumOccs = EntryPointFactory.getTotNumOccs(md, os);
        if (totNumOccs == 0.0) {
            return;
        }
        Map<Behavior, Double> behaviors = os.get(OccSourceObj.PROP_BEHAVIOR_DIST).getWeights();
        Map<OccProfile, Double> profiles = os.get(OccSourceObj.PROP_PROFILE_DIST).getWeights();
        for (Map.Entry<OccProfile, Double> pentry : profiles.entrySet()) {
            VehicleShape shape = pentry.getKey().get(OccProfile.PROP_VEHICLE_SHAPE);
            if (shape == VehicleShape.NONE) continue;
            OccProfile profile = pentry.getKey();
            for (Map.Entry<Behavior, Double> bentry : behaviors.entrySet()) {
                Behavior behavior;
                List<int[]> nNeeded;
                int noccs = (int)Math.round(totNumOccs * pentry.getValue() * bentry.getValue());
                if (noccs == 0 || (nNeeded = EntryPointFactory.getNotEnoughAssisting((ErrorAnalysis)errAnalysis).getOccHelpersNeeded.apply(shape, behavior = bentry.getKey())).isEmpty()) continue;
                for (int[] error : nNeeded) {
                    String cause = String.format(Intl.intl("Occupants generated with profile, \"%1$s\", and behavior, \"%2$s\", might not be assisted by enough occupants in behavior action %3$d."), guiUtil.escapeHTML(profile.getName()), guiUtil.escapeHTML(behavior.getName()), error[0] + 1);
                    String fix = String.format(Intl.intl("Have at least %d more occupants assist the teams in this behavior action."), error[1]);
                    errors.accept(new SimError(SimError.Level.MODERATE, cause, fix, os, behavior, profile));
                }
            }
        }
    }

    private static FitInElevator getFitInElevator(ErrorAnalysis errAnalysis) {
        return errAnalysis.getSharedValue("FIT_IN_ELEVATOR", (md, key) -> {
            Collection<Elevator> elevators = md.elevators.flatten(Elevator.class);
            if (elevators.isEmpty()) {
                return new FitInElevator((vs, b) -> Collections.emptyList());
            }
            Function<Pair, List> getError = p -> {
                Collection<GotoElevators> goToElevators = ((Behavior)p.v2).flatten(GotoElevators.class);
                Collection<IBehaviorAction> allActions = ((Behavior)p.v2).flatten(IBehaviorAction.class);
                if (goToElevators.isEmpty()) {
                    return Collections.emptyList();
                }
                Point3d[] points = ((VehicleShape)p.v1).getBodyPoints();
                double area = Util3D.simplePolygonArea(Arrays.asList(points));
                double occArea = Math.PI * Math.pow(0.24, 2.0);
                int correspondingOccCount = (int)Math.round(area / occArea);
                HashMap<Elevator, Boolean> checked = new HashMap<Elevator, Boolean>();
                int actionID = 1;
                int currentHelperCount = 0;
                ArrayList<Pair<Integer, Integer>> errorActionIDs = new ArrayList<Pair<Integer, Integer>>();
                for (IBehaviorAction action : allActions) {
                    if (action instanceof WaitForAssistance) {
                        currentHelperCount += ((VehicleShape)p.v1).get(VehicleShape.PROP_ATTACHED_AGENTS_POSITIONS).length;
                        checked.clear();
                    } else if (action instanceof DetachAssistants) {
                        currentHelperCount = 0;
                        checked.clear();
                    } else if (action instanceof GotoElevators) {
                        GotoElevators gte = (GotoElevators)action;
                        boolean isError = true;
                        Set<Elevator> els = gte.getElevators();
                        if (els.isEmpty()) {
                            els = new HashSet<Elevator>(elevators);
                        }
                        if (els.isEmpty()) {
                            isError = false;
                        }
                        for (Elevator el : els) {
                            int chc;
                            boolean fit = checked.computeIfAbsent(el, arg_0 -> EntryPointFactory.lambda$getFitInElevator$61(correspondingOccCount, chc = currentHelperCount, arg_0));
                            isError &= !fit;
                            if (!fit) continue;
                            break;
                        }
                        if (isError) {
                            errorActionIDs.add(new Pair<Integer, Integer>(actionID, correspondingOccCount + currentHelperCount));
                        }
                    }
                    ++actionID;
                }
                return errorActionIDs;
            };
            Map errorCache = Collections.synchronizedMap(new HashMap());
            return new FitInElevator((vs, b) -> (List)errorCache.computeIfAbsent(new Pair<VehicleShape, Behavior>((VehicleShape)vs, (Behavior)b), getError));
        }, (md, events) -> {
            Predicate<Class> isModified = type -> EntryPointFactory.isModified(events, type);
            return isModified.test(OccProfile.class) || isModified.test(EgressAgent.class) || isModified.test(OccSourceObj.class) || isModified.test(Behavior.class) || isModified.test(VehicleShape.class) || isModified.test(Elevator.class);
        });
    }

    private static void getVehicleNotFitInElevatorErrors(Consumer<? super SimError> errors, MerlinData md, ErrorAnalysis errAnalysis, EgressAgent a) {
        VehicleShape vs = (VehicleShape)a.getStoredProfileVal(OccProfile.PROP_VEHICLE_SHAPE).value();
        if (vs == null) {
            return;
        }
        Behavior b = a.getBehavior();
        List<Pair<Integer, Integer>> errorActions = EntryPointFactory.getFitInElevator((ErrorAnalysis)errAnalysis).getErrors.apply(vs, b);
        if (errorActions.isEmpty()) {
            return;
        }
        for (Pair<Integer, Integer> action : errorActions) {
            Integer actionID = (Integer)action.v1;
            Integer minLoad = (Integer)action.v2;
            String cause = String.format(Intl.intl("Occupant cannot fit into any elevator in behavior action %1$d, minimum nominal load required is %2$d."), actionID, minLoad);
            String fix = String.format(Intl.intl("Increase nominal load of at least one elevator used in behavior action:%1$d to %2$d."), actionID, minLoad);
            errors.accept(new SimError(SimError.Level.MODERATE, cause, fix, new IMerlinObj[0]));
        }
    }

    private static void getVehicleNotFitInElevatorErrors(Consumer<? super SimError> errors, MerlinData md, ErrorAnalysis errAnalysis, OccSourceObj source) {
        for (OccProfile prof : source.get(OccSourceObj.PROP_PROFILE_DIST).getWeights().keySet()) {
            VehicleShape vs = prof.get(OccProfile.PROP_VEHICLE_SHAPE);
            if (vs == null) continue;
            for (Behavior b : source.get(OccSourceObj.PROP_BEHAVIOR_DIST).getWeights().keySet()) {
                List<Pair<Integer, Integer>> errorActions = EntryPointFactory.getFitInElevator((ErrorAnalysis)errAnalysis).getErrors.apply(vs, b);
                for (Pair<Integer, Integer> action : errorActions) {
                    Integer actionID = (Integer)action.v1;
                    Integer minLoad = (Integer)action.v2;
                    String cause = String.format(Intl.intl("Occupants generated with profile, \"%1$s\", and behavior, \"%2$s\", cannot fit into any elevator in behavior action %3$d, minimum nominal load required is %4$d."), guiUtil.escapeHTML(prof.getName()), guiUtil.escapeHTML(b.getName()), actionID, minLoad);
                    String fix = String.format(Intl.intl("Increase Nominal Load of at least one elevator used in behavior action %1$d to %2$d."), actionID, minLoad);
                    errors.accept(new SimError(SimError.Level.MODERATE, cause, fix, prof, b));
                }
            }
        }
    }

    static void registerCameraTour() {
        EntryPointFactory.registerIcon(CameraTour.class, cameraTourIcon);
        EntryPointFactory.registerType(CameraTour.class, CameraTour.LOCAL_PROPS, Intl.intl("Camera Tour"), true);
    }

    private static void getDoubleDeckElevatorWarnings(Consumer<? super SimError> errors, MerlinData md, Elevator elevator) {
        PropValue<Boolean> enabledObj = elevator.getWithDetails(MerlinData.ENABLED);
        boolean enabled = enabledObj.asOption().orElse(true);
        if (enabled && elevator.isDoubleDeck()) {
            ElevatorRoom room;
            ElevatorRoom dischargeRoom = elevator.getDischargeRoom();
            ArrayList<ElevatorRoom> rooms = new ArrayList<ElevatorRoom>(elevator.getDeepMembers(ElevatorRoom.class));
            int index = 0;
            Iterator iterator = rooms.iterator();
            while (iterator.hasNext() && dischargeRoom != (room = (ElevatorRoom)iterator.next())) {
                ++index;
            }
            assert (index < rooms.size());
            int beforeDischarge = index;
            int afterDischarge = rooms.size() - index - 2;
            boolean incorrectNumberOfLevels = false;
            if (rooms.size() < 4) {
                errors.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("Double-deck elevator has to contain at least 4 levels."), Intl.intl("Connect the double-deck elevator to additional levels."), elevator));
                incorrectNumberOfLevels = true;
            }
            if (beforeDischarge % 2 != 0) {
                errors.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("Double-deck elevator has to contain an even number of levels under the discharge level."), Intl.intl("Make sure the double-deck elevator contains even number of levels under the discharge level."), elevator));
                incorrectNumberOfLevels = true;
            }
            if (afterDischarge < 0) {
                errors.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("Double-deck elevator has to contain at least one level above the discharge level."), Intl.intl("Make sure the double-deck elevator contains at least one level above the discharge level."), elevator));
                incorrectNumberOfLevels = true;
            } else if (afterDischarge % 2 != 0) {
                errors.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("Double-deck elevator has to contain an even number of levels above the upper discharge level."), Intl.intl("Make sure the double-deck elevator contains even number of levels above the upper discharge level."), elevator));
                incorrectNumberOfLevels = true;
            }
            if (!incorrectNumberOfLevels) {
                double dischargeBottomHeight = dischargeRoom.getBounds().getMinZ();
                double dischargeTopHeight = ((ElevatorRoom)rooms.get(index + 1)).getBounds().getMinZ();
                double dischargeTopToBottom = dischargeTopHeight - dischargeBottomHeight;
                for (int i = 0; i < rooms.size(); i += 2) {
                    ElevatorRoom er1 = (ElevatorRoom)rooms.get(i);
                    ElevatorRoom er2 = (ElevatorRoom)rooms.get(i + 1);
                    double er1Height = er1.getBounds().getMinZ();
                    double er2Height = er2.getBounds().getMinZ();
                    double distanceTopToBottom = er2Height - er1Height;
                    if (theUtil.eq(distanceTopToBottom, dischargeTopToBottom, 1.0E-6)) continue;
                    errors.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("Distances between odd and even elevator levels within pairs of levels in a double-deck elevator have to be equal to the distance between discharge floors."), Intl.intl("Change height of floors to match the requirement."), elevator));
                    break;
                }
                if (elevator.getConnectedFloor((ElevatorRoom)rooms.get(index + 1)) == null) {
                    errors.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("Elevator is not connected at its upper discharge floor."), Intl.intl("Make sure the elevator's doors are enabled at the upper discharge floor or change the elevator's discharge floor."), elevator));
                }
            }
        }
    }

    private static void getOverlappingOccSourceAndObstaclesErrors(Consumer<? super SimError> errors, MerlinData md, OccSourceObj obj) {
        Collection<EgressBlockage> blockages = GeomUtil.findPreventingBlockages(md, new AABoxTest(obj.getBounds(), 1.0E-6), 1);
        if (blockages.isEmpty()) {
            return;
        }
        OccSourceObj.ModelRep occSourceModel = obj.getModel();
        if (occSourceModel == null) {
            return;
        }
        for (EgressBlockage eb : blockages) {
            NmtSolidUtil.IntersectionResult overlapResult;
            BooleanSupplier testResult;
            if (!eb.getPreventOccPlacement() || !(testResult = () -> EntryPointFactory.lambda$getOverlappingOccSourceAndObstaclesErrors$113(overlapResult = NmtSolidUtil.testIntersection(eb.getSearchModel(), occSourceModel.rep(), occSourceModel.isSolid(), true), occSourceModel)).getAsBoolean()) continue;
            String msg = obj.get(OccSourceObj.PROP_ENFORCE_FLOWRATE).getValue(new Random()) != false ? Intl.intl(String.format("Occupant source enforces flow rate and intersects obstacle %s, which doesn't allow occupants. The source may need to produce some occupants inside the obstacle.", eb.getName())) : Intl.intl(String.format("Occupant source doesn't enforce flow rate and intersects obstacle %s, which doesn't allow occupants. The source may produce fewer occupants than expected.", eb.getName()));
            errors.accept(new SimError(SimError.Level.MODERATE, msg, Intl.intl("Move the obstacle or occupant source bounds so that they do not overlap or uncheck 'Prevent Occupant Placement' on obstacle."), obj, eb));
        }
    }

    private static final ErrorAnalysis.ErrorGenerator<OccGroupObj> getOccGroupObjErrorGenerator() {
        ErrorAnalysis.IIsDirtyPredicate isDirty = events -> EntryPointFactory.isModified(events, EgressAgent.class) || EntryPointFactory.isModified(events, Behavior.class) || EntryPointFactory.isModified(events, ChangeBehavior.class) || EntryPointFactory.isModified(events, GotoOccTarget.class) || EntryPointFactory.isModified(events, OccGroupTypeObj.class) || EntryPointFactory.isModified(events, OccGroupObj.class) || EntryPointFactory.isModified(events, Proxy.class);
        ErrorAnalysis.IGenerateErrors<OccGroupObj> genErrs = (md, analysis, group, errors) -> {
            String fix;
            Object errorMsg;
            String disabledLeaderErrorMsg = Intl.intl("Movement group leader is disabled.");
            String disabledLeaderFix = Intl.intl("Enable the movement group leader.");
            boolean multipleBehaviors = false;
            PropValue<Boolean> groupEnabledObj = group.getWithDetails(MerlinData.ENABLED);
            boolean groupEnabled = groupEnabledObj.orElse(true);
            if (groupEnabled) {
                Behavior b = null;
                for (Proxy proxy : group.flatten(Proxy.class)) {
                    Object obj;
                    PropValue<Boolean> enabled = proxy.getWithDetails(MerlinData.ENABLED);
                    if (!enabled.isUniform() || !((obj = proxy.getObj()) instanceof EgressAgent)) continue;
                    EgressAgent a = (EgressAgent)obj;
                    if (!enabled.get().booleanValue()) {
                        if (group instanceof OccGroupTypeObj || !group.get(OccGroupObj.PROP_REQUIRES_GROUP_LEADER).booleanValue() || group.get(OccGroupObj.PROP_GROUP_LEADER) != a) continue;
                        errors.accept(new SimError(SimError.Level.CRITICAL, disabledLeaderErrorMsg, disabledLeaderFix, (IMerlinObj)group));
                        continue;
                    }
                    if (b == null) {
                        b = a.getBehavior();
                        continue;
                    }
                    if (multipleBehaviors || a.getBehavior() == b) continue;
                    String errorMsg2 = Intl.intl("Occupants in the movement group have multiple behaviors. Movement group members must share the same behavior.");
                    String fix2 = Intl.intl("Change the behavior of selected occupants.");
                    errors.accept(new SimError(SimError.Level.CRITICAL, errorMsg2, fix2, (IMerlinObj)group));
                    multipleBehaviors = true;
                }
                if (b != null) {
                    Collection<ChangeBehavior> changeBehaviorActions = b.deepFlatten(ChangeBehavior.class);
                    for (ChangeBehavior changeBehavior : changeBehaviorActions) {
                        if (changeBehavior.getAllTargetBehaviors().size() <= 1) continue;
                        errorMsg = String.format(Intl.intl("Occupants in the movement group have behavior change with multiple options in behavior %s. Only a single-option behavior change is allowed for movement group members."), guiUtil.escapeHTML(((Behavior)md.hierarchy.getParent(changeBehavior)).getName()));
                        fix = Intl.intl("Change the behavior of movement group members.");
                        errors.accept(new SimError(SimError.Level.CRITICAL, (String)errorMsg, fix, (IMerlinObj)group));
                        break;
                    }
                    EntryPointFactory.getGotoOccTargetErrors(errors, analysis, group, true, b);
                }
                if (!(group instanceof OccGroupTypeObj) && group.get(OccGroupObj.PROP_REQUIRES_GROUP_LEADER).booleanValue()) {
                    EgressAgent leader = group.get(OccGroupObj.PROP_GROUP_LEADER);
                    if (leader == null) {
                        String string = Intl.intl("Movement group leader is not set.");
                        String fix3 = Intl.intl("Set the movement group leader to one of the movement group members.");
                        errors.accept(new SimError(SimError.Level.CRITICAL, string, fix3, (IMerlinObj)group));
                    } else if (!leader.isEnabled()) {
                        errors.accept(new SimError(SimError.Level.CRITICAL, disabledLeaderErrorMsg, disabledLeaderFix, (IMerlinObj)group));
                    } else if (group.flatten(Proxy.class).stream().noneMatch(p -> p.getObj() == leader)) {
                        errors.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("Movement group leader is not a member of the group."), Intl.intl("Select a group member as the leader."), new IMerlinObj[0]));
                    }
                }
            }
            if (group instanceof OccGroupTypeObj) {
                OccGroupTypeObj groupType = (OccGroupTypeObj)group;
                if (groupType.get(OccGroupTypeObj.PROP_SPECIFY_PROFILES).booleanValue()) {
                    Map<OccProfile, OccGroupTypeObj.GroupCreationDataObj> profData = groupType.get(OccGroupTypeObj.PROP_PROFILE_DATA);
                    double d = 0.0;
                    for (OccProfile prof : profData.keySet()) {
                        if (!((d += profData.get((Object)prof).prefNumberOfMembers.getMin().get(Unit.ONE)) >= 1.0)) continue;
                        break;
                    }
                    if (d < 1.0) {
                        errorMsg = OccGroupsPanel.MIN_WARNING;
                        fix = Intl.intl("Review movement group creation parameters.");
                        errors.accept(new SimError(SimError.Level.CRITICAL, (String)errorMsg, fix, (IMerlinObj)group));
                    }
                } else {
                    double min = groupType.get(OccGroupTypeObj.PROP_PREF_NUMBER_OF_MEMBERS).getMin().get(Unit.ONE);
                    if (min < 1.0) {
                        String errorMsg4 = OccGroupsPanel.MIN_WARNING;
                        String fix4 = Intl.intl("Review group creation parameters.");
                        errors.accept(new SimError(SimError.Level.CRITICAL, errorMsg4, fix4, (IMerlinObj)group));
                    }
                }
            }
        };
        return new ErrorAnalysis.ErrorGenerator<OccGroupObj>(EntryPointFactory.objSourceFromRoot(OccGroupObj.class), isDirty, genErrs);
    }

    private static <T> EntryPoint.Getter<T, EntryPoint.INameGroup> nameGroup(Function<MerlinData, ? extends Collection<?>> getter) {
        EntryPoint.INameGroup group = getter::apply;
        return new ConstantGetter(group);
    }

    private static void getBehaviorActionErrors(MerlinData md, IBehaviorAction obj, Consumer<? super SimError> errors) {
        Behavior behavior = (Behavior)md.hierarchy.getParent(obj);
        if (behavior == null) {
            return;
        }
        int tindex = 0;
        for (IBehaviorAction action : behavior.flatten(IBehaviorAction.class)) {
            if (action == obj) break;
            if (action instanceof ChangeBehavior) {
                ChangeBehavior cb = (ChangeBehavior)action;
                for (Behavior targetBehavior : cb.getAllTargetBehaviors()) {
                    Optional<IBehaviorAction> targetLast = targetBehavior.getLastAction();
                    if (!targetLast.isPresent() || targetLast.get() instanceof ResumePrior) continue;
                    errors.accept(new SimError(SimError.Level.MODERATE, String.format(Intl.intl("Behavior action, %s, might not be reached because of a prior Change Behavior action."), guiUtil.escapeHTML(obj.getName())), Intl.intl("Change the prior Change Behavior action so all its target behaviors end with a \"Resume Prior\" action."), obj, targetBehavior));
                    break;
                }
            }
            ++tindex;
        }
        if (obj.mustBeLast() && tindex != behavior.getMembers().size() - 1) {
            String error = String.format(Intl.intl("%s must be last in the behavior list."), guiUtil.escapeHTML(obj.getName()));
            String fix = String.format(Intl.intl("Delete %s or drag it until it is the last action in the behavior list."), guiUtil.escapeHTML(obj.getName()));
            errors.accept(new SimError(SimError.Level.CRITICAL, error, fix, obj));
        }
    }

    private static Collection<Behavior> getRefugeRoomBehaviors(ErrorAnalysis errAnalysis) {
        return errAnalysis.getSharedValue("REFUGE_ROOM_BEHAVIORS", (md, obj) -> md.behaviors.flatten(Behavior.class).stream().filter(b -> {
            GotoRooms gotoRooms;
            Optional<IBehaviorAction> last = b.getLastAction();
            if (!last.isPresent()) {
                return false;
            }
            IBehaviorAction patt0$temp = last.get();
            return patt0$temp instanceof GotoRooms && EntryPointFactory.isGotoRefugeRoom(gotoRooms = (GotoRooms)patt0$temp);
        }).collect(Collectors.toList()), (md, events) -> EntryPointFactory.isModified(events, Behavior.class) || EntryPointFactory.isModified(events, EgressAgent.class) || EntryPointFactory.isModified(events, IEgressOccupiable.class));
    }

    private static boolean isGotoRefugeRoom(GotoRooms rooms) {
        return rooms.getFilter() instanceof RefugeFilter;
    }

    private static void getRefugeRoomSizeWarnings(Consumer<? super SimError> errors, MerlinData md, ErrorAnalysis errAnalysis, GotoRooms b1Action) {
        if (!EntryPointFactory.isGotoRefugeRoom(b1Action)) {
            return;
        }
        Behavior b1 = md.hierarchy.getAncestor(b1Action, Behavior.class);
        if (b1 == null) {
            return;
        }
        Collection<Behavior> refugeRoomBehaviors = EntryPointFactory.getRefugeRoomBehaviors(errAnalysis);
        Collection<Object> b1TargetRooms = Collections.emptyList();
        try {
            b1TargetRooms = b1Action.getDestination().getExitComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        int totalCapacity = 0;
        for (Object object : b1TargetRooms) {
            if (!(object instanceof IEgressOccupiable)) continue;
            IEgressOccupiable room = (IEgressOccupiable)object;
            double density = 1.0 / PredefOccArea.Token.WAITING_SPACES.area.getValue(SIUS.unit(2));
            double area = room.getArea().getValue(SIUS.unit(4));
            totalCapacity += KnownFuncs.maxPersons(area, density);
        }
        int numAgents = md.agents.flatten(EgressAgent.class, a -> a.getBehavior() == b1).size();
        for (Behavior b2 : refugeRoomBehaviors) {
            if (b2 == b1) continue;
            GotoRooms b2Action = (GotoRooms)b2.getLastAction().get();
            Collection<Object> b2TargetRooms = Collections.emptyList();
            try {
                b2TargetRooms = b2Action.getDestination().getExitComponents();
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            if (b2TargetRooms.isEmpty() || !b1TargetRooms.containsAll(b2TargetRooms)) continue;
            numAgents += md.agents.flatten(EgressAgent.class, a -> a.getBehavior() == b2).size();
        }
        if (numAgents > totalCapacity) {
            String string = String.format(Intl.intl("Refuge rooms are not large enough for all occupants seeking refuge."), new Object[0]);
            String fix = "";
            errors.accept(new SimError(SimError.Level.MODERATE, string, fix, b1Action));
        }
    }

    private static <OccT, ProfT> void getValueErrors(IMerlinObj obj, IProfileProp<OccT, ProfT> pprop, ProfT value, Consumer<? super SimError> errors) {
        pprop.getValueErrors((MerlinData)obj.getDomain(), obj, value, errors);
    }

    public static String makeValidType(String str) {
        return str.replace(' ', '_').replace('/', '_').replace('\\', '_');
    }

    private static void getAssistedEvacErrors(ErrorAnalysis analysis, IMerlinObj obj, OccProfile profile, Behavior behavior, Consumer<? super SimError> errors) {
        AssistWarnings assistWarnings = analysis.getSharedValue("ASSISTED_EVAC_WARNINGS", (md, key) -> new AssistWarnings(Collections.synchronizedMap(new HashMap())), (md, events) -> EntryPointFactory.isModified(events, OccProfile.class) || EntryPointFactory.isModified(events, EgressAgent.class) || EntryPointFactory.isModified(events, OccSourceObj.class) || EntryPointFactory.isModified(events, Behavior.class) || EntryPointFactory.isModified(events, VehicleShape.class));
        Pair<Behavior, AssistState> key2 = new Pair<Behavior, AssistState>(behavior, new AssistState(profile));
        List gens = assistWarnings.value.computeIfAbsent(key2, p -> {
            ArrayList<Function<IMerlinObj, SimError>> errGens = new ArrayList<Function<IMerlinObj, SimError>>();
            if (p.v1 != null) {
                EntryPointFactory.getAssistedEvacErrors((AssistState)p.v2, (Behavior)p.v1, errGens);
            }
            return errGens;
        });
        for (Function gen : gens) {
            errors.accept((SimError)gen.apply(obj));
        }
    }

    private static void getAssistedEvacErrors(AssistState initState, Behavior behavior, List<Function<IMerlinObj, SimError>> errors) {
        try {
            AssistState state = initState.clone();
            behavior.tracePath(bnode -> {
                if (bnode.action instanceof ChangeBehavior && ((ChangeBehavior)bnode.action).getAllTargetBehaviors().size() > 1 || bnode.action instanceof ChangeProfile && ((ChangeProfile)bnode.action).getAllTargetProfiles().size() > 1) {
                    throw new CannotTraceException();
                }
                if (bnode.action instanceof ChangeProfile) {
                    ChangeProfile cp = (ChangeProfile)bnode.action;
                    if (cp.getAllTargetProfiles().isEmpty()) {
                        return null;
                    }
                    OccProfile prof = cp.getAllTargetProfiles().iterator().next();
                    state.update(prof);
                } else if (bnode.action instanceof ChangeProfileProp) {
                    state.update((ChangeProfileProp)bnode.action);
                } else if (bnode.action instanceof RevertProfileProp) {
                    state.update((RevertProfileProp)bnode.action);
                } else if (bnode.action instanceof DetachAssistants) {
                    if (!state.waitingForOrReceivingAssistance) {
                        String error = Intl.intl("Detach from Assistants action must be preceded by a Wait for Assistance action.");
                        String fix = Intl.intl("Add a Wait for Assistance action before the Detach from Assistants action.");
                        errors.add(o -> new SimError(SimError.Level.CRITICAL, error, fix, (IMerlinObj)o));
                    }
                    state.waitingForOrReceivingAssistance = false;
                } else if (bnode.action instanceof WaitForAssistance) {
                    if (state.waitingForOrReceivingAssistance) {
                        String error = Intl.intl("Assistance doesn't end before another Wait for Assistance action starts.");
                        String fix = Intl.intl("Remove the second Wait for Assistance action, or add a Detach from Assistants action.");
                        errors.add(o -> new SimError(SimError.Level.CRITICAL, error, fix, (IMerlinObj)o));
                    } else if (state.numVehicleAttachPoints == -1) {
                        String err = Intl.intl("Occupants must have a polygon shape when they request assistance.");
                        String fix = Intl.intl("Change shape to a polygon before requesting assistance or do not request assistance in the occupant's behavior.");
                        errors.add(o -> new SimError(SimError.Level.CRITICAL, err, fix, (IMerlinObj)o));
                    } else if (state.numVehicleAttachPoints == 0) {
                        errors.add(o -> {
                            boolean generatedOccs = o instanceof OccSourceObj;
                            String err = generatedOccs ? Intl.intl("Generated occupants do not have any positions defined for attached occupants.") : Intl.intl("Occupant vehicle does not have any positions defined for attached occupants.");
                            String fix = Intl.intl("In vehicle shape, define attached occupant positions.");
                            return new SimError(SimError.Level.MODERATE, err, fix, (IMerlinObj)o);
                        });
                    }
                    state.waitingForOrReceivingAssistance = true;
                } else if (bnode.action instanceof IDestinationAction && state.requiresAssistance && !state.waitingForOrReceivingAssistance) {
                    errors.add(o -> {
                        String fix;
                        String err;
                        boolean generatedOccs = o instanceof OccSourceObj;
                        if (generatedOccs) {
                            err = Intl.intl("Generated occupants require assistance to move but do not request assistance through their behavior.");
                            fix = Intl.intl("Change behavior or change profile so occupants do not require assistance.");
                        } else {
                            err = Intl.intl("Occupant requires assistance to move but does not request assistance through its behavior.");
                            fix = Intl.intl("Change behavior or change profile so occupant does not require assistance.");
                        }
                        return new SimError(SimError.Level.MODERATE, err, fix, (IMerlinObj)o);
                    });
                }
                return null;
            });
        }
        catch (CannotTraceException cannotTraceException) {
            // empty catch block
        }
    }

    public static boolean isModified(Events events, Class<?> type) {
        IEventRecord<?> rec = events.getEvents(type, new Class[0]);
        return rec.isModified() && (!rec.areChangesOnly() || !rec.areChangesExclusiveTo(MerlinData.SELECTION_CHANGED, MerlinData.VISIBILITY));
    }

    private static Set<Behavior> getBehaviorsGotoOccTargets(ErrorAnalysis errAnalysis) {
        return errAnalysis.getSharedValue("BEHAVIORS_GO_TO_OCC_TARGETS", (md, obj) -> md.behaviors.flatten(Behavior.class).stream().filter(behavior -> behavior.somePathsContain(GotoOccTarget.class)).collect(Collectors.toCollection(() -> new LinkedIdentityHashSet())), (md, events) -> EntryPointFactory.isModified(events, Behavior.class) || EntryPointFactory.isModified(events, ChangeBehavior.class));
    }

    private static boolean requiresAssistance(OccProfile prof) {
        return EntryPointFactory.requiresAssistance((IUrn)prof.get(OccProfile.PROP_REQUIRES_ASSISTANCE));
    }

    private static boolean requiresAssistance(IUrn<Boolean> requiresAssistance) {
        assert (requiresAssistance.isConstant());
        return requiresAssistance.stream().findFirst().orElse(false);
    }

    private static boolean hasVehicle(OccProfile prof) {
        return prof.get(OccProfile.PROP_VEHICLE_SHAPE) != null;
    }

    private static boolean requiresAssistanceWithNoVehicle(OccProfile prof) {
        return !EntryPointFactory.hasVehicle(prof) && EntryPointFactory.requiresAssistance(prof);
    }

    private static void getGotoOccTargetErrors(Consumer<? super SimError> errors, ErrorAnalysis errAnalysis, IMerlinObj source, boolean isInGroup, Behavior behavior) {
        if (isInGroup && EntryPointFactory.getBehaviorsGotoOccTargets(errAnalysis).contains(behavior)) {
            errors.accept(new SimError(SimError.Level.MODERATE, String.format(Intl.intl("Occupants in movement groups cannot use a behavior that goes to occupant targets. See behavior, %1$s."), MerlinUtil.getName(behavior)), Intl.intl("Use a different behavior or change the referenced behavior."), source, behavior));
        }
    }

    private static void getBadDirectBehaviorErrors(Consumer<? super SimError> errors, IMerlinObj source, Behavior behavior) {
        Optional<IBehaviorAction> taction = behavior.getLastAction();
        if (taction.isPresent() && taction.get() instanceof ResumePrior) {
            errors.accept(new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("%1$s cannot directly reference a behavior that ends with a \"Resume Prior\" action."), guiUtil.escapeHTML(MerlinUtil.getName(source))), Intl.intl("Use a different behavior or change the referenced behavior."), source, behavior));
        }
    }

    private static void getInsidePreventingBlockageErrors(MerlinData md, OccLocation occLoc, Consumer<? super SimError> errors, EgressAgent occ) {
        if (occLoc == null || occLoc.room == null) {
            return;
        }
        Collection<EgressBlockage> blockages = GeomUtil.findPreventingBlockages(md, new PointInAABoxTest(occLoc.point, 1.0E-6), 1);
        for (EgressBlockage blockage : blockages) {
            boolean blocking = GeomUtil.doBlockagesContainPoint(Set.of(blockage), occLoc.point);
            if (!blocking) continue;
            String error = String.format(Intl.intl("%1$s is placed in a blocking obstacle %2$s."), guiUtil.escapeHTML(occ.getName()), blockage.getName());
            String fix = Intl.intl("Delete or move to another location, or disable obstacle's 'Prevent Occupant Placement' property.");
            errors.accept(new SimError(SimError.Level.MODERATE, error, fix, occ, blockage));
        }
    }

    private static void getResolvedProfileErrors(IMerlinObj obj, OccProfile profile, Consumer<? super SimError> errors, String fixProfile) {
        if (EntryPointFactory.requiresAssistanceWithNoVehicle(profile)) {
            if (obj instanceof EgressAgent) {
                String error = Intl.intl("Only occupants with vehicle shapes can receive assistance.");
                errors.accept(new SimError(SimError.Level.CRITICAL, error, fixProfile, obj));
            } else {
                String error = String.format(Intl.intl("Profile, \"%s\", requires assistance but has no vehicle shape."), guiUtil.escapeHTML(profile.getName()));
                errors.accept(new SimError(SimError.Level.CRITICAL, error, fixProfile, obj));
            }
        }
    }

    private static /* synthetic */ boolean lambda$getOverlappingOccSourceAndObstaclesErrors$113(NmtSolidUtil.IntersectionResult overlapResult, OccSourceObj.ModelRep occSourceModel) {
        if (overlapResult.positive) {
            return true;
        }
        if (!occSourceModel.isSolid()) {
            if (!occSourceModel.rep().getFaces().isEmpty()) {
                return overlapResult == NmtSolidUtil.IntersectionResult.TOUCHING_FACE;
            }
            if (!occSourceModel.rep().getEdges().isEmpty()) {
                return overlapResult == NmtSolidUtil.IntersectionResult.MODEL2_EDGE_ADJACENT_MODEL1;
            }
        }
        return false;
    }

    private static /* synthetic */ Boolean lambda$getFitInElevator$61(int correspondingOccCount, int chc, Elevator elev) {
        double load = elev.getNominalLoad().get(Unit.ONE);
        return (double)(correspondingOccCount + chc) <= load;
    }

    private static /* synthetic */ List lambda$getNotEnoughAssisting$56(Map occHelpersNeeded, Function getOccHelpersNeeded, VehicleShape shape, Behavior behavior) {
        return (List)occHelpersNeeded.computeIfAbsent(new Pair<VehicleShape, Behavior>(shape, behavior), getOccHelpersNeeded);
    }

    private static /* synthetic */ List lambda$getNotEnoughAssisting$55(Map rounds, int[] noCount, Pair pair) {
        VehicleShape shape = (VehicleShape)pair.v1;
        Behavior behavior = (Behavior)pair.v2;
        List errors = Collections.emptyList();
        int goalIx = 0;
        for (IBehaviorAction action : behavior.flatten(IBehaviorAction.class)) {
            if (!(action instanceof WaitForAssistance)) {
                ++goalIx;
                continue;
            }
            WaitForAssistance wfa = (WaitForAssistance)action;
            int maxHelpersRemaining = 0;
            if (rounds.isEmpty()) {
                maxHelpersRemaining = shape.get(VehicleShape.PROP_ATTACHED_AGENTS_POSITIONS).length;
            } else {
                Set<AssistedEvacTeam> requestedTeams = wfa.get(WaitForAssistance.TEAMS);
                block1: for (Map teamAssists : rounds.values()) {
                    int helpersRemaining = shape.get(VehicleShape.PROP_ATTACHED_AGENTS_POSITIONS).length;
                    Set<AssistedEvacTeam> teams = requestedTeams.isEmpty() ? teamAssists.keySet() : requestedTeams;
                    for (AssistedEvacTeam team : teams) {
                        int nassists = teamAssists.getOrDefault(team, noCount)[0];
                        if ((helpersRemaining -= nassists) > 0) continue;
                        maxHelpersRemaining = 0;
                        break block1;
                    }
                    maxHelpersRemaining = Math.max(maxHelpersRemaining, helpersRemaining);
                }
            }
            if (maxHelpersRemaining > 0) {
                if (errors.isEmpty()) {
                    errors = new ArrayList(1);
                }
                errors.add(new int[]{goalIx, maxHelpersRemaining});
            }
            ++goalIx;
        }
        return errors;
    }

    private static /* synthetic */ int[] lambda$getNotEnoughAssisting$54(Behavior b) {
        return new int[]{0};
    }

    static {
        gotoOccTargetIcon = occTargetIcon = guiUtil.loadMerlinIcon("occloc16.png", 16);
        gotoOccIcon = occupantIcon;
        gotoCurrentAttractorIcon = attractorIcon;
        occTargetGroupIcon = EntryPointFactory.getManagerIcon(occTargetIcon);
        waitUntilEndIcon = waitIcon = guiUtil.loadMerlinIcon("clock16.png", 16);
        elevatorIcon = guiUtil.loadMerlinIcon("elevator16.png", 16);
        measurementRegionGroupIcon = guiUtil.loadMerlinIcon("measure-area16.png", 16);
        measurementRegionIcon = guiUtil.loadMerlinIcon("measure-area-obj16.png", 16);
        occupantSourceGroupIcon = guiUtil.loadMerlinIcon("occ_source_group16.png", 16);
        occupantSourceIcon = guiUtil.loadMerlinIcon("occ_source16.png", 16);
        assistIcon = guiUtil.loadMerlinIcon("assist16.png", 16);
        waitForAssistanceIcon = guiUtil.loadMerlinIcon("waitForAssistance16.png", 16);
        detachIcon = guiUtil.loadMerlinIcon("detach16.png", 16);
        joinGroupIcon = guiUtil.loadMerlinIcon("occ_group16.png", 16);
        leaveGroupIcon = guiUtil.loadMerlinIcon("occ_group16.png", 16);
        queueIcon = guiUtil.loadMerlinIcon("queue16.png", 16);
        queueGroupIcon = guiUtil.loadMerlinIcon("queue16.png", 16);
        queuePathIcon = guiUtil.loadMerlinIcon("path16.png", 16);
        queueServiceIcon = guiUtil.loadMerlinIcon("service16.png", 16);
        queuePathNodeIcon = guiUtil.loadMerlinIcon("Node16.png", 16);
        blockageIcon = guiUtil.loadMerlinIcon("blockage.png");
        blockageGroupIcon = EntryPointFactory.getManagerIcon(blockageIcon);
        createAttractorIcon = guiUtil.loadMerlinIcon("createattractor16.png", 16);
        destroyAtttractorIcon = guiUtil.loadMerlinIcon("destroyattractor16.png", 16);
        scenariosIcon = guiUtil.loadMerlinIcon("composite16_4.png", 16);
        s_plain = new Font("Sans Serif", 0, 11);
        s_bold = new Font("Sans Serif", 1, 11);
        s_italic = new Font("Sans Serif", 2, 11);
        s_italicBold = s_italic.deriveFont(1);
        EntryPointFactory.registerDefault(FuncType.GetDeletionErr, new ConstantGetter(null));
        EntryPointFactory.registerDefault(FuncType.GetConflict, new ConstantGetter(null));
        EntryPointFactory.registerDefault(FuncType.Delete, new NullAction(false));
        EntryPointFactory.registerDefault(FuncType.IsAutoDeleteGroup, new ConstantGetter(false));
        EntryPointFactory.registerDefault(FuncType.IsDelUndoable, EntryPointFactory.always(true));
        EntryPointFactory.registerDefault(FuncType.DomainRequiredType, EntryPointFactory.always(null));
        EntryPointFactory.registerDefault(FuncType.IsVisible, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.SetVisible, new NullSetter());
        EntryPointFactory.registerDefault(FuncType.GetCompositeRoot, new ConstantSupplier(null));
        EntryPointFactory.registerDefault(FuncType.GetNameGenerator, new ConstantGetter(null));
        EntryPointFactory.registerDefault(FuncType.GetUniqueNameGroup, new ConstantGetter(null));
        EntryPointFactory.registerDefault(FuncType.IsIndexed, new ConstantGetter(false));
        EntryPointFactory.registerDefault(FuncType.IsMovable, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.ShowBounds, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.TypeString, new EntryPoint.Getter<Object, String>(){

            @Override
            public String get(MerlinData md, Object obj) {
                return EntryPointFactory.makeValidType(EntryPointFactory.get(obj).getCategoryName(md, obj));
            }
        });
        EntryPointFactory.registerDefault(FuncType.CategoryName, new ConstantGetter(""));
        EntryPointFactory.registerDefault(FuncType.CanShowInReferencingLists, EntryPointFactory.always(true));
        EntryPointFactory.registerDefault(FuncType.GetPropertyDefs, new ConstantSupplier(null));
        EntryPointFactory.registerDefault(FuncType.IsSearchType, new ConstantSupplier(true));
        EntryPointFactory.registerDefault(FuncType.GetErrorGens, new ConstantGetter(Collections.EMPTY_LIST));
        EntryPointFactory.registerDefault(FuncType.TV_GetName, new ConstantGetter(""));
        EntryPointFactory.registerDefault(FuncType.TV_SetName, new NullSetter());
        EntryPointFactory.registerDefault(FuncType.TV_CanRename, new ConstantGetter(false));
        EntryPointFactory.registerDefault(FuncType.TV_GetIcon, new ConstantAsyncGetter(null));
        EntryPointFactory.registerDefault(FuncType.TV_GetBaseFont, new ConstantGetter(s_plain));
        EntryPointFactory.registerDefault(FuncType.TV_IsVisible, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.TV_IsEnabled, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.TV_GetForcedAutoexpand, new ConstantGetter(false));
        EntryPointFactory.registerDefault(FuncType.TV_IsLeaf, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.TV_GetChildren, new ConstantGetter(Collections.EMPTY_LIST));
        EntryPointFactory.registerDefault(FuncType.TV_GetParent, new ConstantGetter(null));
        EntryPointFactory.register(MerlinData.class, FuncType.TV_GetChildren, (MerlinData md, T obj) -> Arrays.asList(md.cameras, md.tags, md.sceneGeom, md.profiles, md.vehicleShapes, md.assistedEvacTeams, md.behaviors, md.queues, md.occSources, md.agents, md.occGroups, md.occGroupTypes, md.occTargets, md.attractorsRoot, md.elevators, md.regions, md.blockages, md.floors));
        s_objSources = Collections.synchronizedMap(new HashMap());
        EntryPointFactory.register(INamed.class, FuncType.TV_GetName, new EntryPoint.Getter<INamed, String>(){

            @Override
            public String get(MerlinData md, INamed obj) {
                return obj.getName();
            }
        });
        EntryPointFactory.register(INamed.class, FuncType.TV_SetName, new EntryPoint.Setter<INamed, String>(){

            @Override
            public void set(MerlinData md, INamed obj, String arg) {
                assert (false);
                obj.setName(arg);
            }
        });
        EntryPointFactory.register(INamed.class, FuncType.TV_CanRename, new EntryPoint.Getter<INamed, Boolean>(){

            @Override
            public Boolean get(MerlinData md, INamed obj) {
                return obj.isSetNameSupported();
            }
        });
        EntryPointFactory.register(INamed.class, FuncType.GetNameFormatRules, new EntryPoint.Getter<INamed, Predicate<String>>(){

            @Override
            public Predicate<String> get(MerlinData md, INamed obj) {
                return Predicates.alwaysTrue();
            }
        });
        EntryPointFactory.register(IMerlinObj.class, FuncType.TV_GetChildren, (MerlinData md, T obj) -> obj.getChildren());
        EntryPointFactory.register(IMerlinObj.class, FuncType.TV_GetParent, (MerlinData md, T obj) -> md.hierarchy.getParent(obj));
        EntryPointFactory.register(IMerlinObj.class, FuncType.TV_IsLeaf, (MerlinData md, T obj) -> obj.getChildren().isEmpty());
        EntryPointFactory.register(IMerlinObj.class, FuncType.TV_SetName, new EntryPoint.Setter<IMerlinObj, String>(){

            @Override
            public void set(MerlinData md, IMerlinObj obj, String arg) {
                RenameAction.rename(md, null, Arrays.asList(obj), arg);
            }
        });
        EntryPointFactory.register(IMerlinObj.class, FuncType.Delete, new EntryPoint.Action<IMerlinObj, Boolean, Object>(){

            @Override
            public Boolean perform(MerlinData md, IMerlinObj obj, Object arg) {
                Object parentObj = md.hierarchy.getParent(obj);
                if (!(parentObj instanceof Composite)) {
                    return false;
                }
                Composite parent = (Composite)parentObj;
                return parent.remove(obj);
            }
        });
        EntryPointFactory.register(IMerlinObj.class, FuncType.IsVisible, new EntryPoint.Getter<IMerlinObj, Boolean>(){

            @Override
            public Boolean get(MerlinData md, IMerlinObj obj) {
                PropValue<Boolean> value = obj.getWithDetails(MerlinData.VISIBILITY);
                boolean basevis = value.asOption().orElse(true);
                return basevis && !md.displayFilter.filter(obj);
            }
        });
        EntryPointFactory.register(IMerlinObj.class, FuncType.TV_IsEnabled, new EntryPoint.Getter<IMerlinObj, Boolean>(){

            @Override
            public Boolean get(MerlinData md, IMerlinObj obj) {
                PropValue<Boolean> val = obj.getWithDetails(MerlinData.ENABLED);
                return val.asOption().orElse(true);
            }
        });
        EntryPointFactory.register(IMerlinObj.class, FuncType.SetVisible, new EntryPoint.Setter<IMerlinObj, Boolean>(){

            @Override
            public void set(MerlinData md, IMerlinObj obj, Boolean arg) {
                obj.set(MerlinData.VISIBILITY, arg);
            }
        });
        EntryPointFactory.register(IMerlinObj.class, FuncType.TV_IsVisible, new EntryPoint.Getter<IMerlinObj, Boolean>(){

            @Override
            public Boolean get(MerlinData md, IMerlinObj obj) {
                PropValue<Boolean> value = obj.getWithDetails(MerlinData.VISIBILITY);
                return value.asOption().orElse(true);
            }
        });
        EntryPointFactory.register(Animation.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.animations);
        EntryPointFactory.register(Animation.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.animNameGen);
        EntryPointFactory.register(Animation.class, FuncType.IsDelUndoable, EntryPointFactory.always(false));
        EntryPointFactory.registerType(Animation.class, Animation.PROP_TYPES, Intl.intl("Animation"), false);
        EntryPointFactory.register(AnimationDB.class, FuncType.TV_GetParent, (MerlinData md, T obj) -> null);
        EntryPointFactory.registerType(AnimationDB.class, AnimationDB.PROP_TYPES, Intl.intl("Animation Database"), false);
        EntryPointFactory.register(ActionProps.class, FuncType.TV_GetParent, EntryPointFactory.always(null));
        EntryPointFactory.register(OccProfile.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.profiles);
        EntryPointFactory.register(OccProfile.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.profNameGen);
        EntryPointFactory.register(OccProfile.class, FuncType.GetUniqueNameGroup, EntryPointFactory.nameGroup(md -> md.profiles.flatten(OccProfile.class)));
        EntryPointFactory.registerIcon(OccProfile.class, occupantProfileIcon);
        EntryPointFactory.registerType(OccProfile.class, OccProfile.ALL_PROPS, Intl.intl("Occupant Profile"), Intl.intl("Profile"), true);
        EntryPointFactory.register(OccProfile.class, FuncType.DomainRequiredType, EntryPointFactory.always(OccProfile.class));
        EntryPointFactory.register(OccProfile.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(OccProfile.class, FuncType.GetConflict, new EntryPoint.Getter<OccProfile, OccProfile>(){

            @Override
            public OccProfile get(MerlinData md, OccProfile comparable) {
                if (theUtil.equal(comparable, md.profiles.NO_CHANGE)) {
                    return md.profiles.NO_CHANGE;
                }
                return EntryPointFactory.getStandardConflictGetter(OccProfile.class).get(md, comparable);
            }
        });
        EntryPointFactory.register(OccProfileComp.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.profiles);
        EntryPointFactory.registerIcon(OccProfileComp.class, occupantProfileIcon);
        EntryPointFactory.registerType(OccProfileComp.class, OccProfileComp.PROP_TYPES, Intl.intl("Occupant Profile Group"), Intl.intl("Profile_Group"), true);
        EntryPointFactory.register(VehicleShape.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.vehicleShapes);
        EntryPointFactory.register(VehicleShape.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.vehicleShapeNameGen);
        EntryPointFactory.registerIcon(VehicleShape.class, vehicleIcon);
        EntryPointFactory.registerType(VehicleShape.class, VehicleShape.PROP_TYPES, Intl.intl("Vehicle Shape"), true);
        EntryPointFactory.register(VehicleShape.class, FuncType.DomainRequiredType, EntryPointFactory.always(VehicleShape.class));
        EntryPointFactory.register(VehicleShape.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(VehicleShape.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(VehicleShape.class));
        EntryPointFactory.register(VehicleShapeComp.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.vehicleShapes);
        EntryPointFactory.registerIcon(VehicleShapeComp.class, vehicleGroupIcon);
        EntryPointFactory.registerType(VehicleShapeComp.class, VehicleShapeComp.PROP_TYPES, Intl.intl("Vehicle Shape Group"), true);
        EntryPointFactory.register(QueueObject.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.queues);
        EntryPointFactory.register(QueueObject.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.queueObjectNameGen);
        EntryPointFactory.registerIcon(QueueObject.class, queueIcon);
        EntryPointFactory.registerType(QueueObject.class, QueueObject.PROP_TYPES, Intl.intl("Queue"), true);
        EntryPointFactory.registerErrors(QueueObject.class, true, Set.of(), (Events events) -> QueueObject.testValidateDirty(events), (MerlinData md, ErrorAnalysis analysis, ? super T obj, Consumer<SimError> errors) -> obj.validate(md, SimError.Level.MODERATE, errors));
        EntryPointFactory.register(QueueObject.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(QueueObject.class));
        EntryPointFactory.register(IQueueElement.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.queues);
        EntryPointFactory.register(IQueueElement.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.registerType(IQueueElement.class, null, Intl.intl("Queue Element"), false);
        EntryPointFactory.register(QueuePath.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.queues);
        EntryPointFactory.register(QueuePath.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.queuePathNameGen);
        EntryPointFactory.registerIcon(QueuePath.class, queuePathIcon);
        EntryPointFactory.registerType(QueuePath.class, QueuePath.PROP_TYPES, Intl.intl("Queue Path"), Intl.intl("Path"), true);
        EntryPointFactory.registerIcon(QueuePathNode.class, queuePathNodeIcon);
        EntryPointFactory.registerType(QueuePathNode.class, QueuePathNode.PROP_TYPES, Intl.intl("Queue Path Node"), Intl.intl("Node"), true);
        EntryPointFactory.register(QueuePathNode.class, FuncType.IsIndexed, new ConstantGetter(true));
        EntryPointFactory.registerBasicErrors(QueuePathNode.class, false, Set.of(), (md, analysis, obj) -> {
            if (obj.getRoom() == null) {
                return Arrays.asList(new SimError(SimError.Level.CRITICAL, Intl.intl("Queue Path Node is not in a room."), Intl.intl("Move Queue Path Node to a room."), (IMerlinObj)obj));
            }
            return Collections.emptyList();
        });
        EntryPointFactory.register(QueueService.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.queueServiceNameGen);
        EntryPointFactory.registerIcon(QueueService.class, queueServiceIcon);
        EntryPointFactory.registerType(QueueService.class, QueueService.PROP_TYPES, Intl.intl("Queue Service"), Intl.intl("Service"), true);
        EntryPointFactory.registerBasicErrors(QueueService.class, false, Set.of(), (md, analysis, obj) -> {
            if (obj.getRoom() == null) {
                return Arrays.asList(new SimError(SimError.Level.CRITICAL, Intl.intl("Queue Service is not in a room."), Intl.intl("Move Queue Service to a room."), (IMerlinObj)obj));
            }
            return Collections.emptyList();
        });
        EntryPointFactory.register(QueueObjectComp.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.queues);
        EntryPointFactory.register(QueueObjectComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.queueObjectNameGen);
        EntryPointFactory.registerIcon(QueueObjectComp.class, queueGroupIcon);
        EntryPointFactory.registerType(QueueObjectComp.class, QueueObjectComp.PROP_TYPES, Intl.intl("Queue Group"), true);
        EntryPointFactory.register(OccTargetComp.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.occTargets);
        EntryPointFactory.register(OccTargetComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.occTargetsNameGen);
        EntryPointFactory.registerIcon(OccTargetComp.class, occTargetGroupIcon);
        EntryPointFactory.registerType(OccTargetComp.class, OccTargetComp.PROP_TYPES, Intl.intl("Occupant Target Group"), Intl.intl("Occ_Target_Group"), true);
        EntryPointFactory.register(OccTarget.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.occTargets);
        EntryPointFactory.register(OccTarget.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.occTargetsNameGen);
        EntryPointFactory.registerIcon(OccTarget.class, occTargetIcon);
        EntryPointFactory.registerType(OccTarget.class, OccTarget.PROPS, Intl.intl("Occupant Target"), Intl.intl("Occ_Target"), true);
        EntryPointFactory.register(OccTarget.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(OccTarget.class));
        EntryPointFactory.registerBasicErrors(OccTarget.class, false, Set.of(), (md, analysis, obj) -> {
            if (!obj.isEnabled()) {
                return Collections.emptyList();
            }
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (obj.getRoom() == null) {
                errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Occupant target is not in a room."), Intl.intl("Move occupant target to a room."), (IMerlinObj)obj));
            }
            return errors;
        });
        EntryPointFactory.register(AttractorRootComp.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.attractorsRoot);
        EntryPointFactory.register(AttractorRootComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.attractorsNameGen);
        EntryPointFactory.registerIcon(AttractorRootComp.class, attractorGroupIcon);
        EntryPointFactory.registerType(AttractorRootComp.class, AttractorRootComp.PROP_TYPES, Intl.intl("Triggers"), true);
        EntryPointFactory.register(AttractorComp.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.attractorsRoot);
        EntryPointFactory.register(AttractorComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.attractorsNameGen);
        EntryPointFactory.registerIcon(AttractorComp.class, attractorGroupIcon);
        EntryPointFactory.registerType(AttractorComp.class, AttractorComp.PROP_TYPES, Intl.intl("Trigger Group"), true);
        EntryPointFactory.register(AttractorComp.class, FuncType.GetDeletionErr, new EntryPoint.Getter<AttractorComp, Exception>(){

            @Override
            public Exception get(MerlinData md, AttractorComp obj) {
                if (obj == md.attractors) {
                    return new Exception(Intl.intl("Cannot delete Placed Triggers group."));
                }
                for (Object child : obj.getChildren()) {
                    EntryPoint ep = EntryPointFactory.get(child);
                    try {
                        ep.testDelete(md, child);
                    }
                    catch (Exception e) {
                        return e;
                    }
                }
                return null;
            }
        });
        EntryPointFactory.register(AttractorTemplateComp.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.attractorsRoot);
        EntryPointFactory.register(AttractorTemplateComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.attractorsNameGen);
        EntryPointFactory.registerIcon(AttractorTemplateComp.class, attractorGroupIcon);
        EntryPointFactory.registerType(AttractorTemplateComp.class, AttractorTemplateComp.PROP_TYPES, Intl.intl("Trigger Template Group"), true);
        EntryPointFactory.register(AttractorTemplateComp.class, FuncType.GetDeletionErr, new EntryPoint.Getter<AttractorTemplateComp, Exception>(){

            @Override
            public Exception get(MerlinData md, AttractorTemplateComp obj) {
                if (obj == md.attractorTemplates) {
                    return new Exception(Intl.intl("Cannot delete Trigger Templates group."));
                }
                for (Object child : obj.getChildren()) {
                    EntryPoint ep = EntryPointFactory.get(child);
                    try {
                        ep.testDelete(md, child);
                    }
                    catch (Exception e) {
                        return e;
                    }
                }
                return null;
            }
        });
        EntryPointFactory.register(Attractor.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.attractorsRoot);
        EntryPointFactory.register(Attractor.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.attractorsNameGen);
        EntryPointFactory.registerIcon(Attractor.class, attractorIcon);
        EntryPointFactory.registerType(Attractor.class, Attractor.PROPS, Intl.intl("Trigger"), true);
        EntryPointFactory.register(Attractor.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(Attractor.class));
        EntryPointFactory.register(Attractor.class, FuncType.ShowBounds, new ConstantGetter(false));
        EntryPointFactory.registerBasicErrors(Attractor.class, false, Set.of(), (md, analysis, obj) -> {
            if (!obj.isEnabled()) {
                return Collections.emptyList();
            }
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (obj.getRoom() == null && obj.requiresLocation()) {
                errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Trigger is not in a room."), Intl.intl("Move trigger to a room."), (IMerlinObj)obj));
            }
            if (obj.get(Attractor.AWARENESS) == Attractor.Awareness.ROOMS && obj.get(Attractor.ROOMS).isEmpty()) {
                errors.add(new SimError(SimError.Level.MODERATE, Intl.intl("No rooms are specified. Trigger will not be visible to any occupants."), Intl.intl("Specify rooms for the trigger."), (IMerlinObj)obj));
            }
            return errors;
        });
        EntryPointFactory.register(AssistedEvacTeam.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.assistedEvacTeams);
        EntryPointFactory.register(AssistedEvacTeam.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.assistedEvacTeamNameGen);
        EntryPointFactory.registerIcon(AssistedEvacTeam.class, assistedEvacTeamIcon);
        EntryPointFactory.registerType(AssistedEvacTeam.class, AssistedEvacTeam.PROP_TYPES, Intl.intl("Assisted Evac Team"), true);
        EntryPointFactory.register(AssistedEvacTeam.class, FuncType.DomainRequiredType, EntryPointFactory.always(AssistedEvacTeam.class));
        EntryPointFactory.register(AssistedEvacTeam.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(AssistedEvacTeam.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(AssistedEvacTeam.class));
        EntryPointFactory.register(AssistedEvacTeamComp.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.assistedEvacTeams);
        EntryPointFactory.register(AssistedEvacTeamComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.assistedEvacTeamNameGen);
        EntryPointFactory.registerIcon(AssistedEvacTeamComp.class, assistedEvacTeamGroupIcon);
        EntryPointFactory.registerType(AssistedEvacTeamComp.class, AssistedEvacTeamComp.PROP_TYPES, Intl.intl("Assisted Evac Team Group"), true);
        EntryPointFactory.register(Composite.class, FuncType.GetDeletionErr, new EntryPoint.Getter<Composite<?>, Exception>(){

            @Override
            public Exception get(MerlinData md, Composite<?> obj) {
                if (md.hierarchy.getParent(obj) == md) {
                    return new Exception(Intl.intl("Cannot delete a root object."));
                }
                for (Object child : obj.getChildren()) {
                    EntryPoint ep = EntryPointFactory.get(child);
                    try {
                        ep.testDelete(md, child);
                    }
                    catch (Exception e) {
                        return e;
                    }
                }
                return null;
            }
        });
        EntryPointFactory.register(Composite.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(GeomComposite.class, FuncType.TV_GetBaseFont, new EntryPoint.Getter<GeomComposite<?>, Font>(){

            @Override
            public Font get(MerlinData md, GeomComposite<?> obj) {
                if (md.floors.getActive().getWorkingGeomGroup() == obj) {
                    return s_italic;
                }
                return EntryPointFactory.get(GeomComposite.class.getSuperclass()).tvEntryPoint.getBaseFont(md, obj);
            }
        });
        EntryPointFactory.register(GeomComposite.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<GeomComposite<?>, Icon>(){

            @Override
            public Icon get(MerlinData md, GeomComposite<?> obj, Consumer<Icon> whenReady) {
                if (md.hierarchy.isDescendent(md.sceneGeom, obj)) {
                    return importedGeometryGroupIcon;
                }
                if (md.hierarchy.isDescendent(md.floors, obj)) {
                    return floorGroupIcon;
                }
                if (md.hierarchy.isDescendent(md.elevators, obj)) {
                    return elevatorIcon;
                }
                return blankIcon;
            }
        });
        EntryPointFactory.register(GeomComposite.class, FuncType.CategoryName, new EntryPoint.Getter<GeomComposite<?>, String>(){

            @Override
            public String get(MerlinData md, GeomComposite<?> obj) {
                if (md.hierarchy.isDescendent(md.sceneGeom, obj)) {
                    return Intl.intl("Geometry Group");
                }
                if (md.hierarchy.isDescendent(md.floors, obj)) {
                    return Intl.intl("Geometry Group");
                }
                if (md.hierarchy.isDescendent(md.elevators, obj)) {
                    return Intl.intl("Elevator Group");
                }
                return Intl.intl("Group");
            }
        });
        EntryPointFactory.register(EgressAgent.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.agents);
        EntryPointFactory.register(EgressAgent.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("Occupant", 2)));
        EntryPointFactory.registerIcon(EgressAgent.class, occupantIcon);
        EntryPointFactory.registerType(EgressAgent.class, EgressAgent.PROP_TYPES, Intl.intl("Occupant"), true);
        EntryPointFactory.registerErrors(EgressAgent.class, false, Set.of(), (Events events) -> EntryPointFactory.isModified(events, EgressAgent.class) || EntryPointFactory.isModified(events, AEgressComp.class) || EntryPointFactory.isModified(events, OccProfile.class) || EntryPointFactory.isModified(events, Behavior.class) || EntryPointFactory.isModified(events, ChangeBehavior.class) || EntryPointFactory.isModified(events, ChangeProfile.class) || EntryPointFactory.isModified(events, ChangeProfileProp.class) || EntryPointFactory.isModified(events, RevertProfileProp.class) || EntryPointFactory.isModified(events, OccSourceObj.class) || EntryPointFactory.isModified(events, VehicleShape.class) || EntryPointFactory.isModified(events, Elevator.class) || EntryPointFactory.isModified(events, GotoQueue.class) || EntryPointFactory.isModified(events, QueueObject.class) || EntryPointFactory.isModified(events, SimParams.class) || EntryPointFactory.isModified(events, EgressBlockage.class), (MerlinData md, ErrorAnalysis analysis, ? super T obj, Consumer<SimError> errors) -> {
            String fix;
            String error;
            OccLocation location = obj.getLocation();
            if (!obj.isEnabled()) {
                return;
            }
            if (location.room == null || location.room instanceof AEgressComp && !((AEgressComp)((Object)location.room)).isEnabled()) {
                error = String.format(Intl.intl("%s is not in a room."), guiUtil.escapeHTML(obj.getName()));
                fix = Intl.intl("Delete or move to a room.");
                errors.accept(new SimError(SimError.Level.CRITICAL, error, fix, (IMerlinObj)obj));
            }
            if (location.isOverlappingAgents()) {
                error = String.format(Intl.intl("%s is overlapping other occupants."), guiUtil.escapeHTML(obj.getName()));
                fix = Intl.intl("Delete or move to avoid overlap.");
                errors.accept(new SimError(SimError.Level.MODERATE, error, fix, (IMerlinObj)obj));
            }
            if (location.overlapsWalls) {
                error = String.format(Intl.intl("%s is overlapping a room boundary."), guiUtil.escapeHTML(obj.getName()));
                fix = Intl.intl("Delete or move to avoid overlap.");
                errors.accept(new SimError(SimError.Level.CRITICAL, error, fix, (IMerlinObj)obj));
            }
            if (location.failsFilter) {
                error = String.format(Intl.intl("%s is placed in a rejected component."), guiUtil.escapeHTML(obj.getName()));
                fix = Intl.intl("Delete or move to another location, or change rejected components.");
                errors.accept(new SimError(SimError.Level.MODERATE, error, fix, (IMerlinObj)obj));
            }
            EntryPointFactory.getInsidePreventingBlockageErrors(md, location, errors, obj);
            EntryPointFactory.getResolvedProfileErrors(obj, obj.getProfile(), errors, Intl.intl("Change shape or change profile so the occupant can move without assistance."));
            EntryPointFactory.getAssistedEvacErrors(analysis, obj, obj.getProfile(), obj.getBehavior(), errors);
            EntryPointFactory.getNotEnoughAssistingErrors((Consumer<? super SimError>)errors, md, analysis, obj);
            EntryPointFactory.getVehicleNotFitInElevatorErrors((Consumer<? super SimError>)errors, md, analysis, obj);
            for (GotoQueue gotoQueue : obj.getBehavior().flatten(GotoQueue.class)) {
                ArrayList<QueueObject> naughtyQueues = new ArrayList<QueueObject>();
                boolean allowedIn = false;
                for (QueueObject q : gotoQueue.getQueues()) {
                    ObjsFilter<OccProfile> filter = q.getRestrictedProfiles();
                    boolean allowedHere = filter.test(obj.getProfile().getProfParent());
                    boolean bl = allowedIn = allowedIn || allowedHere;
                    if (allowedIn) break;
                    if (allowedHere) continue;
                    naughtyQueues.add(q);
                }
                if (allowedIn) continue;
                String error2 = String.format(Intl.intl("%s is being directed to a queue their Profile restricts them from."), guiUtil.escapeHTML(obj.getName()));
                String fix2 = Intl.intl("Allow this occupant's profile in the target queue, or uncheck the queue in the Behavior's GoToQueue action.");
                ArrayList<AMerlinObj> errObjs = new ArrayList<AMerlinObj>(Arrays.asList(obj, gotoQueue));
                errObjs.addAll(naughtyQueues);
                errors.accept(new SimError(SimError.Level.MODERATE, error2, fix2, errObjs));
            }
            EntryPointFactory.getBadDirectBehaviorErrors(errors, obj, obj.getBehavior());
        });
        EntryPointFactory.register(EgressAgent.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(EgressAgent.class));
        EntryPointFactory.register(EgressAgentComp.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.agents);
        EntryPointFactory.register(EgressAgentComp.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("OccupantGroup", 2)));
        EntryPointFactory.registerIcon(EgressAgentComp.class, occupantGroupIcon);
        EntryPointFactory.registerType(EgressAgentComp.class, EgressAgentComp.PROP_TYPES, Intl.intl("Occupant Group"), true);
        EntryPointFactory.register(EgressAgentComp.class, FuncType.IsAutoDeleteGroup, new EntryPoint.Getter<EgressAgentComp, Boolean>(){

            @Override
            public Boolean get(MerlinData md, EgressAgentComp obj) {
                return obj != md.agents;
            }
        });
        EntryPointFactory.register(EgressAgentComp.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(EgressAgentComp.class));
        EntryPointFactory.register(CameraList.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.cameras);
        EntryPointFactory.register(CameraList.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.cameraNameGen);
        EntryPointFactory.registerIcon(CameraList.class, cameraListIcon);
        EntryPointFactory.registerType(CameraList.class, CameraList.PROP_TYPES, Intl.intl("View Group"), true);
        EntryPointFactory.register(CameraList.class, FuncType.IsAutoDeleteGroup, new EntryPoint.Getter<CameraList, Boolean>(){

            @Override
            public Boolean get(MerlinData md, CameraList obj) {
                return md.cameras != obj;
            }
        });
        EntryPointFactory.registerIcon(Camera.class, cameraIcon);
        EntryPointFactory.registerType(Camera.class, Camera.ALL_PROPS, Intl.intl("View"), true);
        EntryPointFactory.registerCameraTour();
        EntryPointFactory.register(ICameraObj.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.cameras);
        EntryPointFactory.register(ICameraObj.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.cameraNameGen);
        EntryPointFactory.register(ICameraObj.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(Floor.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.floors);
        EntryPointFactory.register(Floor.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> new ConstantGetter(new SequentialNameGen("Floor", 2)));
        EntryPointFactory.register(Floor.class, FuncType.IsMovable, new ConstantGetter(false));
        EntryPointFactory.register(Floor.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(Floor.class));
        EntryPointFactory.registerIcon(Floor.class, floorIcon);
        EntryPointFactory.registerType(Floor.class, Floor.PROP_TYPES, Intl.intl("Floor"), true);
        EntryPointFactory.register(Floor.class, FuncType.TV_GetBaseFont, new EntryPoint.Getter<Floor, Font>(){

            @Override
            public Font get(MerlinData md, Floor obj) {
                boolean working;
                boolean active = md.floors.getActive() == obj;
                boolean bl = working = md.floors.getActive().getWorkingGeomGroup() == obj;
                if (active && working) {
                    return s_italicBold;
                }
                if (active) {
                    return s_bold;
                }
                if (working) {
                    return s_italic;
                }
                return EntryPointFactory.get(Floor.class.getSuperclass()).tvEntryPoint.getFont(md, obj);
            }
        });
        EntryPointFactory.register(Floor.class, FuncType.GetDeletionErr, new EntryPoint.Getter<Floor, Exception>(){

            @Override
            public Exception get(MerlinData md, Floor obj) {
                if (obj == md.activeFloor()) {
                    return new Exception(Intl.intl("The active floor cannot be deleted."));
                }
                return null;
            }
        });
        EntryPointFactory.registerIcon(FloorComposite.class, floorIcon);
        EntryPointFactory.registerType(FloorComposite.class, FloorComposite.PROP_TYPES, Intl.intl("Floor Group"), true);
        EntryPointFactory.register(IEgressComp.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.floors);
        EntryPointFactory.register(IEgressComp.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("Geom", 2)));
        EntryPointFactory.registerBasicErrors(IEgressComp.class, false, Set.of(), (md, analysis, obj) -> {
            Collection<Object> errors = Collections.EMPTY_LIST;
            boolean nonManifold = false;
            Collection<Pair<IEgressComp, IEgressComp.ConflictType>> overlaps = obj.getConflicts();
            for (Pair<IEgressComp, IEgressComp.ConflictType> overlap : overlaps) {
                String msg = "";
                String fix = "";
                switch ((IEgressComp.ConflictType)((Object)((Object)overlap.v2))) {
                    case EDGE: {
                        msg = String.format(Intl.intl("%1$s overlaps %2$s."), guiUtil.escapeHTML(obj.getName()), guiUtil.escapeHTML(((IEgressComp)overlap.v1).getName()));
                        fix = Intl.intl("Adjust edges so components no longer overlap.");
                        break;
                    }
                    case NON_MANIFOLD: {
                        nonManifold = true;
                    }
                }
                if (msg.isEmpty()) continue;
                errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.MODERATE, msg, fix, (IMerlinObj)obj));
            }
            if (nonManifold) {
                String msg = "";
                String fix = "";
                if (obj instanceof EgressDoor) {
                    msg = String.format(Intl.intl("%s must be connected to exactly one or two rooms."), guiUtil.escapeHTML(obj.getName()));
                } else if (obj instanceof EgressCorridor) {
                    msg = String.format(Intl.intl("Each end of %s must be connected to an outer edge of exactly one room."), guiUtil.escapeHTML(obj.getName()));
                }
                errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.MODERATE, msg, fix, (IMerlinObj)obj));
            }
            return errors;
        });
        EntryPointFactory.registerIcon(IEgressOccupiable.class, roomIcon);
        EntryPointFactory.register(IEgressOccupiable.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.floors);
        EntryPointFactory.register(IEgressOccupiable.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(IEgressOccupiable.class));
        EntryPointFactory.register(IEgressConnector.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.floors);
        EntryPointFactory.register(IEgressConnector.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<IEgressConnector, Icon>(){

            @Override
            public Icon get(MerlinData md, IEgressConnector obj, Consumer<Icon> whenReady) {
                return obj.isExit() ? exitIcon : doorIcon;
            }
        });
        EntryPointFactory.register(IEgressConnector.class, FuncType.CategoryName, new EntryPoint.Getter<IEgressConnector, String>(){

            @Override
            public String get(MerlinData md, IEgressConnector obj) {
                return obj.isExit() ? Intl.intl("Exit") : Intl.intl("Door");
            }
        });
        EntryPointFactory.registerIcon(EgressStair.class, stairsIcon);
        EntryPointFactory.registerType(EgressStair.class, EgressStair.PROP_TYPES, Intl.intl("Stair"), true);
        EntryPointFactory.register(EgressStair.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(EgressStair.class));
        EntryPointFactory.registerIcon(EgressCorridor.class, rampIcon);
        EntryPointFactory.registerType(EgressCorridor.class, EgressCorridor.PROP_TYPES, Intl.intl("Ramp"), true);
        EntryPointFactory.registerErrors(EgressCorridor.class, false, List.of(IEgressComp.class), (Events events) -> EntryPointFactory.isModified(events, IEgressOccupiable.class), (MerlinData md, ErrorAnalysis analysis, ? super T obj, Consumer<SimError> errors) -> {
            if (obj.isEnabled()) {
                IEgressOccupiable d_conn1 = obj.getDoor1().getRoom();
                IEgressOccupiable d_conn2 = obj.getDoor2().getRoom();
                if (d_conn1 == null && d_conn2 == null) {
                    errors.accept(new SimError(SimError.Level.MODERATE, String.format(Intl.intl("%s is not connected to any rooms."), guiUtil.escapeHTML(obj.getName())), Intl.intl("Delete or adjust handles to connect to a room."), (IMerlinObj)obj));
                } else if (d_conn1 instanceof ElevatorRoom || d_conn2 instanceof ElevatorRoom) {
                    errors.accept(new SimError(SimError.Level.MODERATE, Intl.intl("Stairs and ramps may not be connected to elevators."), Intl.intl("Remove this object or reconnect to a non-elevator room."), (IMerlinObj)obj));
                }
                if (d_conn1 == null || d_conn2 == null) {
                    String msg = obj instanceof EgressStair ? Intl.intl("Disconnected Stairway") : Intl.intl("Disconnected Ramp");
                    errors.accept(new SimError(SimError.Level.MODERATE, msg, Intl.intl("Modify geometry or add a landing."), (IMerlinObj)obj));
                }
            }
        });
        EntryPointFactory.register(EgressCorridor.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(EgressCorridor.class));
        EntryPointFactory.registerType(EgressDoor.class, EgressDoor.PROP_TYPES, Intl.intl("Door"), true);
        EntryPointFactory.registerBasicErrors(EgressDoor.class, false, List.of(IEgressComp.class), (md, analysis, obj) -> {
            Collection<Object> errors = Collections.EMPTY_SET;
            if (!obj.isEnabled()) {
                return errors;
            }
            String error = null;
            String fix = null;
            IEgressOccupiable room1 = obj.getRoom1();
            IEgressOccupiable room2 = obj.getRoom2();
            if (room1 == null && room2 == null) {
                error = String.format(Intl.intl("%s is not connected to any elements."), guiUtil.escapeHTML(obj.getName()));
                fix = Intl.intl("Delete door.");
            } else if (!(room1 != null && room2 != null || obj.isExit())) {
                error = String.format(Intl.intl("Non-exit, %s, is only connected to one room."), guiUtil.escapeHTML(obj.getName()));
                fix = Intl.intl("Delete or adjust handles to connect to another room.");
            } else if (!(obj instanceof ElevatorDoor) && (room1 instanceof ElevatorRoom || room2 instanceof ElevatorRoom)) {
                error = String.format(Intl.intl("Doors may not be connected to an existing elevator."), new Object[0]);
                fix = Intl.intl("Remove this door or reconnect to a non-elevator room.");
            }
            if (error != null) {
                errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.CRITICAL, error, fix, (IMerlinObj)obj));
            }
            if (obj.isExit()) {
                List<DiscreteVariant.Entry<EgressConnectorState>> state = VariantUtil.getDiscreteValues(obj.getRawState(), true);
                for (DiscreteVariant.Entry<EgressConnectorState> entry : state) {
                    if (entry.val == EgressConnectorState.CONNECTOR_OPEN || entry.val == EgressConnectorState.CONNECTOR_CLOSED) continue;
                    String error2 = Intl.intl("One-way markings on exits are ignored.");
                    String fix2 = Intl.intl("Remove one-way marking on exit.");
                    errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.MODERATE, error2, fix2, (IMerlinObj)obj));
                    break;
                }
            }
            return errors;
        });
        EntryPointFactory.register(EgressDoor.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(EgressDoor.class));
        EntryPointFactory.registerType(EgressRoom.class, EgressRoom.PROP_TYPES, Intl.intl("Room"), true);
        EntryPointFactory.register(EgressRoom.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(EgressRoom.class));
        EntryPointFactory.registerType(Elevator.class, Elevator.LOCAL_PROPS, Intl.intl("Elevator"), true);
        EntryPointFactory.register(Elevator.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.elevators);
        EntryPointFactory.register(Elevator.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("Elevator", 2)));
        EntryPointFactory.register(Elevator.class, FuncType.IsAutoDeleteGroup, new ConstantGetter(true));
        EntryPointFactory.register(Elevator.class, FuncType.GetDeletionErr, new ConstantGetter(null));
        EntryPointFactory.registerErrors(Elevator.class, true, Set.of(), (Events events) -> EntryPointFactory.isModified(events, Elevator.class) || EntryPointFactory.isModified(events, ElevatorRoom.class), (MerlinData md, ErrorAnalysis analysis, ? super T obj, Consumer<SimError> errors) -> {
            PropValue<Boolean> enabled;
            Floor dischargeFloor = obj.getDischargeFloor();
            if (dischargeFloor == null && (enabled = obj.getWithDetails(MerlinData.ENABLED)).asOption().orElse(true).booleanValue()) {
                errors.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("Elevator is not connected at its discharge floor."), Intl.intl("Make sure the elevator's doors are enabled at the discharge floor or change the elevator's discharge floor."), (IMerlinObj)obj));
            }
            if (obj.getCloseDelay().getValueNoUnit() + obj.getOpenDelay().getValueNoUnit() < 1.0) {
                errors.accept(new SimError(SimError.Level.MODERATE, Intl.intl("Combined open delay and close delay is less than 1 second."), Intl.intl("Make sure either open delay or close delay are at least 1 second."), (IMerlinObj)obj));
            }
            EntryPointFactory.getDoubleDeckElevatorWarnings(errors, md, obj);
        });
        EntryPointFactory.register(Elevator.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(Elevator.class));
        EntryPointFactory.registerType(ElevatorGroup.class, ElevatorGroup.PROP_TYPES, Intl.intl("Elevator Group"), true);
        EntryPointFactory.register(ElevatorGroup.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.elevators);
        EntryPointFactory.register(ElevatorGroup.class, FuncType.GetDeletionErr, new ConstantGetter(null));
        EntryPointFactory.registerErrors(ElevatorGroup.class, true, Set.of(), (Events events) -> EntryPointFactory.isModified(events, Elevator.class), (MerlinData md, ErrorAnalysis analysis, ? super T obj, Consumer<SimError> errors) -> {
            Optional<Object> dischargeFloor = Optional.empty();
            for (Elevator elevator : obj.flatten(Elevator.class)) {
                Floor floor = elevator.getDischargeFloor();
                if (floor == null) continue;
                if (!dischargeFloor.isPresent()) {
                    dischargeFloor = Optional.of(floor);
                    continue;
                }
                if (dischargeFloor.get() == floor) continue;
                errors.accept(new SimError(SimError.Level.MODERATE, Intl.intl("Elevators in the same group (call set) should have the same discharge floor. Different floors may produce unknown behavior."), Intl.intl("Set all elevators in the group to the same discharge floor."), (IMerlinObj)obj));
                break;
            }
        });
        EntryPointFactory.register(IElevatorComp.class, FuncType.GetDeletionErr, (MerlinData md, T obj) -> new Exception(Intl.intl("Elevator rooms and doors cannot be individually deleted.")));
        EntryPointFactory.registerType(ElevatorRoom.class, ElevatorRoom.PROP_TYPES, Intl.intl("Elevator Room"), true);
        EntryPointFactory.register(ElevatorRoom.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.elevators);
        EntryPointFactory.register(ElevatorRoom.class, FuncType.TV_GetBaseFont, new EntryPoint.Getter<ElevatorRoom, Font>(){

            @Override
            public Font get(MerlinData md, ElevatorRoom obj) {
                Object parent = md.hierarchy.getParent(obj);
                if (parent instanceof Elevator && ((Elevator)parent).getDischargeRoom() == obj) {
                    return s_bold;
                }
                return EntryPointFactory.get(ElevatorRoom.class.getSuperclass()).tvEntryPoint.getBaseFont(md, obj);
            }
        });
        EntryPointFactory.registerErrors(ElevatorRoom.class, true, Set.of(), (Events events) -> EntryPointFactory.isModified(events, ElevatorDoor.class) || EntryPointFactory.isModified(events, ElevatorRoom.class), (MerlinData md, ErrorAnalysis analysis, ? super T obj, Consumer<SimError> errors) -> {
            LinkedIdentityHashSet connectedFloors = new LinkedIdentityHashSet();
            for (ElevatorDoor door : obj.getElevatorDoors()) {
                Floor floor = ElevatorUtil.getFloor(md, obj, door);
                if (floor == null) continue;
                connectedFloors.add(floor);
            }
            if (connectedFloors.size() > 1) {
                errors.accept(new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("Elevator level is connected to %d floors.  It must only be connected to one."), connectedFloors.size()), Intl.intl("Move all rooms connected to the elevator level to the same floor."), (IMerlinObj)obj));
            }
            if (connectedFloors.size() >= 1) {
                Elevator elev = (Elevator)obj.getParent();
                if (elev != null) {
                    IdentityHashMap<Floor, Integer> floorUseCounts = new IdentityHashMap<Floor, Integer>();
                    for (ElevatorRoom level : elev.getMembers(ElevatorRoom.class)) {
                        Floor floor = ElevatorUtil.getFloor(md, level);
                        if (floor == null) continue;
                        Integer count = (Integer)floorUseCounts.get(floor);
                        if (count == null) {
                            floorUseCounts.put(floor, 1);
                            continue;
                        }
                        count = count + 1;
                        floorUseCounts.put(floor, count);
                    }
                    Integer count = (Integer)floorUseCounts.get(connectedFloors.iterator().next());
                    if (count != null && count > 1) {
                        errors.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("Multiple elevator levels connected to one floor."), Intl.intl("This elevator level must be connected to its own floor."), (IMerlinObj)obj));
                    }
                } else {
                    errors.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("This elevator is in an invalid state."), Intl.intl("elevatorRoom.getParent() is returning null."), (IMerlinObj)obj));
                }
            }
        });
        EntryPointFactory.register(ElevatorRoom.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(ElevatorRoom.class));
        EntryPointFactory.registerType(ElevatorDoor.class, ElevatorDoor.PROP_TYPES, Intl.intl("Elevator Door"), true);
        EntryPointFactory.register(ElevatorRoom.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.elevators);
        EntryPointFactory.registerBasicErrors(ElevatorDoor.class, true, Set.of(), (md, analysis, obj) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (obj.getRoom1() instanceof ElevatorRoom && obj.getRoom2() != obj.getRoom1() && obj.getRoom2() instanceof ElevatorRoom) {
                SimError error = new SimError(SimError.Level.CRITICAL, Intl.intl("Elevator doors can only be connected to one elevator."), Intl.intl("Delete one of the elevators."), (IMerlinObj)obj);
                errors.add(error);
            }
            return errors;
        });
        EntryPointFactory.register(ElevatorDoor.class, FuncType.GetConflict, new EntryPoint.Getter<ElevatorDoor, ElevatorDoor>(){

            @Override
            public ElevatorDoor get(MerlinData md, ElevatorDoor comparable) {
                Collection<ElevatorRoom> elevatorRooms = md.elevators.flatten(ElevatorRoom.class);
                for (ElevatorRoom room : elevatorRooms) {
                    for (ElevatorDoor door : room.getElevatorDoors()) {
                        if (!theUtil.equal(comparable, door)) continue;
                        return door;
                    }
                }
                return null;
            }
        });
        EntryPointFactory.register(EgressBlockageComp.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.blockages);
        EntryPointFactory.register(EgressBlockageComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.blkgNameGen);
        EntryPointFactory.registerIcon(EgressBlockageComp.class, blockageGroupIcon);
        EntryPointFactory.registerType(EgressBlockageComp.class, EgressBlockageComp.PROP_TYPES, Intl.intl("Obstacle Group"), true);
        EntryPointFactory.register(EgressBlockage.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.blockages);
        EntryPointFactory.register(EgressBlockage.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.blkgNameGen);
        EntryPointFactory.registerIcon(EgressBlockage.class, blockageIcon);
        EntryPointFactory.registerType(EgressBlockage.class, EgressBlockage.PROPS, Intl.intl("Obstacle"), true);
        EntryPointFactory.register(EgressBlockage.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(EgressBlockage.class));
        EntryPointFactory.registerBasicErrors(EgressBlockage.class, false, Set.of(), (md, analysis, obj) -> {
            ArrayList<SimError> errs = new ArrayList<SimError>();
            if (obj.getDisplayType() == EgressBlockage.DisplayType.CAD_GEOM && obj.get(EgressBlockage.LINK_CAD_GEOM_TO_SEARCH).booleanValue() && obj.get(EgressBlockage.CAD_GEOM).node == GeomNodeUtil.EMPTY_NODE) {
                errs.add(new SimError(SimError.Level.MODERATE, Intl.intl("No imported geometry has been picked for the obstacle."), Intl.intl("Select the obstacle and click <b>Pick</b> to choose imported geometry or uncheck <b>Link shape to CAD geometry</b>"), (IMerlinObj)obj));
            }
            return errs;
        });
        EntryPointFactory.registerType(ImportedGeom.class, ImportedGeom.PROP_TYPES, Intl.intl("Imported Geometry"), Intl.intl("Imported"), true);
        EntryPointFactory.register(ImportedGeom.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.sceneGeom);
        EntryPointFactory.register(ImportedGeom.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("Imported", 2)));
        EntryPointFactory.register(ImportedGeom.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<ImportedGeom, Icon>(){

            @Override
            public Icon get(MerlinData md, ImportedGeom obj, Consumer<Icon> whenReady) {
                if (obj.getGeom().getNumPrims(1) > 0) {
                    return importedGeometry3DIcon;
                }
                return importedGeometry2DIcon;
            }
        });
        EntryPointFactory.registerIcon(RasterImage.class, backgroundImageIcon);
        EntryPointFactory.registerType(RasterImage.class, RasterImage.PROP_TYPES, Intl.intl("Background Image"), false);
        EntryPointFactory.registerType(BGImage.class, BGImage.PROP_TYPES, Intl.intl("Background Image"), true);
        EntryPointFactory.register(MeasurementRegionObj.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.regions);
        EntryPointFactory.register(MeasurementRegionObj.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.densityNameGen);
        EntryPointFactory.registerIcon(MeasurementRegionObj.class, measurementRegionIcon);
        EntryPointFactory.registerType(MeasurementRegionObj.class, MeasurementRegionObj.PROP_TYPES, Intl.intl("Measurement Region"), true);
        EntryPointFactory.register(MeasurementRegions.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.regions);
        EntryPointFactory.register(MeasurementRegions.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.densityNameGen);
        EntryPointFactory.registerIcon(MeasurementRegions.class, measurementRegionGroupIcon);
        EntryPointFactory.registerType(MeasurementRegions.class, MeasurementRegions.PROP_TYPES, Intl.intl("Measurement Region Group"), true);
        EntryPointFactory.register(OccSourceObj.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.occSources);
        EntryPointFactory.register(OccSourceObj.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.occSourceNameGen);
        EntryPointFactory.registerIcon(OccSourceObj.class, occupantSourceIcon);
        EntryPointFactory.registerType(OccSourceObj.class, OccSourceObj.PROP_TYPES, Intl.intl("Occupant Source"), Intl.intl("Occ_Source"), true);
        EntryPointFactory.register(OccSourceObj.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.registerErrors(OccSourceObj.class, false, Set.of(), new ErrorAnalysis.ErrorGenerator<OccSourceObj>(EntryPointFactory.objSourceFromRoot(OccSourceObj.class), events -> EntryPointFactory.isModified(events, OccSourceObj.class) || EntryPointFactory.isModified(events, EgressAgent.class) || EntryPointFactory.isModified(events, Behavior.class) || EntryPointFactory.isModified(events, OccProfile.class) || EntryPointFactory.isModified(events, OccGroupTypeObj.class) || EntryPointFactory.isModified(events, ChangeBehavior.class) || EntryPointFactory.isModified(events, ChangeProfile.class) || EntryPointFactory.isModified(events, ChangeProfileProp.class) || EntryPointFactory.isModified(events, RevertProfileProp.class) || EntryPointFactory.isModified(events, VehicleShape.class) || EntryPointFactory.isModified(events, Elevator.class) || EntryPointFactory.isModified(events, SimParams.class) || EntryPointFactory.isModified(events, EgressBlockage.class), (md, analysis, obj, errors) -> {
            Set<OccProfile> profs = obj.get(OccSourceObj.PROP_PROFILE_DIST).getWeights().keySet();
            Set<Behavior> behaviors = obj.get(OccSourceObj.PROP_BEHAVIOR_DIST).getWeights().keySet();
            if (profs.isEmpty()) {
                errors.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("Occupant Source doesn't list any occupant profiles."), Intl.intl("Add an occupant profile to the source."), (IMerlinObj)obj));
            }
            if (behaviors.isEmpty()) {
                errors.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("Occupant Source doesn't list any behaviors."), Intl.intl("Add a behavior to the source."), (IMerlinObj)obj));
            }
            profs.forEach(prof -> EntryPointFactory.getResolvedProfileErrors(obj, prof, errors, Intl.intl("Change profile or remove profile from occupant source.")));
            for (OccProfile profile : profs) {
                for (Behavior behavior2 : behaviors) {
                    EntryPointFactory.getAssistedEvacErrors(analysis, obj, profile, behavior2, errors);
                }
            }
            EntryPointFactory.getNotEnoughAssistingErrors((Consumer<? super SimError>)errors, md, analysis, obj);
            EntryPointFactory.getVehicleNotFitInElevatorErrors((Consumer<? super SimError>)errors, md, analysis, obj);
            if (obj.getType() == OccSourceObj.OccSourceType.EGRESS_COMPONENT && Objects.equals(obj.get(OccSourceObj.PROP_COMPONENT), null)) {
                SimError e = new SimError(SimError.Level.CRITICAL, Intl.intl("Component of this occupant source was deleted."), Intl.intl("Assign this occupant source to an existing component."), Collections.emptyList());
                errors.accept(e);
            }
            boolean inMovementGroup = obj.isGrouped(md);
            obj.get(OccSourceObj.PROP_BEHAVIOR_DIST).forEach(behavior -> {
                EntryPointFactory.getBadDirectBehaviorErrors(errors, obj, behavior);
                EntryPointFactory.getGotoOccTargetErrors(errors, analysis, obj, inMovementGroup, behavior);
            });
            if (obj.get(OccSourceObj.PROP_ENFORCE_FLOWRATE).stream().noneMatch(b -> b) && (obj.get(OccSourceObj.PROP_FLOW_RATE) instanceof RandomizedImpulseFunction1d || obj.get(OccSourceObj.PROP_FLOW_RATE) instanceof ImpulseFunction1d)) {
                errors.accept(new SimError(SimError.Level.MODERATE, Intl.intl("The flowrate is not being enforced. The occupant source might not produce the desired number of occupants."), "<html>" + Intl.intl("Set <b>Enforce Flow Rate</b> to <b>Yes</b>."), (IMerlinObj)obj));
            }
            EntryPointFactory.getOverlappingOccSourceAndObstaclesErrors(errors, md, obj);
        }), new ErrorAnalysis.ErrorGenerator<OccSourceObj>(EntryPointFactory.objSourceFromRoot(OccSourceObj.class), events -> {
            Predicate<Class> isModified = type -> EntryPointFactory.isModified(events, type);
            return isModified.test(OccSourceObj.class) || isModified.test(Behavior.class) || isModified.test(EgressDoor.class) || isModified.test(GotoExits.class);
        }, (md, analysis, occSource, errors) -> {
            if (!occSource.isEnabled()) {
                return;
            }
            IEgressComp comp = occSource.getComponent();
            if (comp == null || !(comp instanceof EgressDoor) || !((EgressDoor)comp).isExit()) {
                return;
            }
            for (Behavior b : occSource.get(OccSourceObj.PROP_BEHAVIOR_DIST).getWeights().keySet()) {
                GotoExits gotoExits;
                Collection<IBehaviorAction> goals = b.flatten(IBehaviorAction.class);
                IBehaviorAction firstGoal = goals.iterator().next();
                if (firstGoal == null || !(firstGoal instanceof GotoExits) || !(gotoExits = (GotoExits)firstGoal).isGotoAny() && !gotoExits.get(GotoExits.PROP_EXITS).contains(comp)) continue;
                String cause = String.format(Intl.intl("Occupants generated with behavior:\"%s\" will immediately exit through the door to which this occupant source is attached."), guiUtil.escapeHTML(b.getName()));
                String fix = String.format(Intl.intl("Change the first action in behavior:\"%s\" ."), guiUtil.escapeHTML(b.getName()));
                errors.accept(new SimError(SimError.Level.MODERATE, cause, fix, (IMerlinObj)occSource, b, comp));
            }
        }));
        EntryPointFactory.register(OccSourceObj.OccSourceComp.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.occSources);
        EntryPointFactory.register(OccSourceObj.OccSourceComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.occSourceNameGen);
        EntryPointFactory.registerIcon(OccSourceObj.OccSourceComp.class, occupantSourceGroupIcon);
        EntryPointFactory.registerType(OccSourceObj.OccSourceComp.class, OccSourceObj.OccSourceComp.PROP_TYPES, Intl.intl("Occupant Source Group"), true);
        EntryPointFactory.register(OccGroupObj.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.occGroups);
        EntryPointFactory.register(OccGroupObj.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.occGroupNameGen);
        EntryPointFactory.registerIcon(OccGroupObj.class, occupantGroupIcon);
        EntryPointFactory.registerType(OccGroupObj.class, OccGroupObj.PROP_TYPES, Intl.intl("Movement Group"), true);
        EntryPointFactory.register(OccGroupObj.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(OccGroupObj.class, FuncType.IsAutoDeleteGroup, new ConstantGetter(true));
        EntryPointFactory.registerErrors(OccGroupObj.class, true, Set.of(), EntryPointFactory.getOccGroupObjErrorGenerator());
        EntryPointFactory.register(OccGroupObj.OccGroupComp.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.occGroups);
        EntryPointFactory.register(OccGroupObj.OccGroupComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.occGroupNameGen);
        EntryPointFactory.registerIcon(OccGroupObj.OccGroupComp.class, occupantGroupIcon);
        EntryPointFactory.registerType(OccGroupObj.OccGroupComp.class, OccGroupObj.OccGroupComp.PROP_TYPES, Intl.intl("Movement Group Group"), true);
        EntryPointFactory.register(OccGroupTypeObj.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.occGroupTypes);
        EntryPointFactory.register(OccGroupTypeObj.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.occGroupTypeNameGen);
        EntryPointFactory.registerIcon(OccGroupTypeObj.class, occupantGroupIcon);
        EntryPointFactory.registerType(OccGroupTypeObj.class, OccGroupTypeObj.PROP_TYPES, Intl.intl("Movement Group Template"), true);
        EntryPointFactory.register(OccGroupTypeObj.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.registerErrors(OccGroupTypeObj.class, false, Set.of(), EntryPointFactory.getOccGroupObjErrorGenerator());
        EntryPointFactory.register(OccGroupTypeObj.class, FuncType.GetConflict, new EntryPoint.Getter<OccGroupTypeObj, OccGroupTypeObj>(){

            @Override
            public OccGroupTypeObj get(MerlinData md, OccGroupTypeObj comparable) {
                if (theUtil.equal(comparable, md.occGroupTypes.NO_GROUP_TYPE)) {
                    return md.occGroupTypes.NO_GROUP_TYPE;
                }
                return EntryPointFactory.getStandardConflictGetter(OccGroupTypeObj.class).get(md, comparable);
            }
        });
        EntryPointFactory.registerIcon(OccGroupTypeObj.OccGroupTypeComp.class, occupantGroupIcon);
        EntryPointFactory.register(OccGroupTypeObj.OccGroupTypeComp.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.occGroupTypes);
        EntryPointFactory.register(OccGroupTypeObj.OccGroupTypeComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.occGroupTypeNameGen);
        EntryPointFactory.registerType(OccGroupTypeObj.OccGroupTypeComp.class, OccGroupTypeObj.OccGroupTypeComp.PROP_TYPES, Intl.intl("Movement Group Template Group"), true);
        EntryPointFactory.register(Proxy.class, FuncType.TypeString, (MerlinData md, T obj) -> EntryPointFactory.get(obj.getObj()).getTypeString(md, obj.getObj()));
        EntryPointFactory.register(Proxy.class, FuncType.CategoryName, (MerlinData md, T obj) -> {
            String baseName = EntryPointFactory.get(obj.getObj()).getCategoryName(md, obj.getObj());
            return String.format(Intl.intl("%s Reference"), baseName);
        });
        EntryPointFactory.register(Proxy.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.occGroups);
        EntryPointFactory.register(Proxy.class, FuncType.TV_GetForcedAutoexpand, new EntryPoint.Getter<Proxy<? extends IMerlinObj>, Boolean>(){

            @Override
            public Boolean get(MerlinData md, Proxy<? extends IMerlinObj> obj) {
                return md.selection.isSelected(obj);
            }
        });
        EntryPointFactory.register(Proxy.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<Proxy<? extends IMerlinObj>, Icon>(){

            @Override
            public Icon get(MerlinData md, Proxy<? extends IMerlinObj> proxy, Consumer<Icon> whenReady) {
                IMerlinObj obj = proxy.getObj();
                return ((EntryPoint.AsyncGetter)EntryPointFactory.findFunc(obj.getClass(), FuncType.TV_GetIcon)).get(md, obj, whenReady);
            }
        });
        EntryPointFactory.register(Proxy.class, FuncType.GetNameFormatRules, (MerlinData md, T obj) -> EntryPointFactory.get(obj.getObj()).getNameValidator(md, obj.getObj()));
        EntryPointFactory.register(Proxy.class, FuncType.GetUniqueNameGroup, (MerlinData md, T obj) -> EntryPointFactory.get(obj.getObj()).getUniqueNameGroup(md, obj.getObj()));
        EntryPointFactory.registerErrors(Proxy.class, true, List.of(), (Events events) -> EntryPointFactory.isModified(events, OccGroupObj.class), (MerlinData md, ErrorAnalysis analysis, ? super T proxy, Consumer<SimError> errors) -> {
            Object patt0$temp = proxy.getObj();
            if (!(patt0$temp instanceof EgressAgent)) {
                return;
            }
            EgressAgent a = (EgressAgent)patt0$temp;
            Set<Proxy<? extends IMerlinObj>> proxies = md.proxies.getProxies(a);
            Supplier<Stream> getGroups = () -> proxies.stream().map(p -> md.hierarchy.getAncestor(p, OccGroupObj.class)).filter(group -> group != null);
            if (getGroups.get().count() > 1L) {
                String sb = getGroups.get().map(group -> group.getName()).collect(Collectors.joining(", "));
                String error = String.format(Intl.intl("Occupants can only participate in a single movement group. Occupant %s is a member of following movement groups: %s."), guiUtil.escapeHTML(a.getName()), guiUtil.escapeHTML(sb));
                String fix = String.format(Intl.intl("Make sure occupant %s is a member of at most one movement group."), guiUtil.escapeHTML(a.getName()));
                errors.accept(new SimError(SimError.Level.CRITICAL, error, fix, (IMerlinObj)proxy));
            }
        });
        EntryPointFactory.registerType(TagsComp.class, TagsComp.PROP_TYPES, Intl.intl("Tag Group"), true);
        EntryPointFactory.registerIcon(TagsComp.class, changeTagsIcon);
        EntryPointFactory.register(TagsComp.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.tags);
        EntryPointFactory.registerType(Tag.class, Tag.PROP_TYPES, Intl.intl("Tag"), true);
        EntryPointFactory.register(Tag.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.tags);
        EntryPointFactory.register(Tag.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.tagNameGen);
        EntryPointFactory.register(Tag.class, FuncType.GetUniqueNameGroup, EntryPointFactory.nameGroup(md -> md.tags.flatten(Tag.class)));
        EntryPointFactory.registerIcon(Tag.class, changeTagsIcon);
        EntryPointFactory.register(Tag.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(Tag.class));
        EntryPointFactory.register(Tag.class, FuncType.GetNameFormatRules, (MerlinData md, T obj) -> StringTagsUtil.getValidTagNamePredicate());
        EntryPointFactory.registerIcon(BehaviorRoot.class, behaviorIcon);
        EntryPointFactory.registerType(BehaviorRoot.class, BehaviorRoot.PROP_TYPES, Intl.intl("Behavior Root"), false);
        EntryPointFactory.register(BehaviorRoot.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.behaviors);
        EntryPointFactory.register(Behavior.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.behaviors);
        EntryPointFactory.register(Behavior.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("Behavior", 2)));
        EntryPointFactory.registerIcon(Behavior.class, behaviorIcon);
        EntryPointFactory.registerType(Behavior.class, Behavior.PROP_TYPES, Intl.intl("Behavior"), false);
        EntryPointFactory.register(Behavior.class, FuncType.DomainRequiredType, EntryPointFactory.always(Behavior.class));
        EntryPointFactory.registerErrors(Behavior.class, true, Set.of(), (Events events) -> EntryPointFactory.isModified(events, ChangeBehavior.class) || EntryPointFactory.isModified(events, Behavior.class), (MerlinData md, ErrorAnalysis analysis, ? super T obj, Consumer<SimError> errors) -> {
            Optional<IBehaviorAction> last = obj.getLastAction();
            if (!last.isPresent() || !last.get().mustBeLast() && !MerlinUtil.isBehaviorTerminal(obj)) {
                String error = String.format(Intl.intl("Behavior, %s, does not have an ending action."), guiUtil.escapeHTML(obj.getName()));
                String fix = Intl.intl("Add an ending action to the behavior, such as Goto Exit.");
                errors.accept(new SimError(SimError.Level.MODERATE, error, fix, (IMerlinObj)obj));
            } else if (obj.getInitialDelay() instanceof ConstantCurve && ((ConstantCurve)obj.getInitialDelay()).getValue().getRawValue() == 0.0 && obj.getMembers().size() == 1 && last.map(a -> a.mustBeLast() && a.isImmediate()).orElse(false).booleanValue()) {
                String error = String.format(Intl.intl("Behavior, %s, will end immediately after being started."), guiUtil.escapeHTML(obj.getName()));
                String fix = Intl.intl("Set an initial delay or add intermediate actions for the occupants to perform.");
                errors.accept(new SimError(SimError.Level.MODERATE, error, fix, (IMerlinObj)obj));
            }
        });
        EntryPointFactory.register(Behavior.class, FuncType.GetConflict, new EntryPoint.Getter<Behavior, Behavior>(){

            @Override
            public Behavior get(MerlinData md, Behavior comparable) {
                if (theUtil.equal(comparable, md.behaviors.NO_CHANGE)) {
                    return md.behaviors.NO_CHANGE;
                }
                return EntryPointFactory.getStandardConflictGetter(Behavior.class).get(md, comparable);
            }
        });
        EntryPointFactory.register(IBehaviorAction.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.behaviors);
        EntryPointFactory.register(IBehaviorAction.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(IBehaviorAction.class, FuncType.IsIndexed, new ConstantGetter(true));
        EntryPointFactory.registerErrors(IBehaviorAction.class, false, Set.of(), (Events events) -> EntryPointFactory.isModified(events, Behavior.class) || EntryPointFactory.isModified(events, ChangeBehavior.class), (MerlinData md, ErrorAnalysis analysis, ? super T obj, Consumer<SimError> errors) -> EntryPointFactory.getBehaviorActionErrors(md, obj, errors));
        EntryPointFactory.registerIcon(Wait.class, waitIcon);
        EntryPointFactory.registerType(Wait.class, Wait.PROP_TYPES, Intl.intl("Wait"), true);
        EntryPointFactory.registerIcon(WaitUntil.class, waitIcon);
        EntryPointFactory.registerType(WaitUntil.class, WaitUntil.PROP_TYPES, Intl.intl("Wait Until"), true);
        EntryPointFactory.registerIcon(GotoWaypoint.class, gotoIcon);
        EntryPointFactory.registerType(GotoWaypoint.class, GotoWaypoint.PROP_TYPES, Intl.intl("Go To Waypoint"), true);
        EntryPointFactory.registerBasicErrors(GotoWaypoint.class, true, List.of(IBehaviorAction.class), (md, analysis, obj) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (obj.getRoom() == null) {
                errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Waypoint is not in a room."), Intl.intl("Move waypoint to a room."), (IMerlinObj)obj));
            }
            return errors;
        });
        EntryPointFactory.registerIcon(GotoExits.class, exitIcon);
        EntryPointFactory.registerType(GotoExits.class, GotoExits.PROP_TYPES, Intl.intl("Go To Exit"), true);
        EntryPointFactory.registerErrors(GotoExits.class, true, List.of(IBehaviorAction.class), (Events events) -> EntryPointFactory.isModified(events, EgressDoor.class), (MerlinData md, ErrorAnalysis analysis, ? super T obj, Consumer<SimError> errors) -> {
            boolean invalidExits = false;
            for (EgressDoor door : obj.get(GotoExits.PROP_EXITS)) {
                if (door.isExit()) continue;
                invalidExits = true;
                break;
            }
            if (invalidExits) {
                String error = String.format(Intl.intl("%s is set to exit out non-exit doors."), guiUtil.escapeHTML(obj.getName()));
                String fix = Intl.intl("Edit exits.");
                errors.accept(new SimError(SimError.Level.CRITICAL, error, fix, (IMerlinObj)obj));
            }
        });
        EntryPointFactory.registerIcon(RemoveOcc.class, removeOccIcon);
        EntryPointFactory.registerType(RemoveOcc.class, RemoveOcc.PROP_TYPES, Intl.intl("Remove Occupant"), Intl.intl("Remove_Occ"), true);
        EntryPointFactory.registerIcon(WaitUntilEnd.class, waitUntilEndIcon);
        EntryPointFactory.registerType(WaitUntilEnd.class, WaitUntilEnd.PROP_TYPES, Intl.intl("Wait Until End"), true);
        EntryPointFactory.registerIcon(ResumePrior.class, resumePriorIcon);
        EntryPointFactory.registerType(ResumePrior.class, ResumePrior.PROP_TYPES, Intl.intl("Resume Prior"), true);
        EntryPointFactory.registerIcon(GotoElevators.class, elevatorIcon);
        EntryPointFactory.registerType(GotoElevators.class, GotoElevators.PROP_TYPES, Intl.intl("Goto Elevators"), true);
        EntryPointFactory.registerIcon(GotoQueue.class, queueIcon);
        EntryPointFactory.registerType(GotoQueue.class, GotoQueue.PROP_TYPES, Intl.intl("Goto Queues"), true);
        EntryPointFactory.registerBasicErrors(GotoQueue.class, false, List.of(IBehaviorAction.class), (md, analysis, obj) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (obj.getQueues().isEmpty()) {
                String error = Intl.intl("No queues are selected.");
                String fix = Intl.intl("Specify queues to go to.");
                errors.add(new SimError(SimError.Level.MODERATE, error, fix, (IMerlinObj)obj));
            }
            return errors;
        });
        EntryPointFactory.registerType(GotoRooms.class, GotoRooms.PROP_TYPES, Intl.intl("Goto Rooms"), true);
        EntryPointFactory.register(GotoRooms.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<GotoRooms, Icon>(){

            @Override
            public Icon get(MerlinData md, GotoRooms obj, Consumer<Icon> whenReady) {
                return obj.mustBeLast() ? refugeRoomIcon : roomIcon;
            }
        });
        EntryPointFactory.registerErrors(GotoRooms.class, true, List.of(IBehaviorAction.class), (Events events) -> EntryPointFactory.isModified(events, IEgressOccupiable.class) || EntryPointFactory.isModified(events, Behavior.class) || EntryPointFactory.isModified(events, GotoRooms.class) || EntryPointFactory.isModified(events, EgressAgent.class), (MerlinData md, ErrorAnalysis analysis, ? super T obj, Consumer<SimError> errors) -> {
            if (obj.getRooms().isEmpty() && !GotoRooms.getAnyAllowed(obj.getFilter())) {
                String error = Intl.intl("No rooms are selected.");
                String fix = Intl.intl("Specify target rooms.");
                errors.accept(new SimError(SimError.Level.CRITICAL, error, fix, (IMerlinObj)obj));
            }
            obj.getRooms().stream().filter(obj.getFilter().negate()).forEach(room -> {
                String error = obj.getFilter().toString();
                String fix = Intl.intl("Choose valid target rooms.");
                errors.accept(new SimError(SimError.Level.CRITICAL, error, fix, (IMerlinObj)obj, (IMerlinObj)room));
            });
            EntryPointFactory.getRefugeRoomSizeWarnings(errors, md, analysis, obj);
        });
        EntryPointFactory.registerType(GotoOccTarget.class, GotoOccTarget.PROP_TYPES, Intl.intl("Goto Occupant Target"), Intl.intl("Goto_Occ_Target"), true);
        EntryPointFactory.register(GotoOccTarget.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<GotoOccTarget, Icon>(){

            @Override
            public Icon get(MerlinData md, GotoOccTarget obj, Consumer<Icon> whenReady) {
                return gotoOccTargetIcon;
            }
        });
        EntryPointFactory.registerBasicErrors(GotoOccTarget.class, false, List.of(IBehaviorAction.class), (md, analysis, obj) -> Collections.emptyList());
        EntryPointFactory.registerIcon(GotoOcc.class, gotoOccIcon);
        EntryPointFactory.registerType(GotoOcc.class, GotoOcc.PROP_TYPES, Intl.intl("Goto Occupant"), Intl.intl("Goto_Occ"), true);
        EntryPointFactory.registerIcon(GotoCurrentAttractor.class, gotoCurrentAttractorIcon);
        EntryPointFactory.registerType(GotoCurrentAttractor.class, GotoCurrentAttractor.PROP_TYPES, Intl.intl("Goto Current Trigger"), true);
        EntryPointFactory.registerIcon(AssistOccupants.class, assistIcon);
        EntryPointFactory.registerType(AssistOccupants.class, AssistOccupants.PROP_TYPES, Intl.intl("Assist Occupants"), true);
        EntryPointFactory.registerBasicErrors(AssistOccupants.class, false, List.of(IBehaviorAction.class), (md, analysis, obj) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (obj.get(AssistOccupants.CLIENT_AWARENESS) == ClientAwareness.ROOMS && obj.get(AssistOccupants.ROOMS).isEmpty()) {
                errors.add(new SimError(SimError.Level.MODERATE, Intl.intl("No rooms are specified. Assistant will not be able to assist any clients."), Intl.intl("Specify rooms for the assistant."), (IMerlinObj)obj));
            }
            return errors;
        });
        EntryPointFactory.registerIcon(WaitForAssistance.class, waitForAssistanceIcon);
        EntryPointFactory.registerType(WaitForAssistance.class, WaitForAssistance.PROP_TYPES, Intl.intl("Wait for Assistance"), true);
        EntryPointFactory.registerIcon(DetachAssistants.class, detachIcon);
        EntryPointFactory.registerType(DetachAssistants.class, DetachAssistants.PROP_TYPES, Intl.intl("Detach from Assistants"), true);
        EntryPointFactory.registerIcon(AbandonOccTargets.class, abandonOccTargetsIcon);
        EntryPointFactory.registerType(AbandonOccTargets.class, AbandonOccTargets.PROP_TYPES, Intl.intl("Abandon Occupant Targets"), Intl.intl("Abandon_Occ_Targets"), true);
        EntryPointFactory.registerIcon(JoinOccGroup.class, joinGroupIcon);
        EntryPointFactory.registerType(JoinOccGroup.class, JoinOccGroup.PROP_TYPES, Intl.intl("Join Occupant Group"), Intl.intl("Join_Occ_Group"), false);
        EntryPointFactory.registerErrors(JoinOccGroup.class, true, List.of(IBehaviorAction.class), (Events events) -> EntryPointFactory.isModified(events, OccGroupObj.class), (MerlinData md, ErrorAnalysis analysis, ? super T obj, Consumer<SimError> errors) -> {
            if (obj.getGroup() == null) {
                String error = Intl.intl("No movement group is selected.");
                String fix = Intl.intl("Specify a movement group to join.");
                errors.accept(new SimError(SimError.Level.CRITICAL, error, fix, (IMerlinObj)obj));
            } else if (obj.type.equals((Object)JoinOccGroup.Type.LEAD_GROUP) && !obj.getGroup().get(OccGroupObj.PROP_REQUIRES_GROUP_LEADER).booleanValue()) {
                String error = Intl.intl("This action must be used with a movement group or a movement group template that follows a leader.");
                String fix = String.format(Intl.intl("Check the Follow Leader checkbox in the dialog for %s"), guiUtil.escapeHTML(obj.getGroup().getName()));
                errors.accept(new SimError(SimError.Level.CRITICAL, error, fix, (IMerlinObj)obj));
            }
        });
        EntryPointFactory.registerIcon(ChangeBehavior.class, behaviorIcon);
        EntryPointFactory.registerType(ChangeBehavior.class, ChangeBehavior.PROP_TYPES, Intl.intl("Change Behavior"), true);
        EntryPointFactory.registerIcon(ChangeProfile.class, occupantProfileIcon);
        EntryPointFactory.registerType(ChangeProfile.class, ChangeProfile.PROP_TYPES, Intl.intl("Change Profile"), true);
        EntryPointFactory.registerErrors(ChangeProfile.class, false, List.of(IBehaviorAction.class), (Events events) -> EntryPointFactory.isModified(events, OccProfile.class) || EntryPointFactory.isModified(events, ChangeProfile.class), (MerlinData md, ErrorAnalysis analysis, ? super T obj, Consumer<SimError> errors) -> {
            for (OccProfile prof : obj.getAllTargetProfiles()) {
                EntryPointFactory.getResolvedProfileErrors(obj, prof, errors, Intl.intl("Change profile or remove profile from target profiles list."));
            }
        });
        Class clazz = theUtil.makeGeneric(ChangeProfileProp.class);
        EntryPointFactory.registerIcon(clazz, changeOccProfilePropIcon);
        EntryPointFactory.registerType(clazz, ChangeProfileProp.PROP_TYPES, Intl.intl("Change Profile Property"), true);
        EntryPointFactory.registerBasicErrors(clazz, false, List.of(IBehaviorAction.class), (md, analysis, obj) -> {
            if (obj.getDomain() == null) {
                return List.of();
            }
            ArrayList errors = new ArrayList(2);
            obj.getProfileProp().ifPresent(pprop -> EntryPointFactory.getValueErrors(obj, pprop, obj.get(pprop.asProp()), errors::add));
            return errors;
        });
        EntryPointFactory.registerIcon(RevertProfileProp.class, revertOccProfilePropIcon);
        EntryPointFactory.registerType(RevertProfileProp.class, RevertProfileProp.PROP_TYPES, Intl.intl("Reset Profile Property"), true);
        EntryPointFactory.registerBasicErrors(RevertProfileProp.class, false, List.of(IBehaviorAction.class), (md, analysis, obj) -> {
            Collection<SimError> errors = Collections.emptyList();
            if (obj.get(RevertProfileProp.PROFILE_PROP) == null) {
                errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.CRITICAL, Intl.intl("A property must be specified."), Intl.intl("Specify a property to change."), (IMerlinObj)obj));
            }
            return errors;
        });
        EntryPointFactory.registerIcon(ChangeTags.class, changeTagsIcon);
        EntryPointFactory.registerType(ChangeTags.class, ChangeTags.PROP_TYPES, Intl.intl("Change Tags"), true);
        EntryPointFactory.registerBasicErrors(ChangeTags.class, false, List.of(IBehaviorAction.class), (md, analysis, obj) -> {
            Collection<SimError> errors = Collections.emptyList();
            if (!obj.get(ChangeTags.OPERATION).tagsCanBeEmpty && obj.get(ChangeTags.TAGS).isEmpty()) {
                errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.CRITICAL, "<html>" + Intl.intl("<i>Tags</i> must not be empty."), Intl.intl("Specify tags in the property panel."), (IMerlinObj)obj));
            }
            return errors;
        });
        EntryPointFactory.registerIcon(LookAt.class, lookAtIcon);
        EntryPointFactory.registerType(LookAt.class, LookAt.PROP_TYPES, Intl.intl("Look At"), true);
        EntryPointFactory.registerIcon(LookAhead.class, lookAheadIcon);
        EntryPointFactory.registerType(LookAhead.class, LookAhead.PROP_TYPES, Intl.intl("Look Ahead"), true);
        EntryPointFactory.registerIcon(CreateAttractor.class, createAttractorIcon);
        EntryPointFactory.registerType(CreateAttractor.class, CreateAttractor.PROP_TYPES, Intl.intl("Create Trigger"), true);
        EntryPointFactory.registerBasicErrors(CreateAttractor.class, true, List.of(IBehaviorAction.class), (md, analysis, obj) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (obj.getLocation() == CreateAttractor.LocationMode.FIXED_LOCATION && obj.getFixedRoom() == null) {
                errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Trigger create location is not in a room."), Intl.intl("Move trigger create location to a room."), (IMerlinObj)obj));
            }
            if (obj.getAttractors().isEmpty()) {
                errors.add(new SimError(SimError.Level.MODERATE, Intl.intl("No triggers selected to create."), Intl.intl("Select a trigger template to create."), (IMerlinObj)obj));
            }
            return errors;
        });
        EntryPointFactory.registerIcon(DestroyAttractor.class, destroyAtttractorIcon);
        EntryPointFactory.registerType(DestroyAttractor.class, DestroyAttractor.PROP_TYPES, Intl.intl("Destroy Trigger"), true);
        EntryPointFactory.registerBasicErrors(DestroyAttractor.class, true, List.of(IBehaviorAction.class), (md, analysis, obj) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (obj.getAttractors().isEmpty()) {
                errors.add(new SimError(SimError.Level.MODERATE, Intl.intl("No triggers selected to destroy."), Intl.intl("Select a trigger template to destroy."), (IMerlinObj)obj));
            }
            return errors;
        });
        EntryPointFactory.registerType(MaterialDB.class, MaterialDB.PROP_TYPES, Intl.intl("Material Database"), false);
        EntryPointFactory.register(MaterialDB.class, FuncType.TV_GetParent, (MerlinData md, T obj) -> null);
        EntryPointFactory.registerType(Material.class, Material.PROP_TYPES, Intl.intl("Material"), false);
        EntryPointFactory.register(Material.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.materials);
        EntryPointFactory.register(Material.class, FuncType.IsDelUndoable, (MerlinData md, T obj) -> !md.materials.isPermanent((Material)obj));
        EntryPointFactory.register(Material.class, FuncType.Delete, new EntryPoint.Action<Material, Boolean, Object>(){

            @Override
            public Boolean perform(MerlinData md, Material obj, Object arg) {
                MaterialDB db = md.materials;
                return db.remove(obj, true);
            }
        });
        EntryPointFactory.register(Material.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<Material, Icon>(){

            @Override
            public Icon get(MerlinData md, Material obj, Consumer<Icon> whenReady) {
                return guiUtil.getIconsAsync(icons -> whenReady.accept(icons[0]), obj, 16, 16, 0, guiUtil.ImageFilter.NORMAL)[0];
            }
        });
        EntryPointFactory.register(Material.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(Material.class));
        EntryPointFactory.registerType(ScenarioRoot.class, ScenarioRoot.PROP_TYPES, Intl.intl("Scenario_Root"), false);
        EntryPointFactory.registerIcon(ScenarioRoot.class, scenariosIcon);
        EntryPointFactory.register(ScenarioRoot.class, FuncType.TV_GetParent, (MerlinData md, T obj) -> null);
        EntryPointFactory.registerType(Scenario.class, Scenario.PROPS, Intl.intl("Scenario"), true);
        EntryPointFactory.registerIcon(Scenario.class, scenariosIcon);
        EntryPointFactory.register(Scenario.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.scenarios);
        EntryPointFactory.register(Scenario.class, FuncType.TV_GetBaseFont, (MerlinData md, T obj) -> obj.isDefault() ? s_bold : s_plain);
        EntryPointFactory.register(Scenario.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<Scenario, Icon>(){

            @Override
            public Icon get(MerlinData md, Scenario obj, Consumer<Icon> whenReady) {
                return obj.newDecaratorIcon();
            }
        });
        EntryPointFactory.register(Scenario.class, FuncType.CanShowInReferencingLists, (MerlinData md, T scenario) -> !scenario.isDefault());
        EntryPointFactory.register(Scenario.class, FuncType.GetUniqueNameGroup, EntryPointFactory.nameGroup(md -> md.scenarios.flatten(Scenario.class)));
        EntryPointFactory.register(Scenario.class, FuncType.GetNameFormatRules, (MerlinData md, T obj) -> ScenarioUtil.getValidScenarioNamePredicate());
        EntryPointFactory.register(Scenario.class, FuncType.GetDeletionErr, (MerlinData md, T obj) -> {
            if (obj.isDefault()) {
                return new Exception(Intl.intl("Cannot delete the default Scenario."));
            }
            return null;
        });
        EntryPointFactory.registerType(JsonObj.class, JsonObj.PROP_TYPES, Intl.intl("JSON"), Application.isDev());
        EntryPointFactory.register(JsonObj.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.json);
        EntryPointFactory.register(JsonObj.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("JsonObj", 2)));
        EntryPointFactory.registerType(ScriptObj.class, ScriptObj.PROP_TYPES, Intl.intl("Script"), EditCustomScripts.isCustomScriptingEnabled());
        EntryPointFactory.register(ScriptObj.class, FuncType.GetCompositeRoot, (MerlinData md) -> md.customScripts);
        EntryPointFactory.register(ScriptObj.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.customScriptNameGen);
        EntryPointFactory.registerType(SimParams.class, SimParams.PROP_TYPES, Intl.intl("Simulation Parameters"), false);
        EntryPointFactory.registerType(MonteCarlo.class, MonteCarlo.PROPS, Intl.intl("Monte Carlo"), false);
        EntryPointFactory.register(MonteCarlo.class, FuncType.CanShowInReferencingLists, (MerlinData md, T obj) -> false);
        EntryPointFactory.register(RunInferno.ActionProps.class, FuncType.CanShowInReferencingLists, (MerlinData md, T props) -> false);
        EntryPointFactory.register(CreateElevator.ActionProps.class, FuncType.CanShowInReferencingLists, (MerlinData md, T props) -> false);
        for (Pair<Class<?>, FuncType> funcEntry : s_funcs.keySet()) {
            EntryPointFactory.get((Class)funcEntry.v1);
        }
    }

    private static enum FuncType {
        GetDeletionErr,
        GetConflict,
        Delete,
        IsAutoDeleteGroup,
        IsDelUndoable,
        DomainRequiredType,
        IsVisible,
        SetVisible,
        GetCompositeRoot,
        GetNameGenerator,
        GetUniqueNameGroup,
        IsIndexed,
        IsMovable,
        ShowBounds,
        TypeString,
        CategoryName,
        GetNameFormatRules,
        CanShowInReferencingLists,
        GetErrorGens,
        GetPropertyDefs,
        IsSearchType,
        TV_GetName,
        TV_SetName,
        TV_CanRename,
        TV_GetIcon,
        TV_GetBaseFont,
        TV_IsVisible,
        TV_IsEnabled,
        TV_GetForcedAutoexpand,
        TV_IsLeaf,
        TV_GetChildren,
        TV_GetParent;

    }

    private static class ConstantAsyncGetter<T, ReturnT>
    implements EntryPoint.AsyncGetter<T, ReturnT> {
        public final ReturnT value;

        public ConstantAsyncGetter(ReturnT value) {
            this.value = value;
        }

        @Override
        public ReturnT get(MerlinData md, T obj, Consumer<ReturnT> whenReady) {
            return this.value;
        }
    }

    private static class ConstantSupplier<T, ReturnT>
    implements EntryPoint.Supplier<T, ReturnT> {
        private final ReturnT d_value;

        public ConstantSupplier(ReturnT value) {
            this.d_value = value;
        }

        @Override
        public ReturnT get(MerlinData md) {
            return this.d_value;
        }
    }

    private static class ConstantGetter<T, ReturnT>
    implements EntryPoint.Getter<T, ReturnT> {
        private final ReturnT d_value;

        public ConstantGetter(ReturnT value) {
            this.d_value = value;
        }

        @Override
        public ReturnT get(MerlinData md, T obj) {
            return this.d_value;
        }
    }

    private record NotEnoughAssisting(BiFunction<VehicleShape, Behavior, List<int[]>> getOccHelpersNeeded) {
    }

    private record FitInElevator(BiFunction<VehicleShape, Behavior, List<Pair<Integer, Integer>>> getErrors) {
    }

    private record AssistWarnings(Map<Pair<Behavior, AssistState>, List<Function<IMerlinObj, SimError>>> value) {
    }

    private static class AssistState
    implements Cloneable {
        public int numVehicleAttachPoints = -1;
        public boolean requiresAssistance = false;
        public boolean waitingForOrReceivingAssistance = false;
        public OccProfile lastProfile;

        public AssistState(OccProfile profile) {
            this.update(profile);
        }

        public void update(OccProfile prof) {
            this.lastProfile = prof;
            this.updateShape(prof.get(OccProfile.PROP_VEHICLE_SHAPE));
            this.requiresAssistance = EntryPointFactory.requiresAssistance(prof);
        }

        public void update(ChangeProfileProp<?> changeProp) {
            IProfileProp<?, ?> prop = changeProp.getProp();
            if (prop == OccProfile.PROP_SHAPE) {
                OccProfile.OccShape occShape = (OccProfile.OccShape)changeProp.getValue();
                this.updateShape(occShape.vehicleShape);
            } else if (prop == OccProfile.PROP_VEHICLE_SHAPE) {
                this.updateShape((VehicleShape)changeProp.getValue());
            } else if (prop == OccProfile.PROP_REQUIRES_ASSISTANCE) {
                this.requiresAssistance = EntryPointFactory.requiresAssistance((IUrn)changeProp.getValue());
            }
        }

        public void update(RevertProfileProp<?> resetProp) {
            IProfileProp<?, ?> prop = resetProp.getProp();
            if (prop == OccProfile.PROP_SHAPE || prop == OccProfile.PROP_VEHICLE_SHAPE) {
                this.updateShape(this.lastProfile.get(OccProfile.PROP_VEHICLE_SHAPE));
            } else if (prop == OccProfile.PROP_REQUIRES_ASSISTANCE) {
                this.requiresAssistance = EntryPointFactory.requiresAssistance(this.lastProfile);
            }
        }

        private void updateShape(VehicleShape shape) {
            this.numVehicleAttachPoints = shape == null ? -1 : shape.get(VehicleShape.PROP_ATTACHED_AGENTS_POSITIONS).length;
        }

        public int hashCode() {
            return 0xB3234A ^ Objects.hash(this.numVehicleAttachPoints, this.requiresAssistance, this.waitingForOrReceivingAssistance);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AssistState)) {
                return false;
            }
            AssistState as = (AssistState)obj;
            return as.numVehicleAttachPoints == this.numVehicleAttachPoints && as.requiresAssistance == this.requiresAssistance && as.waitingForOrReceivingAssistance == this.waitingForOrReceivingAssistance;
        }

        public AssistState clone() {
            try {
                return (AssistState)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    private static class CannotTraceException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private CannotTraceException() {
        }
    }

    private static class NullAction<T, ReturnT, ArgT>
    implements EntryPoint.Action<T, ReturnT, ArgT> {
        private final ReturnT d_value;

        public NullAction(ReturnT defReturn) {
            this.d_value = defReturn;
        }

        @Override
        public ReturnT perform(MerlinData md, T obj, ArgT arg) {
            return this.d_value;
        }
    }

    private static class NullSetter<T, ArgT>
    implements EntryPoint.Setter<T, ArgT> {
        private NullSetter() {
        }

        @Override
        public void set(MerlinData md, T obj, ArgT arg) {
        }
    }

    private static abstract class MVMgrConstructor<T>
    implements EntryPoint.Action<T, Collection<? extends IMerlinDispMgr<?>>, ModelView> {
        private Collection<? extends IMerlinDispMgr<?>> d_managers;

        private MVMgrConstructor() {
        }

        @Override
        public Collection<? extends IMerlinDispMgr<?>> perform(MerlinData md, T obj, ModelView mv) {
            if (this.d_managers != null) {
                return this.d_managers;
            }
            this.d_managers = this.create(md, obj, mv);
            return this.d_managers;
        }

        protected abstract Collection<? extends IMerlinDispMgr<?>> create(MerlinData var1, T var2, ModelView var3);
    }
}

