/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis.rend;

import inferno.data2.ANode;
import inferno.data2.Tri;
import inferno.sim.KB;
import inferno.vis.GLView;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import javax.vecmath.Color3b;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.lwjgl.opengl.GL11;
import thunderheadeng.geometry.Box3d;
import thunderheadeng.geometry.LineSeg3D;

public class RenderUtil {
    public static DoubleBuffer toGLTransform(Matrix4d xform) {
        DoubleBuffer buffer = ByteBuffer.allocateDirect(128).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        RenderUtil.toGLTransform(xform, buffer);
        return buffer;
    }

    public static DoubleBuffer toGLTransform(Matrix4d xform, DoubleBuffer buffer) {
        double[] temp = new double[4];
        for (int m = 0; m < 4; ++m) {
            xform.getColumn(m, temp);
            buffer.put(temp);
        }
        buffer.position(0);
        return buffer;
    }

    public static boolean isVisible(GLView view, KB kb, ANode room) {
        boolean animating = !view.getFilters().isFilteringAllOf(GLView.ANIMATION_FILTER.class);
        return !animating || room.getAnimationId() >= 0 || !view.getElevatorNodes(kb.getElevatorModel()).contains(room);
    }

    public static boolean isAnimating(GLView view, KB kb, ANode room) {
        boolean animating = !view.getFilters().isFilteringAllOf(GLView.ANIMATION_FILTER.class);
        return animating && room.getAnimationId() >= 0;
    }

    public static boolean isComponentVisible(GLView view, KB kb, Tri ... connectedTris) {
        for (Tri tri : connectedTris) {
            if (!RenderUtil.isVisible(view, kb, tri.node)) continue;
            return true;
        }
        return false;
    }

    public static Matrix4d getAnimXform(GLView view, KB kb, Tri ... connectedTris) {
        if (connectedTris.length == 0) {
            return null;
        }
        ANode node = connectedTris[0].node;
        for (int m = 1; m < connectedTris.length; ++m) {
            if (connectedTris[m].node == node) continue;
            return null;
        }
        return RenderUtil.isAnimating(view, kb, node) ? node.getAnimXform() : null;
    }

    public static void renderDisc2(double r1, double r2, int tris) {
        GL11.glBegin(5);
        double deg2rad = Math.PI / 180;
        GL11.glVertex2d(0.0, 0.0);
        for (int i = 0; i < 360; i += 10) {
            double degInRad = (double)i * deg2rad;
            GL11.glVertex2d(Math.cos(degInRad) * r1, Math.sin(degInRad) * r1);
            GL11.glVertex2d(Math.cos(degInRad) * r2, Math.sin(degInRad) * r2);
        }
        double degInRad = 360.0 * deg2rad;
        GL11.glVertex2d(Math.cos(degInRad) * r1, Math.sin(degInRad) * r1);
        GL11.glVertex2d(Math.cos(degInRad) * r2, Math.sin(degInRad) * r2);
        GL11.glEnd();
    }

    public static void renderDisk(double r) {
        GL11.glBegin(6);
        double deg2rad = Math.PI / 180;
        GL11.glVertex2d(0.0, 0.0);
        for (int i = 0; i < 360; i += 10) {
            double degInRad = (double)i * deg2rad;
            GL11.glVertex2d(Math.cos(degInRad) * r, Math.sin(degInRad) * r);
        }
        double degInRad = 360.0 * deg2rad;
        GL11.glVertex2d(Math.cos(degInRad) * r, Math.sin(degInRad) * r);
        GL11.glEnd();
    }

    public static void renderCircle(double r, int segs) {
        GL11.glBegin(2);
        double deg2rad = Math.PI / 180;
        for (int i = 0; i < 360; i += 10) {
            double degInRad = (double)i * deg2rad;
            GL11.glVertex2d(Math.cos(degInRad) * r, Math.sin(degInRad) * r);
        }
        GL11.glEnd();
    }

    public static void renderBox(Box3d box) {
        GL11.glBegin(7);
        for (Point3d[] face : box.getFaces()) {
            for (int m = 0; m < 4; ++m) {
                Point3d p = face[m];
                GL11.glVertex3d(p.x, p.y, p.z);
            }
        }
        GL11.glEnd();
    }

    public static Color toColor(Color3b color) {
        return new Color(RenderUtil.toColorCC(color.x), RenderUtil.toColorCC(color.y), RenderUtil.toColorCC(color.z));
    }

    private static int toColorCC(byte ccb) {
        return 0xFF & ccb;
    }

    public static void lineSeg(LineSeg3D lineSeg) {
        Point3d p1 = lineSeg.getP1();
        Point3d p2 = lineSeg.getP2();
        GL11.glBegin(1);
        GL11.glVertex3d(p1.x, p1.y, p1.z + 0.01);
        GL11.glVertex3d(p2.x, p2.y, p2.z + 0.01);
        GL11.glEnd();
    }

    public static void lineSeg(Point3d loc, Vector3d dirVec) {
        Point3d p2 = new Point3d(loc);
        p2.add(dirVec);
        GL11.glBegin(1);
        GL11.glVertex3d(loc.x, loc.y, loc.z + 0.01);
        GL11.glVertex3d(p2.x, p2.y, p2.z + 0.01);
        GL11.glEnd();
    }

    public static void lineTo(Point3d loc, Point3d pt) {
        GL11.glBegin(1);
        GL11.glVertex3d(loc.x, loc.y, loc.z + 0.01);
        GL11.glVertex3d(pt.x, pt.y, pt.z + 0.01);
        GL11.glEnd();
    }

    public static void glColor4(int r, int g, int b, int a) {
        GL11.glColor4d((double)r / 255.0, (double)g / 255.0, (double)b / 255.0, (double)a / 255.0);
    }

    public static void glColor4(Color c) {
        GL11.glColor4ub((byte)c.getRed(), (byte)c.getGreen(), (byte)c.getBlue(), (byte)c.getAlpha());
    }
}

