/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis.rend;

import common.vis.ColorMaps;
import inferno.geom.IDensityField;
import inferno.geom.VorDensityField;
import inferno.sim.KB;
import inferno.vis.DisplayFilter;
import inferno.vis.GLView;
import inferno.vis.rend.IRenderer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.lwjgl.opengl.GL11;
import thunderheadeng.delaunay.VoronoiInfo;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;

public class RendVorDensityField
implements IRenderer<VorDensityField> {
    private static final ColorMaps.IColorMap SHADER = ColorMaps.RAINBOW2;
    private IDensityField d_prevField = null;
    private AABox d_bounds = null;
    private VorDensityField.Interpolation d_interp = VorDensityField.DEF_INTERP;
    private boolean d_fastSearch = true;
    private int d_textureId = -1;
    private static final double SAMPLE_RES = 0.15;

    public void setInterp(VorDensityField.Interpolation interp) {
        this.d_interp = interp;
    }

    public void setFastSearch(boolean fast) {
        this.d_fastSearch = fast;
    }

    @Override
    public AABox getBounds(VorDensityField obj) {
        if (this.d_bounds == null || obj != this.d_prevField) {
            this.d_bounds = RendVorDensityField.calcBounds(obj);
        }
        this.d_prevField = obj;
        return this.d_bounds;
    }

    private static AABox calcBounds(VorDensityField vdf) {
        AABox bounds = new AABox();
        for (VorDensityField.Vertex vert : vdf.getVerts()) {
            bounds.add(new Point3d(vert.p.x, vert.p.y, 0.0));
        }
        return bounds;
    }

    private void updateTexture() {
        if (this.d_textureId != -1) {
            return;
        }
        this.d_textureId = GL11.glGenTextures();
        int numColors = 256;
        ByteBuffer data = ByteBuffer.allocateDirect(numColors * 3).order(ByteOrder.nativeOrder());
        byte[] color = new byte[3];
        for (int m = 0; m < numColors; ++m) {
            ColorMaps.getColor(SHADER, (double)m / (double)(numColors - 1), color);
            data.put(color);
        }
        data.position(0);
        GL11.glBindTexture(3552, this.d_textureId);
        GL11.glPixelStorei(3317, 1);
        GL11.glTexImage1D(3552, 0, 6407, numColors, 0, 6407, 5121, data);
        GL11.glTexParameteri(3552, 10241, 9728);
        GL11.glTexParameteri(3552, 10240, 9728);
        GL11.glTexParameteri(3552, 10242, 33071);
        GL11.glTexParameteri(3552, 10243, 33071);
        GL11.glBindTexture(3552, 0);
    }

    @Override
    public void renderOpaque(GLView view, KB kb, VorDensityField vdf) throws Exception {
        DisplayFilter filters = view.getFilters();
        if (filters.isFilteringAllOf(TRI_OUTLINE_FILTER.class) && filters.isFilteringAllOf(VOR_OUTLINE_FILTER.class) && filters.isFilteringAllOf(DENSITY_FILTER.class)) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated(0.0, 0.0, 0.027);
        if (!filters.isFilteringAllOf(DENSITY_FILTER.class)) {
            this.renderDensityField(view, kb, vdf);
        }
        if (!filters.isFilteringAllOf(TRI_OUTLINE_FILTER.class)) {
            this.renderTriOutlines(view, kb, vdf);
        }
        if (!filters.isFilteringAllOf(VOR_OUTLINE_FILTER.class)) {
            this.renderVorOutlines(view, kb, vdf);
        }
        GL11.glPopMatrix();
    }

    private void renderVorOutlines(GLView view, KB kb, VorDensityField vdf) {
        GL11.glPushAttrib(40972);
        GL11.glPolygonMode(1032, 6913);
        GL11.glEnable(2848);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glHint(3154, 4354);
        GL11.glLineWidth(2.0f);
        GL11.glColor3f(0.1f, 0.2f, 0.9f);
        for (Face f : vdf.getOccAreas().values()) {
            for (FaceLoop floop : f.edgeLoops) {
                GL11.glBegin(1);
                for (EdgeUse eu : floop.edges) {
                    GL11.glVertex2d(eu.v1().loc.x, eu.v1().loc.y);
                    GL11.glVertex2d(eu.v2().loc.x, eu.v2().loc.y);
                }
                GL11.glEnd();
            }
        }
        GL11.glPopAttrib();
    }

    private void renderTriOutlines(GLView view, KB kb, VorDensityField vdf) {
        GL11.glPushAttrib(8);
        GL11.glPolygonMode(1032, 6913);
        GL11.glColor3f(1.0f, 0.0f, 0.0f);
        int[] tris = vdf.getTris();
        VorDensityField.Vertex[] verts = vdf.getVerts();
        GL11.glBegin(4);
        for (int m = 0; m < tris.length; ++m) {
            Point2d p = verts[tris[m]].p;
            GL11.glVertex2d(p.x, p.y);
        }
        GL11.glEnd();
        GL11.glPopAttrib();
    }

    private void renderDensityField(GLView view, KB kb, VorDensityField vdf) {
        vdf.setFastSearchesEnabled(this.d_fastSearch);
        vdf.setInterpolation(this.d_interp);
        if (!view.getFilters().isFilteringAllOf(DENSITY_SUBSAMPLE.class)) {
            try {
                this.renderDensityFieldSampleGrid(view, kb, vdf);
            }
            catch (OutOfMemoryError e) {
                System.err.println("[renderDensityFieldSampleGrid] " + e.getMessage());
            }
        } else if (!view.getFilters().isFilteringAllOf(DENSITY_TRIANGLES.class)) {
            this.renderDensityFieldTris(view, kb, vdf);
        } else if (!view.getFilters().isFilteringAllOf(DENSITY_VOR.class)) {
            this.renderDensityFieldVor(view, kb, vdf);
        }
    }

    private void renderDensityFieldTris(GLView view, KB kb, VorDensityField vdf) {
        VorDensityField.Vertex[] verts = vdf.getVerts();
        int[] tris = vdf.getTris();
        this.updateTexture();
        double[] densBounds = new double[]{0.5, 3.5};
        double minDensity = densBounds[0];
        double maxDensity = densBounds[1];
        double da = maxDensity == minDensity ? 0.0 : 1.0 / (maxDensity - minDensity);
        DoubleBuffer vertBuffer = ByteBuffer.allocateDirect(verts.length * 2 * 8).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        FloatBuffer texuvBuffer = ByteBuffer.allocateDirect(verts.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        IntBuffer triBuffer = ByteBuffer.allocateDirect(tris.length * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        triBuffer.put(tris);
        for (VorDensityField.Vertex vert : verts) {
            double dens = vert.area <= 0.0 ? 0.0 : vert.val / vert.area;
            double intensity = (dens - minDensity) * da;
            if (intensity > 1.0) {
                intensity = 1.0;
            } else if (intensity < 0.0) {
                intensity = 0.0;
            }
            texuvBuffer.put((float)intensity);
            vertBuffer.put(vert.p.x);
            vertBuffer.put(vert.p.y);
        }
        vertBuffer.position(0);
        texuvBuffer.position(0);
        triBuffer.position(0);
        GL11.glPushAttrib(8192);
        GL11.glEnableClientState(32884);
        GL11.glEnableClientState(32888);
        GL11.glEnable(3552);
        GL11.glEnable(2903);
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        GL11.glBindTexture(3552, this.d_textureId);
        GL11.glTexCoordPointer(1, 4, texuvBuffer);
        GL11.glVertexPointer(2, 16, vertBuffer);
        GL11.glDrawElements(4, triBuffer);
        GL11.glDisableClientState(32884);
        GL11.glDisableClientState(32888);
        GL11.glBindTexture(3552, 0);
        GL11.glPopAttrib();
    }

    private void renderDensityFieldVor(GLView view, KB kb, VorDensityField vdf) {
        VorDensityField.Vertex[] verts = vdf.getVerts();
        VoronoiInfo vi = vdf.getVoronoiInfo();
        this.updateTexture();
        double[] densBounds = new double[]{0.5, 3.5};
        double minDensity = densBounds[0];
        double maxDensity = densBounds[1];
        double da = maxDensity == minDensity ? 0.0 : 1.0 / (maxDensity - minDensity);
        GL11.glPushAttrib(8192);
        GL11.glEnable(3552);
        GL11.glEnable(2903);
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        GL11.glBindTexture(3552, this.d_textureId);
        for (int m = 0; m < vi.polys.length; ++m) {
            VorDensityField.Vertex v = verts[m];
            double dens = v.area <= 0.0 ? 0.0 : v.val / v.area;
            double intensity = (dens - minDensity) * da;
            GL11.glTexCoord1f((float)intensity);
            int[] poly = vi.polys[m];
            GL11.glBegin(9);
            for (int i : poly) {
                Point2d p = vi.points[i];
                GL11.glVertex2d(p.x, p.y);
            }
            GL11.glEnd();
        }
        GL11.glBindTexture(3552, 0);
        GL11.glPopAttrib();
    }

    private void renderDensityFieldSampleGrid(GLView view, KB kb, VorDensityField vdf) {
        AABox geomBounds = vdf.getGeometryBounds().scale(0.99999);
        double width = geomBounds.getWidth();
        double depth = geomBounds.getDepth();
        Point3d min = geomBounds.getMin();
        if (width == 0.0 || depth == 0.0) {
            return;
        }
        int nx = Math.max(3, (int)Math.ceil(width / 0.15) + 1);
        int ny = Math.max(3, (int)Math.ceil(depth / 0.15) + 1);
        double[] densBounds = new double[]{0.0, 6.0};
        double maxDensity = densBounds[1];
        double minDensity = densBounds[0];
        double da = maxDensity == minDensity ? 0.0 : 1.0 / (maxDensity - minDensity);
        GL11.glPushAttrib(8192);
        GL11.glEnableClientState(32884);
        GL11.glEnableClientState(32886);
        int numVerts = nx * ny;
        DoubleBuffer vertBuffer = ByteBuffer.allocateDirect(numVerts * 2 * 8).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        ByteBuffer colorBuffer = ByteBuffer.allocateDirect(numVerts * 3 * 1).order(ByteOrder.nativeOrder());
        byte[] cbuf = new byte[3];
        double invx = width / ((double)nx - 1.0);
        double invy = depth / ((double)ny - 1.0);
        Point2d tempp = new Point2d();
        for (int iy = 0; iy < ny; ++iy) {
            double y = (double)iy * invy;
            for (int ix = 0; ix < nx; ++ix) {
                double x = (double)ix * invx;
                tempp.set(min.x + x, min.y + y);
                double density = this.getDensity(vdf, tempp);
                double intensity = (density - minDensity) * da;
                if (intensity < 0.0) {
                    intensity = 0.0;
                } else if (intensity > 1.0) {
                    intensity = 1.0;
                }
                ColorMaps.getColor(SHADER, intensity, cbuf);
                colorBuffer.put(cbuf);
                vertBuffer.put(tempp.x);
                vertBuffer.put(tempp.y);
            }
        }
        int numQuads = (nx - 1) * (ny - 1);
        IntBuffer ixBuffer = ByteBuffer.allocateDirect(numQuads * 4 * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        for (int iy = 0; iy < ny - 1; ++iy) {
            int yoffset = nx * iy;
            int yoffset2 = nx * (iy + 1);
            for (int ix = 0; ix < nx - 1; ++ix) {
                ixBuffer.put(yoffset + ix);
                ixBuffer.put(yoffset + ix + 1);
                ixBuffer.put(yoffset2 + ix + 1);
                ixBuffer.put(yoffset2 + ix);
            }
        }
        vertBuffer.position(0);
        colorBuffer.position(0);
        ixBuffer.position(0);
        GL11.glColorPointer(3, true, 3, colorBuffer);
        GL11.glVertexPointer(2, 16, vertBuffer);
        GL11.glDrawElements(7, ixBuffer);
        GL11.glDisableClientState(32884);
        GL11.glDisableClientState(32886);
        GL11.glPopAttrib();
    }

    private double getDensity(VorDensityField vdf, Point2d p) {
        double val = vdf.getDensity(p);
        return val;
    }

    @Override
    public void renderTranslucent(GLView view, KB kb, VorDensityField obj) throws Exception {
    }

    public static class TRI_OUTLINE_FILTER {
    }

    public static class VOR_OUTLINE_FILTER {
    }

    public static class DENSITY_FILTER {
    }

    public static class DENSITY_SUBSAMPLE {
    }

    public static class DENSITY_TRIANGLES {
    }

    public static class DENSITY_VOR {
    }
}

