/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis.rend;

import inferno.data2.ANode;
import inferno.data2.Tri;
import inferno.sim.KB;
import inferno.vis.GLView;
import inferno.vis.rend.IRenderer;
import inferno.vis.rend.RenderUtil;
import java.awt.Color;
import java.nio.DoubleBuffer;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.lwjgl.opengl.GL11;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;

public class RendMeshTri
implements IRenderer<Tri> {
    private static Point3d[] losColors = new Point3d[]{new Point3d(1.0, 1.0, 1.0), new Point3d(1.0, 1.0, 0.517), new Point3d(1.0, 1.0, 0.129), new Point3d(1.0, 0.808, 0.0), new Point3d(1.0, 0.549, 0.0), new Point3d(1.0, 0.259, 0.0)};
    private final DoubleBuffer d_matrixBuffer = RenderUtil.toGLTransform(GeomConstants.IDENTITY4d);

    private static int getLoS(double density) {
        if (density <= 0.828) {
            return 0;
        }
        if (density <= 1.076) {
            return 1;
        }
        if (density <= 1.538) {
            return 2;
        }
        if (density <= 3.588) {
            return 3;
        }
        if (density <= 5.382) {
            return 4;
        }
        return 5;
    }

    private static Point3d convert(Color c) {
        float[] comps = new float[3];
        c.getColorComponents(comps);
        return new Point3d(comps[0], comps[1], comps[2]);
    }

    @Override
    public void renderOpaque(GLView view, KB kb, Tri mt) {
        if (!RenderUtil.isVisible(view, kb, mt.node)) {
            return;
        }
        Point3d tColor = null;
        if (!view.getFilters().isFilteringAllOf(COLOR_BY_FLAGS.class)) {
            tColor = mt.testAnyFlags(2) ? new Point3d(1.0, 0.0, 0.0) : (mt.testAnyFlags(1) ? RendMeshTri.convert(Color.ORANGE) : RendMeshTri.convert(Color.WHITE));
        } else {
            if (mt.terrain.isOpen()) {
                ANode n = mt.node;
                double d = (double)n.getNumOccupants() / n.getArea();
                tColor = losColors[RendMeshTri.getLoS(d)];
            } else if (mt.terrain.isStair()) {
                tColor = new Point3d(0.9, 0.7, 0.6);
            } else if (mt.terrain.isRamp()) {
                tColor = new Point3d(0.6, 0.7, 0.6);
            }
            tColor = new Point3d(tColor);
            double scale = Math.min(1.0, mt.getSpeedModifier().getAbsoluteSpeed(1.0, false));
            tColor.scale(scale);
        }
        this.render(view, kb, mt, tColor);
    }

    @Override
    public void renderTranslucent(GLView view, KB kb, Tri obj) {
    }

    public void render(GLView view, KB kb, Tri mt, Point3d tColor) {
        Point3d pt1 = mt.v[0].p;
        Point3d pt2 = mt.v[1].p;
        Point3d pt3 = mt.v[2].p;
        boolean animating = RenderUtil.isAnimating(view, kb, mt.node);
        if (animating) {
            Matrix4d xform = mt.node.getAnimXform();
            GL11.glPushMatrix();
            GL11.glMultMatrix(RenderUtil.toGLTransform(xform, this.d_matrixBuffer));
        }
        GL11.glColor3d(tColor.x, tColor.y, tColor.z);
        GL11.glBegin(4);
        GL11.glVertex3d(pt1.x, pt1.y, pt1.z);
        GL11.glVertex3d(pt2.x, pt2.y, pt2.z);
        GL11.glVertex3d(pt3.x, pt3.y, pt3.z);
        GL11.glEnd();
        if (animating) {
            GL11.glPopMatrix();
        }
    }

    @Override
    public AABox getBounds(Tri mt) {
        Point3d pt1 = mt.v[0].p;
        Point3d pt2 = mt.v[1].p;
        Point3d pt3 = mt.v[2].p;
        return new AABox(pt1, pt2, pt3);
    }

    public static class COLOR_BY_FLAGS {
    }
}

