/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis;

import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.vis.AbstractPropertiesTable;
import java.lang.reflect.Field;
import java.util.List;
import thunderheadeng.util.Global;

public class PropertiesTableGlobal
extends AbstractPropertiesTable {
    @Override
    public void initModel(Field[] classFields) {
        this.d_properties = new String[]{"Current time step", "Active agents count", "Avg. max cont. reduced movement speed time (s)", "Avg. total reduced movement speed time (s)", "Avg. exit time (s)", "Mesh: number of vertices", "Mesh: number of edges", "Mesh: number of triangles", "Mesh: number of boundary edges"};
    }

    @Override
    public void update(List<Object> data) {
        Engine engine = (Engine)data.get(0);
        KB kb = engine.getKB();
        int row = 0;
        this.d_table.setValueAt(engine.getCurrentTimeStep(), row++, 1);
        this.d_table.setValueAt(kb.getActiveAgents().size(), row++, 1);
        this.d_table.setValueAt(Global.format(kb.getOccStats().getSlowTimeMcStats((KB)kb).avg), row++, 1);
        this.d_table.setValueAt(Global.format(kb.getOccStats().getSlowTimeTotalStats((KB)kb).avg), row++, 1);
        this.d_table.setValueAt(Global.format(kb.getOccStats().getExitTimeStats((KB)kb).avg), row++, 1);
        this.d_table.setValueAt(kb.getMesh().getVerts().length, row++, 1);
        this.d_table.setValueAt(kb.getMesh().getEdges().length, row++, 1);
        this.d_table.setValueAt(kb.getMesh().getTris().length, row++, 1);
        this.d_table.setValueAt(kb.getMesh().getBoundaryEdges().length, row++, 1);
    }
}

